/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetBytes;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetLong;
import org.junit.Assert;
import org.junit.Test;

public class TestCuckooSet {
    private static int MAX_SIZE = 65437;

    @Test
    public void testSetLong() {
        Long[] values = new Long[]{1L, 2L, 3L, 1000L, 2000L, 3000L, 8L, 8L, 9L, 13L, 17L, 22L, 23L, 24L, 25L, -26L, 27L, 28L, 29L, 30L, 111111111111111L, -444444444444444L, Long.MIN_VALUE};
        Long[] negatives = new Long[]{0L, 4L, 4000L, -2L, 19L, 222222222222222L, -333333333333333L};
        CuckooSetLong s = new CuckooSetLong(values.length);
        for (Long v : values) {
            s.insert(v.longValue());
        }
        for (Long v : values) {
            Assert.assertTrue((boolean)s.lookup(v.longValue()));
        }
        for (Long v : negatives) {
            Assert.assertFalse((boolean)s.lookup(v.longValue()));
        }
        Long[] values2 = new Long[]{1L, 2L, 3L, 1000L, 2000L, 3000L, 8L, 8L, 9L, 13L, 17L, 22L, 23L, 24L, 25L, -26L, 27L, 28L, 29L, 30L, 111111111111111L, -444444444444444L};
        Long[] negatives2 = new Long[]{0L, 4L, 4000L, -2L, 19L, 222222222222222L, -333333333333333L, Long.MIN_VALUE};
        s = new CuckooSetLong(values2.length);
        for (Long v : values2) {
            s.insert(v.longValue());
        }
        for (Long v : values2) {
            Assert.assertTrue((boolean)s.lookup(v.longValue()));
        }
        for (Long v : negatives2) {
            Assert.assertFalse((boolean)s.lookup(v.longValue()));
        }
    }

    @Test
    public void testSetLongRandom() {
        Random gen = new Random(98763537L);
        int i = 0;
        while (i < 200) {
            int size = gen.nextInt() % MAX_SIZE;
            if (size <= 0) continue;
            ++i;
            long[] values = new long[size];
            this.loadRandom(values, gen);
            CuckooSetLong s = new CuckooSetLong(size);
            this.loadSet(s, values);
            for (int j = 0; j != size; ++j) {
                Assert.assertTrue((boolean)s.lookup(values[j]));
            }
        }
    }

    @Test
    public void testSetDouble() {
        Double[] values = new Double[]{7021.0, 5780.0, 0.0, -1.0, 1.999E50};
        Double[] negatives = new Double[]{7000.0, -2.0, 1.9999E50};
        CuckooSetDouble s = new CuckooSetDouble(values.length);
        for (Double v : values) {
            s.insert(v.doubleValue());
        }
        for (Double v : values) {
            Assert.assertTrue((boolean)s.lookup(v.doubleValue()));
        }
        for (Double v : negatives) {
            Assert.assertFalse((boolean)s.lookup(v.doubleValue()));
        }
    }

    @Test
    public void testSetBytes() {
        String[] strings = new String[]{"foo", "bar", "baz", "a", "", "x1341", "Z"};
        String[] negativeStrings = new String[]{"not", "in", "the", "set", "foobar"};
        byte[][] values = this.getByteArrays(strings);
        byte[][] negatives = this.getByteArrays(negativeStrings);
        CuckooSetBytes s = new CuckooSetBytes(strings.length);
        for (byte[] v : values) {
            s.insert(v);
        }
        for (byte[] v : values) {
            Assert.assertTrue((boolean)s.lookup(v, 0, v.length));
        }
        for (byte[] v : negatives) {
            Assert.assertFalse((boolean)s.lookup(v, 0, v.length));
        }
        byte[] buf = this.getUTF8Bytes("thewordfooisinhere");
        Assert.assertTrue((boolean)s.lookup(buf, 7, 3));
    }

    @Test
    public void testSetBytesLargeRandom() {
        Random gen = new Random(98763537L);
        int i = 0;
        while (i < 200) {
            int size = gen.nextInt() % MAX_SIZE;
            if (size <= 0) continue;
            ++i;
            byte[][] values = new byte[size][];
            this.loadRandomBytes(values, gen);
            CuckooSetBytes s = new CuckooSetBytes(size);
            this.loadSet(s, values);
            for (int j = 0; j != size; ++j) {
                Assert.assertTrue((boolean)s.lookup(values[j], 0, values[j].length));
            }
        }
    }

    public void loadRandomBytes(byte[][] values, Random gen) {
        for (int i = 0; i != values.length; ++i) {
            values[i] = this.getUTF8Bytes(Integer.toString(gen.nextInt()));
        }
    }

    private byte[] getUTF8Bytes(String s) {
        byte[] v = null;
        try {
            v = s.getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    private byte[][] getByteArrays(String[] strings) {
        byte[][] values = new byte[strings.length][];
        for (int i = 0; i != strings.length; ++i) {
            try {
                values[i] = strings[i].getBytes("UTF-8");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return values;
    }

    private void loadSet(CuckooSetLong s, long[] values) {
        long[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long v = arr$[i$];
            s.insert(v.longValue());
        }
    }

    private void loadSet(CuckooSetBytes s, byte[][] values) {
        for (byte[] v : values) {
            s.insert(v);
        }
    }

    private void loadRandom(long[] a, Random gen) {
        int size = a.length;
        for (int i = 0; i != size; ++i) {
            a[i] = gen.nextLong();
        }
    }
}

