/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.dag.api.TezException;

public class SampleTezSessionState
extends TezSessionState {
    private boolean open;
    private final String sessionId;
    private HiveConf hiveConf;
    private String user;
    private boolean doAsEnabled;

    public SampleTezSessionState(String sessionId) {
        super(sessionId);
        this.sessionId = sessionId;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void open(HiveConf conf) throws IOException, LoginException, URISyntaxException, TezException {
        this.hiveConf = conf;
        UserGroupInformation ugi = Utils.getUGI();
        this.user = ugi.getShortUserName();
        this.doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
    }

    public void close(boolean keepTmpDir) throws TezException, IOException {
        this.open = keepTmpDir;
    }

    public HiveConf getConf() {
        return this.hiveConf;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUser() {
        return this.user;
    }

    public boolean getDoAsEnabled() {
        return this.doAsEnabled;
    }
}

