/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.session;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkSessionManagerImpl {
    private static final Log LOG = LogFactory.getLog(TestSparkSessionManagerImpl.class);
    private SparkSessionManagerImpl sessionManagerHS2 = null;
    private boolean anyFailedSessionThread;

    @Test
    public void testSingleSessionMultipleUse() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("spark.master", "local");
        SparkSessionManagerImpl sessionManager = SparkSessionManagerImpl.getInstance();
        SparkSession sparkSession1 = sessionManager.getSession(null, conf, true);
        Assert.assertTrue((boolean)sparkSession1.isOpen());
        SparkSession sparkSession2 = sessionManager.getSession(sparkSession1, conf, true);
        Assert.assertTrue((sparkSession1 == sparkSession2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sparkSession2.isOpen());
        sessionManager.shutdown();
        sessionManager.closeSession(sparkSession1);
    }

    @Test
    public void testMultiSessionMultipleUse() throws Exception {
        this.sessionManagerHS2 = SparkSessionManagerImpl.getInstance();
        this.sessionManagerHS2.shutdown();
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("spark.master", "local");
        this.sessionManagerHS2.setup(hiveConf);
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread((Runnable)new SessionThread(), "Session thread " + i);
            t.start();
            threadList.add(t);
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                String msg = "Interrupted while waiting for test session threads.";
                LOG.error((Object)msg, (Throwable)e);
                Assert.fail((String)msg);
            }
        }
        Assert.assertFalse((String)"At least one of the session threads failed. See the test output for details.", (boolean)this.anyFailedSessionThread);
        System.out.println("Ending SessionManagerHS2");
        this.sessionManagerHS2.shutdown();
    }

    public class SessionThread
    implements Runnable {
        @Override
        public void run() {
            try {
                Random random = new Random(Thread.currentThread().getId());
                String threadName = Thread.currentThread().getName();
                System.out.println(threadName + " started.");
                HiveConf conf = new HiveConf();
                conf.set("spark.master", "local");
                SparkSession prevSession = null;
                SparkSession currentSession = null;
                for (int i = 0; i < 5; ++i) {
                    currentSession = TestSparkSessionManagerImpl.this.sessionManagerHS2.getSession(prevSession, conf, true);
                    Assert.assertTrue((prevSession == null || prevSession == currentSession ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)currentSession.isOpen());
                    System.out.println(String.format("%s got session (%d): %s", threadName, i, currentSession.getSessionId()));
                    Thread.sleep((random.nextInt(3) + 1) * 1000);
                    TestSparkSessionManagerImpl.this.sessionManagerHS2.returnSession(currentSession);
                    prevSession = currentSession;
                }
                TestSparkSessionManagerImpl.this.sessionManagerHS2.closeSession(currentSession);
                System.out.println(threadName + " ended.");
            }
            catch (Throwable e) {
                TestSparkSessionManagerImpl.this.anyFailedSessionThread = true;
                String msg = String.format("Error executing '%s'", Thread.currentThread().getName());
                LOG.error((Object)msg, e);
                Assert.fail((String)(msg + " " + StringUtils.stringifyException((Throwable)e)));
            }
        }
    }
}

