/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import parquet.common.schema.ColumnPath;
import parquet.filter2.predicate.Operators;
import parquet.io.api.Binary;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;

public class ValidTypeMap {
    private static final Map<Class<?>, Set<FullTypeDescriptor>> classToParquetType = new HashMap();
    private static final Map<FullTypeDescriptor, Set<Class<?>>> parquetTypeToClass = new HashMap();

    private ValidTypeMap() {
    }

    private static void add(Class<?> c, FullTypeDescriptor f) {
        Set<FullTypeDescriptor> descriptors = classToParquetType.get(c);
        if (descriptors == null) {
            descriptors = new HashSet<FullTypeDescriptor>();
            classToParquetType.put(c, descriptors);
        }
        descriptors.add(f);
        Set<Class<?>> classes = parquetTypeToClass.get(f);
        if (classes == null) {
            classes = new HashSet();
            parquetTypeToClass.put(f, classes);
        }
        classes.add(c);
    }

    public static <T extends Comparable<T>> void assertTypeValid(Operators.Column<T> foundColumn, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType) {
        Class<T> foundColumnType = foundColumn.getColumnType();
        ColumnPath columnPath = foundColumn.getColumnPath();
        Set<FullTypeDescriptor> validTypeDescriptors = classToParquetType.get(foundColumnType);
        FullTypeDescriptor typeInFileMetaData = new FullTypeDescriptor(primitiveType, originalType);
        if (validTypeDescriptors == null) {
            StringBuilder message = new StringBuilder();
            message.append("Column ").append(columnPath.toDotString()).append(" was declared as type: ").append(foundColumnType.getName()).append(" which is not supported in FilterPredicates.");
            Set<Class<?>> supportedTypes = parquetTypeToClass.get(typeInFileMetaData);
            if (supportedTypes != null) {
                message.append(" Supported types for this column are: ").append(supportedTypes);
            } else {
                message.append(" There are no supported types for columns of " + typeInFileMetaData);
            }
            throw new IllegalArgumentException(message.toString());
        }
        if (!validTypeDescriptors.contains(typeInFileMetaData)) {
            StringBuilder message = new StringBuilder();
            message.append("FilterPredicate column: ").append(columnPath.toDotString()).append("'s declared type (").append(foundColumnType.getName()).append(") does not match the schema found in file metadata. Column ").append(columnPath.toDotString()).append(" is of type: ").append(typeInFileMetaData).append("\nValid types for this column are: ").append(parquetTypeToClass.get(typeInFileMetaData));
            throw new IllegalArgumentException(message.toString());
        }
    }

    static {
        ValidTypeMap.add(Integer.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.INT32, null));
        ValidTypeMap.add(Long.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.INT64, null));
        ValidTypeMap.add(Float.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.FLOAT, null));
        ValidTypeMap.add(Double.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.DOUBLE, null));
        ValidTypeMap.add(Boolean.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.BOOLEAN, null));
        ValidTypeMap.add(Binary.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.BINARY, null));
        ValidTypeMap.add(Binary.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, null));
        ValidTypeMap.add(Binary.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.UTF8));
        ValidTypeMap.add(Binary.class, new FullTypeDescriptor(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, OriginalType.UTF8));
    }

    private static final class FullTypeDescriptor {
        private final PrimitiveType.PrimitiveTypeName primitiveType;
        private final OriginalType originalType;

        private FullTypeDescriptor(PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType) {
            this.primitiveType = primitiveType;
            this.originalType = originalType;
        }

        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        public OriginalType getOriginalType() {
            return this.originalType;
        }

        public String toString() {
            return "FullTypeDescriptor(PrimitiveType: " + (Object)((Object)this.primitiveType) + ", OriginalType: " + (Object)((Object)this.originalType) + ')';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullTypeDescriptor that = (FullTypeDescriptor)o;
            if (this.originalType != that.originalType) {
                return false;
            }
            return this.primitiveType == that.primitiveType;
        }

        public int hashCode() {
            int result = this.primitiveType != null ? this.primitiveType.hashCode() : 0;
            result = 31 * result + (this.originalType != null ? this.originalType.hashCode() : 0);
            return result;
        }
    }
}

