/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="HashTable Sink Operator")
public class HashTableSinkDesc
extends JoinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean handleSkewJoin = false;
    private int skewKeyDefinition = -1;
    private Map<Byte, Path> bigKeysDirMap;
    private Map<Byte, Map<Byte, Path>> smallKeysDirMap;
    private Map<Byte, TableDesc> skewKeysValuesTables;
    private Map<Byte, List<ExprNodeDesc>> exprs;
    private Map<Byte, List<ExprNodeDesc>> filters;
    private int[][] filterMap;
    protected List<String> outputColumnNames;
    private transient Map<String, Byte> reversedExprs;
    protected boolean noOuterJoin;
    protected JoinCondDesc[] conds;
    protected Byte[] tagOrder;
    private TableDesc keyTableDesc;
    private Map<Byte, List<ExprNodeDesc>> keys;
    private TableDesc keyTblDesc;
    private List<TableDesc> valueTblDescs;
    private List<TableDesc> valueTblFilteredDescs;
    private int posBigTable;
    private Map<Byte, List<Integer>> retainList;
    private transient BucketMapJoinContext bucketMapjoinContext;
    private float hashtableMemoryUsage;
    private String dumpFilePrefix;

    public HashTableSinkDesc() {
        this.bucketMapjoinContext = new BucketMapJoinContext();
    }

    public HashTableSinkDesc(MapJoinDesc clone) {
        this.bigKeysDirMap = clone.getBigKeysDirMap();
        this.conds = clone.getConds();
        this.exprs = new HashMap<Byte, List<ExprNodeDesc>>(clone.getExprs());
        this.handleSkewJoin = clone.getHandleSkewJoin();
        this.keyTableDesc = clone.getKeyTableDesc();
        this.noOuterJoin = clone.getNoOuterJoin();
        this.outputColumnNames = clone.getOutputColumnNames();
        this.reversedExprs = clone.getReversedExprs();
        this.skewKeyDefinition = clone.getSkewKeyDefinition();
        this.skewKeysValuesTables = clone.getSkewKeysValuesTables();
        this.smallKeysDirMap = clone.getSmallKeysDirMap();
        this.tagOrder = clone.getTagOrder();
        this.filters = new HashMap<Byte, List<ExprNodeDesc>>(clone.getFilters());
        this.filterMap = clone.getFilterMap();
        this.keys = new HashMap<Byte, List<ExprNodeDesc>>(clone.getKeys());
        this.keyTblDesc = clone.getKeyTblDesc();
        this.valueTblDescs = clone.getValueTblDescs();
        this.valueTblFilteredDescs = clone.getValueFilteredTblDescs();
        this.posBigTable = clone.getPosBigTable();
        this.retainList = clone.getRetainList();
        this.dumpFilePrefix = clone.getDumpFilePrefix();
        this.bucketMapjoinContext = new BucketMapJoinContext(clone);
        this.hashtableMemoryUsage = clone.getHashTableMemoryUsage();
    }

    public float getHashtableMemoryUsage() {
        return this.hashtableMemoryUsage;
    }

    public void setHashtableMemoryUsage(float hashtableMemoryUsage) {
        this.hashtableMemoryUsage = hashtableMemoryUsage;
    }

    public String getDumpFilePrefix() {
        return this.dumpFilePrefix;
    }

    public void setDumpFilePrefix(String dumpFilePrefix) {
        this.dumpFilePrefix = dumpFilePrefix;
    }

    public boolean isHandleSkewJoin() {
        return this.handleSkewJoin;
    }

    @Override
    public void setHandleSkewJoin(boolean handleSkewJoin) {
        this.handleSkewJoin = handleSkewJoin;
    }

    @Override
    public int getSkewKeyDefinition() {
        return this.skewKeyDefinition;
    }

    @Override
    public void setSkewKeyDefinition(int skewKeyDefinition) {
        this.skewKeyDefinition = skewKeyDefinition;
    }

    @Override
    public Map<Byte, Path> getBigKeysDirMap() {
        return this.bigKeysDirMap;
    }

    @Override
    public void setBigKeysDirMap(Map<Byte, Path> bigKeysDirMap) {
        this.bigKeysDirMap = bigKeysDirMap;
    }

    @Override
    public Map<Byte, Map<Byte, Path>> getSmallKeysDirMap() {
        return this.smallKeysDirMap;
    }

    @Override
    public void setSmallKeysDirMap(Map<Byte, Map<Byte, Path>> smallKeysDirMap) {
        this.smallKeysDirMap = smallKeysDirMap;
    }

    @Override
    public Map<Byte, TableDesc> getSkewKeysValuesTables() {
        return this.skewKeysValuesTables;
    }

    @Override
    public void setSkewKeysValuesTables(Map<Byte, TableDesc> skewKeysValuesTables) {
        this.skewKeysValuesTables = skewKeysValuesTables;
    }

    @Override
    public Map<Byte, List<ExprNodeDesc>> getExprs() {
        return this.exprs;
    }

    @Override
    public void setExprs(Map<Byte, List<ExprNodeDesc>> exprs) {
        this.exprs = exprs;
    }

    @Override
    public Map<Byte, List<ExprNodeDesc>> getFilters() {
        return this.filters;
    }

    public List<TableDesc> getValueTblFilteredDescs() {
        return this.valueTblFilteredDescs;
    }

    public void setValueTblFilteredDescs(List<TableDesc> valueTblFilteredDescs) {
        this.valueTblFilteredDescs = valueTblFilteredDescs;
    }

    @Override
    public void setFilters(Map<Byte, List<ExprNodeDesc>> filters) {
        this.filters = filters;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Override
    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    @Override
    public Map<String, Byte> getReversedExprs() {
        return this.reversedExprs;
    }

    @Override
    public void setReversedExprs(Map<String, Byte> reversedExprs) {
        this.reversedExprs = reversedExprs;
    }

    @Override
    public boolean isNoOuterJoin() {
        return this.noOuterJoin;
    }

    @Override
    public void setNoOuterJoin(boolean noOuterJoin) {
        this.noOuterJoin = noOuterJoin;
    }

    @Override
    public JoinCondDesc[] getConds() {
        return this.conds;
    }

    @Override
    public void setConds(JoinCondDesc[] conds) {
        this.conds = conds;
    }

    @Override
    public Byte[] getTagOrder() {
        return this.tagOrder;
    }

    @Override
    public void setTagOrder(Byte[] tagOrder) {
        this.tagOrder = tagOrder;
    }

    @Override
    public TableDesc getKeyTableDesc() {
        return this.keyTableDesc;
    }

    @Override
    public void setKeyTableDesc(TableDesc keyTableDesc) {
        this.keyTableDesc = keyTableDesc;
    }

    @Override
    public int[][] getFilterMap() {
        return this.filterMap;
    }

    @Override
    public void setFilterMap(int[][] filterMap) {
        this.filterMap = filterMap;
    }

    @Override
    @Explain(displayName="filter mappings", normalExplain=false)
    public Map<Integer, String> getFilterMapString() {
        return this.toCompactString(this.filterMap);
    }

    public Map<Byte, List<Integer>> getRetainList() {
        return this.retainList;
    }

    public void setRetainList(Map<Byte, List<Integer>> retainList) {
        this.retainList = retainList;
    }

    @Override
    @Explain(displayName="keys")
    public Map<Byte, String> getKeysString() {
        LinkedHashMap<Byte, String> keyMap = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> k : this.getKeys().entrySet()) {
            keyMap.put(k.getKey(), PlanUtils.getExprListString((Collection<ExprNodeDesc>)k.getValue()));
        }
        return keyMap;
    }

    public Map<Byte, List<ExprNodeDesc>> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<Byte, List<ExprNodeDesc>> keys) {
        this.keys = keys;
    }

    @Explain(displayName="Position of Big Table", normalExplain=false)
    public int getPosBigTable() {
        return this.posBigTable;
    }

    public void setPosBigTable(int posBigTable) {
        this.posBigTable = posBigTable;
    }

    public TableDesc getKeyTblDesc() {
        return this.keyTblDesc;
    }

    public void setKeyTblDesc(TableDesc keyTblDesc) {
        this.keyTblDesc = keyTblDesc;
    }

    public List<TableDesc> getValueTblDescs() {
        return this.valueTblDescs;
    }

    public void setValueTblDescs(List<TableDesc> valueTblDescs) {
        this.valueTblDescs = valueTblDescs;
    }

    public BucketMapJoinContext getBucketMapjoinContext() {
        return this.bucketMapjoinContext;
    }

    public void setBucketMapjoinContext(BucketMapJoinContext bucketMapjoinContext) {
        this.bucketMapjoinContext = bucketMapjoinContext;
    }
}

