/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.stats;

import com.google.common.base.Function;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.BuiltInMetadata;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUniqueKeys;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.relopt.hep.HepRelVertex;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;

public class HiveRelMdUniqueKeys {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltinMethod.UNIQUE_KEYS.method, (Object)new HiveRelMdUniqueKeys());

    public Set<BitSet> getUniqueKeys(ProjectRelBase rel, boolean ignoreNulls) {
        HiveTableScanRel tScan = HiveRelMdUniqueKeys.getTableScan(rel.getChild(), false);
        if (tScan == null) {
            Function fn = RelMdUniqueKeys.SOURCE.apply(rel.getClass(), BuiltInMetadata.UniqueKeys.class);
            return ((BuiltInMetadata.UniqueKeys)fn.apply(rel)).getUniqueKeys(ignoreNulls);
        }
        HashMap<Integer, Integer> posMap = new HashMap<Integer, Integer>();
        int projectPos = 0;
        int colStatsPos = 0;
        BitSet projectedCols = new BitSet();
        for (RexNode r : rel.getProjects()) {
            if (r instanceof RexInputRef) {
                projectedCols.set(((RexInputRef)r).getIndex());
                posMap.put(colStatsPos, projectPos);
                ++colStatsPos;
            }
            ++projectPos;
        }
        double numRows = tScan.getRows();
        List<ColStatistics> colStats = tScan.getColStat((List<Integer>)BitSets.toList((BitSet)projectedCols));
        HashSet<BitSet> keys = new HashSet<BitSet>();
        colStatsPos = 0;
        for (ColStatistics cStat : colStats) {
            boolean isKey = false;
            if ((double)cStat.getCountDistint() >= numRows) {
                isKey = true;
            }
            if (!isKey && cStat.getRange() != null && cStat.getRange().maxValue != null && cStat.getRange().minValue != null) {
                double r = cStat.getRange().maxValue.doubleValue() - cStat.getRange().minValue.doubleValue() + 1.0;
                boolean bl = isKey = numRows == r;
            }
            if (isKey) {
                BitSet key = new BitSet();
                key.set((Integer)posMap.get(colStatsPos));
                keys.add(key);
            }
            ++colStatsPos;
        }
        return keys;
    }

    static HiveTableScanRel getTableScan(RelNode r, boolean traverseProject) {
        while (r != null && !(r instanceof HiveTableScanRel)) {
            if (r instanceof HepRelVertex) {
                r = ((HepRelVertex)r).getCurrentRel();
                continue;
            }
            if (r instanceof FilterRelBase) {
                r = ((FilterRelBase)r).getChild();
                continue;
            }
            if (traverseProject && r instanceof ProjectRelBase) {
                r = ((ProjectRelBase)r).getChild();
                continue;
            }
            r = null;
        }
        return r == null ? null : (HiveTableScanRel)r;
    }
}

