/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.rules;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveFilterRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveProjectRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptRuleOperandChildren;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.sql.SqlKind;

public abstract class HivePushFilterPastJoinRule
extends PushFilterPastJoinRule {
    public static final HivePushFilterPastJoinRule FILTER_ON_JOIN = new HivePushFilterIntoJoinRule();
    public static final HivePushFilterPastJoinRule JOIN = new HivePushDownJoinConditionRule();

    protected HivePushFilterPastJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        super(operand, id, smart, filterFactory, projectFactory);
    }

    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, JoinRelBase join, JoinRelType joinType) {
        if (joinType.equals((Object)JoinRelType.INNER)) {
            ListIterator<RexNode> filterIter = joinFilters.listIterator();
            while (filterIter.hasNext()) {
                RexNode exp = filterIter.next();
                if (exp instanceof RexCall) {
                    RexCall c = (RexCall)exp;
                    boolean validHiveJoinFilter = false;
                    if (c.getOperator().getKind() == SqlKind.EQUALS) {
                        validHiveJoinFilter = true;
                        for (RexNode rn : c.getOperands()) {
                            if (!this.filterRefersToBothSidesOfJoin(rn, join)) continue;
                            validHiveJoinFilter = false;
                            break;
                        }
                    } else if (c.getOperator().getKind() == SqlKind.LESS_THAN || c.getOperator().getKind() == SqlKind.GREATER_THAN || c.getOperator().getKind() == SqlKind.LESS_THAN_OR_EQUAL || c.getOperator().getKind() == SqlKind.GREATER_THAN_OR_EQUAL) {
                        validHiveJoinFilter = true;
                        if (this.filterRefersToBothSidesOfJoin((RexNode)c, join)) {
                            validHiveJoinFilter = false;
                        }
                    }
                    if (validHiveJoinFilter) continue;
                }
                aboveFilters.add(exp);
                filterIter.remove();
            }
        }
    }

    private boolean filterRefersToBothSidesOfJoin(RexNode filter, JoinRelBase j) {
        boolean refersToBothSides = false;
        int joinNoOfProjects = j.getRowType().getFieldCount();
        BitSet filterProjs = new BitSet(joinNoOfProjects);
        BitSet allLeftProjs = new BitSet(joinNoOfProjects);
        BitSet allRightProjs = new BitSet(joinNoOfProjects);
        allLeftProjs.set(0, j.getInput(0).getRowType().getFieldCount(), true);
        allRightProjs.set(j.getInput(0).getRowType().getFieldCount(), joinNoOfProjects, true);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(filterProjs);
        filter.accept((RexVisitor)inputFinder);
        if (allLeftProjs.intersects(filterProjs) && allRightProjs.intersects(filterProjs)) {
            refersToBothSides = true;
        }
        return refersToBothSides;
    }

    public static class HivePushDownJoinConditionRule
    extends HivePushFilterPastJoinRule {
        public HivePushDownJoinConditionRule() {
            super(RelOptRule.operand(JoinRelBase.class, (RelOptRuleOperandChildren)RelOptRule.any()), "HivePushFilterPastJoinRule:no-filter", true, HiveFilterRel.DEFAULT_FILTER_FACTORY, HiveProjectRel.DEFAULT_PROJECT_FACTORY);
        }

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            super.perform(call, null, join);
        }
    }

    public static class HivePushFilterIntoJoinRule
    extends HivePushFilterPastJoinRule {
        public HivePushFilterIntoJoinRule() {
            super(RelOptRule.operand(FilterRelBase.class, (RelOptRuleOperand)RelOptRule.operand(JoinRelBase.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HivePushFilterPastJoinRule:filter", true, HiveFilterRel.DEFAULT_FILTER_FACTORY, HiveProjectRel.DEFAULT_PROJECT_FACTORY);
        }

        public void onMatch(RelOptRuleCall call) {
            FilterRelBase filter = (FilterRelBase)call.rel(0);
            JoinRelBase join = (JoinRelBase)call.rel(1);
            super.perform(call, filter, join);
        }
    }
}

