/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import parquet.Log;
import parquet.column.values.ValuesReader;
import parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import parquet.io.api.Binary;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private byte[] in;
    private int offset;

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.lengthReader.initFromPage(valueCount, in, offset);
        offset = this.lengthReader.getNextOffset();
        this.in = in;
        this.offset = offset;
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        int start = this.offset;
        this.offset = start + length;
        return Binary.fromConstantByteArray(this.in, start, length);
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        this.offset += length;
    }
}

