/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.statistics;

import parquet.bytes.BytesUtils;
import parquet.column.statistics.Statistics;

public class LongStatistics
extends Statistics<Long> {
    private long max;
    private long min;

    @Override
    public void updateStats(long value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        LongStatistics longStats = (LongStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(longStats.getMin(), longStats.getMax());
        } else {
            this.updateStats(longStats.getMin(), longStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToLong(maxBytes);
        this.min = BytesUtils.bytesToLong(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.longToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.longToBytes(this.min);
    }

    @Override
    public boolean isSmallerThan(long size) {
        return !this.hasNonNullValue() || 16L < size;
    }

    @Override
    public String toString() {
        if (this.hasNonNullValue()) {
            return String.format("min: %d, max: %d, num_nulls: %d", this.min, this.max, this.getNumNulls());
        }
        if (!this.isEmpty()) {
            return String.format("num_nulls: %d, min/max not defined", this.getNumNulls());
        }
        return "no stats for this column";
    }

    public void updateStats(long min_value, long max_value) {
        if (min_value < this.min) {
            this.min = min_value;
        }
        if (max_value > this.max) {
            this.max = max_value;
        }
    }

    public void initializeStats(long min_value, long max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    @Override
    public Long genericGetMin() {
        return this.min;
    }

    @Override
    public Long genericGetMax() {
        return this.max;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public void setMinMax(long min, long max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }
}

