/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBasePad;
import org.apache.hadoop.io.Text;

@Description(name="rpad", value="_FUNC_(str, len, pad) - Returns str, right-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nIn case of empty pad string, the return value is null.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  'hi???'\n  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'\n  > SELECT _FUNC_('hi', 5, '') FROM src LIMIT 1;\n  null")
public class GenericUDFRpad
extends GenericUDFBasePad {
    public GenericUDFRpad() {
        super("rpad");
    }

    @Override
    protected void performOp(byte[] data, byte[] txt, byte[] padTxt, int len, Text str, Text pad) {
        int pos;
        for (pos = 0; pos < str.getLength() && pos < len; ++pos) {
            data[pos] = txt[pos];
        }
        while (pos < len) {
            for (int i = 0; i < pad.getLength() && i < len - pos; ++i) {
                data[pos + i] = padTxt[i];
            }
            pos += pad.getLength();
        }
    }
}

