/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="max", value="_FUNC_(expr) - Returns the maximum value of expr")
public class GenericUDAFMax
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFMax.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(parameters[0]);
        if (!ObjectInspectorUtils.compareSupported(oi)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFMaxEvaluator();
    }

    static class MaxStreamingFixedWindow
    extends GenericUDAFStreamingEvaluator<Object> {
        public MaxStreamingFixedWindow(GenericUDAFEvaluator wrappedEval, WindowFrameDef wFrmDef) {
            super(wrappedEval, wFrmDef);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new State(underlying);
        }

        protected ObjectInspector inputOI() {
            return ((GenericUDAFMaxEvaluator)this.wrappedEval).inputOI;
        }

        protected ObjectInspector outputOI() {
            return ((GenericUDAFMaxEvaluator)this.wrappedEval).outputOI;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            State s = (State)agg;
            Object o = parameters[0];
            while (!s.maxChain.isEmpty() && this.removeLast(o, ((Object[])s.maxChain.getLast())[0])) {
                s.maxChain.removeLast();
            }
            if (s.numRows == 0) {
                for (int i = this.wFrameDef.getEnd().getRelativeOffset(); i < 0; ++i) {
                    s.results.add(null);
                }
            }
            if (!this.wFrameDef.isStartUnbounded() || s.maxChain.isEmpty()) {
                o = o == null ? null : ObjectInspectorUtils.copyToStandardObject(o, this.inputOI(), ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                s.maxChain.addLast(new Object[]{o, s.numRows});
            }
            if (s.numRows >= this.wFrameDef.getEnd().getRelativeOffset()) {
                s.results.add(((Object[])s.maxChain.getFirst())[0]);
            }
            ++s.numRows;
            int fIdx = (Integer)((Object[])s.maxChain.getFirst())[1];
            if (!this.wFrameDef.isStartUnbounded() && s.numRows >= fIdx + this.wFrameDef.getWindowSize()) {
                s.maxChain.removeFirst();
            }
        }

        protected boolean removeLast(Object in, Object last) {
            return this.isGreater(in, last);
        }

        private boolean isGreater(Object in, Object last) {
            if (in == null) {
                return false;
            }
            if (last == null) {
                return true;
            }
            return ObjectInspectorUtils.compare(in, this.inputOI(), last, this.outputOI()) > 0;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            int i;
            State s = (State)agg;
            Object[] r = s.maxChain.isEmpty() ? null : (Object[])s.maxChain.getFirst();
            for (i = Math.max(0, this.wFrameDef.getStart().getRelativeOffset()); i < this.wFrameDef.getEnd().getRelativeOffset(); ++i) {
                s.results.add(r == null ? null : r[0]);
                ++s.numRows;
                if (r == null) continue;
                int fIdx = (Integer)r[1];
                if (this.wFrameDef.isStartUnbounded() || s.numRows + i < fIdx + this.wFrameDef.getWindowSize() || s.maxChain.isEmpty()) continue;
                s.maxChain.removeFirst();
                r = !s.maxChain.isEmpty() ? (Object[])s.maxChain.getFirst() : r;
            }
            for (i = 0; i < this.wFrameDef.getStart().getRelativeOffset(); ++i) {
                s.results.add(null);
                ++s.numRows;
            }
            return null;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        class State
        extends GenericUDAFStreamingEvaluator.StreamingState {
            private final Deque<Object[]> maxChain;

            public State(GenericUDAFEvaluator.AggregationBuffer buf) {
                super(MaxStreamingFixedWindow.this, buf);
                this.maxChain = new ArrayDeque<Object[]>(MaxStreamingFixedWindow.this.wFrameDef.isStartUnbounded() ? 1 : MaxStreamingFixedWindow.this.wFrameDef.getWindowSize());
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                if (MaxStreamingFixedWindow.this.wFrameDef.isStartUnbounded()) {
                    return -1;
                }
                int wdwSz = MaxStreamingFixedWindow.this.wFrameDef.getWindowSize();
                return underlying + underlying * wdwSz + underlying * wdwSz + 12;
            }

            @Override
            protected void reset() {
                this.maxChain.clear();
                super.reset();
            }
        }
    }

    @UDFType(distinctLike=true)
    public static class GenericUDAFMaxEvaluator
    extends GenericUDAFEvaluator {
        private transient ObjectInspector inputOI;
        private transient ObjectInspector outputOI;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MaxAgg result = new MaxAgg();
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg myagg = (MaxAgg)agg;
            myagg.o = null;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            this.merge(agg, parameters[0]);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                MaxAgg myagg = (MaxAgg)agg;
                int r = ObjectInspectorUtils.compare(myagg.o, this.outputOI, partial, this.inputOI);
                if (myagg.o == null || r < 0) {
                    myagg.o = ObjectInspectorUtils.copyToStandardObject(partial, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaxAgg myagg = (MaxAgg)agg;
            return myagg.o;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            return new MaxStreamingFixedWindow(this, wFrmDef);
        }

        static class MaxAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Object o;

            MaxAgg() {
            }
        }
    }
}

