/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class LoadTableDesc
extends LoadDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean replace;
    private DynamicPartitionCtx dpCtx;
    private ListBucketingCtx lbCtx;
    private boolean holdDDLTime;
    private boolean inheritTableSpecs = true;
    private AcidUtils.Operation writeType;
    private TableDesc table;
    private Map<String, String> partitionSpec;

    public LoadTableDesc() {
        this.holdDDLTime = false;
    }

    public LoadTableDesc(LoadTableDesc o) {
        super(o.getSourcePath());
        this.replace = o.getReplace();
        this.dpCtx = o.getDPCtx();
        this.lbCtx = o.getLbCtx();
        this.inheritTableSpecs = o.getInheritTableSpecs();
        this.writeType = o.getWriteType();
        this.table = o.getTable();
        this.partitionSpec = o.getPartitionSpec();
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, boolean replace, AcidUtils.Operation writeType) {
        super(sourcePath);
        this.init(table, partitionSpec, replace, writeType);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, boolean replace) {
        this(sourcePath, table, partitionSpec, replace, AcidUtils.Operation.NOT_ACID);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, AcidUtils.Operation writeType) {
        this(sourcePath, table, partitionSpec, true, writeType);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec) {
        this(sourcePath, table, partitionSpec, true, AcidUtils.Operation.NOT_ACID);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, DynamicPartitionCtx dpCtx, AcidUtils.Operation writeType) {
        super(sourcePath);
        this.dpCtx = dpCtx;
        if (dpCtx != null && dpCtx.getPartSpec() != null && this.partitionSpec == null) {
            this.init(table, dpCtx.getPartSpec(), true, writeType);
        } else {
            this.init(table, new LinkedHashMap<String, String>(), true, writeType);
        }
    }

    private void init(TableDesc table, Map<String, String> partitionSpec, boolean replace, AcidUtils.Operation writeType) {
        this.table = table;
        this.partitionSpec = partitionSpec;
        this.replace = replace;
        this.holdDDLTime = false;
        this.writeType = writeType;
    }

    public void setHoldDDLTime(boolean ddlTime) {
        this.holdDDLTime = ddlTime;
    }

    public boolean getHoldDDLTime() {
        return this.holdDDLTime;
    }

    @Explain(displayName="table")
    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    @Explain(displayName="partition")
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public void setPartitionSpec(Map<String, String> partitionSpec) {
        this.partitionSpec = partitionSpec;
    }

    @Explain(displayName="replace")
    public boolean getReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public DynamicPartitionCtx getDPCtx() {
        return this.dpCtx;
    }

    public void setDPCtx(DynamicPartitionCtx dpCtx) {
        this.dpCtx = dpCtx;
    }

    public boolean getInheritTableSpecs() {
        return this.inheritTableSpecs;
    }

    public void setInheritTableSpecs(boolean inheritTableSpecs) {
        this.inheritTableSpecs = inheritTableSpecs;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public void setLbCtx(ListBucketingCtx lbCtx) {
        this.lbCtx = lbCtx;
    }

    public AcidUtils.Operation getWriteType() {
        return this.writeType;
    }
}

