/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;

public class HiveCalciteUtil {
    public static List<Integer> getVirtualCols(List<? extends RexNode> exps) {
        ArrayList<Integer> vCols = new ArrayList<Integer>();
        for (int i = 0; i < exps.size(); ++i) {
            if (exps.get(i) instanceof RexInputRef) continue;
            vCols.add(i);
        }
        return vCols;
    }

    public static boolean validateASTForUnsupportedTokens(ASTNode ast) {
        return !ParseUtils.containsTokenOfType(ast, 642, 872);
    }

    public static List<RexNode> getProjsFromBelowAsInputRef(final RelNode rel) {
        List<RexNode> projectList = Lists.transform(rel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

            @Override
            public RexNode apply(RelDataTypeField field) {
                return rel.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
            }
        });
        return projectList;
    }

    public static List<Integer> translateBitSetToProjIndx(ImmutableBitSet projBitSet) {
        ArrayList<Integer> projIndxLst = new ArrayList<Integer>();
        for (int i = 0; i < projBitSet.length(); ++i) {
            if (!projBitSet.get(i)) continue;
            projIndxLst.add(i);
        }
        return projIndxLst;
    }

    public static RexNode projectNonColumnEquiConditions(RelFactories.ProjectFactory factory, RelNode[] inputRels, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, int systemColCount, List<Integer> leftKeys, List<Integer> rightKeys) {
        RelDataTypeField field;
        int i;
        RelNode leftRel = inputRels[0];
        RelNode rightRel = inputRels[1];
        RexBuilder rexBuilder = leftRel.getCluster().getRexBuilder();
        RexNode outJoinCond = null;
        int origLeftInputSize = leftRel.getRowType().getFieldCount();
        int origRightInputSize = rightRel.getRowType().getFieldCount();
        ArrayList<Object> newLeftFields = new ArrayList<Object>();
        ArrayList<String> newLeftFieldNames = new ArrayList<String>();
        ArrayList<Object> newRightFields = new ArrayList<Object>();
        ArrayList<String> newRightFieldNames = new ArrayList<String>();
        int leftKeyCount = leftJoinKeys.size();
        for (i = 0; i < origLeftInputSize; ++i) {
            field = (RelDataTypeField)leftRel.getRowType().getFieldList().get(i);
            newLeftFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newLeftFieldNames.add(field.getName());
        }
        for (i = 0; i < origRightInputSize; ++i) {
            field = (RelDataTypeField)rightRel.getRowType().getFieldList().get(i);
            newRightFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newRightFieldNames.add(field.getName());
        }
        int newKeyCount = 0;
        ArrayList<Pair> origColEqConds = new ArrayList<Pair>();
        for (i = 0; i < leftKeyCount; ++i) {
            RexNode leftKey = leftJoinKeys.get(i);
            RexNode rightKey = rightJoinKeys.get(i);
            if (leftKey instanceof RexInputRef && rightKey instanceof RexInputRef) {
                origColEqConds.add(Pair.of((Object)((RexInputRef)leftKey).getIndex(), (Object)((RexInputRef)rightKey).getIndex()));
                continue;
            }
            newLeftFields.add(leftKey);
            newLeftFieldNames.add(null);
            newRightFields.add(rightKey);
            newRightFieldNames.add(null);
            ++newKeyCount;
        }
        for (i = 0; i < origColEqConds.size(); ++i) {
            Pair p = (Pair)origColEqConds.get(i);
            RexNode leftKey = leftJoinKeys.get(i);
            RexNode rightKey = rightJoinKeys.get(i);
            leftKeys.add((Integer)p.left);
            rightKeys.add((Integer)p.right);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(leftKey.getType(), systemColCount + (Integer)p.left), rexBuilder.makeInputRef(rightKey.getType(), systemColCount + origLeftInputSize + newKeyCount + (Integer)p.right)});
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{outJoinCond, cond});
        }
        if (newKeyCount == 0) {
            return outJoinCond;
        }
        int newLeftOffset = systemColCount + origLeftInputSize;
        int newRightOffset = systemColCount + origLeftInputSize + origRightInputSize + newKeyCount;
        for (i = 0; i < newKeyCount; ++i) {
            leftKeys.add(origLeftInputSize + i);
            rightKeys.add(origRightInputSize + i);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(((RexNode)newLeftFields.get(origLeftInputSize + i)).getType(), newLeftOffset + i), rexBuilder.makeInputRef(((RexNode)newRightFields.get(origRightInputSize + i)).getType(), newRightOffset + i)});
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{outJoinCond, cond});
        }
        if (newKeyCount > 0) {
            leftRel = factory.createProject(leftRel, newLeftFields, SqlValidatorUtil.uniquify(newLeftFieldNames));
            rightRel = factory.createProject(rightRel, newRightFields, SqlValidatorUtil.uniquify(newRightFieldNames));
        }
        inputRels[0] = leftRel;
        inputRels[1] = rightRel;
        return outJoinCond;
    }

    public static boolean limitRelNode(RelNode rel) {
        return rel instanceof Sort && ((Sort)rel).getCollation().getFieldCollations().isEmpty();
    }

    public static boolean orderRelNode(RelNode rel) {
        return rel instanceof Sort && !((Sort)rel).getCollation().getFieldCollations().isEmpty();
    }

    public static Pair<RelNode, RelNode> getTopLevelSelect(RelNode rootRel) {
        RelNode parentOforiginalProjRel = rootRel;
        HiveProject originalProjRel = null;
        for (RelNode tmpRel = rootRel; tmpRel != null; tmpRel = tmpRel.getInput(0)) {
            if (tmpRel instanceof HiveProject) {
                originalProjRel = (HiveProject)tmpRel;
                break;
            }
            parentOforiginalProjRel = tmpRel;
        }
        return new Pair((Object)parentOforiginalProjRel, originalProjRel);
    }

    public static boolean isDeterministic(RexNode expr) {
        boolean deterministic = true;
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            public Void visitCall(RexCall call) {
                if (!call.getOperator().isDeterministic()) {
                    throw new Util.FoundOne((Object)call);
                }
                return (Void)super.visitCall(call);
            }
        };
        try {
            expr.accept((RexVisitor)visitor);
        }
        catch (Util.FoundOne e) {
            deterministic = false;
        }
        return deterministic;
    }

    public static class JoinLeafPredicateInfo {
        private final SqlKind comparisonType;
        private final ImmutableList<RexNode> joinKeyExprsFromLeft;
        private final ImmutableList<RexNode> joinKeyExprsFromRight;
        private final ImmutableSet<Integer> projsFromLeftPartOfJoinKeysInChildSchema;
        private final ImmutableSet<Integer> projsFromRightPartOfJoinKeysInChildSchema;
        private final ImmutableSet<Integer> projsFromRightPartOfJoinKeysInJoinSchema;

        public JoinLeafPredicateInfo(SqlKind comparisonType, List<RexNode> joinKeyExprsFromLeft, List<RexNode> joinKeyExprsFromRight, Set<Integer> projsFromLeftPartOfJoinKeysInChildSchema, Set<Integer> projsFromRightPartOfJoinKeysInChildSchema, Set<Integer> projsFromRightPartOfJoinKeysInJoinSchema) {
            this.comparisonType = comparisonType;
            this.joinKeyExprsFromLeft = ImmutableList.copyOf(joinKeyExprsFromLeft);
            this.joinKeyExprsFromRight = ImmutableList.copyOf(joinKeyExprsFromRight);
            this.projsFromLeftPartOfJoinKeysInChildSchema = ImmutableSet.copyOf(projsFromLeftPartOfJoinKeysInChildSchema);
            this.projsFromRightPartOfJoinKeysInChildSchema = ImmutableSet.copyOf(projsFromRightPartOfJoinKeysInChildSchema);
            this.projsFromRightPartOfJoinKeysInJoinSchema = ImmutableSet.copyOf(projsFromRightPartOfJoinKeysInJoinSchema);
        }

        public List<RexNode> getJoinKeyExprsFromLeft() {
            return this.joinKeyExprsFromLeft;
        }

        public List<RexNode> getJoinKeyExprsFromRight() {
            return this.joinKeyExprsFromRight;
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInChildSchema() {
            return this.projsFromLeftPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInJoinSchema() {
            return this.projsFromLeftPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInChildSchema() {
            return this.projsFromRightPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInJoinSchema() {
            return this.projsFromRightPartOfJoinKeysInJoinSchema;
        }

        private static JoinLeafPredicateInfo constructJoinLeafPredicateInfo(HiveJoin j, RexNode pe) {
            JoinLeafPredicateInfo jlpi = null;
            ArrayList filterNulls = new ArrayList();
            ArrayList<RexNode> joinKeyExprsFromLeft = new ArrayList<RexNode>();
            ArrayList<RexNode> joinKeyExprsFromRight = new ArrayList<RexNode>();
            HashSet<Integer> projsFromLeftPartOfJoinKeysInChildSchema = new HashSet<Integer>();
            HashSet<Integer> projsFromRightPartOfJoinKeysInChildSchema = new HashSet<Integer>();
            HashSet<Integer> projsFromRightPartOfJoinKeysInJoinSchema = new HashSet<Integer>();
            int rightOffSet = j.getLeft().getRowType().getFieldCount();
            RelOptUtil.splitJoinCondition((List)j.getSystemFieldList(), (RelNode)j.getLeft(), (RelNode)j.getRight(), (RexNode)pe, joinKeyExprsFromLeft, joinKeyExprsFromRight, filterNulls, null);
            RelOptUtil.InputReferencedVisitor irvLeft = new RelOptUtil.InputReferencedVisitor();
            irvLeft.apply(joinKeyExprsFromLeft);
            projsFromLeftPartOfJoinKeysInChildSchema.addAll(irvLeft.inputPosReferenced);
            RelOptUtil.InputReferencedVisitor irvRight = new RelOptUtil.InputReferencedVisitor();
            irvRight.apply(joinKeyExprsFromRight);
            projsFromRightPartOfJoinKeysInChildSchema.addAll(irvRight.inputPosReferenced);
            for (Integer indx : projsFromRightPartOfJoinKeysInChildSchema) {
                projsFromRightPartOfJoinKeysInJoinSchema.add(indx + rightOffSet);
            }
            jlpi = new JoinLeafPredicateInfo(pe.getKind(), joinKeyExprsFromLeft, joinKeyExprsFromRight, projsFromLeftPartOfJoinKeysInChildSchema, projsFromRightPartOfJoinKeysInChildSchema, projsFromRightPartOfJoinKeysInJoinSchema);
            return jlpi;
        }
    }

    public static class JoinPredicateInfo {
        private final ImmutableList<JoinLeafPredicateInfo> nonEquiJoinPredicateElements;
        private final ImmutableList<JoinLeafPredicateInfo> equiJoinPredicateElements;
        private final ImmutableSet<Integer> projsFromLeftPartOfJoinKeysInChildSchema;
        private final ImmutableSet<Integer> projsFromRightPartOfJoinKeysInChildSchema;
        private final ImmutableSet<Integer> projsFromRightPartOfJoinKeysInJoinSchema;
        private final ImmutableMap<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo;

        public JoinPredicateInfo(List<JoinLeafPredicateInfo> nonEquiJoinPredicateElements, List<JoinLeafPredicateInfo> equiJoinPredicateElements, Set<Integer> projsFromLeftPartOfJoinKeysInChildSchema, Set<Integer> projsFromRightPartOfJoinKeysInChildSchema, Set<Integer> projsFromRightPartOfJoinKeysInJoinSchema, Map<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo) {
            this.nonEquiJoinPredicateElements = ImmutableList.copyOf(nonEquiJoinPredicateElements);
            this.equiJoinPredicateElements = ImmutableList.copyOf(equiJoinPredicateElements);
            this.projsFromLeftPartOfJoinKeysInChildSchema = ImmutableSet.copyOf(projsFromLeftPartOfJoinKeysInChildSchema);
            this.projsFromRightPartOfJoinKeysInChildSchema = ImmutableSet.copyOf(projsFromRightPartOfJoinKeysInChildSchema);
            this.projsFromRightPartOfJoinKeysInJoinSchema = ImmutableSet.copyOf(projsFromRightPartOfJoinKeysInJoinSchema);
            this.mapOfProjIndxInJoinSchemaToLeafPInfo = ImmutableMap.copyOf(mapOfProjIndxInJoinSchemaToLeafPInfo);
        }

        public List<JoinLeafPredicateInfo> getNonEquiJoinPredicateElements() {
            return this.nonEquiJoinPredicateElements;
        }

        public List<JoinLeafPredicateInfo> getEquiJoinPredicateElements() {
            return this.equiJoinPredicateElements;
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInChildSchema() {
            return this.projsFromLeftPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInChildSchema() {
            return this.projsFromRightPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInJoinSchema() {
            return this.projsFromLeftPartOfJoinKeysInChildSchema;
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInJoinSchema() {
            return this.projsFromRightPartOfJoinKeysInJoinSchema;
        }

        public Map<Integer, ImmutableList<JoinLeafPredicateInfo>> getMapOfProjIndxToLeafPInfo() {
            return this.mapOfProjIndxInJoinSchemaToLeafPInfo;
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(HiveJoin j) {
            return JoinPredicateInfo.constructJoinPredicateInfo(j, j.getCondition());
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(HiveJoin j, RexNode predicate) {
            JoinPredicateInfo jpi = null;
            JoinLeafPredicateInfo jlpi = null;
            ArrayList<JoinLeafPredicateInfo> equiLPIList = new ArrayList<JoinLeafPredicateInfo>();
            ArrayList<JoinLeafPredicateInfo> nonEquiLPIList = new ArrayList<JoinLeafPredicateInfo>();
            HashSet<Integer> projsFromLeftPartOfJoinKeys = new HashSet<Integer>();
            HashSet<Integer> projsFromRightPartOfJoinKeys = new HashSet<Integer>();
            HashSet<Integer> projsFromRightPartOfJoinKeysInJoinSchema = new HashSet<Integer>();
            HashMap tmpMapOfProjIndxInJoinSchemaToLeafPInfo = new HashMap();
            HashMap<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo = new HashMap<Integer, ImmutableList<JoinLeafPredicateInfo>>();
            List<JoinLeafPredicateInfo> tmpJLPILst = null;
            int rightOffSet = j.getLeft().getRowType().getFieldCount();
            List conjuctiveElements = RelOptUtil.conjunctions((RexNode)predicate);
            for (RexNode rexNode : conjuctiveElements) {
                jlpi = JoinLeafPredicateInfo.constructJoinLeafPredicateInfo(j, rexNode);
                if (jlpi.comparisonType.equals((Object)SqlKind.EQUALS)) {
                    equiLPIList.add(jlpi);
                } else {
                    nonEquiLPIList.add(jlpi);
                }
                projsFromLeftPartOfJoinKeys.addAll(jlpi.getProjsFromLeftPartOfJoinKeysInChildSchema());
                projsFromRightPartOfJoinKeys.addAll(jlpi.getProjsFromRightPartOfJoinKeysInChildSchema());
                projsFromRightPartOfJoinKeysInJoinSchema.addAll(jlpi.getProjsFromRightPartOfJoinKeysInJoinSchema());
                for (Integer projIndx : jlpi.getProjsFromLeftPartOfJoinKeysInChildSchema()) {
                    tmpJLPILst = (ArrayList<JoinLeafPredicateInfo>)tmpMapOfProjIndxInJoinSchemaToLeafPInfo.get(projIndx);
                    if (tmpJLPILst == null) {
                        tmpJLPILst = new ArrayList<JoinLeafPredicateInfo>();
                    }
                    tmpJLPILst.add(jlpi);
                    tmpMapOfProjIndxInJoinSchemaToLeafPInfo.put(projIndx, tmpJLPILst);
                }
                for (Integer projIndx : jlpi.getProjsFromRightPartOfJoinKeysInChildSchema()) {
                    int projIndxInJoin = projIndx + rightOffSet;
                    tmpJLPILst = (List)tmpMapOfProjIndxInJoinSchemaToLeafPInfo.get(projIndxInJoin);
                    if (tmpJLPILst == null) {
                        tmpJLPILst = new ArrayList();
                    }
                    tmpJLPILst.add(jlpi);
                    tmpMapOfProjIndxInJoinSchemaToLeafPInfo.put(projIndxInJoin, tmpJLPILst);
                }
            }
            for (Map.Entry entry : tmpMapOfProjIndxInJoinSchemaToLeafPInfo.entrySet()) {
                mapOfProjIndxInJoinSchemaToLeafPInfo.put((Integer)entry.getKey(), ImmutableList.copyOf((Collection)entry.getValue()));
            }
            jpi = new JoinPredicateInfo(nonEquiLPIList, equiLPIList, projsFromLeftPartOfJoinKeys, projsFromRightPartOfJoinKeys, projsFromRightPartOfJoinKeysInJoinSchema, mapOfProjIndxInJoinSchemaToLeafPInfo);
            return jpi;
        }
    }
}

