/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.stats;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanMapper;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.Mapper;

@Explain(displayName="Partial Scan Statistics")
public class PartialScanWork
extends MapWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient List<Path> inputPaths;
    private String aggKey;
    private String statsTmpDir;

    public PartialScanWork() {
    }

    public PartialScanWork(List<Path> inputPaths) {
        this.inputPaths = inputPaths;
        PartitionDesc partDesc = new PartitionDesc();
        partDesc.setInputFileFormatClass(RCFileBlockMergeInputFormat.class);
        if (this.getPathToPartitionInfo() == null) {
            this.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        }
        for (Path path : this.inputPaths) {
            this.getPathToPartitionInfo().put(path.toString(), partDesc);
        }
    }

    public List<Path> getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(List<Path> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public Class<? extends Mapper> getMapperClass() {
        return PartialScanMapper.class;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return CombineHiveInputFormat.class.getName();
    }

    @Override
    public boolean isGatheringStats() {
        return true;
    }

    @Explain(displayName="Stats Aggregation Key Prefix", normalExplain=false)
    public String getAggKey() {
        return this.aggKey;
    }

    public void setAggKey(String aggKey) {
        this.aggKey = aggKey;
    }

    public String getStatsTmpDir() {
        return this.statsTmpDir;
    }

    public void setStatsTmpDir(String statsTmpDir, HiveConf conf) {
        this.statsTmpDir = HiveConf.getVar(conf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name()) ? statsTmpDir : "";
    }
}

