/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;

public class NullUtil {
    public static void setNullDataEntriesLong(LongColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (v.noNulls) {
            return;
        }
        if (v.isRepeating && v.isNull[0]) {
            v.vector[0] = 1L;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!v.isNull[i]) continue;
                v.vector[i] = 1L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!v.isNull[i]) continue;
                v.vector[i] = 1L;
            }
        }
    }

    public static void setNullOutputEntriesColScalar(ColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (v instanceof DoubleColumnVector) {
            return;
        }
        NullUtil.setNullDataEntriesLong((LongColumnVector)v, selectedInUse, sel, n);
    }

    public static void setNullDataEntriesDouble(DoubleColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (v.noNulls) {
            return;
        }
        if (v.isRepeating && v.isNull[0]) {
            v.vector[0] = Double.NaN;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!v.isNull[i]) continue;
                v.vector[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!v.isNull[i]) continue;
                v.vector[i] = Double.NaN;
            }
        }
    }

    public static void setNullAndDivBy0DataEntriesDouble(DoubleColumnVector v, boolean selectedInUse, int[] sel, int n, LongColumnVector denoms) {
        assert (v.isRepeating || !denoms.isRepeating);
        boolean realNulls = !v.noNulls;
        v.noNulls = false;
        long[] vector = denoms.vector;
        if (v.isRepeating && (v.isNull[0] = realNulls && v.isNull[0] || vector[0] == 0L)) {
            v.vector[0] = Double.NaN;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                v.isNull[i = sel[j]] = realNulls && v.isNull[i] || vector[i] == 0L;
                if (!v.isNull[i = sel[j]]) continue;
                v.vector[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                v.isNull[i] = realNulls && v.isNull[i] || vector[i] == 0L;
                if (!v.isNull[i]) continue;
                v.vector[i] = Double.NaN;
            }
        }
    }

    public static void setNullAndDivBy0DataEntriesDouble(DoubleColumnVector v, boolean selectedInUse, int[] sel, int n, DoubleColumnVector denoms) {
        assert (v.isRepeating || !denoms.isRepeating);
        boolean realNulls = !v.noNulls;
        v.noNulls = false;
        double[] vector = denoms.vector;
        if (v.isRepeating && (v.isNull[0] = realNulls && v.isNull[0] || vector[0] == 0.0)) {
            v.vector[0] = Double.NaN;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                v.isNull[i = sel[j]] = realNulls && v.isNull[i] || vector[i] == 0.0;
                if (!v.isNull[i = sel[j]]) continue;
                v.vector[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                v.isNull[i] = realNulls && v.isNull[i] || vector[i] == 0.0;
                if (!v.isNull[i]) continue;
                v.vector[i] = Double.NaN;
            }
        }
    }

    public static void setNullAndDivBy0DataEntriesLong(LongColumnVector v, boolean selectedInUse, int[] sel, int n, LongColumnVector denoms) {
        assert (v.isRepeating || !denoms.isRepeating);
        v.noNulls = false;
        long[] vector = denoms.vector;
        if (v.isRepeating && (v.isNull[0] = v.isNull[0] || vector[0] == 0L)) {
            v.vector[0] = 1L;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                v.isNull[i = sel[j]] = v.isNull[i] || vector[i] == 0L;
                if (!v.isNull[i = sel[j]]) continue;
                v.vector[i] = 1L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                v.isNull[i] = v.isNull[i] || vector[i] == 0L;
                if (!v.isNull[i]) continue;
                v.vector[i] = 1L;
            }
        }
    }

    public static void setNullAndDivBy0DataEntriesLong(LongColumnVector v, boolean selectedInUse, int[] sel, int n, DoubleColumnVector denoms) {
        assert (v.isRepeating || !denoms.isRepeating);
        v.noNulls = false;
        double[] vector = denoms.vector;
        if (v.isRepeating && (v.isNull[0] = v.isNull[0] || vector[0] == 0.0)) {
            v.vector[0] = 1L;
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                v.isNull[i = sel[j]] = v.isNull[i] || vector[i] == 0.0;
                if (!v.isNull[i = sel[j]]) continue;
                v.vector[i] = 1L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                v.isNull[i] = v.isNull[i] || vector[i] == 0.0;
                if (!v.isNull[i]) continue;
                v.vector[i] = 1L;
            }
        }
    }

    public static void propagateNullsColCol(ColumnVector inputColVector1, ColumnVector inputColVector2, ColumnVector outputColVector, int[] sel, int n, boolean selectedInUse) {
        block31: {
            block32: {
                block30: {
                    boolean bl = outputColVector.noNulls = inputColVector1.noNulls && inputColVector2.noNulls;
                    if (outputColVector.noNulls) {
                        Arrays.fill(outputColVector.isNull, false);
                        return;
                    }
                    if (!inputColVector1.noNulls || inputColVector2.noNulls) break block30;
                    if (inputColVector2.isRepeating) {
                        outputColVector.isNull[0] = inputColVector2.isNull[0];
                    } else if (selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputColVector2.isNull[i];
                        }
                    } else {
                        System.arraycopy(inputColVector2.isNull, 0, outputColVector.isNull, 0, n);
                    }
                    break block31;
                }
                if (inputColVector1.noNulls || !inputColVector2.noNulls) break block32;
                if (inputColVector1.isRepeating) {
                    outputColVector.isNull[0] = inputColVector1.isNull[0];
                } else if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputColVector.isNull[i] = inputColVector1.isNull[i];
                    }
                } else {
                    System.arraycopy(inputColVector1.isNull, 0, outputColVector.isNull, 0, n);
                }
                break block31;
            }
            if (inputColVector1.noNulls || inputColVector2.noNulls) break block31;
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                boolean bl = outputColVector.isNull[0] = inputColVector1.isNull[0] || inputColVector2.isNull[0];
                if (outputColVector.isNull[0]) {
                    outputColVector.isRepeating = true;
                    return;
                }
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (inputColVector1.isNull[0]) {
                    outputColVector.isNull[0] = true;
                    outputColVector.isRepeating = true;
                    return;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputColVector.isNull[i] = inputColVector2.isNull[i];
                    }
                } else {
                    System.arraycopy(inputColVector2.isNull, 0, outputColVector.isNull, 0, n);
                }
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (inputColVector2.isNull[0]) {
                    outputColVector.isNull[0] = true;
                    outputColVector.isRepeating = true;
                    return;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputColVector.isNull[i] = inputColVector1.isNull[i];
                    }
                } else {
                    System.arraycopy(inputColVector1.isNull, 0, outputColVector.isNull, 0, n);
                }
            } else if (selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVector1.isNull[i] || inputColVector2.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColVector.isNull[i] = inputColVector1.isNull[i] || inputColVector2.isNull[i];
                }
            }
        }
    }

    public static void setNullDataEntriesDecimal(DecimalColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (v.noNulls) {
            return;
        }
        if (v.isRepeating && v.isNull[0]) {
            v.setNullDataValue(0);
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!v.isNull[i]) continue;
                v.setNullDataValue(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!v.isNull[i]) continue;
                v.setNullDataValue(i);
            }
        }
    }

    public static void initOutputNullsToFalse(ColumnVector v, boolean isRepeating, boolean selectedInUse, int[] sel, int n) {
        if (v.isRepeating) {
            v.isNull[0] = false;
            return;
        }
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                v.isNull[i] = false;
            }
        } else {
            Arrays.fill(v.isNull, 0, n, false);
        }
    }

    public static int filterNulls(ColumnVector v, boolean selectedInUse, int[] sel, int n) {
        int newSize = 0;
        if (v.noNulls) {
            return n;
        }
        if (v.isRepeating) {
            return v.isNull[0] ? 0 : n;
        }
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (v.isNull[i]) continue;
                sel[newSize++] = i;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (v.isNull[i]) continue;
                sel[newSize++] = i;
            }
        }
        return newSize;
    }
}

