/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;

public class SortByShuffler
implements SparkShuffler<BytesWritable> {
    private final boolean totalOrder;

    public SortByShuffler(boolean totalOrder) {
        this.totalOrder = totalOrder;
    }

    @Override
    public JavaPairRDD<HiveKey, BytesWritable> shuffle(JavaPairRDD<HiveKey, BytesWritable> input, int numPartitions) {
        JavaPairRDD rdd;
        if (this.totalOrder) {
            rdd = numPartitions > 0 ? input.sortByKey(true, numPartitions) : input.sortByKey(true);
        } else {
            HashPartitioner partitioner = new HashPartitioner(numPartitions);
            rdd = input.repartitionAndSortWithinPartitions((Partitioner)partitioner);
        }
        return rdd;
    }

    @Override
    public String getName() {
        return "SortBy";
    }
}

