/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class HiveDecimal
implements Comparable<HiveDecimal> {
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    public static final int USER_DEFAULT_PRECISION = 10;
    public static final int USER_DEFAULT_SCALE = 0;
    public static final int SYSTEM_DEFAULT_PRECISION = 38;
    public static final int SYSTEM_DEFAULT_SCALE = 18;
    public static final HiveDecimal ZERO = new HiveDecimal(BigDecimal.ZERO);
    public static final HiveDecimal ONE = new HiveDecimal(BigDecimal.ONE);
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_HALF_UP = 4;
    private BigDecimal bd = BigDecimal.ZERO;

    private HiveDecimal(BigDecimal bd) {
        this.bd = bd;
    }

    public static HiveDecimal create(BigDecimal b) {
        return HiveDecimal.create(b, true);
    }

    public static HiveDecimal create(BigDecimal b, boolean allowRounding) {
        BigDecimal bd = HiveDecimal.normalize(b, allowRounding);
        return bd == null ? null : new HiveDecimal(bd);
    }

    public static HiveDecimal create(BigInteger unscaled, int scale) {
        BigDecimal bd = HiveDecimal.normalize(new BigDecimal(unscaled, scale), true);
        return bd == null ? null : new HiveDecimal(bd);
    }

    public static HiveDecimal create(String dec) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(dec);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        bd = HiveDecimal.normalize(bd, true);
        return bd == null ? null : new HiveDecimal(bd);
    }

    public static HiveDecimal create(BigInteger bi) {
        BigDecimal bd = HiveDecimal.normalize(new BigDecimal(bi), true);
        return bd == null ? null : new HiveDecimal(bd);
    }

    public static HiveDecimal create(int i) {
        return new HiveDecimal(new BigDecimal(i));
    }

    public static HiveDecimal create(long l) {
        return new HiveDecimal(new BigDecimal(l));
    }

    public String toString() {
        return this.bd.toPlainString();
    }

    public HiveDecimal setScale(int i) {
        return new HiveDecimal(this.bd.setScale(i, RoundingMode.HALF_UP));
    }

    @Override
    public int compareTo(HiveDecimal dec) {
        return this.bd.compareTo(dec.bd);
    }

    public int hashCode() {
        return this.bd.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.bd.equals(((HiveDecimal)obj).bd);
    }

    public int scale() {
        return this.bd.scale();
    }

    public int precision() {
        int bdScale;
        int bdPrecision = this.bd.precision();
        if (bdPrecision < (bdScale = this.bd.scale())) {
            return bdScale;
        }
        return bdPrecision;
    }

    public int intValue() {
        return this.bd.intValue();
    }

    public double doubleValue() {
        return this.bd.doubleValue();
    }

    public long longValue() {
        return this.bd.longValue();
    }

    public short shortValue() {
        return this.bd.shortValue();
    }

    public float floatValue() {
        return this.bd.floatValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.bd;
    }

    public byte byteValue() {
        return this.bd.byteValue();
    }

    public HiveDecimal setScale(int adjustedScale, int rm) {
        return HiveDecimal.create(this.bd.setScale(adjustedScale, rm));
    }

    public HiveDecimal subtract(HiveDecimal dec) {
        return HiveDecimal.create(this.bd.subtract(dec.bd));
    }

    public HiveDecimal multiply(HiveDecimal dec) {
        return HiveDecimal.create(this.bd.multiply(dec.bd), false);
    }

    public BigInteger unscaledValue() {
        return this.bd.unscaledValue();
    }

    public HiveDecimal scaleByPowerOfTen(int n) {
        return HiveDecimal.create(this.bd.scaleByPowerOfTen(n));
    }

    public HiveDecimal abs() {
        return HiveDecimal.create(this.bd.abs());
    }

    public HiveDecimal negate() {
        return HiveDecimal.create(this.bd.negate());
    }

    public HiveDecimal add(HiveDecimal dec) {
        return HiveDecimal.create(this.bd.add(dec.bd));
    }

    public HiveDecimal pow(int n) {
        BigDecimal result = HiveDecimal.normalize(this.bd.pow(n), false);
        return result == null ? null : new HiveDecimal(result);
    }

    public HiveDecimal remainder(HiveDecimal dec) {
        return HiveDecimal.create(this.bd.remainder(dec.bd));
    }

    public HiveDecimal divide(HiveDecimal dec) {
        return HiveDecimal.create(this.bd.divide(dec.bd, 38, RoundingMode.HALF_UP), true);
    }

    public int signum() {
        return this.bd.signum();
    }

    private static BigDecimal trim(BigDecimal d) {
        if (d.compareTo(BigDecimal.ZERO) == 0) {
            d = BigDecimal.ZERO;
        } else if ((d = d.stripTrailingZeros()).scale() < 0) {
            d = d.setScale(0);
        }
        return d;
    }

    private static BigDecimal normalize(BigDecimal bd, boolean allowRounding) {
        if (bd == null) {
            return null;
        }
        int intDigits = (bd = HiveDecimal.trim(bd)).precision() - bd.scale();
        if (intDigits > 38) {
            return null;
        }
        int maxScale = Math.min(38, Math.min(38 - intDigits, bd.scale()));
        if (bd.scale() > maxScale) {
            if (allowRounding) {
                bd = bd.setScale(maxScale, RoundingMode.HALF_UP);
                bd = HiveDecimal.trim(bd);
            } else {
                bd = null;
            }
        }
        return bd;
    }

    public static BigDecimal enforcePrecisionScale(BigDecimal bd, int maxPrecision, int maxScale) {
        if (bd == null) {
            return null;
        }
        if (bd.compareTo(BigDecimal.ZERO) == 0 && bd.scale() == 0 && maxPrecision == maxScale) {
            return bd.setScale(maxScale);
        }
        if ((bd = HiveDecimal.trim(bd)).scale() > maxScale) {
            bd = bd.setScale(maxScale, RoundingMode.HALF_UP);
        }
        int maxIntDigits = maxPrecision - maxScale;
        int intDigits = bd.precision() - bd.scale();
        if (intDigits > maxIntDigits) {
            return null;
        }
        return bd;
    }

    public static HiveDecimal enforcePrecisionScale(HiveDecimal dec, int maxPrecision, int maxScale) {
        if (dec == null) {
            return null;
        }
        BigDecimal bd = HiveDecimal.enforcePrecisionScale(dec.bd, maxPrecision, maxScale);
        if (bd == null) {
            return null;
        }
        return HiveDecimal.create(bd);
    }
}

