// $ANTLR 3.4 org/apache/hadoop/hive/ql/parse/HiveParser.g 2014-09-16 20:40:20

package org.apache.hadoop.hive.ql.parse;

import java.util.Collection;
import java.util.HashMap;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
   Licensed to the Apache Software Foundation (ASF) under one or more 
   contributor license agreements.  See the NOTICE file distributed with 
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with 
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class HiveParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AMPERSAND", "BITWISEOR", "BITWISEXOR", "BigintLiteral", "ByteLengthLiteral", "COLON", "COMMA", "COMMENT", "CharSetLiteral", "CharSetName", "DIV", "DIVIDE", "DOLLAR", "DOT", "DecimalLiteral", "Digit", "EQUAL", "EQUAL_NS", "Exponent", "GREATERTHAN", "GREATERTHANOREQUALTO", "HexDigit", "Identifier", "KW_ADD", "KW_AFTER", "KW_ALL", "KW_ALTER", "KW_ANALYZE", "KW_AND", "KW_ARCHIVE", "KW_ARRAY", "KW_AS", "KW_ASC", "KW_BEFORE", "KW_BETWEEN", "KW_BIGINT", "KW_BINARY", "KW_BOOLEAN", "KW_BOTH", "KW_BUCKET", "KW_BUCKETS", "KW_BY", "KW_CASCADE", "KW_CASE", "KW_CAST", "KW_CHANGE", "KW_CHAR", "KW_CLUSTER", "KW_CLUSTERED", "KW_CLUSTERSTATUS", "KW_COLLECTION", "KW_COLUMN", "KW_COLUMNS", "KW_COMMENT", "KW_COMPUTE", "KW_CONCATENATE", "KW_CONTINUE", "KW_CREATE", "KW_CROSS", "KW_CUBE", "KW_CURRENT", "KW_CURSOR", "KW_DATA", "KW_DATABASE", "KW_DATABASES", "KW_DATE", "KW_DATETIME", "KW_DBPROPERTIES", "KW_DECIMAL", "KW_DEFAULT", "KW_DEFERRED", "KW_DEFINED", "KW_DELETE", "KW_DELIMITED", "KW_DEPENDENCY", "KW_DESC", "KW_DESCRIBE", "KW_DIRECTORIES", "KW_DIRECTORY", "KW_DISABLE", "KW_DISTINCT", "KW_DISTRIBUTE", "KW_DOUBLE", "KW_DROP", "KW_ELEM_TYPE", "KW_ELSE", "KW_ENABLE", "KW_END", "KW_ESCAPED", "KW_EXCHANGE", "KW_EXCLUSIVE", "KW_EXISTS", "KW_EXPLAIN", "KW_EXPORT", "KW_EXTENDED", "KW_EXTERNAL", "KW_FALSE", "KW_FETCH", "KW_FIELDS", "KW_FILEFORMAT", "KW_FIRST", "KW_FLOAT", "KW_FOLLOWING", "KW_FOR", "KW_FORMAT", "KW_FORMATTED", "KW_FROM", "KW_FULL", "KW_FUNCTION", "KW_FUNCTIONS", "KW_GRANT", "KW_GROUP", "KW_GROUPING", "KW_HAVING", "KW_HOLD_DDLTIME", "KW_IDXPROPERTIES", "KW_IF", "KW_IGNORE", "KW_IMPORT", "KW_IN", "KW_INDEX", "KW_INDEXES", "KW_INNER", "KW_INPATH", "KW_INPUTDRIVER", "KW_INPUTFORMAT", "KW_INSERT", "KW_INT", "KW_INTERSECT", "KW_INTO", "KW_IS", "KW_ITEMS", "KW_JOIN", "KW_KEYS", "KW_KEY_TYPE", "KW_LATERAL", "KW_LEFT", "KW_LESS", "KW_LIKE", "KW_LIMIT", "KW_LINES", "KW_LOAD", "KW_LOCAL", "KW_LOCATION", "KW_LOCK", "KW_LOCKS", "KW_LOGICAL", "KW_LONG", "KW_MACRO", "KW_MAP", "KW_MAPJOIN", "KW_MATERIALIZED", "KW_MINUS", "KW_MORE", "KW_MSCK", "KW_NONE", "KW_NOSCAN", "KW_NOT", "KW_NO_DROP", "KW_NULL", "KW_OF", "KW_OFFLINE", "KW_ON", "KW_OPTION", "KW_OR", "KW_ORCFILE", "KW_ORDER", "KW_OUT", "KW_OUTER", "KW_OUTPUTDRIVER", "KW_OUTPUTFORMAT", "KW_OVER", "KW_OVERWRITE", "KW_PARQUETFILE", "KW_PARTIALSCAN", "KW_PARTITION", "KW_PARTITIONED", "KW_PARTITIONS", "KW_PERCENT", "KW_PLUS", "KW_PRECEDING", "KW_PRESERVE", "KW_PRETTY", "KW_PROCEDURE", "KW_PROTECTION", "KW_PURGE", "KW_RANGE", "KW_RCFILE", "KW_READ", "KW_READONLY", "KW_READS", "KW_REBUILD", "KW_RECORDREADER", "KW_RECORDWRITER", "KW_REDUCE", "KW_REGEXP", "KW_RENAME", "KW_REPAIR", "KW_REPLACE", "KW_RESTRICT", "KW_REVOKE", "KW_RIGHT", "KW_RLIKE", "KW_ROLE", "KW_ROLES", "KW_ROLLUP", "KW_ROW", "KW_ROWS", "KW_SCHEMA", "KW_SCHEMAS", "KW_SELECT", "KW_SEMI", "KW_SEQUENCEFILE", "KW_SERDE", "KW_SERDEPROPERTIES", "KW_SERVER", "KW_SET", "KW_SETS", "KW_SHARED", "KW_SHOW", "KW_SHOW_DATABASE", "KW_SKEWED", "KW_SMALLINT", "KW_SORT", "KW_SORTED", "KW_SSL", "KW_STATISTICS", "KW_STORED", "KW_STREAMTABLE", "KW_STRING", "KW_STRUCT", "KW_TABLE", "KW_TABLES", "KW_TABLESAMPLE", "KW_TBLPROPERTIES", "KW_TEMPORARY", "KW_TERMINATED", "KW_TEXTFILE", "KW_THEN", "KW_TIMESTAMP", "KW_TINYINT", "KW_TO", "KW_TOUCH", "KW_TRANSFORM", "KW_TRIGGER", "KW_TRUE", "KW_TRUNCATE", "KW_UNARCHIVE", "KW_UNBOUNDED", "KW_UNDO", "KW_UNION", "KW_UNIONTYPE", "KW_UNIQUEJOIN", "KW_UNLOCK", "KW_UNSET", "KW_UNSIGNED", "KW_UPDATE", "KW_URI", "KW_USE", "KW_USER", "KW_USING", "KW_UTC", "KW_UTCTIMESTAMP", "KW_VALUE_TYPE", "KW_VARCHAR", "KW_VIEW", "KW_WHEN", "KW_WHERE", "KW_WHILE", "KW_WINDOW", "KW_WITH", "LCURLY", "LESSTHAN", "LESSTHANOREQUALTO", "LPAREN", "LSQUARE", "Letter", "MINUS", "MOD", "NOTEQUAL", "Number", "PLUS", "QUESTION", "RCURLY", "RPAREN", "RSQUARE", "RegexComponent", "SEMICOLON", "STAR", "SmallintLiteral", "StringLiteral", "TILDE", "TinyintLiteral", "WS", "TOK_ALIASLIST", "TOK_ALLCOLREF", "TOK_ALTERDATABASE_PROPERTIES", "TOK_ALTERINDEX_PROPERTIES", "TOK_ALTERINDEX_REBUILD", "TOK_ALTERTABLE_ADDCOLS", "TOK_ALTERTABLE_ADDPARTS", "TOK_ALTERTABLE_ALTERPARTS", "TOK_ALTERTABLE_ALTERPARTS_MERGEFILES", "TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE", "TOK_ALTERTABLE_ARCHIVE", "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION", "TOK_ALTERTABLE_CLUSTER_SORT", "TOK_ALTERTABLE_DROPPARTS", "TOK_ALTERTABLE_FILEFORMAT", "TOK_ALTERTABLE_LOCATION", "TOK_ALTERTABLE_PARTITION", "TOK_ALTERTABLE_PROPERTIES", "TOK_ALTERTABLE_RENAME", "TOK_ALTERTABLE_RENAMECOL", "TOK_ALTERTABLE_RENAMEPART", "TOK_ALTERTABLE_REPLACECOLS", "TOK_ALTERTABLE_SERDEPROPERTIES", "TOK_ALTERTABLE_SERIALIZER", "TOK_ALTERTABLE_SKEWED", "TOK_ALTERTABLE_TOUCH", "TOK_ALTERTABLE_UNARCHIVE", "TOK_ALTERTBLPART_SKEWED_LOCATION", "TOK_ALTERVIEW_ADDPARTS", "TOK_ALTERVIEW_AS", "TOK_ALTERVIEW_DROPPARTS", "TOK_ALTERVIEW_PROPERTIES", "TOK_ALTERVIEW_RENAME", "TOK_ANALYZE", "TOK_BIGINT", "TOK_BINARY", "TOK_BOOLEAN", "TOK_CASCADE", "TOK_CHAR", "TOK_CHARSETLITERAL", "TOK_CLUSTERBY", "TOK_COLTYPELIST", "TOK_CREATEDATABASE", "TOK_CREATEFUNCTION", "TOK_CREATEINDEX", "TOK_CREATEINDEX_INDEXTBLNAME", "TOK_CREATEMACRO", "TOK_CREATEROLE", "TOK_CREATETABLE", "TOK_CREATEVIEW", "TOK_CROSSJOIN", "TOK_CUBE_GROUPBY", "TOK_DATABASECOMMENT", "TOK_DATABASELOCATION", "TOK_DATABASEPROPERTIES", "TOK_DATE", "TOK_DATELITERAL", "TOK_DATETIME", "TOK_DBPROPLIST", "TOK_DECIMAL", "TOK_DEFERRED_REBUILDINDEX", "TOK_DESCDATABASE", "TOK_DESCFUNCTION", "TOK_DESCTABLE", "TOK_DESTINATION", "TOK_DIR", "TOK_DISABLE", "TOK_DISTRIBUTEBY", "TOK_DOUBLE", "TOK_DROPDATABASE", "TOK_DROPFUNCTION", "TOK_DROPINDEX", "TOK_DROPMACRO", "TOK_DROPROLE", "TOK_DROPTABLE", "TOK_DROPTABLE_PROPERTIES", "TOK_DROPVIEW", "TOK_DROPVIEW_PROPERTIES", "TOK_ENABLE", "TOK_EXCHANGEPARTITION", "TOK_EXPLAIN", "TOK_EXPLIST", "TOK_EXPORT", "TOK_FALSE", "TOK_FILEFORMAT_GENERIC", "TOK_FLOAT", "TOK_FROM", "TOK_FULLOUTERJOIN", "TOK_FUNCTION", "TOK_FUNCTIONDI", "TOK_FUNCTIONSTAR", "TOK_GRANT", "TOK_GRANT_ROLE", "TOK_GRANT_WITH_OPTION", "TOK_GROUP", "TOK_GROUPBY", "TOK_GROUPING_SETS", "TOK_GROUPING_SETS_EXPRESSION", "TOK_HAVING", "TOK_HINT", "TOK_HINTARGLIST", "TOK_HINTLIST", "TOK_HOLD_DDLTIME", "TOK_IFEXISTS", "TOK_IFNOTEXISTS", "TOK_IGNOREPROTECTION", "TOK_IMPORT", "TOK_INDEXCOMMENT", "TOK_INDEXPROPERTIES", "TOK_INDEXPROPLIST", "TOK_INSERT", "TOK_INSERT_INTO", "TOK_INT", "TOK_ISNOTNULL", "TOK_ISNULL", "TOK_JOIN", "TOK_LATERAL_VIEW", "TOK_LATERAL_VIEW_OUTER", "TOK_LEFTOUTERJOIN", "TOK_LEFTSEMIJOIN", "TOK_LENGTH", "TOK_LIKETABLE", "TOK_LIMIT", "TOK_LIST", "TOK_LOAD", "TOK_LOCAL_DIR", "TOK_LOCKTABLE", "TOK_MAP", "TOK_MAPJOIN", "TOK_MSCK", "TOK_NOT_CLUSTERED", "TOK_NOT_SORTED", "TOK_NO_DROP", "TOK_NULL", "TOK_OFFLINE", "TOK_OP_ADD", "TOK_OP_AND", "TOK_OP_BITAND", "TOK_OP_BITNOT", "TOK_OP_BITOR", "TOK_OP_BITXOR", "TOK_OP_DIV", "TOK_OP_EQ", "TOK_OP_GE", "TOK_OP_GT", "TOK_OP_LE", "TOK_OP_LIKE", "TOK_OP_LT", "TOK_OP_MOD", "TOK_OP_MUL", "TOK_OP_NE", "TOK_OP_NOT", "TOK_OP_OR", "TOK_OP_SUB", "TOK_ORDERBY", "TOK_ORREPLACE", "TOK_PARTITIONINGSPEC", "TOK_PARTITIONLOCATION", "TOK_PARTSPEC", "TOK_PARTVAL", "TOK_PERCENT", "TOK_PRINCIPAL_NAME", "TOK_PRIVILEGE", "TOK_PRIVILEGE_LIST", "TOK_PRIV_ALL", "TOK_PRIV_ALTER_DATA", "TOK_PRIV_ALTER_METADATA", "TOK_PRIV_CREATE", "TOK_PRIV_DROP", "TOK_PRIV_INDEX", "TOK_PRIV_INSERT", "TOK_PRIV_LOCK", "TOK_PRIV_OBJECT", "TOK_PRIV_OBJECT_COL", "TOK_PRIV_SELECT", "TOK_PRIV_SHOW_DATABASE", "TOK_PTBLFUNCTION", "TOK_QUERY", "TOK_READONLY", "TOK_RECORDREADER", "TOK_RECORDWRITER", "TOK_RESTRICT", "TOK_REVOKE", "TOK_REVOKE_ROLE", "TOK_RIGHTOUTERJOIN", "TOK_ROLE", "TOK_ROLLUP_GROUPBY", "TOK_ROWCOUNT", "TOK_SELECT", "TOK_SELECTDI", "TOK_SELEXPR", "TOK_SERDE", "TOK_SERDENAME", "TOK_SERDEPROPS", "TOK_SERVER", "TOK_SHOWCOLUMNS", "TOK_SHOWDATABASES", "TOK_SHOWFUNCTIONS", "TOK_SHOWINDEXES", "TOK_SHOWLOCKS", "TOK_SHOWPARTITIONS", "TOK_SHOWTABLES", "TOK_SHOW_CREATETABLE", "TOK_SHOW_GRANT", "TOK_SHOW_ROLES", "TOK_SHOW_ROLE_GRANT", "TOK_SHOW_SET_ROLE", "TOK_SHOW_TABLESTATUS", "TOK_SHOW_TBLPROPERTIES", "TOK_SKEWED_LOCATIONS", "TOK_SKEWED_LOCATION_LIST", "TOK_SKEWED_LOCATION_MAP", "TOK_SMALLINT", "TOK_SORTBY", "TOK_STORAGEHANDLER", "TOK_STOREDASDIRS", "TOK_STREAMTABLE", "TOK_STRING", "TOK_STRINGLITERALSEQUENCE", "TOK_STRUCT", "TOK_SUBQUERY", "TOK_SWITCHDATABASE", "TOK_TAB", "TOK_TABALIAS", "TOK_TABCOL", "TOK_TABCOLLIST", "TOK_TABCOLNAME", "TOK_TABCOLVALUE", "TOK_TABCOLVALUES", "TOK_TABCOLVALUE_PAIR", "TOK_TABLEBUCKETS", "TOK_TABLEBUCKETSAMPLE", "TOK_TABLECOMMENT", "TOK_TABLEFILEFORMAT", "TOK_TABLELOCATION", "TOK_TABLEPARTCOLS", "TOK_TABLEPROPERTIES", "TOK_TABLEPROPERTY", "TOK_TABLEPROPLIST", "TOK_TABLEROWFORMAT", "TOK_TABLEROWFORMATCOLLITEMS", "TOK_TABLEROWFORMATFIELD", "TOK_TABLEROWFORMATLINES", "TOK_TABLEROWFORMATMAPKEYS", "TOK_TABLEROWFORMATNULL", "TOK_TABLESERIALIZER", "TOK_TABLESKEWED", "TOK_TABLESPLITSAMPLE", "TOK_TABLE_OR_COL", "TOK_TABLE_PARTITION", "TOK_TABNAME", "TOK_TABREF", "TOK_TABSORTCOLNAMEASC", "TOK_TABSORTCOLNAMEDESC", "TOK_TABSRC", "TOK_TABTYPE", "TOK_TBLORCFILE", "TOK_TBLPARQUETFILE", "TOK_TBLRCFILE", "TOK_TBLSEQUENCEFILE", "TOK_TBLTEXTFILE", "TOK_TIMESTAMP", "TOK_TINYINT", "TOK_TMP_FILE", "TOK_TRANSFORM", "TOK_TRUE", "TOK_TRUNCATETABLE", "TOK_UNION", "TOK_UNIONTYPE", "TOK_UNIQUEJOIN", "TOK_UNLOCKTABLE", "TOK_URI", "TOK_USER", "TOK_USERSCRIPTCOLNAMES", "TOK_USERSCRIPTCOLSCHEMA", "TOK_VARCHAR", "TOK_VIEWPARTCOLS", "TOK_WHERE", "TOK_WINDOWDEF", "TOK_WINDOWRANGE", "TOK_WINDOWSPEC", "TOK_WINDOWVALUES", "848"
    };

    public static final int EOF=-1;
    public static final int AMPERSAND=4;
    public static final int BITWISEOR=5;
    public static final int BITWISEXOR=6;
    public static final int BigintLiteral=7;
    public static final int ByteLengthLiteral=8;
    public static final int COLON=9;
    public static final int COMMA=10;
    public static final int COMMENT=11;
    public static final int CharSetLiteral=12;
    public static final int CharSetName=13;
    public static final int DIV=14;
    public static final int DIVIDE=15;
    public static final int DOLLAR=16;
    public static final int DOT=17;
    public static final int DecimalLiteral=18;
    public static final int Digit=19;
    public static final int EQUAL=20;
    public static final int EQUAL_NS=21;
    public static final int Exponent=22;
    public static final int GREATERTHAN=23;
    public static final int GREATERTHANOREQUALTO=24;
    public static final int HexDigit=25;
    public static final int Identifier=26;
    public static final int KW_ADD=27;
    public static final int KW_AFTER=28;
    public static final int KW_ALL=29;
    public static final int KW_ALTER=30;
    public static final int KW_ANALYZE=31;
    public static final int KW_AND=32;
    public static final int KW_ARCHIVE=33;
    public static final int KW_ARRAY=34;
    public static final int KW_AS=35;
    public static final int KW_ASC=36;
    public static final int KW_BEFORE=37;
    public static final int KW_BETWEEN=38;
    public static final int KW_BIGINT=39;
    public static final int KW_BINARY=40;
    public static final int KW_BOOLEAN=41;
    public static final int KW_BOTH=42;
    public static final int KW_BUCKET=43;
    public static final int KW_BUCKETS=44;
    public static final int KW_BY=45;
    public static final int KW_CASCADE=46;
    public static final int KW_CASE=47;
    public static final int KW_CAST=48;
    public static final int KW_CHANGE=49;
    public static final int KW_CHAR=50;
    public static final int KW_CLUSTER=51;
    public static final int KW_CLUSTERED=52;
    public static final int KW_CLUSTERSTATUS=53;
    public static final int KW_COLLECTION=54;
    public static final int KW_COLUMN=55;
    public static final int KW_COLUMNS=56;
    public static final int KW_COMMENT=57;
    public static final int KW_COMPUTE=58;
    public static final int KW_CONCATENATE=59;
    public static final int KW_CONTINUE=60;
    public static final int KW_CREATE=61;
    public static final int KW_CROSS=62;
    public static final int KW_CUBE=63;
    public static final int KW_CURRENT=64;
    public static final int KW_CURSOR=65;
    public static final int KW_DATA=66;
    public static final int KW_DATABASE=67;
    public static final int KW_DATABASES=68;
    public static final int KW_DATE=69;
    public static final int KW_DATETIME=70;
    public static final int KW_DBPROPERTIES=71;
    public static final int KW_DECIMAL=72;
    public static final int KW_DEFAULT=73;
    public static final int KW_DEFERRED=74;
    public static final int KW_DEFINED=75;
    public static final int KW_DELETE=76;
    public static final int KW_DELIMITED=77;
    public static final int KW_DEPENDENCY=78;
    public static final int KW_DESC=79;
    public static final int KW_DESCRIBE=80;
    public static final int KW_DIRECTORIES=81;
    public static final int KW_DIRECTORY=82;
    public static final int KW_DISABLE=83;
    public static final int KW_DISTINCT=84;
    public static final int KW_DISTRIBUTE=85;
    public static final int KW_DOUBLE=86;
    public static final int KW_DROP=87;
    public static final int KW_ELEM_TYPE=88;
    public static final int KW_ELSE=89;
    public static final int KW_ENABLE=90;
    public static final int KW_END=91;
    public static final int KW_ESCAPED=92;
    public static final int KW_EXCHANGE=93;
    public static final int KW_EXCLUSIVE=94;
    public static final int KW_EXISTS=95;
    public static final int KW_EXPLAIN=96;
    public static final int KW_EXPORT=97;
    public static final int KW_EXTENDED=98;
    public static final int KW_EXTERNAL=99;
    public static final int KW_FALSE=100;
    public static final int KW_FETCH=101;
    public static final int KW_FIELDS=102;
    public static final int KW_FILEFORMAT=103;
    public static final int KW_FIRST=104;
    public static final int KW_FLOAT=105;
    public static final int KW_FOLLOWING=106;
    public static final int KW_FOR=107;
    public static final int KW_FORMAT=108;
    public static final int KW_FORMATTED=109;
    public static final int KW_FROM=110;
    public static final int KW_FULL=111;
    public static final int KW_FUNCTION=112;
    public static final int KW_FUNCTIONS=113;
    public static final int KW_GRANT=114;
    public static final int KW_GROUP=115;
    public static final int KW_GROUPING=116;
    public static final int KW_HAVING=117;
    public static final int KW_HOLD_DDLTIME=118;
    public static final int KW_IDXPROPERTIES=119;
    public static final int KW_IF=120;
    public static final int KW_IGNORE=121;
    public static final int KW_IMPORT=122;
    public static final int KW_IN=123;
    public static final int KW_INDEX=124;
    public static final int KW_INDEXES=125;
    public static final int KW_INNER=126;
    public static final int KW_INPATH=127;
    public static final int KW_INPUTDRIVER=128;
    public static final int KW_INPUTFORMAT=129;
    public static final int KW_INSERT=130;
    public static final int KW_INT=131;
    public static final int KW_INTERSECT=132;
    public static final int KW_INTO=133;
    public static final int KW_IS=134;
    public static final int KW_ITEMS=135;
    public static final int KW_JOIN=136;
    public static final int KW_KEYS=137;
    public static final int KW_KEY_TYPE=138;
    public static final int KW_LATERAL=139;
    public static final int KW_LEFT=140;
    public static final int KW_LESS=141;
    public static final int KW_LIKE=142;
    public static final int KW_LIMIT=143;
    public static final int KW_LINES=144;
    public static final int KW_LOAD=145;
    public static final int KW_LOCAL=146;
    public static final int KW_LOCATION=147;
    public static final int KW_LOCK=148;
    public static final int KW_LOCKS=149;
    public static final int KW_LOGICAL=150;
    public static final int KW_LONG=151;
    public static final int KW_MACRO=152;
    public static final int KW_MAP=153;
    public static final int KW_MAPJOIN=154;
    public static final int KW_MATERIALIZED=155;
    public static final int KW_MINUS=156;
    public static final int KW_MORE=157;
    public static final int KW_MSCK=158;
    public static final int KW_NONE=159;
    public static final int KW_NOSCAN=160;
    public static final int KW_NOT=161;
    public static final int KW_NO_DROP=162;
    public static final int KW_NULL=163;
    public static final int KW_OF=164;
    public static final int KW_OFFLINE=165;
    public static final int KW_ON=166;
    public static final int KW_OPTION=167;
    public static final int KW_OR=168;
    public static final int KW_ORCFILE=169;
    public static final int KW_ORDER=170;
    public static final int KW_OUT=171;
    public static final int KW_OUTER=172;
    public static final int KW_OUTPUTDRIVER=173;
    public static final int KW_OUTPUTFORMAT=174;
    public static final int KW_OVER=175;
    public static final int KW_OVERWRITE=176;
    public static final int KW_PARQUETFILE=177;
    public static final int KW_PARTIALSCAN=178;
    public static final int KW_PARTITION=179;
    public static final int KW_PARTITIONED=180;
    public static final int KW_PARTITIONS=181;
    public static final int KW_PERCENT=182;
    public static final int KW_PLUS=183;
    public static final int KW_PRECEDING=184;
    public static final int KW_PRESERVE=185;
    public static final int KW_PRETTY=186;
    public static final int KW_PROCEDURE=187;
    public static final int KW_PROTECTION=188;
    public static final int KW_PURGE=189;
    public static final int KW_RANGE=190;
    public static final int KW_RCFILE=191;
    public static final int KW_READ=192;
    public static final int KW_READONLY=193;
    public static final int KW_READS=194;
    public static final int KW_REBUILD=195;
    public static final int KW_RECORDREADER=196;
    public static final int KW_RECORDWRITER=197;
    public static final int KW_REDUCE=198;
    public static final int KW_REGEXP=199;
    public static final int KW_RENAME=200;
    public static final int KW_REPAIR=201;
    public static final int KW_REPLACE=202;
    public static final int KW_RESTRICT=203;
    public static final int KW_REVOKE=204;
    public static final int KW_RIGHT=205;
    public static final int KW_RLIKE=206;
    public static final int KW_ROLE=207;
    public static final int KW_ROLES=208;
    public static final int KW_ROLLUP=209;
    public static final int KW_ROW=210;
    public static final int KW_ROWS=211;
    public static final int KW_SCHEMA=212;
    public static final int KW_SCHEMAS=213;
    public static final int KW_SELECT=214;
    public static final int KW_SEMI=215;
    public static final int KW_SEQUENCEFILE=216;
    public static final int KW_SERDE=217;
    public static final int KW_SERDEPROPERTIES=218;
    public static final int KW_SERVER=219;
    public static final int KW_SET=220;
    public static final int KW_SETS=221;
    public static final int KW_SHARED=222;
    public static final int KW_SHOW=223;
    public static final int KW_SHOW_DATABASE=224;
    public static final int KW_SKEWED=225;
    public static final int KW_SMALLINT=226;
    public static final int KW_SORT=227;
    public static final int KW_SORTED=228;
    public static final int KW_SSL=229;
    public static final int KW_STATISTICS=230;
    public static final int KW_STORED=231;
    public static final int KW_STREAMTABLE=232;
    public static final int KW_STRING=233;
    public static final int KW_STRUCT=234;
    public static final int KW_TABLE=235;
    public static final int KW_TABLES=236;
    public static final int KW_TABLESAMPLE=237;
    public static final int KW_TBLPROPERTIES=238;
    public static final int KW_TEMPORARY=239;
    public static final int KW_TERMINATED=240;
    public static final int KW_TEXTFILE=241;
    public static final int KW_THEN=242;
    public static final int KW_TIMESTAMP=243;
    public static final int KW_TINYINT=244;
    public static final int KW_TO=245;
    public static final int KW_TOUCH=246;
    public static final int KW_TRANSFORM=247;
    public static final int KW_TRIGGER=248;
    public static final int KW_TRUE=249;
    public static final int KW_TRUNCATE=250;
    public static final int KW_UNARCHIVE=251;
    public static final int KW_UNBOUNDED=252;
    public static final int KW_UNDO=253;
    public static final int KW_UNION=254;
    public static final int KW_UNIONTYPE=255;
    public static final int KW_UNIQUEJOIN=256;
    public static final int KW_UNLOCK=257;
    public static final int KW_UNSET=258;
    public static final int KW_UNSIGNED=259;
    public static final int KW_UPDATE=260;
    public static final int KW_URI=261;
    public static final int KW_USE=262;
    public static final int KW_USER=263;
    public static final int KW_USING=264;
    public static final int KW_UTC=265;
    public static final int KW_UTCTIMESTAMP=266;
    public static final int KW_VALUE_TYPE=267;
    public static final int KW_VARCHAR=268;
    public static final int KW_VIEW=269;
    public static final int KW_WHEN=270;
    public static final int KW_WHERE=271;
    public static final int KW_WHILE=272;
    public static final int KW_WINDOW=273;
    public static final int KW_WITH=274;
    public static final int LCURLY=275;
    public static final int LESSTHAN=276;
    public static final int LESSTHANOREQUALTO=277;
    public static final int LPAREN=278;
    public static final int LSQUARE=279;
    public static final int Letter=280;
    public static final int MINUS=281;
    public static final int MOD=282;
    public static final int NOTEQUAL=283;
    public static final int Number=284;
    public static final int PLUS=285;
    public static final int QUESTION=286;
    public static final int RCURLY=287;
    public static final int RPAREN=288;
    public static final int RSQUARE=289;
    public static final int RegexComponent=290;
    public static final int SEMICOLON=291;
    public static final int STAR=292;
    public static final int SmallintLiteral=293;
    public static final int StringLiteral=294;
    public static final int TILDE=295;
    public static final int TinyintLiteral=296;
    public static final int WS=297;
    public static final int TOK_ALIASLIST=566;
    public static final int TOK_ALLCOLREF=567;
    public static final int TOK_ALTERDATABASE_PROPERTIES=568;
    public static final int TOK_ALTERINDEX_PROPERTIES=569;
    public static final int TOK_ALTERINDEX_REBUILD=570;
    public static final int TOK_ALTERTABLE_ADDCOLS=571;
    public static final int TOK_ALTERTABLE_ADDPARTS=572;
    public static final int TOK_ALTERTABLE_ALTERPARTS=573;
    public static final int TOK_ALTERTABLE_ALTERPARTS_MERGEFILES=574;
    public static final int TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE=575;
    public static final int TOK_ALTERTABLE_ARCHIVE=576;
    public static final int TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION=577;
    public static final int TOK_ALTERTABLE_CLUSTER_SORT=578;
    public static final int TOK_ALTERTABLE_DROPPARTS=579;
    public static final int TOK_ALTERTABLE_FILEFORMAT=580;
    public static final int TOK_ALTERTABLE_LOCATION=581;
    public static final int TOK_ALTERTABLE_PARTITION=582;
    public static final int TOK_ALTERTABLE_PROPERTIES=583;
    public static final int TOK_ALTERTABLE_RENAME=584;
    public static final int TOK_ALTERTABLE_RENAMECOL=585;
    public static final int TOK_ALTERTABLE_RENAMEPART=586;
    public static final int TOK_ALTERTABLE_REPLACECOLS=587;
    public static final int TOK_ALTERTABLE_SERDEPROPERTIES=588;
    public static final int TOK_ALTERTABLE_SERIALIZER=589;
    public static final int TOK_ALTERTABLE_SKEWED=590;
    public static final int TOK_ALTERTABLE_TOUCH=591;
    public static final int TOK_ALTERTABLE_UNARCHIVE=592;
    public static final int TOK_ALTERTBLPART_SKEWED_LOCATION=593;
    public static final int TOK_ALTERVIEW_ADDPARTS=594;
    public static final int TOK_ALTERVIEW_AS=595;
    public static final int TOK_ALTERVIEW_DROPPARTS=596;
    public static final int TOK_ALTERVIEW_PROPERTIES=597;
    public static final int TOK_ALTERVIEW_RENAME=598;
    public static final int TOK_ANALYZE=599;
    public static final int TOK_BIGINT=600;
    public static final int TOK_BINARY=601;
    public static final int TOK_BOOLEAN=602;
    public static final int TOK_CASCADE=603;
    public static final int TOK_CHAR=604;
    public static final int TOK_CHARSETLITERAL=605;
    public static final int TOK_CLUSTERBY=606;
    public static final int TOK_COLTYPELIST=607;
    public static final int TOK_CREATEDATABASE=608;
    public static final int TOK_CREATEFUNCTION=609;
    public static final int TOK_CREATEINDEX=610;
    public static final int TOK_CREATEINDEX_INDEXTBLNAME=611;
    public static final int TOK_CREATEMACRO=612;
    public static final int TOK_CREATEROLE=613;
    public static final int TOK_CREATETABLE=614;
    public static final int TOK_CREATEVIEW=615;
    public static final int TOK_CROSSJOIN=616;
    public static final int TOK_CUBE_GROUPBY=617;
    public static final int TOK_DATABASECOMMENT=618;
    public static final int TOK_DATABASELOCATION=619;
    public static final int TOK_DATABASEPROPERTIES=620;
    public static final int TOK_DATE=621;
    public static final int TOK_DATELITERAL=622;
    public static final int TOK_DATETIME=623;
    public static final int TOK_DBPROPLIST=624;
    public static final int TOK_DECIMAL=625;
    public static final int TOK_DEFERRED_REBUILDINDEX=626;
    public static final int TOK_DESCDATABASE=627;
    public static final int TOK_DESCFUNCTION=628;
    public static final int TOK_DESCTABLE=629;
    public static final int TOK_DESTINATION=630;
    public static final int TOK_DIR=631;
    public static final int TOK_DISABLE=632;
    public static final int TOK_DISTRIBUTEBY=633;
    public static final int TOK_DOUBLE=634;
    public static final int TOK_DROPDATABASE=635;
    public static final int TOK_DROPFUNCTION=636;
    public static final int TOK_DROPINDEX=637;
    public static final int TOK_DROPMACRO=638;
    public static final int TOK_DROPROLE=639;
    public static final int TOK_DROPTABLE=640;
    public static final int TOK_DROPTABLE_PROPERTIES=641;
    public static final int TOK_DROPVIEW=642;
    public static final int TOK_DROPVIEW_PROPERTIES=643;
    public static final int TOK_ENABLE=644;
    public static final int TOK_EXCHANGEPARTITION=645;
    public static final int TOK_EXPLAIN=646;
    public static final int TOK_EXPLIST=647;
    public static final int TOK_EXPORT=648;
    public static final int TOK_FALSE=649;
    public static final int TOK_FILEFORMAT_GENERIC=650;
    public static final int TOK_FLOAT=651;
    public static final int TOK_FROM=652;
    public static final int TOK_FULLOUTERJOIN=653;
    public static final int TOK_FUNCTION=654;
    public static final int TOK_FUNCTIONDI=655;
    public static final int TOK_FUNCTIONSTAR=656;
    public static final int TOK_GRANT=657;
    public static final int TOK_GRANT_ROLE=658;
    public static final int TOK_GRANT_WITH_OPTION=659;
    public static final int TOK_GROUP=660;
    public static final int TOK_GROUPBY=661;
    public static final int TOK_GROUPING_SETS=662;
    public static final int TOK_GROUPING_SETS_EXPRESSION=663;
    public static final int TOK_HAVING=664;
    public static final int TOK_HINT=665;
    public static final int TOK_HINTARGLIST=666;
    public static final int TOK_HINTLIST=667;
    public static final int TOK_HOLD_DDLTIME=668;
    public static final int TOK_IFEXISTS=669;
    public static final int TOK_IFNOTEXISTS=670;
    public static final int TOK_IGNOREPROTECTION=671;
    public static final int TOK_IMPORT=672;
    public static final int TOK_INDEXCOMMENT=673;
    public static final int TOK_INDEXPROPERTIES=674;
    public static final int TOK_INDEXPROPLIST=675;
    public static final int TOK_INSERT=676;
    public static final int TOK_INSERT_INTO=677;
    public static final int TOK_INT=678;
    public static final int TOK_ISNOTNULL=679;
    public static final int TOK_ISNULL=680;
    public static final int TOK_JOIN=681;
    public static final int TOK_LATERAL_VIEW=682;
    public static final int TOK_LATERAL_VIEW_OUTER=683;
    public static final int TOK_LEFTOUTERJOIN=684;
    public static final int TOK_LEFTSEMIJOIN=685;
    public static final int TOK_LENGTH=686;
    public static final int TOK_LIKETABLE=687;
    public static final int TOK_LIMIT=688;
    public static final int TOK_LIST=689;
    public static final int TOK_LOAD=690;
    public static final int TOK_LOCAL_DIR=691;
    public static final int TOK_LOCKTABLE=692;
    public static final int TOK_MAP=693;
    public static final int TOK_MAPJOIN=694;
    public static final int TOK_MSCK=695;
    public static final int TOK_NOT_CLUSTERED=696;
    public static final int TOK_NOT_SORTED=697;
    public static final int TOK_NO_DROP=698;
    public static final int TOK_NULL=699;
    public static final int TOK_OFFLINE=700;
    public static final int TOK_OP_ADD=701;
    public static final int TOK_OP_AND=702;
    public static final int TOK_OP_BITAND=703;
    public static final int TOK_OP_BITNOT=704;
    public static final int TOK_OP_BITOR=705;
    public static final int TOK_OP_BITXOR=706;
    public static final int TOK_OP_DIV=707;
    public static final int TOK_OP_EQ=708;
    public static final int TOK_OP_GE=709;
    public static final int TOK_OP_GT=710;
    public static final int TOK_OP_LE=711;
    public static final int TOK_OP_LIKE=712;
    public static final int TOK_OP_LT=713;
    public static final int TOK_OP_MOD=714;
    public static final int TOK_OP_MUL=715;
    public static final int TOK_OP_NE=716;
    public static final int TOK_OP_NOT=717;
    public static final int TOK_OP_OR=718;
    public static final int TOK_OP_SUB=719;
    public static final int TOK_ORDERBY=720;
    public static final int TOK_ORREPLACE=721;
    public static final int TOK_PARTITIONINGSPEC=722;
    public static final int TOK_PARTITIONLOCATION=723;
    public static final int TOK_PARTSPEC=724;
    public static final int TOK_PARTVAL=725;
    public static final int TOK_PERCENT=726;
    public static final int TOK_PRINCIPAL_NAME=727;
    public static final int TOK_PRIVILEGE=728;
    public static final int TOK_PRIVILEGE_LIST=729;
    public static final int TOK_PRIV_ALL=730;
    public static final int TOK_PRIV_ALTER_DATA=731;
    public static final int TOK_PRIV_ALTER_METADATA=732;
    public static final int TOK_PRIV_CREATE=733;
    public static final int TOK_PRIV_DROP=734;
    public static final int TOK_PRIV_INDEX=735;
    public static final int TOK_PRIV_INSERT=736;
    public static final int TOK_PRIV_LOCK=737;
    public static final int TOK_PRIV_OBJECT=738;
    public static final int TOK_PRIV_OBJECT_COL=739;
    public static final int TOK_PRIV_SELECT=740;
    public static final int TOK_PRIV_SHOW_DATABASE=741;
    public static final int TOK_PTBLFUNCTION=742;
    public static final int TOK_QUERY=743;
    public static final int TOK_READONLY=744;
    public static final int TOK_RECORDREADER=745;
    public static final int TOK_RECORDWRITER=746;
    public static final int TOK_RESTRICT=747;
    public static final int TOK_REVOKE=748;
    public static final int TOK_REVOKE_ROLE=749;
    public static final int TOK_RIGHTOUTERJOIN=750;
    public static final int TOK_ROLE=751;
    public static final int TOK_ROLLUP_GROUPBY=752;
    public static final int TOK_ROWCOUNT=753;
    public static final int TOK_SELECT=754;
    public static final int TOK_SELECTDI=755;
    public static final int TOK_SELEXPR=756;
    public static final int TOK_SERDE=757;
    public static final int TOK_SERDENAME=758;
    public static final int TOK_SERDEPROPS=759;
    public static final int TOK_SERVER=760;
    public static final int TOK_SHOWCOLUMNS=761;
    public static final int TOK_SHOWDATABASES=762;
    public static final int TOK_SHOWFUNCTIONS=763;
    public static final int TOK_SHOWINDEXES=764;
    public static final int TOK_SHOWLOCKS=765;
    public static final int TOK_SHOWPARTITIONS=766;
    public static final int TOK_SHOWTABLES=767;
    public static final int TOK_SHOW_CREATETABLE=768;
    public static final int TOK_SHOW_GRANT=769;
    public static final int TOK_SHOW_ROLES=770;
    public static final int TOK_SHOW_ROLE_GRANT=771;
    public static final int TOK_SHOW_SET_ROLE=772;
    public static final int TOK_SHOW_TABLESTATUS=773;
    public static final int TOK_SHOW_TBLPROPERTIES=774;
    public static final int TOK_SKEWED_LOCATIONS=775;
    public static final int TOK_SKEWED_LOCATION_LIST=776;
    public static final int TOK_SKEWED_LOCATION_MAP=777;
    public static final int TOK_SMALLINT=778;
    public static final int TOK_SORTBY=779;
    public static final int TOK_STORAGEHANDLER=780;
    public static final int TOK_STOREDASDIRS=781;
    public static final int TOK_STREAMTABLE=782;
    public static final int TOK_STRING=783;
    public static final int TOK_STRINGLITERALSEQUENCE=784;
    public static final int TOK_STRUCT=785;
    public static final int TOK_SUBQUERY=786;
    public static final int TOK_SWITCHDATABASE=787;
    public static final int TOK_TAB=788;
    public static final int TOK_TABALIAS=789;
    public static final int TOK_TABCOL=790;
    public static final int TOK_TABCOLLIST=791;
    public static final int TOK_TABCOLNAME=792;
    public static final int TOK_TABCOLVALUE=793;
    public static final int TOK_TABCOLVALUES=794;
    public static final int TOK_TABCOLVALUE_PAIR=795;
    public static final int TOK_TABLEBUCKETS=796;
    public static final int TOK_TABLEBUCKETSAMPLE=797;
    public static final int TOK_TABLECOMMENT=798;
    public static final int TOK_TABLEFILEFORMAT=799;
    public static final int TOK_TABLELOCATION=800;
    public static final int TOK_TABLEPARTCOLS=801;
    public static final int TOK_TABLEPROPERTIES=802;
    public static final int TOK_TABLEPROPERTY=803;
    public static final int TOK_TABLEPROPLIST=804;
    public static final int TOK_TABLEROWFORMAT=805;
    public static final int TOK_TABLEROWFORMATCOLLITEMS=806;
    public static final int TOK_TABLEROWFORMATFIELD=807;
    public static final int TOK_TABLEROWFORMATLINES=808;
    public static final int TOK_TABLEROWFORMATMAPKEYS=809;
    public static final int TOK_TABLEROWFORMATNULL=810;
    public static final int TOK_TABLESERIALIZER=811;
    public static final int TOK_TABLESKEWED=812;
    public static final int TOK_TABLESPLITSAMPLE=813;
    public static final int TOK_TABLE_OR_COL=814;
    public static final int TOK_TABLE_PARTITION=815;
    public static final int TOK_TABNAME=816;
    public static final int TOK_TABREF=817;
    public static final int TOK_TABSORTCOLNAMEASC=818;
    public static final int TOK_TABSORTCOLNAMEDESC=819;
    public static final int TOK_TABSRC=820;
    public static final int TOK_TABTYPE=821;
    public static final int TOK_TBLORCFILE=822;
    public static final int TOK_TBLPARQUETFILE=823;
    public static final int TOK_TBLRCFILE=824;
    public static final int TOK_TBLSEQUENCEFILE=825;
    public static final int TOK_TBLTEXTFILE=826;
    public static final int TOK_TIMESTAMP=827;
    public static final int TOK_TINYINT=828;
    public static final int TOK_TMP_FILE=829;
    public static final int TOK_TRANSFORM=830;
    public static final int TOK_TRUE=831;
    public static final int TOK_TRUNCATETABLE=832;
    public static final int TOK_UNION=833;
    public static final int TOK_UNIONTYPE=834;
    public static final int TOK_UNIQUEJOIN=835;
    public static final int TOK_UNLOCKTABLE=836;
    public static final int TOK_URI=837;
    public static final int TOK_USER=838;
    public static final int TOK_USERSCRIPTCOLNAMES=839;
    public static final int TOK_USERSCRIPTCOLSCHEMA=840;
    public static final int TOK_VARCHAR=841;
    public static final int TOK_VIEWPARTCOLS=842;
    public static final int TOK_WHERE=843;
    public static final int TOK_WINDOWDEF=844;
    public static final int TOK_WINDOWRANGE=845;
    public static final int TOK_WINDOWSPEC=846;
    public static final int TOK_WINDOWVALUES=847;

    // delegates
    public HiveParser_SelectClauseParser gSelectClauseParser;
    public HiveParser_FromClauseParser gFromClauseParser;
    public HiveParser_IdentifiersParser gIdentifiersParser;
    public Parser[] getDelegates() {
        return new Parser[] {gSelectClauseParser, gFromClauseParser, gIdentifiersParser};
    }

    // delegators


    public HiveParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public HiveParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        gSelectClauseParser = new HiveParser_SelectClauseParser(input, state, this);
        gFromClauseParser = new HiveParser_FromClauseParser(input, state, this);
        gIdentifiersParser = new HiveParser_IdentifiersParser(input, state, this);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
    gSelectClauseParser.setTreeAdaptor(this.adaptor);gFromClauseParser.setTreeAdaptor(this.adaptor);gIdentifiersParser.setTreeAdaptor(this.adaptor);
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return HiveParser.tokenNames; }
    public String getGrammarFileName() { return "org/apache/hadoop/hive/ql/parse/HiveParser.g"; }


      ArrayList<ParseError> errors = new ArrayList<ParseError>();
      Stack msgs = new Stack<String>();

      private static HashMap<String, String> xlateMap;
      static {
        xlateMap = new HashMap<String, String>();

        // Keywords
        xlateMap.put("KW_TRUE", "TRUE");
        xlateMap.put("KW_FALSE", "FALSE");
        xlateMap.put("KW_ALL", "ALL");
        xlateMap.put("KW_NONE", "NONE");
        xlateMap.put("KW_DEFAULT", "DEFAULT");
        xlateMap.put("KW_AND", "AND");
        xlateMap.put("KW_OR", "OR");
        xlateMap.put("KW_NOT", "NOT");
        xlateMap.put("KW_LIKE", "LIKE");

        xlateMap.put("KW_ASC", "ASC");
        xlateMap.put("KW_DESC", "DESC");
        xlateMap.put("KW_ORDER", "ORDER");
        xlateMap.put("KW_BY", "BY");
        xlateMap.put("KW_GROUP", "GROUP");
        xlateMap.put("KW_WHERE", "WHERE");
        xlateMap.put("KW_FROM", "FROM");
        xlateMap.put("KW_AS", "AS");
        xlateMap.put("KW_SELECT", "SELECT");
        xlateMap.put("KW_DISTINCT", "DISTINCT");
        xlateMap.put("KW_INSERT", "INSERT");
        xlateMap.put("KW_OVERWRITE", "OVERWRITE");
        xlateMap.put("KW_OUTER", "OUTER");
        xlateMap.put("KW_JOIN", "JOIN");
        xlateMap.put("KW_LEFT", "LEFT");
        xlateMap.put("KW_RIGHT", "RIGHT");
        xlateMap.put("KW_FULL", "FULL");
        xlateMap.put("KW_ON", "ON");
        xlateMap.put("KW_PARTITION", "PARTITION");
        xlateMap.put("KW_PARTITIONS", "PARTITIONS");
        xlateMap.put("KW_TABLE", "TABLE");
        xlateMap.put("KW_TABLES", "TABLES");
        xlateMap.put("KW_TBLPROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_SHOW", "SHOW");
        xlateMap.put("KW_MSCK", "MSCK");
        xlateMap.put("KW_DIRECTORY", "DIRECTORY");
        xlateMap.put("KW_LOCAL", "LOCAL");
        xlateMap.put("KW_TRANSFORM", "TRANSFORM");
        xlateMap.put("KW_USING", "USING");
        xlateMap.put("KW_CLUSTER", "CLUSTER");
        xlateMap.put("KW_DISTRIBUTE", "DISTRIBUTE");
        xlateMap.put("KW_SORT", "SORT");
        xlateMap.put("KW_UNION", "UNION");
        xlateMap.put("KW_LOAD", "LOAD");
        xlateMap.put("KW_DATA", "DATA");
        xlateMap.put("KW_INPATH", "INPATH");
        xlateMap.put("KW_IS", "IS");
        xlateMap.put("KW_NULL", "NULL");
        xlateMap.put("KW_CREATE", "CREATE");
        xlateMap.put("KW_EXTERNAL", "EXTERNAL");
        xlateMap.put("KW_ALTER", "ALTER");
        xlateMap.put("KW_DESCRIBE", "DESCRIBE");
        xlateMap.put("KW_DROP", "DROP");
        xlateMap.put("KW_REANME", "REANME");
        xlateMap.put("KW_TO", "TO");
        xlateMap.put("KW_COMMENT", "COMMENT");
        xlateMap.put("KW_BOOLEAN", "BOOLEAN");
        xlateMap.put("KW_TINYINT", "TINYINT");
        xlateMap.put("KW_SMALLINT", "SMALLINT");
        xlateMap.put("KW_INT", "INT");
        xlateMap.put("KW_BIGINT", "BIGINT");
        xlateMap.put("KW_FLOAT", "FLOAT");
        xlateMap.put("KW_DOUBLE", "DOUBLE");
        xlateMap.put("KW_DATE", "DATE");
        xlateMap.put("KW_DATETIME", "DATETIME");
        xlateMap.put("KW_TIMESTAMP", "TIMESTAMP");
        xlateMap.put("KW_STRING", "STRING");
        xlateMap.put("KW_BINARY", "BINARY");
        xlateMap.put("KW_ARRAY", "ARRAY");
        xlateMap.put("KW_MAP", "MAP");
        xlateMap.put("KW_REDUCE", "REDUCE");
        xlateMap.put("KW_PARTITIONED", "PARTITIONED");
        xlateMap.put("KW_CLUSTERED", "CLUSTERED");
        xlateMap.put("KW_SORTED", "SORTED");
        xlateMap.put("KW_INTO", "INTO");
        xlateMap.put("KW_BUCKETS", "BUCKETS");
        xlateMap.put("KW_ROW", "ROW");
        xlateMap.put("KW_FORMAT", "FORMAT");
        xlateMap.put("KW_DELIMITED", "DELIMITED");
        xlateMap.put("KW_FIELDS", "FIELDS");
        xlateMap.put("KW_TERMINATED", "TERMINATED");
        xlateMap.put("KW_COLLECTION", "COLLECTION");
        xlateMap.put("KW_ITEMS", "ITEMS");
        xlateMap.put("KW_KEYS", "KEYS");
        xlateMap.put("KW_KEY_TYPE", "$KEY$");
        xlateMap.put("KW_LINES", "LINES");
        xlateMap.put("KW_STORED", "STORED");
        xlateMap.put("KW_SEQUENCEFILE", "SEQUENCEFILE");
        xlateMap.put("KW_TEXTFILE", "TEXTFILE");
        xlateMap.put("KW_INPUTFORMAT", "INPUTFORMAT");
        xlateMap.put("KW_OUTPUTFORMAT", "OUTPUTFORMAT");
        xlateMap.put("KW_LOCATION", "LOCATION");
        xlateMap.put("KW_TABLESAMPLE", "TABLESAMPLE");
        xlateMap.put("KW_BUCKET", "BUCKET");
        xlateMap.put("KW_OUT", "OUT");
        xlateMap.put("KW_OF", "OF");
        xlateMap.put("KW_CAST", "CAST");
        xlateMap.put("KW_ADD", "ADD");
        xlateMap.put("KW_REPLACE", "REPLACE");
        xlateMap.put("KW_COLUMNS", "COLUMNS");
        xlateMap.put("KW_RLIKE", "RLIKE");
        xlateMap.put("KW_REGEXP", "REGEXP");
        xlateMap.put("KW_TEMPORARY", "TEMPORARY");
        xlateMap.put("KW_FUNCTION", "FUNCTION");
        xlateMap.put("KW_EXPLAIN", "EXPLAIN");
        xlateMap.put("KW_EXTENDED", "EXTENDED");
        xlateMap.put("KW_SERDE", "SERDE");
        xlateMap.put("KW_WITH", "WITH");
        xlateMap.put("KW_SERDEPROPERTIES", "SERDEPROPERTIES");
        xlateMap.put("KW_LIMIT", "LIMIT");
        xlateMap.put("KW_SET", "SET");
        xlateMap.put("KW_PROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_VALUE_TYPE", "$VALUE$");
        xlateMap.put("KW_ELEM_TYPE", "$ELEM$");
        xlateMap.put("KW_DEFINED", "DEFINED");

        // Operators
        xlateMap.put("DOT", ".");
        xlateMap.put("COLON", ":");
        xlateMap.put("COMMA", ",");
        xlateMap.put("SEMICOLON", ");");

        xlateMap.put("LPAREN", "(");
        xlateMap.put("RPAREN", ")");
        xlateMap.put("LSQUARE", "[");
        xlateMap.put("RSQUARE", "]");

        xlateMap.put("EQUAL", "=");
        xlateMap.put("NOTEQUAL", "<>");
        xlateMap.put("EQUAL_NS", "<=>");
        xlateMap.put("LESSTHANOREQUALTO", "<=");
        xlateMap.put("LESSTHAN", "<");
        xlateMap.put("GREATERTHANOREQUALTO", ">=");
        xlateMap.put("GREATERTHAN", ">");

        xlateMap.put("DIVIDE", "/");
        xlateMap.put("PLUS", "+");
        xlateMap.put("MINUS", "-");
        xlateMap.put("STAR", "*");
        xlateMap.put("MOD", "%");

        xlateMap.put("AMPERSAND", "&");
        xlateMap.put("TILDE", "~");
        xlateMap.put("BITWISEOR", "|");
        xlateMap.put("BITWISEXOR", "^");
        xlateMap.put("CharSetLiteral", "\\'");
      }

      public static Collection<String> getKeywords() {
        return xlateMap.values();
      }

      private static String xlate(String name) {

        String ret = xlateMap.get(name);
        if (ret == null) {
          ret = name;
        }

        return ret;
      }

      @Override
      public Object recoverFromMismatchedSet(IntStream input,
          RecognitionException re, BitSet follow) throws RecognitionException {
        throw re;
      }

      @Override
      public void displayRecognitionError(String[] tokenNames,
          RecognitionException e) {
        errors.add(new ParseError(this, e, tokenNames));
      }

      @Override
      public String getErrorHeader(RecognitionException e) {
        String header = null;
        if (e.charPositionInLine < 0 && input.LT(-1) != null) {
          Token t = input.LT(-1);
          header = "line " + t.getLine() + ":" + t.getCharPositionInLine();
        } else {
          header = super.getErrorHeader(e);
        }

        return header;
      }
      
      @Override
      public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;

        // Translate the token names to something that the user can understand
        String[] xlateNames = new String[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
          xlateNames[i] = HiveParser.xlate(tokenNames[i]);
        }

        if (e instanceof NoViableAltException) {
          @SuppressWarnings("unused")
          NoViableAltException nvae = (NoViableAltException) e;
          // for development, can add
          // "decision=<<"+nvae.grammarDecisionDescription+">>"
          // and "(decision="+nvae.decisionNumber+") and
          // "state "+nvae.stateNumber
          msg = "cannot recognize input near"
                  + (input.LT(1) != null ? " " + getTokenErrorDisplay(input.LT(1)) : "")
                  + (input.LT(2) != null ? " " + getTokenErrorDisplay(input.LT(2)) : "")
                  + (input.LT(3) != null ? " " + getTokenErrorDisplay(input.LT(3)) : "");
        } else if (e instanceof MismatchedTokenException) {
          MismatchedTokenException mte = (MismatchedTokenException) e;
          msg = super.getErrorMessage(e, xlateNames) + (input.LT(-1) == null ? "":" near '" + input.LT(-1).getText()) + "'";
        } else if (e instanceof FailedPredicateException) {
          FailedPredicateException fpe = (FailedPredicateException) e;
          msg = "Failed to recognize predicate '" + fpe.token.getText() + "'. Failed rule: '" + fpe.ruleName + "'";
        } else {
          msg = super.getErrorMessage(e, xlateNames);
        }

        if (msgs.size() > 0) {
          msg = msg + " in " + msgs.peek();
        }
        return msg;
      }


    public static class statement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:566:1: statement : ( explainStatement EOF | execStatement EOF );
    public final HiveParser.statement_return statement() throws RecognitionException {
        HiveParser.statement_return retval = new HiveParser.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token EOF2=null;
        Token EOF4=null;
        HiveParser.explainStatement_return explainStatement1 =null;

        HiveParser.execStatement_return execStatement3 =null;


        CommonTree EOF2_tree=null;
        CommonTree EOF4_tree=null;

        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:567:2: ( explainStatement EOF | execStatement EOF )
            int alt1=2;
            switch ( input.LA(1) ) {
            case KW_EXPLAIN:
                {
                alt1=1;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_EXPORT:
            case KW_FROM:
            case KW_GRANT:
            case KW_IMPORT:
            case KW_INSERT:
            case KW_LOAD:
            case KW_LOCK:
            case KW_MAP:
            case KW_MSCK:
            case KW_REDUCE:
            case KW_REVOKE:
            case KW_SELECT:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
                {
                alt1=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;

            }

            switch (alt1) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:567:4: explainStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_explainStatement_in_statement929);
                    explainStatement1=explainStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, explainStatement1.getTree());

                    EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_statement931); 
                    EOF2_tree = 
                    (CommonTree)adaptor.create(EOF2)
                    ;
                    adaptor.addChild(root_0, EOF2_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:568:4: execStatement EOF
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_execStatement_in_statement936);
                    execStatement3=execStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, execStatement3.getTree());

                    EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_statement938); 
                    EOF4_tree = 
                    (CommonTree)adaptor.create(EOF4)
                    ;
                    adaptor.addChild(root_0, EOF4_tree);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class explainStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "explainStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:571:1: explainStatement : KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? ) ;
    public final HiveParser.explainStatement_return explainStatement() throws RecognitionException {
        HiveParser.explainStatement_return retval = new HiveParser.explainStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token explainOptions=null;
        Token KW_EXPLAIN5=null;
        HiveParser.execStatement_return execStatement6 =null;


        CommonTree explainOptions_tree=null;
        CommonTree KW_EXPLAIN5_tree=null;
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_DEPENDENCY=new RewriteRuleTokenStream(adaptor,"token KW_DEPENDENCY");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_EXPLAIN=new RewriteRuleTokenStream(adaptor,"token KW_EXPLAIN");
        RewriteRuleTokenStream stream_KW_LOGICAL=new RewriteRuleTokenStream(adaptor,"token KW_LOGICAL");
        RewriteRuleSubtreeStream stream_execStatement=new RewriteRuleSubtreeStream(adaptor,"rule execStatement");
         msgs.push("explain statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:2: ( KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:4: KW_EXPLAIN (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )? execStatement
            {
            KW_EXPLAIN5=(Token)match(input,KW_EXPLAIN,FOLLOW_KW_EXPLAIN_in_explainStatement959);  
            stream_KW_EXPLAIN.add(KW_EXPLAIN5);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:15: (explainOptions= KW_EXTENDED |explainOptions= KW_FORMATTED |explainOptions= KW_DEPENDENCY |explainOptions= KW_LOGICAL )?
            int alt2=5;
            switch ( input.LA(1) ) {
                case KW_EXTENDED:
                    {
                    alt2=1;
                    }
                    break;
                case KW_FORMATTED:
                    {
                    alt2=2;
                    }
                    break;
                case KW_DEPENDENCY:
                    {
                    alt2=3;
                    }
                    break;
                case KW_LOGICAL:
                    {
                    alt2=4;
                    }
                    break;
            }

            switch (alt2) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:16: explainOptions= KW_EXTENDED
                    {
                    explainOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_explainStatement964);  
                    stream_KW_EXTENDED.add(explainOptions);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:43: explainOptions= KW_FORMATTED
                    {
                    explainOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_explainStatement968);  
                    stream_KW_FORMATTED.add(explainOptions);


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:71: explainOptions= KW_DEPENDENCY
                    {
                    explainOptions=(Token)match(input,KW_DEPENDENCY,FOLLOW_KW_DEPENDENCY_in_explainStatement972);  
                    stream_KW_DEPENDENCY.add(explainOptions);


                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:574:100: explainOptions= KW_LOGICAL
                    {
                    explainOptions=(Token)match(input,KW_LOGICAL,FOLLOW_KW_LOGICAL_in_explainStatement976);  
                    stream_KW_LOGICAL.add(explainOptions);


                    }
                    break;

            }


            pushFollow(FOLLOW_execStatement_in_explainStatement980);
            execStatement6=execStatement();

            state._fsp--;

            stream_execStatement.add(execStatement6.getTree());

            // AST REWRITE
            // elements: execStatement, explainOptions
            // token labels: explainOptions
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_explainOptions=new RewriteRuleTokenStream(adaptor,"token explainOptions",explainOptions);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 575:7: -> ^( TOK_EXPLAIN execStatement ( $explainOptions)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:575:10: ^( TOK_EXPLAIN execStatement ( $explainOptions)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPLAIN, "TOK_EXPLAIN")
                , root_1);

                adaptor.addChild(root_1, stream_execStatement.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:575:39: ( $explainOptions)?
                if ( stream_explainOptions.hasNext() ) {
                    adaptor.addChild(root_1, stream_explainOptions.nextNode());

                }
                stream_explainOptions.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "explainStatement"


    public static class execStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "execStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:578:1: execStatement : ( queryStatementExpression | loadStatement | exportStatement | importStatement | ddlStatement );
    public final HiveParser.execStatement_return execStatement() throws RecognitionException {
        HiveParser.execStatement_return retval = new HiveParser.execStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.queryStatementExpression_return queryStatementExpression7 =null;

        HiveParser.loadStatement_return loadStatement8 =null;

        HiveParser.exportStatement_return exportStatement9 =null;

        HiveParser.importStatement_return importStatement10 =null;

        HiveParser.ddlStatement_return ddlStatement11 =null;



         msgs.push("statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:581:5: ( queryStatementExpression | loadStatement | exportStatement | importStatement | ddlStatement )
            int alt3=5;
            switch ( input.LA(1) ) {
            case KW_FROM:
            case KW_INSERT:
            case KW_MAP:
            case KW_REDUCE:
            case KW_SELECT:
                {
                alt3=1;
                }
                break;
            case KW_LOAD:
                {
                alt3=2;
                }
                break;
            case KW_EXPORT:
                {
                alt3=3;
                }
                break;
            case KW_IMPORT:
                {
                alt3=4;
                }
                break;
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_CREATE:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DROP:
            case KW_GRANT:
            case KW_LOCK:
            case KW_MSCK:
            case KW_REVOKE:
            case KW_SET:
            case KW_SHOW:
            case KW_TRUNCATE:
            case KW_UNLOCK:
            case KW_USE:
                {
                alt3=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:581:7: queryStatementExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_queryStatementExpression_in_execStatement1022);
                    queryStatementExpression7=queryStatementExpression();

                    state._fsp--;

                    adaptor.addChild(root_0, queryStatementExpression7.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:582:7: loadStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_loadStatement_in_execStatement1030);
                    loadStatement8=loadStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, loadStatement8.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:583:7: exportStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_exportStatement_in_execStatement1038);
                    exportStatement9=exportStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, exportStatement9.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:584:7: importStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_importStatement_in_execStatement1046);
                    importStatement10=importStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, importStatement10.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:585:7: ddlStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_ddlStatement_in_execStatement1054);
                    ddlStatement11=ddlStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, ddlStatement11.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "execStatement"


    public static class loadStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "loadStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:588:1: loadStatement : KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) ;
    public final HiveParser.loadStatement_return loadStatement() throws RecognitionException {
        HiveParser.loadStatement_return retval = new HiveParser.loadStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token islocal=null;
        Token path=null;
        Token isoverwrite=null;
        Token KW_LOAD12=null;
        Token KW_DATA13=null;
        Token KW_INPATH14=null;
        Token KW_INTO15=null;
        Token KW_TABLE16=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree islocal_tree=null;
        CommonTree path_tree=null;
        CommonTree isoverwrite_tree=null;
        CommonTree KW_LOAD12_tree=null;
        CommonTree KW_DATA13_tree=null;
        CommonTree KW_INPATH14_tree=null;
        CommonTree KW_INTO15_tree=null;
        CommonTree KW_TABLE16_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPATH=new RewriteRuleTokenStream(adaptor,"token KW_INPATH");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_KW_LOCAL=new RewriteRuleTokenStream(adaptor,"token KW_LOCAL");
        RewriteRuleTokenStream stream_KW_OVERWRITE=new RewriteRuleTokenStream(adaptor,"token KW_OVERWRITE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_LOAD=new RewriteRuleTokenStream(adaptor,"token KW_LOAD");
        RewriteRuleTokenStream stream_KW_DATA=new RewriteRuleTokenStream(adaptor,"token KW_DATA");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         msgs.push("load statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:5: ( KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition ) -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:7: KW_LOAD KW_DATA (islocal= KW_LOCAL )? KW_INPATH (path= StringLiteral ) (isoverwrite= KW_OVERWRITE )? KW_INTO KW_TABLE (tab= tableOrPartition )
            {
            KW_LOAD12=(Token)match(input,KW_LOAD,FOLLOW_KW_LOAD_in_loadStatement1081);  
            stream_KW_LOAD.add(KW_LOAD12);


            KW_DATA13=(Token)match(input,KW_DATA,FOLLOW_KW_DATA_in_loadStatement1083);  
            stream_KW_DATA.add(KW_DATA13);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:23: (islocal= KW_LOCAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case KW_LOCAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:24: islocal= KW_LOCAL
                    {
                    islocal=(Token)match(input,KW_LOCAL,FOLLOW_KW_LOCAL_in_loadStatement1088);  
                    stream_KW_LOCAL.add(islocal);


                    }
                    break;

            }


            KW_INPATH14=(Token)match(input,KW_INPATH,FOLLOW_KW_INPATH_in_loadStatement1092);  
            stream_KW_INPATH.add(KW_INPATH14);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:53: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:54: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_loadStatement1097);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:74: (isoverwrite= KW_OVERWRITE )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case KW_OVERWRITE:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:75: isoverwrite= KW_OVERWRITE
                    {
                    isoverwrite=(Token)match(input,KW_OVERWRITE,FOLLOW_KW_OVERWRITE_in_loadStatement1103);  
                    stream_KW_OVERWRITE.add(isoverwrite);


                    }
                    break;

            }


            KW_INTO15=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_loadStatement1107);  
            stream_KW_INTO.add(KW_INTO15);


            KW_TABLE16=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_loadStatement1109);  
            stream_KW_TABLE.add(KW_TABLE16);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:119: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:591:120: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_loadStatement1114);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            // AST REWRITE
            // elements: tab, islocal, isoverwrite, path
            // token labels: islocal, isoverwrite, path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_islocal=new RewriteRuleTokenStream(adaptor,"token islocal",islocal);
            RewriteRuleTokenStream stream_isoverwrite=new RewriteRuleTokenStream(adaptor,"token isoverwrite",isoverwrite);
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 592:5: -> ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:592:8: ^( TOK_LOAD $path $tab ( $islocal)? ( $isoverwrite)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOAD, "TOK_LOAD")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:592:31: ( $islocal)?
                if ( stream_islocal.hasNext() ) {
                    adaptor.addChild(root_1, stream_islocal.nextNode());

                }
                stream_islocal.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:592:41: ( $isoverwrite)?
                if ( stream_isoverwrite.hasNext() ) {
                    adaptor.addChild(root_1, stream_isoverwrite.nextNode());

                }
                stream_isoverwrite.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "loadStatement"


    public static class exportStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "exportStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:595:1: exportStatement : KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) ;
    public final HiveParser.exportStatement_return exportStatement() throws RecognitionException {
        HiveParser.exportStatement_return retval = new HiveParser.exportStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token path=null;
        Token KW_EXPORT17=null;
        Token KW_TABLE18=null;
        Token KW_TO19=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;


        CommonTree path_tree=null;
        CommonTree KW_EXPORT17_tree=null;
        CommonTree KW_TABLE18_tree=null;
        CommonTree KW_TO19_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_EXPORT=new RewriteRuleTokenStream(adaptor,"token KW_EXPORT");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
         msgs.push("export statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:5: ( KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral ) -> ^( TOK_EXPORT $tab $path) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:7: KW_EXPORT KW_TABLE (tab= tableOrPartition ) KW_TO (path= StringLiteral )
            {
            KW_EXPORT17=(Token)match(input,KW_EXPORT,FOLLOW_KW_EXPORT_in_exportStatement1166);  
            stream_KW_EXPORT.add(KW_EXPORT17);


            KW_TABLE18=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_exportStatement1168);  
            stream_KW_TABLE.add(KW_TABLE18);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:26: (tab= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:27: tab= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_exportStatement1173);
            tab=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(tab.getTree());

            }


            KW_TO19=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_exportStatement1176);  
            stream_KW_TO.add(KW_TO19);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:55: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:598:56: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_exportStatement1181);  
            stream_StringLiteral.add(path);


            }


            // AST REWRITE
            // elements: tab, path
            // token labels: path
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 599:5: -> ^( TOK_EXPORT $tab $path)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:599:8: ^( TOK_EXPORT $tab $path)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXPORT, "TOK_EXPORT")
                , root_1);

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_path.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "exportStatement"


    public static class importStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "importStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:602:1: importStatement : KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) ;
    public final HiveParser.importStatement_return importStatement() throws RecognitionException {
        HiveParser.importStatement_return retval = new HiveParser.importStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token path=null;
        Token KW_IMPORT20=null;
        Token KW_TABLE21=null;
        Token KW_FROM22=null;
        HiveParser_IdentifiersParser.tableOrPartition_return tab =null;

        HiveParser.tableLocation_return tableLocation23 =null;


        CommonTree ext_tree=null;
        CommonTree path_tree=null;
        CommonTree KW_IMPORT20_tree=null;
        CommonTree KW_TABLE21_tree=null;
        CommonTree KW_FROM22_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_IMPORT=new RewriteRuleTokenStream(adaptor,"token KW_IMPORT");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
         msgs.push("import statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:2: ( KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )? -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:4: KW_IMPORT ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )? KW_FROM (path= StringLiteral ) ( tableLocation )?
            {
            KW_IMPORT20=(Token)match(input,KW_IMPORT,FOLLOW_KW_IMPORT_in_importStatement1222);  
            stream_KW_IMPORT.add(KW_IMPORT20);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:14: ( (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition ) )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                case KW_TABLE:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:15: (ext= KW_EXTERNAL )? KW_TABLE (tab= tableOrPartition )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:15: (ext= KW_EXTERNAL )?
                    int alt6=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTERNAL:
                            {
                            alt6=1;
                            }
                            break;
                    }

                    switch (alt6) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:16: ext= KW_EXTERNAL
                            {
                            ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_importStatement1228);  
                            stream_KW_EXTERNAL.add(ext);


                            }
                            break;

                    }


                    KW_TABLE21=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_importStatement1232);  
                    stream_KW_TABLE.add(KW_TABLE21);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:43: (tab= tableOrPartition )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:44: tab= tableOrPartition
                    {
                    pushFollow(FOLLOW_tableOrPartition_in_importStatement1237);
                    tab=tableOrPartition();

                    state._fsp--;

                    stream_tableOrPartition.add(tab.getTree());

                    }


                    }
                    break;

            }


            KW_FROM22=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_importStatement1242);  
            stream_KW_FROM.add(KW_FROM22);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:76: (path= StringLiteral )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:77: path= StringLiteral
            {
            path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_importStatement1247);  
            stream_StringLiteral.add(path);


            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:97: ( tableLocation )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:605:97: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_importStatement1250);
                    tableLocation23=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation23.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ext, tableLocation, tab, path
            // token labels: path, ext
            // rule labels: retval, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 606:5: -> ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:606:8: ^( TOK_IMPORT $path ( $tab)? ( $ext)? ( tableLocation )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IMPORT, "TOK_IMPORT")
                , root_1);

                adaptor.addChild(root_1, stream_path.nextNode());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:606:28: ( $tab)?
                if ( stream_tab.hasNext() ) {
                    adaptor.addChild(root_1, stream_tab.nextTree());

                }
                stream_tab.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:606:34: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:606:39: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "importStatement"


    public static class ddlStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ddlStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:609:1: ddlStatement : ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRoles | grantRole | revokeRole | setRole | showCurrentRole );
    public final HiveParser.ddlStatement_return ddlStatement() throws RecognitionException {
        HiveParser.ddlStatement_return retval = new HiveParser.ddlStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.createDatabaseStatement_return createDatabaseStatement24 =null;

        HiveParser.switchDatabaseStatement_return switchDatabaseStatement25 =null;

        HiveParser.dropDatabaseStatement_return dropDatabaseStatement26 =null;

        HiveParser.createTableStatement_return createTableStatement27 =null;

        HiveParser.dropTableStatement_return dropTableStatement28 =null;

        HiveParser.truncateTableStatement_return truncateTableStatement29 =null;

        HiveParser.alterStatement_return alterStatement30 =null;

        HiveParser.descStatement_return descStatement31 =null;

        HiveParser.showStatement_return showStatement32 =null;

        HiveParser.metastoreCheck_return metastoreCheck33 =null;

        HiveParser.createViewStatement_return createViewStatement34 =null;

        HiveParser.dropViewStatement_return dropViewStatement35 =null;

        HiveParser.createFunctionStatement_return createFunctionStatement36 =null;

        HiveParser.createMacroStatement_return createMacroStatement37 =null;

        HiveParser.createIndexStatement_return createIndexStatement38 =null;

        HiveParser.dropIndexStatement_return dropIndexStatement39 =null;

        HiveParser.dropFunctionStatement_return dropFunctionStatement40 =null;

        HiveParser.dropMacroStatement_return dropMacroStatement41 =null;

        HiveParser.analyzeStatement_return analyzeStatement42 =null;

        HiveParser.lockStatement_return lockStatement43 =null;

        HiveParser.unlockStatement_return unlockStatement44 =null;

        HiveParser.createRoleStatement_return createRoleStatement45 =null;

        HiveParser.dropRoleStatement_return dropRoleStatement46 =null;

        HiveParser.grantPrivileges_return grantPrivileges47 =null;

        HiveParser.revokePrivileges_return revokePrivileges48 =null;

        HiveParser.showGrants_return showGrants49 =null;

        HiveParser.showRoleGrants_return showRoleGrants50 =null;

        HiveParser.showRoles_return showRoles51 =null;

        HiveParser.grantRole_return grantRole52 =null;

        HiveParser.revokeRole_return revokeRole53 =null;

        HiveParser.setRole_return setRole54 =null;

        HiveParser.showCurrentRole_return showCurrentRole55 =null;



         msgs.push("ddl statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:612:5: ( createDatabaseStatement | switchDatabaseStatement | dropDatabaseStatement | createTableStatement | dropTableStatement | truncateTableStatement | alterStatement | descStatement | showStatement | metastoreCheck | createViewStatement | dropViewStatement | createFunctionStatement | createMacroStatement | createIndexStatement | dropIndexStatement | dropFunctionStatement | dropMacroStatement | analyzeStatement | lockStatement | unlockStatement | createRoleStatement | dropRoleStatement | grantPrivileges | revokePrivileges | showGrants | showRoleGrants | showRoles | grantRole | revokeRole | setRole | showCurrentRole )
            int alt9=32;
            alt9 = dfa9.predict(input);
            switch (alt9) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:612:7: createDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createDatabaseStatement_in_ddlStatement1302);
                    createDatabaseStatement24=createDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createDatabaseStatement24.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:613:7: switchDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_switchDatabaseStatement_in_ddlStatement1310);
                    switchDatabaseStatement25=switchDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, switchDatabaseStatement25.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:614:7: dropDatabaseStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropDatabaseStatement_in_ddlStatement1318);
                    dropDatabaseStatement26=dropDatabaseStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropDatabaseStatement26.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:615:7: createTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createTableStatement_in_ddlStatement1326);
                    createTableStatement27=createTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createTableStatement27.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:616:7: dropTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropTableStatement_in_ddlStatement1334);
                    dropTableStatement28=dropTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropTableStatement28.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:617:7: truncateTableStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_truncateTableStatement_in_ddlStatement1342);
                    truncateTableStatement29=truncateTableStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, truncateTableStatement29.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:618:7: alterStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatement_in_ddlStatement1350);
                    alterStatement30=alterStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatement30.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:619:7: descStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_descStatement_in_ddlStatement1358);
                    descStatement31=descStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, descStatement31.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:620:7: showStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showStatement_in_ddlStatement1366);
                    showStatement32=showStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, showStatement32.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:621:7: metastoreCheck
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_metastoreCheck_in_ddlStatement1374);
                    metastoreCheck33=metastoreCheck();

                    state._fsp--;

                    adaptor.addChild(root_0, metastoreCheck33.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:622:7: createViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createViewStatement_in_ddlStatement1382);
                    createViewStatement34=createViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createViewStatement34.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:623:7: dropViewStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropViewStatement_in_ddlStatement1390);
                    dropViewStatement35=dropViewStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropViewStatement35.getTree());

                    }
                    break;
                case 13 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:624:7: createFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createFunctionStatement_in_ddlStatement1398);
                    createFunctionStatement36=createFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createFunctionStatement36.getTree());

                    }
                    break;
                case 14 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:625:7: createMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createMacroStatement_in_ddlStatement1406);
                    createMacroStatement37=createMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createMacroStatement37.getTree());

                    }
                    break;
                case 15 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:626:7: createIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createIndexStatement_in_ddlStatement1414);
                    createIndexStatement38=createIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createIndexStatement38.getTree());

                    }
                    break;
                case 16 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:627:7: dropIndexStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropIndexStatement_in_ddlStatement1422);
                    dropIndexStatement39=dropIndexStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropIndexStatement39.getTree());

                    }
                    break;
                case 17 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:628:7: dropFunctionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropFunctionStatement_in_ddlStatement1430);
                    dropFunctionStatement40=dropFunctionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropFunctionStatement40.getTree());

                    }
                    break;
                case 18 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:629:7: dropMacroStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropMacroStatement_in_ddlStatement1438);
                    dropMacroStatement41=dropMacroStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropMacroStatement41.getTree());

                    }
                    break;
                case 19 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:630:7: analyzeStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_analyzeStatement_in_ddlStatement1446);
                    analyzeStatement42=analyzeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, analyzeStatement42.getTree());

                    }
                    break;
                case 20 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:631:7: lockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lockStatement_in_ddlStatement1454);
                    lockStatement43=lockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, lockStatement43.getTree());

                    }
                    break;
                case 21 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:632:7: unlockStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_unlockStatement_in_ddlStatement1462);
                    unlockStatement44=unlockStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, unlockStatement44.getTree());

                    }
                    break;
                case 22 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:633:7: createRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_createRoleStatement_in_ddlStatement1470);
                    createRoleStatement45=createRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createRoleStatement45.getTree());

                    }
                    break;
                case 23 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:634:7: dropRoleStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_dropRoleStatement_in_ddlStatement1478);
                    dropRoleStatement46=dropRoleStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, dropRoleStatement46.getTree());

                    }
                    break;
                case 24 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:635:7: grantPrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantPrivileges_in_ddlStatement1486);
                    grantPrivileges47=grantPrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, grantPrivileges47.getTree());

                    }
                    break;
                case 25 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:636:7: revokePrivileges
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokePrivileges_in_ddlStatement1494);
                    revokePrivileges48=revokePrivileges();

                    state._fsp--;

                    adaptor.addChild(root_0, revokePrivileges48.getTree());

                    }
                    break;
                case 26 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:637:7: showGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showGrants_in_ddlStatement1502);
                    showGrants49=showGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showGrants49.getTree());

                    }
                    break;
                case 27 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:638:7: showRoleGrants
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoleGrants_in_ddlStatement1510);
                    showRoleGrants50=showRoleGrants();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoleGrants50.getTree());

                    }
                    break;
                case 28 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:639:7: showRoles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showRoles_in_ddlStatement1518);
                    showRoles51=showRoles();

                    state._fsp--;

                    adaptor.addChild(root_0, showRoles51.getTree());

                    }
                    break;
                case 29 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:640:7: grantRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_grantRole_in_ddlStatement1526);
                    grantRole52=grantRole();

                    state._fsp--;

                    adaptor.addChild(root_0, grantRole52.getTree());

                    }
                    break;
                case 30 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:641:7: revokeRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_revokeRole_in_ddlStatement1534);
                    revokeRole53=revokeRole();

                    state._fsp--;

                    adaptor.addChild(root_0, revokeRole53.getTree());

                    }
                    break;
                case 31 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:642:7: setRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_setRole_in_ddlStatement1542);
                    setRole54=setRole();

                    state._fsp--;

                    adaptor.addChild(root_0, setRole54.getTree());

                    }
                    break;
                case 32 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:643:7: showCurrentRole
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_showCurrentRole_in_ddlStatement1550);
                    showCurrentRole55=showCurrentRole();

                    state._fsp--;

                    adaptor.addChild(root_0, showCurrentRole55.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ddlStatement"


    public static class ifExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:646:1: ifExists : KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) ;
    public final HiveParser.ifExists_return ifExists() throws RecognitionException {
        HiveParser.ifExists_return retval = new HiveParser.ifExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF56=null;
        Token KW_EXISTS57=null;

        CommonTree KW_IF56_tree=null;
        CommonTree KW_EXISTS57_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         msgs.push("if exists clause"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:649:5: ( KW_IF KW_EXISTS -> ^( TOK_IFEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:649:7: KW_IF KW_EXISTS
            {
            KW_IF56=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifExists1577);  
            stream_KW_IF.add(KW_IF56);


            KW_EXISTS57=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifExists1579);  
            stream_KW_EXISTS.add(KW_EXISTS57);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 650:5: -> ^( TOK_IFEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:650:8: ^( TOK_IFEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFEXISTS, "TOK_IFEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifExists"


    public static class restrictOrCascade_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "restrictOrCascade"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:653:1: restrictOrCascade : ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) );
    public final HiveParser.restrictOrCascade_return restrictOrCascade() throws RecognitionException {
        HiveParser.restrictOrCascade_return retval = new HiveParser.restrictOrCascade_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RESTRICT58=null;
        Token KW_CASCADE59=null;

        CommonTree KW_RESTRICT58_tree=null;
        CommonTree KW_CASCADE59_tree=null;
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_RESTRICT=new RewriteRuleTokenStream(adaptor,"token KW_RESTRICT");

         msgs.push("restrict or cascade clause"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:656:5: ( KW_RESTRICT -> ^( TOK_RESTRICT ) | KW_CASCADE -> ^( TOK_CASCADE ) )
            int alt10=2;
            switch ( input.LA(1) ) {
            case KW_RESTRICT:
                {
                alt10=1;
                }
                break;
            case KW_CASCADE:
                {
                alt10=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }

            switch (alt10) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:656:7: KW_RESTRICT
                    {
                    KW_RESTRICT58=(Token)match(input,KW_RESTRICT,FOLLOW_KW_RESTRICT_in_restrictOrCascade1616);  
                    stream_KW_RESTRICT.add(KW_RESTRICT58);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 657:5: -> ^( TOK_RESTRICT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:657:8: ^( TOK_RESTRICT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_RESTRICT, "TOK_RESTRICT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:658:7: KW_CASCADE
                    {
                    KW_CASCADE59=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_restrictOrCascade1634);  
                    stream_KW_CASCADE.add(KW_CASCADE59);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 659:5: -> ^( TOK_CASCADE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:659:8: ^( TOK_CASCADE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_CASCADE, "TOK_CASCADE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "restrictOrCascade"


    public static class ifNotExists_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ifNotExists"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:662:1: ifNotExists : KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) ;
    public final HiveParser.ifNotExists_return ifNotExists() throws RecognitionException {
        HiveParser.ifNotExists_return retval = new HiveParser.ifNotExists_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IF60=null;
        Token KW_NOT61=null;
        Token KW_EXISTS62=null;

        CommonTree KW_IF60_tree=null;
        CommonTree KW_NOT61_tree=null;
        CommonTree KW_EXISTS62_tree=null;
        RewriteRuleTokenStream stream_KW_IF=new RewriteRuleTokenStream(adaptor,"token KW_IF");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_EXISTS=new RewriteRuleTokenStream(adaptor,"token KW_EXISTS");

         msgs.push("if not exists clause"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:5: ( KW_IF KW_NOT KW_EXISTS -> ^( TOK_IFNOTEXISTS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:665:7: KW_IF KW_NOT KW_EXISTS
            {
            KW_IF60=(Token)match(input,KW_IF,FOLLOW_KW_IF_in_ifNotExists1671);  
            stream_KW_IF.add(KW_IF60);


            KW_NOT61=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_ifNotExists1673);  
            stream_KW_NOT.add(KW_NOT61);


            KW_EXISTS62=(Token)match(input,KW_EXISTS,FOLLOW_KW_EXISTS_in_ifNotExists1675);  
            stream_KW_EXISTS.add(KW_EXISTS62);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 666:5: -> ^( TOK_IFNOTEXISTS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:666:8: ^( TOK_IFNOTEXISTS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IFNOTEXISTS, "TOK_IFNOTEXISTS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ifNotExists"


    public static class storedAsDirs_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "storedAsDirs"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:669:1: storedAsDirs : KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) ;
    public final HiveParser.storedAsDirs_return storedAsDirs() throws RecognitionException {
        HiveParser.storedAsDirs_return retval = new HiveParser.storedAsDirs_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_STORED63=null;
        Token KW_AS64=null;
        Token KW_DIRECTORIES65=null;

        CommonTree KW_STORED63_tree=null;
        CommonTree KW_AS64_tree=null;
        CommonTree KW_DIRECTORIES65_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_STORED=new RewriteRuleTokenStream(adaptor,"token KW_STORED");
        RewriteRuleTokenStream stream_KW_DIRECTORIES=new RewriteRuleTokenStream(adaptor,"token KW_DIRECTORIES");

         msgs.push("stored as directories"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:672:5: ( KW_STORED KW_AS KW_DIRECTORIES -> ^( TOK_STOREDASDIRS ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:672:7: KW_STORED KW_AS KW_DIRECTORIES
            {
            KW_STORED63=(Token)match(input,KW_STORED,FOLLOW_KW_STORED_in_storedAsDirs1712);  
            stream_KW_STORED.add(KW_STORED63);


            KW_AS64=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_storedAsDirs1714);  
            stream_KW_AS.add(KW_AS64);


            KW_DIRECTORIES65=(Token)match(input,KW_DIRECTORIES,FOLLOW_KW_DIRECTORIES_in_storedAsDirs1716);  
            stream_KW_DIRECTORIES.add(KW_DIRECTORIES65);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 673:5: -> ^( TOK_STOREDASDIRS )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:673:8: ^( TOK_STOREDASDIRS )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_STOREDASDIRS, "TOK_STOREDASDIRS")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "storedAsDirs"


    public static class orReplace_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orReplace"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:676:1: orReplace : KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) ;
    public final HiveParser.orReplace_return orReplace() throws RecognitionException {
        HiveParser.orReplace_return retval = new HiveParser.orReplace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OR66=null;
        Token KW_REPLACE67=null;

        CommonTree KW_OR66_tree=null;
        CommonTree KW_REPLACE67_tree=null;
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_OR=new RewriteRuleTokenStream(adaptor,"token KW_OR");

         msgs.push("or replace clause"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:5: ( KW_OR KW_REPLACE -> ^( TOK_ORREPLACE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:679:7: KW_OR KW_REPLACE
            {
            KW_OR66=(Token)match(input,KW_OR,FOLLOW_KW_OR_in_orReplace1753);  
            stream_KW_OR.add(KW_OR66);


            KW_REPLACE67=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_orReplace1755);  
            stream_KW_REPLACE.add(KW_REPLACE67);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 680:5: -> ^( TOK_ORREPLACE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:680:8: ^( TOK_ORREPLACE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ORREPLACE, "TOK_ORREPLACE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orReplace"


    public static class ignoreProtection_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ignoreProtection"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:683:1: ignoreProtection : KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) ;
    public final HiveParser.ignoreProtection_return ignoreProtection() throws RecognitionException {
        HiveParser.ignoreProtection_return retval = new HiveParser.ignoreProtection_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IGNORE68=null;
        Token KW_PROTECTION69=null;

        CommonTree KW_IGNORE68_tree=null;
        CommonTree KW_PROTECTION69_tree=null;
        RewriteRuleTokenStream stream_KW_PROTECTION=new RewriteRuleTokenStream(adaptor,"token KW_PROTECTION");
        RewriteRuleTokenStream stream_KW_IGNORE=new RewriteRuleTokenStream(adaptor,"token KW_IGNORE");

         msgs.push("ignore protection clause"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:686:9: ( KW_IGNORE KW_PROTECTION -> ^( TOK_IGNOREPROTECTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:686:11: KW_IGNORE KW_PROTECTION
            {
            KW_IGNORE68=(Token)match(input,KW_IGNORE,FOLLOW_KW_IGNORE_in_ignoreProtection1796);  
            stream_KW_IGNORE.add(KW_IGNORE68);


            KW_PROTECTION69=(Token)match(input,KW_PROTECTION,FOLLOW_KW_PROTECTION_in_ignoreProtection1798);  
            stream_KW_PROTECTION.add(KW_PROTECTION69);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 687:9: -> ^( TOK_IGNOREPROTECTION )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:687:12: ^( TOK_IGNOREPROTECTION )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_IGNOREPROTECTION, "TOK_IGNOREPROTECTION")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ignoreProtection"


    public static class createDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:690:1: createDatabaseStatement : KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) ;
    public final HiveParser.createDatabaseStatement_return createDatabaseStatement() throws RecognitionException {
        HiveParser.createDatabaseStatement_return retval = new HiveParser.createDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE70=null;
        Token KW_DATABASE71=null;
        Token KW_SCHEMA72=null;
        Token KW_WITH76=null;
        Token KW_DBPROPERTIES77=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbprops =null;

        HiveParser.ifNotExists_return ifNotExists73 =null;

        HiveParser.databaseComment_return databaseComment74 =null;

        HiveParser.dbLocation_return dbLocation75 =null;


        CommonTree KW_CREATE70_tree=null;
        CommonTree KW_DATABASE71_tree=null;
        CommonTree KW_SCHEMA72_tree=null;
        CommonTree KW_WITH76_tree=null;
        CommonTree KW_DBPROPERTIES77_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_dbLocation=new RewriteRuleSubtreeStream(adaptor,"rule dbLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_databaseComment=new RewriteRuleSubtreeStream(adaptor,"rule databaseComment");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("create database statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:5: ( KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )? -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:7: KW_CREATE ( KW_DATABASE | KW_SCHEMA ) ( ifNotExists )? name= identifier ( databaseComment )? ( dbLocation )? ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            {
            KW_CREATE70=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createDatabaseStatement1843);  
            stream_KW_CREATE.add(KW_CREATE70);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:17: ( KW_DATABASE | KW_SCHEMA )
            int alt11=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt11=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt11=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:18: KW_DATABASE
                    {
                    KW_DATABASE71=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_createDatabaseStatement1846);  
                    stream_KW_DATABASE.add(KW_DATABASE71);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:693:30: KW_SCHEMA
                    {
                    KW_SCHEMA72=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_createDatabaseStatement1848);  
                    stream_KW_SCHEMA.add(KW_SCHEMA72);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:694:9: ( ifNotExists )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:694:9: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createDatabaseStatement1859);
                    ifNotExists73=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists73.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_createDatabaseStatement1872);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:696:9: ( databaseComment )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:696:9: databaseComment
                    {
                    pushFollow(FOLLOW_databaseComment_in_createDatabaseStatement1882);
                    databaseComment74=databaseComment();

                    state._fsp--;

                    stream_databaseComment.add(databaseComment74.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:9: ( dbLocation )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:697:9: dbLocation
                    {
                    pushFollow(FOLLOW_dbLocation_in_createDatabaseStatement1893);
                    dbLocation75=dbLocation();

                    state._fsp--;

                    stream_dbLocation.add(dbLocation75.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:698:9: ( KW_WITH KW_DBPROPERTIES dbprops= dbProperties )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:698:10: KW_WITH KW_DBPROPERTIES dbprops= dbProperties
                    {
                    KW_WITH76=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_createDatabaseStatement1905);  
                    stream_KW_WITH.add(KW_WITH76);


                    KW_DBPROPERTIES77=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_createDatabaseStatement1907);  
                    stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES77);


                    pushFollow(FOLLOW_dbProperties_in_createDatabaseStatement1911);
                    dbprops=dbProperties();

                    state._fsp--;

                    stream_dbProperties.add(dbprops.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ifNotExists, dbLocation, databaseComment, dbprops, name
            // token labels: 
            // rule labels: retval, name, dbprops
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);
            RewriteRuleSubtreeStream stream_dbprops=new RewriteRuleSubtreeStream(adaptor,"rule dbprops",dbprops!=null?dbprops.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 699:5: -> ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:8: ^( TOK_CREATEDATABASE $name ( ifNotExists )? ( dbLocation )? ( databaseComment )? ( $dbprops)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEDATABASE, "TOK_CREATEDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:35: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:48: ( dbLocation )?
                if ( stream_dbLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbLocation.nextTree());

                }
                stream_dbLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:60: ( databaseComment )?
                if ( stream_databaseComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_databaseComment.nextTree());

                }
                stream_databaseComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:699:78: ( $dbprops)?
                if ( stream_dbprops.hasNext() ) {
                    adaptor.addChild(root_1, stream_dbprops.nextTree());

                }
                stream_dbprops.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createDatabaseStatement"


    public static class dbLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:702:1: dbLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) ;
    public final HiveParser.dbLocation_return dbLocation() throws RecognitionException {
        HiveParser.dbLocation_return retval = new HiveParser.dbLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION78=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION78_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         msgs.push("database location specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:705:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_DATABASELOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:706:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION78=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_dbLocation1972);  
            stream_KW_LOCATION.add(KW_LOCATION78);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_dbLocation1976);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 706:38: -> ^( TOK_DATABASELOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:706:41: ^( TOK_DATABASELOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASELOCATION, "TOK_DATABASELOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbLocation"


    public static class dbProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:709:1: dbProperties : LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) ;
    public final HiveParser.dbProperties_return dbProperties() throws RecognitionException {
        HiveParser.dbProperties_return retval = new HiveParser.dbProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN79=null;
        Token RPAREN81=null;
        HiveParser.dbPropertiesList_return dbPropertiesList80 =null;


        CommonTree LPAREN79_tree=null;
        CommonTree RPAREN81_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_dbPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule dbPropertiesList");
         msgs.push("dbproperties"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:712:5: ( LPAREN dbPropertiesList RPAREN -> ^( TOK_DATABASEPROPERTIES dbPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:713:7: LPAREN dbPropertiesList RPAREN
            {
            LPAREN79=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_dbProperties2018);  
            stream_LPAREN.add(LPAREN79);


            pushFollow(FOLLOW_dbPropertiesList_in_dbProperties2020);
            dbPropertiesList80=dbPropertiesList();

            state._fsp--;

            stream_dbPropertiesList.add(dbPropertiesList80.getTree());

            RPAREN81=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_dbProperties2022);  
            stream_RPAREN.add(RPAREN81);


            // AST REWRITE
            // elements: dbPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 713:38: -> ^( TOK_DATABASEPROPERTIES dbPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:713:41: ^( TOK_DATABASEPROPERTIES dbPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASEPROPERTIES, "TOK_DATABASEPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_dbPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbProperties"


    public static class dbPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dbPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:716:1: dbPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.dbPropertiesList_return dbPropertiesList() throws RecognitionException {
        HiveParser.dbPropertiesList_return retval = new HiveParser.dbPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA83=null;
        HiveParser.keyValueProperty_return keyValueProperty82 =null;

        HiveParser.keyValueProperty_return keyValueProperty84 =null;


        CommonTree COMMA83_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         msgs.push("database properties list"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:719:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_DBPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2063);
            keyValueProperty82=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty82.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:24: ( COMMA keyValueProperty )*
            loop16:
            do {
                int alt16=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt16=1;
                    }
                    break;

                }

                switch (alt16) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:25: COMMA keyValueProperty
            	    {
            	    COMMA83=(Token)match(input,COMMA,FOLLOW_COMMA_in_dbPropertiesList2066);  
            	    stream_COMMA.add(COMMA83);


            	    pushFollow(FOLLOW_keyValueProperty_in_dbPropertiesList2068);
            	    keyValueProperty84=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty84.getTree());

            	    }
            	    break;

            	default :
            	    break loop16;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 720:50: -> ^( TOK_DBPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:720:53: ^( TOK_DBPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DBPROPLIST, "TOK_DBPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dbPropertiesList"


    public static class switchDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "switchDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:724:1: switchDatabaseStatement : KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) ;
    public final HiveParser.switchDatabaseStatement_return switchDatabaseStatement() throws RecognitionException {
        HiveParser.switchDatabaseStatement_return retval = new HiveParser.switchDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USE85=null;
        HiveParser_IdentifiersParser.identifier_return identifier86 =null;


        CommonTree KW_USE85_tree=null;
        RewriteRuleTokenStream stream_KW_USE=new RewriteRuleTokenStream(adaptor,"token KW_USE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("switch database statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:5: ( KW_USE identifier -> ^( TOK_SWITCHDATABASE identifier ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:727:7: KW_USE identifier
            {
            KW_USE85=(Token)match(input,KW_USE,FOLLOW_KW_USE_in_switchDatabaseStatement2107);  
            stream_KW_USE.add(KW_USE85);


            pushFollow(FOLLOW_identifier_in_switchDatabaseStatement2109);
            identifier86=identifier();

            state._fsp--;

            stream_identifier.add(identifier86.getTree());

            // AST REWRITE
            // elements: identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 728:5: -> ^( TOK_SWITCHDATABASE identifier )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:728:8: ^( TOK_SWITCHDATABASE identifier )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SWITCHDATABASE, "TOK_SWITCHDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "switchDatabaseStatement"


    public static class dropDatabaseStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropDatabaseStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:731:1: dropDatabaseStatement : KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) ;
    public final HiveParser.dropDatabaseStatement_return dropDatabaseStatement() throws RecognitionException {
        HiveParser.dropDatabaseStatement_return retval = new HiveParser.dropDatabaseStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP87=null;
        Token KW_DATABASE88=null;
        Token KW_SCHEMA89=null;
        HiveParser.ifExists_return ifExists90 =null;

        HiveParser_IdentifiersParser.identifier_return identifier91 =null;

        HiveParser.restrictOrCascade_return restrictOrCascade92 =null;


        CommonTree KW_DROP87_tree=null;
        CommonTree KW_DATABASE88_tree=null;
        CommonTree KW_SCHEMA89_tree=null;
        RewriteRuleTokenStream stream_KW_SCHEMA=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMA");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleSubtreeStream stream_restrictOrCascade=new RewriteRuleSubtreeStream(adaptor,"rule restrictOrCascade");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("drop database statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:5: ( KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )? -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:7: KW_DROP ( KW_DATABASE | KW_SCHEMA ) ( ifExists )? identifier ( restrictOrCascade )?
            {
            KW_DROP87=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropDatabaseStatement2148);  
            stream_KW_DROP.add(KW_DROP87);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:15: ( KW_DATABASE | KW_SCHEMA )
            int alt17=2;
            switch ( input.LA(1) ) {
            case KW_DATABASE:
                {
                alt17=1;
                }
                break;
            case KW_SCHEMA:
                {
                alt17=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }

            switch (alt17) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:16: KW_DATABASE
                    {
                    KW_DATABASE88=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_dropDatabaseStatement2151);  
                    stream_KW_DATABASE.add(KW_DATABASE88);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:28: KW_SCHEMA
                    {
                    KW_SCHEMA89=(Token)match(input,KW_SCHEMA,FOLLOW_KW_SCHEMA_in_dropDatabaseStatement2153);  
                    stream_KW_SCHEMA.add(KW_SCHEMA89);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:39: ( ifExists )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:39: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropDatabaseStatement2156);
                    ifExists90=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists90.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropDatabaseStatement2159);
            identifier91=identifier();

            state._fsp--;

            stream_identifier.add(identifier91.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:60: ( restrictOrCascade )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case KW_CASCADE:
                case KW_RESTRICT:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:734:60: restrictOrCascade
                    {
                    pushFollow(FOLLOW_restrictOrCascade_in_dropDatabaseStatement2161);
                    restrictOrCascade92=restrictOrCascade();

                    state._fsp--;

                    stream_restrictOrCascade.add(restrictOrCascade92.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: restrictOrCascade, ifExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 735:5: -> ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:735:8: ^( TOK_DROPDATABASE identifier ( ifExists )? ( restrictOrCascade )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPDATABASE, "TOK_DROPDATABASE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:735:38: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:735:48: ( restrictOrCascade )?
                if ( stream_restrictOrCascade.hasNext() ) {
                    adaptor.addChild(root_1, stream_restrictOrCascade.nextTree());

                }
                stream_restrictOrCascade.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropDatabaseStatement"


    public static class databaseComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "databaseComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:738:1: databaseComment : KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) ;
    public final HiveParser.databaseComment_return databaseComment() throws RecognitionException {
        HiveParser.databaseComment_return retval = new HiveParser.databaseComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT93=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT93_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         msgs.push("database's comment"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:5: ( KW_COMMENT comment= StringLiteral -> ^( TOK_DATABASECOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:741:7: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT93=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_databaseComment2207);  
            stream_KW_COMMENT.add(KW_COMMENT93);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_databaseComment2211);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 742:5: -> ^( TOK_DATABASECOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:742:8: ^( TOK_DATABASECOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DATABASECOMMENT, "TOK_DATABASECOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "databaseComment"


    public static class createTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:745:1: createTableStatement : KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatement )? ) -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatement )? ) ;
    public final HiveParser.createTableStatement_return createTableStatement() throws RecognitionException {
        HiveParser.createTableStatement_return retval = new HiveParser.createTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token ext=null;
        Token like=null;
        Token KW_CREATE94=null;
        Token KW_TABLE95=null;
        Token LPAREN99=null;
        Token RPAREN101=null;
        Token KW_AS110=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return likeName =null;

        HiveParser.ifNotExists_return ifNotExists96 =null;

        HiveParser.tableLocation_return tableLocation97 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed98 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList100 =null;

        HiveParser.tableComment_return tableComment102 =null;

        HiveParser.tablePartition_return tablePartition103 =null;

        HiveParser.tableBuckets_return tableBuckets104 =null;

        HiveParser.tableSkewed_return tableSkewed105 =null;

        HiveParser.tableRowFormat_return tableRowFormat106 =null;

        HiveParser.tableFileFormat_return tableFileFormat107 =null;

        HiveParser.tableLocation_return tableLocation108 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed109 =null;

        HiveParser.selectStatement_return selectStatement111 =null;


        CommonTree ext_tree=null;
        CommonTree like_tree=null;
        CommonTree KW_CREATE94_tree=null;
        CommonTree KW_TABLE95_tree=null;
        CommonTree LPAREN99_tree=null;
        CommonTree RPAREN101_tree=null;
        CommonTree KW_AS110_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_EXTERNAL=new RewriteRuleTokenStream(adaptor,"token KW_EXTERNAL");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_selectStatement=new RewriteRuleSubtreeStream(adaptor,"rule selectStatement");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_tablePartition=new RewriteRuleSubtreeStream(adaptor,"rule tablePartition");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableComment=new RewriteRuleSubtreeStream(adaptor,"rule tableComment");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
         msgs.push("create table statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:5: ( KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatement )? ) -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatement )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:7: KW_CREATE (ext= KW_EXTERNAL )? KW_TABLE ( ifNotExists )? name= tableName (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatement )? )
            {
            KW_CREATE94=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createTableStatement2251);  
            stream_KW_CREATE.add(KW_CREATE94);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:17: (ext= KW_EXTERNAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case KW_EXTERNAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:18: ext= KW_EXTERNAL
                    {
                    ext=(Token)match(input,KW_EXTERNAL,FOLLOW_KW_EXTERNAL_in_createTableStatement2256);  
                    stream_KW_EXTERNAL.add(ext);


                    }
                    break;

            }


            KW_TABLE95=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createTableStatement2260);  
            stream_KW_TABLE.add(KW_TABLE95);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:45: ( ifNotExists )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:748:45: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createTableStatement2262);
                    ifNotExists96=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists96.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_createTableStatement2267);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:749:7: (like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )? | ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatement )? )
            int alt34=2;
            switch ( input.LA(1) ) {
            case KW_LIKE:
                {
                alt34=1;
                }
                break;
            case EOF:
            case KW_AS:
            case KW_CLUSTERED:
            case KW_COMMENT:
            case KW_LOCATION:
            case KW_PARTITIONED:
            case KW_ROW:
            case KW_SKEWED:
            case KW_STORED:
            case KW_TBLPROPERTIES:
            case LPAREN:
                {
                alt34=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }

            switch (alt34) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:749:10: like= KW_LIKE likeName= tableName ( tableLocation )? ( tablePropertiesPrefixed )?
                    {
                    like=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_createTableStatement2280);  
                    stream_KW_LIKE.add(like);


                    pushFollow(FOLLOW_tableName_in_createTableStatement2284);
                    likeName=tableName();

                    state._fsp--;

                    stream_tableName.add(likeName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:750:10: ( tableLocation )?
                    int alt22=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt22=1;
                            }
                            break;
                    }

                    switch (alt22) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:750:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2295);
                            tableLocation97=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation97.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:751:10: ( tablePropertiesPrefixed )?
                    int alt23=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt23=1;
                            }
                            break;
                    }

                    switch (alt23) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:751:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2307);
                            tablePropertiesPrefixed98=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed98.getTree());

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:752:10: ( LPAREN columnNameTypeList RPAREN )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( KW_AS selectStatement )?
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:752:10: ( LPAREN columnNameTypeList RPAREN )?
                    int alt24=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt24=1;
                            }
                            break;
                    }

                    switch (alt24) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:752:11: LPAREN columnNameTypeList RPAREN
                            {
                            LPAREN99=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createTableStatement2320);  
                            stream_LPAREN.add(LPAREN99);


                            pushFollow(FOLLOW_columnNameTypeList_in_createTableStatement2322);
                            columnNameTypeList100=columnNameTypeList();

                            state._fsp--;

                            stream_columnNameTypeList.add(columnNameTypeList100.getTree());

                            RPAREN101=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createTableStatement2324);  
                            stream_RPAREN.add(RPAREN101);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:753:10: ( tableComment )?
                    int alt25=2;
                    switch ( input.LA(1) ) {
                        case KW_COMMENT:
                            {
                            alt25=1;
                            }
                            break;
                    }

                    switch (alt25) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:753:10: tableComment
                            {
                            pushFollow(FOLLOW_tableComment_in_createTableStatement2337);
                            tableComment102=tableComment();

                            state._fsp--;

                            stream_tableComment.add(tableComment102.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:754:10: ( tablePartition )?
                    int alt26=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITIONED:
                            {
                            alt26=1;
                            }
                            break;
                    }

                    switch (alt26) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:754:10: tablePartition
                            {
                            pushFollow(FOLLOW_tablePartition_in_createTableStatement2349);
                            tablePartition103=tablePartition();

                            state._fsp--;

                            stream_tablePartition.add(tablePartition103.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:755:10: ( tableBuckets )?
                    int alt27=2;
                    switch ( input.LA(1) ) {
                        case KW_CLUSTERED:
                            {
                            alt27=1;
                            }
                            break;
                    }

                    switch (alt27) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:755:10: tableBuckets
                            {
                            pushFollow(FOLLOW_tableBuckets_in_createTableStatement2361);
                            tableBuckets104=tableBuckets();

                            state._fsp--;

                            stream_tableBuckets.add(tableBuckets104.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:756:10: ( tableSkewed )?
                    int alt28=2;
                    switch ( input.LA(1) ) {
                        case KW_SKEWED:
                            {
                            alt28=1;
                            }
                            break;
                    }

                    switch (alt28) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:756:10: tableSkewed
                            {
                            pushFollow(FOLLOW_tableSkewed_in_createTableStatement2373);
                            tableSkewed105=tableSkewed();

                            state._fsp--;

                            stream_tableSkewed.add(tableSkewed105.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:757:10: ( tableRowFormat )?
                    int alt29=2;
                    switch ( input.LA(1) ) {
                        case KW_ROW:
                            {
                            alt29=1;
                            }
                            break;
                    }

                    switch (alt29) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:757:10: tableRowFormat
                            {
                            pushFollow(FOLLOW_tableRowFormat_in_createTableStatement2385);
                            tableRowFormat106=tableRowFormat();

                            state._fsp--;

                            stream_tableRowFormat.add(tableRowFormat106.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:758:10: ( tableFileFormat )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case KW_STORED:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:758:10: tableFileFormat
                            {
                            pushFollow(FOLLOW_tableFileFormat_in_createTableStatement2397);
                            tableFileFormat107=tableFileFormat();

                            state._fsp--;

                            stream_tableFileFormat.add(tableFileFormat107.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:759:10: ( tableLocation )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case KW_LOCATION:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:759:10: tableLocation
                            {
                            pushFollow(FOLLOW_tableLocation_in_createTableStatement2409);
                            tableLocation108=tableLocation();

                            state._fsp--;

                            stream_tableLocation.add(tableLocation108.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:760:10: ( tablePropertiesPrefixed )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case KW_TBLPROPERTIES:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:760:10: tablePropertiesPrefixed
                            {
                            pushFollow(FOLLOW_tablePropertiesPrefixed_in_createTableStatement2421);
                            tablePropertiesPrefixed109=tablePropertiesPrefixed();

                            state._fsp--;

                            stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed109.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:761:10: ( KW_AS selectStatement )?
                    int alt33=2;
                    switch ( input.LA(1) ) {
                        case KW_AS:
                            {
                            alt33=1;
                            }
                            break;
                    }

                    switch (alt33) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:761:11: KW_AS selectStatement
                            {
                            KW_AS110=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createTableStatement2434);  
                            stream_KW_AS.add(KW_AS110);


                            pushFollow(FOLLOW_selectStatement_in_createTableStatement2436);
                            selectStatement111=selectStatement();

                            state._fsp--;

                            stream_selectStatement.add(selectStatement111.getTree());

                            }
                            break;

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: tableBuckets, tablePropertiesPrefixed, name, tablePartition, likeName, selectStatement, ifNotExists, tableComment, tableRowFormat, tableSkewed, columnNameTypeList, ext, tableFileFormat, tableLocation
            // token labels: ext
            // rule labels: retval, likeName, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_ext=new RewriteRuleTokenStream(adaptor,"token ext",ext);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_likeName=new RewriteRuleSubtreeStream(adaptor,"rule likeName",likeName!=null?likeName.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 763:5: -> ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatement )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:763:8: ^( TOK_CREATETABLE $name ( $ext)? ( ifNotExists )? ^( TOK_LIKETABLE ( $likeName)? ) ( columnNameTypeList )? ( tableComment )? ( tablePartition )? ( tableBuckets )? ( tableSkewed )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( selectStatement )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATETABLE, "TOK_CREATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:763:33: ( $ext)?
                if ( stream_ext.hasNext() ) {
                    adaptor.addChild(root_1, stream_ext.nextNode());

                }
                stream_ext.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:763:38: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:764:10: ^( TOK_LIKETABLE ( $likeName)? )
                {
                CommonTree root_2 = (CommonTree)adaptor.nil();
                root_2 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LIKETABLE, "TOK_LIKETABLE")
                , root_2);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:764:27: ( $likeName)?
                if ( stream_likeName.hasNext() ) {
                    adaptor.addChild(root_2, stream_likeName.nextTree());

                }
                stream_likeName.reset();

                adaptor.addChild(root_1, root_2);
                }

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:765:10: ( columnNameTypeList )?
                if ( stream_columnNameTypeList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                }
                stream_columnNameTypeList.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:766:10: ( tableComment )?
                if ( stream_tableComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableComment.nextTree());

                }
                stream_tableComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:767:10: ( tablePartition )?
                if ( stream_tablePartition.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePartition.nextTree());

                }
                stream_tablePartition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:768:10: ( tableBuckets )?
                if ( stream_tableBuckets.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                }
                stream_tableBuckets.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:769:10: ( tableSkewed )?
                if ( stream_tableSkewed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                }
                stream_tableSkewed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:770:10: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:771:10: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:772:10: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:773:10: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:774:10: ( selectStatement )?
                if ( stream_selectStatement.hasNext() ) {
                    adaptor.addChild(root_1, stream_selectStatement.nextTree());

                }
                stream_selectStatement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createTableStatement"


    public static class truncateTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "truncateTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:778:1: truncateTableStatement : KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) ;
    public final HiveParser.truncateTableStatement_return truncateTableStatement() throws RecognitionException {
        HiveParser.truncateTableStatement_return retval = new HiveParser.truncateTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TRUNCATE112=null;
        Token KW_TABLE113=null;
        Token KW_COLUMNS115=null;
        Token LPAREN116=null;
        Token RPAREN118=null;
        HiveParser.tablePartitionPrefix_return tablePartitionPrefix114 =null;

        HiveParser.columnNameList_return columnNameList117 =null;


        CommonTree KW_TRUNCATE112_tree=null;
        CommonTree KW_TABLE113_tree=null;
        CommonTree KW_COLUMNS115_tree=null;
        CommonTree LPAREN116_tree=null;
        CommonTree RPAREN118_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TRUNCATE=new RewriteRuleTokenStream(adaptor,"token KW_TRUNCATE");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
         msgs.push("truncate table statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:5: ( KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )? -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:7: KW_TRUNCATE KW_TABLE tablePartitionPrefix ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            {
            KW_TRUNCATE112=(Token)match(input,KW_TRUNCATE,FOLLOW_KW_TRUNCATE_in_truncateTableStatement2639);  
            stream_KW_TRUNCATE.add(KW_TRUNCATE112);


            KW_TABLE113=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_truncateTableStatement2641);  
            stream_KW_TABLE.add(KW_TABLE113);


            pushFollow(FOLLOW_tablePartitionPrefix_in_truncateTableStatement2643);
            tablePartitionPrefix114=tablePartitionPrefix();

            state._fsp--;

            stream_tablePartitionPrefix.add(tablePartitionPrefix114.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:49: ( KW_COLUMNS LPAREN columnNameList RPAREN )?
            int alt35=2;
            switch ( input.LA(1) ) {
                case KW_COLUMNS:
                    {
                    alt35=1;
                    }
                    break;
            }

            switch (alt35) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:50: KW_COLUMNS LPAREN columnNameList RPAREN
                    {
                    KW_COLUMNS115=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_truncateTableStatement2646);  
                    stream_KW_COLUMNS.add(KW_COLUMNS115);


                    LPAREN116=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_truncateTableStatement2648);  
                    stream_LPAREN.add(LPAREN116);


                    pushFollow(FOLLOW_columnNameList_in_truncateTableStatement2650);
                    columnNameList117=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(columnNameList117.getTree());

                    RPAREN118=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_truncateTableStatement2652);  
                    stream_RPAREN.add(RPAREN118);


                    }
                    break;

            }


            // AST REWRITE
            // elements: tablePartitionPrefix, columnNameList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 781:92: -> ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:95: ^( TOK_TRUNCATETABLE tablePartitionPrefix ( columnNameList )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TRUNCATETABLE, "TOK_TRUNCATETABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:781:136: ( columnNameList )?
                if ( stream_columnNameList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameList.nextTree());

                }
                stream_columnNameList.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "truncateTableStatement"


    public static class createIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:783:1: createIndexStatement : KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) ;
    public final HiveParser.createIndexStatement_return createIndexStatement() throws RecognitionException {
        HiveParser.createIndexStatement_return retval = new HiveParser.createIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token typeName=null;
        Token KW_CREATE119=null;
        Token KW_INDEX120=null;
        Token KW_ON121=null;
        Token KW_TABLE122=null;
        Token LPAREN123=null;
        Token RPAREN124=null;
        Token KW_AS125=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.columnNameList_return indexedCols =null;

        HiveParser.autoRebuild_return autoRebuild126 =null;

        HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed127 =null;

        HiveParser.indexTblName_return indexTblName128 =null;

        HiveParser.tableRowFormat_return tableRowFormat129 =null;

        HiveParser.tableFileFormat_return tableFileFormat130 =null;

        HiveParser.tableLocation_return tableLocation131 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed132 =null;

        HiveParser.indexComment_return indexComment133 =null;


        CommonTree typeName_tree=null;
        CommonTree KW_CREATE119_tree=null;
        CommonTree KW_INDEX120_tree=null;
        CommonTree KW_ON121_tree=null;
        CommonTree KW_TABLE122_tree=null;
        CommonTree LPAREN123_tree=null;
        CommonTree RPAREN124_tree=null;
        CommonTree KW_AS125_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_indexPropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesPrefixed");
        RewriteRuleSubtreeStream stream_tableRowFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableRowFormat");
        RewriteRuleSubtreeStream stream_tableFileFormat=new RewriteRuleSubtreeStream(adaptor,"rule tableFileFormat");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_autoRebuild=new RewriteRuleSubtreeStream(adaptor,"rule autoRebuild");
        RewriteRuleSubtreeStream stream_tableLocation=new RewriteRuleSubtreeStream(adaptor,"rule tableLocation");
        RewriteRuleSubtreeStream stream_indexTblName=new RewriteRuleSubtreeStream(adaptor,"rule indexTblName");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_indexComment=new RewriteRuleSubtreeStream(adaptor,"rule indexComment");
         msgs.push("create index statement");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:786:5: ( KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:786:7: KW_CREATE KW_INDEX indexName= identifier KW_ON KW_TABLE tab= tableName LPAREN indexedCols= columnNameList RPAREN KW_AS typeName= StringLiteral ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )?
            {
            KW_CREATE119=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createIndexStatement2687);  
            stream_KW_CREATE.add(KW_CREATE119);


            KW_INDEX120=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_createIndexStatement2689);  
            stream_KW_INDEX.add(KW_INDEX120);


            pushFollow(FOLLOW_identifier_in_createIndexStatement2693);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON121=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_createIndexStatement2701);  
            stream_KW_ON.add(KW_ON121);


            KW_TABLE122=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_createIndexStatement2703);  
            stream_KW_TABLE.add(KW_TABLE122);


            pushFollow(FOLLOW_tableName_in_createIndexStatement2707);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            LPAREN123=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createIndexStatement2709);  
            stream_LPAREN.add(LPAREN123);


            pushFollow(FOLLOW_columnNameList_in_createIndexStatement2713);
            indexedCols=columnNameList();

            state._fsp--;

            stream_columnNameList.add(indexedCols.getTree());

            RPAREN124=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createIndexStatement2715);  
            stream_RPAREN.add(RPAREN124);


            KW_AS125=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createIndexStatement2723);  
            stream_KW_AS.add(KW_AS125);


            typeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_createIndexStatement2727);  
            stream_StringLiteral.add(typeName);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:7: ( autoRebuild )?
            int alt36=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt36=1;
                    }
                    break;
            }

            switch (alt36) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:789:7: autoRebuild
                    {
                    pushFollow(FOLLOW_autoRebuild_in_createIndexStatement2735);
                    autoRebuild126=autoRebuild();

                    state._fsp--;

                    stream_autoRebuild.add(autoRebuild126.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:790:7: ( indexPropertiesPrefixed )?
            int alt37=2;
            switch ( input.LA(1) ) {
                case KW_IDXPROPERTIES:
                    {
                    alt37=1;
                    }
                    break;
            }

            switch (alt37) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:790:7: indexPropertiesPrefixed
                    {
                    pushFollow(FOLLOW_indexPropertiesPrefixed_in_createIndexStatement2744);
                    indexPropertiesPrefixed127=indexPropertiesPrefixed();

                    state._fsp--;

                    stream_indexPropertiesPrefixed.add(indexPropertiesPrefixed127.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:791:7: ( indexTblName )?
            int alt38=2;
            switch ( input.LA(1) ) {
                case KW_IN:
                    {
                    alt38=1;
                    }
                    break;
            }

            switch (alt38) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:791:7: indexTblName
                    {
                    pushFollow(FOLLOW_indexTblName_in_createIndexStatement2753);
                    indexTblName128=indexTblName();

                    state._fsp--;

                    stream_indexTblName.add(indexTblName128.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:792:7: ( tableRowFormat )?
            int alt39=2;
            switch ( input.LA(1) ) {
                case KW_ROW:
                    {
                    alt39=1;
                    }
                    break;
            }

            switch (alt39) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:792:7: tableRowFormat
                    {
                    pushFollow(FOLLOW_tableRowFormat_in_createIndexStatement2762);
                    tableRowFormat129=tableRowFormat();

                    state._fsp--;

                    stream_tableRowFormat.add(tableRowFormat129.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:793:7: ( tableFileFormat )?
            int alt40=2;
            switch ( input.LA(1) ) {
                case KW_STORED:
                    {
                    alt40=1;
                    }
                    break;
            }

            switch (alt40) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:793:7: tableFileFormat
                    {
                    pushFollow(FOLLOW_tableFileFormat_in_createIndexStatement2771);
                    tableFileFormat130=tableFileFormat();

                    state._fsp--;

                    stream_tableFileFormat.add(tableFileFormat130.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:794:7: ( tableLocation )?
            int alt41=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt41=1;
                    }
                    break;
            }

            switch (alt41) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:794:7: tableLocation
                    {
                    pushFollow(FOLLOW_tableLocation_in_createIndexStatement2780);
                    tableLocation131=tableLocation();

                    state._fsp--;

                    stream_tableLocation.add(tableLocation131.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:795:7: ( tablePropertiesPrefixed )?
            int alt42=2;
            switch ( input.LA(1) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt42=1;
                    }
                    break;
            }

            switch (alt42) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:795:7: tablePropertiesPrefixed
                    {
                    pushFollow(FOLLOW_tablePropertiesPrefixed_in_createIndexStatement2789);
                    tablePropertiesPrefixed132=tablePropertiesPrefixed();

                    state._fsp--;

                    stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed132.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:7: ( indexComment )?
            int alt43=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt43=1;
                    }
                    break;
            }

            switch (alt43) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:796:7: indexComment
                    {
                    pushFollow(FOLLOW_indexComment_in_createIndexStatement2798);
                    indexComment133=indexComment();

                    state._fsp--;

                    stream_indexComment.add(indexComment133.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tab, indexComment, tablePropertiesPrefixed, tableRowFormat, indexPropertiesPrefixed, indexName, indexTblName, tableLocation, typeName, tableFileFormat, autoRebuild, indexedCols
            // token labels: typeName
            // rule labels: indexedCols, retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_typeName=new RewriteRuleTokenStream(adaptor,"token typeName",typeName);
            RewriteRuleSubtreeStream stream_indexedCols=new RewriteRuleSubtreeStream(adaptor,"rule indexedCols",indexedCols!=null?indexedCols.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 797:5: -> ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:797:7: ^( TOK_CREATEINDEX $indexName $typeName $tab $indexedCols ( autoRebuild )? ( indexPropertiesPrefixed )? ( indexTblName )? ( tableRowFormat )? ( tableFileFormat )? ( tableLocation )? ( tablePropertiesPrefixed )? ( indexComment )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX, "TOK_CREATEINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_typeName.nextNode());

                adaptor.addChild(root_1, stream_tab.nextTree());

                adaptor.addChild(root_1, stream_indexedCols.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:798:9: ( autoRebuild )?
                if ( stream_autoRebuild.hasNext() ) {
                    adaptor.addChild(root_1, stream_autoRebuild.nextTree());

                }
                stream_autoRebuild.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:799:9: ( indexPropertiesPrefixed )?
                if ( stream_indexPropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexPropertiesPrefixed.nextTree());

                }
                stream_indexPropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:800:9: ( indexTblName )?
                if ( stream_indexTblName.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexTblName.nextTree());

                }
                stream_indexTblName.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:801:9: ( tableRowFormat )?
                if ( stream_tableRowFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableRowFormat.nextTree());

                }
                stream_tableRowFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:802:9: ( tableFileFormat )?
                if ( stream_tableFileFormat.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableFileFormat.nextTree());

                }
                stream_tableFileFormat.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:803:9: ( tableLocation )?
                if ( stream_tableLocation.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableLocation.nextTree());

                }
                stream_tableLocation.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:804:9: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:805:9: ( indexComment )?
                if ( stream_indexComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_indexComment.nextTree());

                }
                stream_indexComment.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createIndexStatement"


    public static class indexComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:808:1: indexComment : KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) ;
    public final HiveParser.indexComment_return indexComment() throws RecognitionException {
        HiveParser.indexComment_return retval = new HiveParser.indexComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT134=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT134_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         msgs.push("comment on an index");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:811:9: ( KW_COMMENT comment= StringLiteral -> ^( TOK_INDEXCOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:812:17: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT134=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_indexComment2955);  
            stream_KW_COMMENT.add(KW_COMMENT134);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_indexComment2959);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 812:51: -> ^( TOK_INDEXCOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:812:54: ^( TOK_INDEXCOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXCOMMENT, "TOK_INDEXCOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexComment"


    public static class autoRebuild_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "autoRebuild"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:815:1: autoRebuild : KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) ;
    public final HiveParser.autoRebuild_return autoRebuild() throws RecognitionException {
        HiveParser.autoRebuild_return retval = new HiveParser.autoRebuild_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_WITH135=null;
        Token KW_DEFERRED136=null;
        Token KW_REBUILD137=null;

        CommonTree KW_WITH135_tree=null;
        CommonTree KW_DEFERRED136_tree=null;
        CommonTree KW_REBUILD137_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_DEFERRED=new RewriteRuleTokenStream(adaptor,"token KW_DEFERRED");

         msgs.push("auto rebuild index");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:818:5: ( KW_WITH KW_DEFERRED KW_REBUILD -> ^( TOK_DEFERRED_REBUILDINDEX ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:818:7: KW_WITH KW_DEFERRED KW_REBUILD
            {
            KW_WITH135=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_autoRebuild3000);  
            stream_KW_WITH.add(KW_WITH135);


            KW_DEFERRED136=(Token)match(input,KW_DEFERRED,FOLLOW_KW_DEFERRED_in_autoRebuild3002);  
            stream_KW_DEFERRED.add(KW_DEFERRED136);


            KW_REBUILD137=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_autoRebuild3004);  
            stream_KW_REBUILD.add(KW_REBUILD137);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 819:5: -> ^( TOK_DEFERRED_REBUILDINDEX )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:819:7: ^( TOK_DEFERRED_REBUILDINDEX )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DEFERRED_REBUILDINDEX, "TOK_DEFERRED_REBUILDINDEX")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "autoRebuild"


    public static class indexTblName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexTblName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:822:1: indexTblName : KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) ;
    public final HiveParser.indexTblName_return indexTblName() throws RecognitionException {
        HiveParser.indexTblName_return retval = new HiveParser.indexTblName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IN138=null;
        Token KW_TABLE139=null;
        HiveParser_FromClauseParser.tableName_return indexTbl =null;


        CommonTree KW_IN138_tree=null;
        CommonTree KW_TABLE139_tree=null;
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
         msgs.push("index table name");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:5: ( KW_IN KW_TABLE indexTbl= tableName -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:825:7: KW_IN KW_TABLE indexTbl= tableName
            {
            KW_IN138=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_indexTblName3040);  
            stream_KW_IN.add(KW_IN138);


            KW_TABLE139=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_indexTblName3042);  
            stream_KW_TABLE.add(KW_TABLE139);


            pushFollow(FOLLOW_tableName_in_indexTblName3046);
            indexTbl=tableName();

            state._fsp--;

            stream_tableName.add(indexTbl.getTree());

            // AST REWRITE
            // elements: indexTbl
            // token labels: 
            // rule labels: retval, indexTbl
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexTbl=new RewriteRuleSubtreeStream(adaptor,"rule indexTbl",indexTbl!=null?indexTbl.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 826:5: -> ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:826:7: ^( TOK_CREATEINDEX_INDEXTBLNAME $indexTbl)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEINDEX_INDEXTBLNAME, "TOK_CREATEINDEX_INDEXTBLNAME")
                , root_1);

                adaptor.addChild(root_1, stream_indexTbl.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexTblName"


    public static class indexPropertiesPrefixed_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesPrefixed"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:829:1: indexPropertiesPrefixed : KW_IDXPROPERTIES ! indexProperties ;
    public final HiveParser.indexPropertiesPrefixed_return indexPropertiesPrefixed() throws RecognitionException {
        HiveParser.indexPropertiesPrefixed_return retval = new HiveParser.indexPropertiesPrefixed_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_IDXPROPERTIES140=null;
        HiveParser.indexProperties_return indexProperties141 =null;


        CommonTree KW_IDXPROPERTIES140_tree=null;

         msgs.push("table properties with prefix"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:832:5: ( KW_IDXPROPERTIES ! indexProperties )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:833:9: KW_IDXPROPERTIES ! indexProperties
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_IDXPROPERTIES140=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_indexPropertiesPrefixed3093); 

            pushFollow(FOLLOW_indexProperties_in_indexPropertiesPrefixed3096);
            indexProperties141=indexProperties();

            state._fsp--;

            adaptor.addChild(root_0, indexProperties141.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesPrefixed"


    public static class indexProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:836:1: indexProperties : LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) ;
    public final HiveParser.indexProperties_return indexProperties() throws RecognitionException {
        HiveParser.indexProperties_return retval = new HiveParser.indexProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN142=null;
        Token RPAREN144=null;
        HiveParser.indexPropertiesList_return indexPropertiesList143 =null;


        CommonTree LPAREN142_tree=null;
        CommonTree RPAREN144_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_indexPropertiesList=new RewriteRuleSubtreeStream(adaptor,"rule indexPropertiesList");
         msgs.push("index properties"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:839:5: ( LPAREN indexPropertiesList RPAREN -> ^( TOK_INDEXPROPERTIES indexPropertiesList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:840:7: LPAREN indexPropertiesList RPAREN
            {
            LPAREN142=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_indexProperties3129);  
            stream_LPAREN.add(LPAREN142);


            pushFollow(FOLLOW_indexPropertiesList_in_indexProperties3131);
            indexPropertiesList143=indexPropertiesList();

            state._fsp--;

            stream_indexPropertiesList.add(indexPropertiesList143.getTree());

            RPAREN144=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_indexProperties3133);  
            stream_RPAREN.add(RPAREN144);


            // AST REWRITE
            // elements: indexPropertiesList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 840:41: -> ^( TOK_INDEXPROPERTIES indexPropertiesList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:840:44: ^( TOK_INDEXPROPERTIES indexPropertiesList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPERTIES, "TOK_INDEXPROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_indexPropertiesList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexProperties"


    public static class indexPropertiesList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexPropertiesList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:843:1: indexPropertiesList : keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) ;
    public final HiveParser.indexPropertiesList_return indexPropertiesList() throws RecognitionException {
        HiveParser.indexPropertiesList_return retval = new HiveParser.indexPropertiesList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA146=null;
        HiveParser.keyValueProperty_return keyValueProperty145 =null;

        HiveParser.keyValueProperty_return keyValueProperty147 =null;


        CommonTree COMMA146_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_keyValueProperty=new RewriteRuleSubtreeStream(adaptor,"rule keyValueProperty");
         msgs.push("index properties list"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:846:5: ( keyValueProperty ( COMMA keyValueProperty )* -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:7: keyValueProperty ( COMMA keyValueProperty )*
            {
            pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3174);
            keyValueProperty145=keyValueProperty();

            state._fsp--;

            stream_keyValueProperty.add(keyValueProperty145.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:24: ( COMMA keyValueProperty )*
            loop44:
            do {
                int alt44=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt44=1;
                    }
                    break;

                }

                switch (alt44) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:25: COMMA keyValueProperty
            	    {
            	    COMMA146=(Token)match(input,COMMA,FOLLOW_COMMA_in_indexPropertiesList3177);  
            	    stream_COMMA.add(COMMA146);


            	    pushFollow(FOLLOW_keyValueProperty_in_indexPropertiesList3179);
            	    keyValueProperty147=keyValueProperty();

            	    state._fsp--;

            	    stream_keyValueProperty.add(keyValueProperty147.getTree());

            	    }
            	    break;

            	default :
            	    break loop44;
                }
            } while (true);


            // AST REWRITE
            // elements: keyValueProperty
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 847:50: -> ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:847:53: ^( TOK_INDEXPROPLIST ( keyValueProperty )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_INDEXPROPLIST, "TOK_INDEXPROPLIST")
                , root_1);

                if ( !(stream_keyValueProperty.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_keyValueProperty.hasNext() ) {
                    adaptor.addChild(root_1, stream_keyValueProperty.nextTree());

                }
                stream_keyValueProperty.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexPropertiesList"


    public static class dropIndexStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropIndexStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:850:1: dropIndexStatement : KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) ;
    public final HiveParser.dropIndexStatement_return dropIndexStatement() throws RecognitionException {
        HiveParser.dropIndexStatement_return retval = new HiveParser.dropIndexStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP148=null;
        Token KW_INDEX149=null;
        Token KW_ON151=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_FromClauseParser.tableName_return tab =null;

        HiveParser.ifExists_return ifExists150 =null;


        CommonTree KW_DROP148_tree=null;
        CommonTree KW_INDEX149_tree=null;
        CommonTree KW_ON151_tree=null;
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("drop index statement");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:5: ( KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:7: KW_DROP KW_INDEX ( ifExists )? indexName= identifier KW_ON tab= tableName
            {
            KW_DROP148=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropIndexStatement3217);  
            stream_KW_DROP.add(KW_DROP148);


            KW_INDEX149=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_dropIndexStatement3219);  
            stream_KW_INDEX.add(KW_INDEX149);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:24: ( ifExists )?
            int alt45=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt45=1;
                    }
                    break;
            }

            switch (alt45) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:853:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropIndexStatement3221);
                    ifExists150=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists150.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropIndexStatement3226);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            KW_ON151=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_dropIndexStatement3228);  
            stream_KW_ON.add(KW_ON151);


            pushFollow(FOLLOW_tableName_in_dropIndexStatement3232);
            tab=tableName();

            state._fsp--;

            stream_tableName.add(tab.getTree());

            // AST REWRITE
            // elements: indexName, ifExists, tab
            // token labels: 
            // rule labels: retval, indexName, tab
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);
            RewriteRuleSubtreeStream stream_tab=new RewriteRuleSubtreeStream(adaptor,"rule tab",tab!=null?tab.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 854:5: -> ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:854:7: ^( TOK_DROPINDEX $indexName $tab ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPINDEX, "TOK_DROPINDEX")
                , root_1);

                adaptor.addChild(root_1, stream_indexName.nextTree());

                adaptor.addChild(root_1, stream_tab.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:854:39: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropIndexStatement"


    public static class dropTableStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropTableStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:857:1: dropTableStatement : KW_DROP KW_TABLE ( ifExists )? tableName -> ^( TOK_DROPTABLE tableName ( ifExists )? ) ;
    public final HiveParser.dropTableStatement_return dropTableStatement() throws RecognitionException {
        HiveParser.dropTableStatement_return retval = new HiveParser.dropTableStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP152=null;
        Token KW_TABLE153=null;
        HiveParser.ifExists_return ifExists154 =null;

        HiveParser_FromClauseParser.tableName_return tableName155 =null;


        CommonTree KW_DROP152_tree=null;
        CommonTree KW_TABLE153_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         msgs.push("drop statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:5: ( KW_DROP KW_TABLE ( ifExists )? tableName -> ^( TOK_DROPTABLE tableName ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:7: KW_DROP KW_TABLE ( ifExists )? tableName
            {
            KW_DROP152=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropTableStatement3277);  
            stream_KW_DROP.add(KW_DROP152);


            KW_TABLE153=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_dropTableStatement3279);  
            stream_KW_TABLE.add(KW_TABLE153);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:24: ( ifExists )?
            int alt46=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt46=1;
                    }
                    break;
            }

            switch (alt46) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:24: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropTableStatement3281);
                    ifExists154=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists154.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_dropTableStatement3284);
            tableName155=tableName();

            state._fsp--;

            stream_tableName.add(tableName155.getTree());

            // AST REWRITE
            // elements: ifExists, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 860:44: -> ^( TOK_DROPTABLE tableName ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:47: ^( TOK_DROPTABLE tableName ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPTABLE, "TOK_DROPTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:860:73: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropTableStatement"


    public static class alterStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:863:1: alterStatement : KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix ) ;
    public final HiveParser.alterStatement_return alterStatement() throws RecognitionException {
        HiveParser.alterStatement_return retval = new HiveParser.alterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALTER156=null;
        Token KW_TABLE157=null;
        Token KW_VIEW159=null;
        Token KW_INDEX161=null;
        Token KW_DATABASE163=null;
        HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix158 =null;

        HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix160 =null;

        HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix162 =null;

        HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix164 =null;


        CommonTree KW_ALTER156_tree=null;
        CommonTree KW_TABLE157_tree=null;
        CommonTree KW_VIEW159_tree=null;
        CommonTree KW_INDEX161_tree=null;
        CommonTree KW_DATABASE163_tree=null;

         msgs.push("alter statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:866:5: ( KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:866:7: KW_ALTER ! ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix )
            {
            root_0 = (CommonTree)adaptor.nil();


            KW_ALTER156=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_alterStatement3322); 

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:867:9: ( KW_TABLE ! alterTableStatementSuffix | KW_VIEW ! alterViewStatementSuffix | KW_INDEX ! alterIndexStatementSuffix | KW_DATABASE ! alterDatabaseStatementSuffix )
            int alt47=4;
            switch ( input.LA(1) ) {
            case KW_TABLE:
                {
                alt47=1;
                }
                break;
            case KW_VIEW:
                {
                alt47=2;
                }
                break;
            case KW_INDEX:
                {
                alt47=3;
                }
                break;
            case KW_DATABASE:
                {
                alt47=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;

            }

            switch (alt47) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:868:13: KW_TABLE ! alterTableStatementSuffix
                    {
                    KW_TABLE157=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatement3347); 

                    pushFollow(FOLLOW_alterTableStatementSuffix_in_alterStatement3350);
                    alterTableStatementSuffix158=alterTableStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTableStatementSuffix158.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:870:13: KW_VIEW ! alterViewStatementSuffix
                    {
                    KW_VIEW159=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_alterStatement3374); 

                    pushFollow(FOLLOW_alterViewStatementSuffix_in_alterStatement3377);
                    alterViewStatementSuffix160=alterViewStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterViewStatementSuffix160.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:872:13: KW_INDEX ! alterIndexStatementSuffix
                    {
                    KW_INDEX161=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_alterStatement3401); 

                    pushFollow(FOLLOW_alterIndexStatementSuffix_in_alterStatement3404);
                    alterIndexStatementSuffix162=alterIndexStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterIndexStatementSuffix162.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:874:13: KW_DATABASE ! alterDatabaseStatementSuffix
                    {
                    KW_DATABASE163=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_alterStatement3428); 

                    pushFollow(FOLLOW_alterDatabaseStatementSuffix_in_alterStatement3431);
                    alterDatabaseStatementSuffix164=alterDatabaseStatementSuffix();

                    state._fsp--;

                    adaptor.addChild(root_0, alterDatabaseStatementSuffix164.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatement"


    public static class alterTableStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTableStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:878:1: alterTableStatementSuffix : ( alterStatementSuffixRename | alterStatementSuffixAddCol | alterStatementSuffixRenameCol | alterStatementSuffixDropPartitions | alterStatementSuffixAddPartitions | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterTblPartitionStatement | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition );
    public final HiveParser.alterTableStatementSuffix_return alterTableStatementSuffix() throws RecognitionException {
        HiveParser.alterTableStatementSuffix_return retval = new HiveParser.alterTableStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename165 =null;

        HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol166 =null;

        HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol167 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions168 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions169 =null;

        HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch170 =null;

        HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive171 =null;

        HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive172 =null;

        HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties173 =null;

        HiveParser.alterTblPartitionStatement_return alterTblPartitionStatement174 =null;

        HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby175 =null;

        HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition176 =null;



         msgs.push("alter table statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:5: ( alterStatementSuffixRename | alterStatementSuffixAddCol | alterStatementSuffixRenameCol | alterStatementSuffixDropPartitions | alterStatementSuffixAddPartitions | alterStatementSuffixTouch | alterStatementSuffixArchive | alterStatementSuffixUnArchive | alterStatementSuffixProperties | alterTblPartitionStatement | alterStatementSuffixSkewedby | alterStatementSuffixExchangePartition )
            int alt48=12;
            alt48 = dfa48.predict(input);
            switch (alt48) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:881:7: alterStatementSuffixRename
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterTableStatementSuffix3468);
                    alterStatementSuffixRename165=alterStatementSuffixRename();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRename165.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:882:7: alterStatementSuffixAddCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddCol_in_alterTableStatementSuffix3476);
                    alterStatementSuffixAddCol166=alterStatementSuffixAddCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddCol166.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:883:7: alterStatementSuffixRenameCol
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenameCol_in_alterTableStatementSuffix3484);
                    alterStatementSuffixRenameCol167=alterStatementSuffixRenameCol();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenameCol167.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:884:7: alterStatementSuffixDropPartitions
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterTableStatementSuffix3492);
                    alterStatementSuffixDropPartitions168=alterStatementSuffixDropPartitions();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixDropPartitions168.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:885:7: alterStatementSuffixAddPartitions
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterTableStatementSuffix3500);
                    alterStatementSuffixAddPartitions169=alterStatementSuffixAddPartitions();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixAddPartitions169.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:886:7: alterStatementSuffixTouch
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixTouch_in_alterTableStatementSuffix3508);
                    alterStatementSuffixTouch170=alterStatementSuffixTouch();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixTouch170.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:887:7: alterStatementSuffixArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixArchive_in_alterTableStatementSuffix3516);
                    alterStatementSuffixArchive171=alterStatementSuffixArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixArchive171.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:888:7: alterStatementSuffixUnArchive
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixUnArchive_in_alterTableStatementSuffix3524);
                    alterStatementSuffixUnArchive172=alterStatementSuffixUnArchive();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixUnArchive172.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:889:7: alterStatementSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProperties_in_alterTableStatementSuffix3532);
                    alterStatementSuffixProperties173=alterStatementSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProperties173.getTree());

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:890:7: alterTblPartitionStatement
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatement_in_alterTableStatementSuffix3540);
                    alterTblPartitionStatement174=alterTblPartitionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTblPartitionStatement174.getTree());

                    }
                    break;
                case 11 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:891:7: alterStatementSuffixSkewedby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSkewedby_in_alterTableStatementSuffix3548);
                    alterStatementSuffixSkewedby175=alterStatementSuffixSkewedby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSkewedby175.getTree());

                    }
                    break;
                case 12 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:892:7: alterStatementSuffixExchangePartition
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixExchangePartition_in_alterTableStatementSuffix3556);
                    alterStatementSuffixExchangePartition176=alterStatementSuffixExchangePartition();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixExchangePartition176.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTableStatementSuffix"


    public static class alterViewStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:895:1: alterViewStatementSuffix : ( alterViewSuffixProperties | alterStatementSuffixRename -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename ) | alterStatementSuffixAddPartitions -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions ) | alterStatementSuffixDropPartitions -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions ) |name= tableName KW_AS selectStatement -> ^( TOK_ALTERVIEW_AS $name selectStatement ) );
    public final HiveParser.alterViewStatementSuffix_return alterViewStatementSuffix() throws RecognitionException {
        HiveParser.alterViewStatementSuffix_return retval = new HiveParser.alterViewStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_AS181=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties177 =null;

        HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename178 =null;

        HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions179 =null;

        HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions180 =null;

        HiveParser.selectStatement_return selectStatement182 =null;


        CommonTree KW_AS181_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleSubtreeStream stream_selectStatement=new RewriteRuleSubtreeStream(adaptor,"rule selectStatement");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitions=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitions");
        RewriteRuleSubtreeStream stream_alterStatementSuffixRename=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixRename");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_alterStatementSuffixDropPartitions=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixDropPartitions");
         msgs.push("alter view statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:898:5: ( alterViewSuffixProperties | alterStatementSuffixRename -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename ) | alterStatementSuffixAddPartitions -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions ) | alterStatementSuffixDropPartitions -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions ) |name= tableName KW_AS selectStatement -> ^( TOK_ALTERVIEW_AS $name selectStatement ) )
            int alt49=5;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                case KW_UNSET:
                    {
                    alt49=1;
                    }
                    break;
                case KW_RENAME:
                    {
                    alt49=2;
                    }
                    break;
                case KW_ADD:
                    {
                    alt49=3;
                    }
                    break;
                case KW_DROP:
                    {
                    alt49=4;
                    }
                    break;
                case DOT:
                case KW_AS:
                    {
                    alt49=5;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 49, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                case KW_UNSET:
                    {
                    alt49=1;
                    }
                    break;
                case KW_RENAME:
                    {
                    alt49=2;
                    }
                    break;
                case KW_ADD:
                    {
                    alt49=3;
                    }
                    break;
                case KW_DROP:
                    {
                    alt49=4;
                    }
                    break;
                case DOT:
                case KW_AS:
                    {
                    alt49=5;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 49, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 49, 0, input);

                throw nvae;

            }

            switch (alt49) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:898:7: alterViewSuffixProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterViewSuffixProperties_in_alterViewStatementSuffix3583);
                    alterViewSuffixProperties177=alterViewSuffixProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterViewSuffixProperties177.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:899:7: alterStatementSuffixRename
                    {
                    pushFollow(FOLLOW_alterStatementSuffixRename_in_alterViewStatementSuffix3591);
                    alterStatementSuffixRename178=alterStatementSuffixRename();

                    state._fsp--;

                    stream_alterStatementSuffixRename.add(alterStatementSuffixRename178.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixRename
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 900:9: -> ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:900:12: ^( TOK_ALTERVIEW_RENAME alterStatementSuffixRename )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_RENAME, "TOK_ALTERVIEW_RENAME")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixRename.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:901:7: alterStatementSuffixAddPartitions
                    {
                    pushFollow(FOLLOW_alterStatementSuffixAddPartitions_in_alterViewStatementSuffix3615);
                    alterStatementSuffixAddPartitions179=alterStatementSuffixAddPartitions();

                    state._fsp--;

                    stream_alterStatementSuffixAddPartitions.add(alterStatementSuffixAddPartitions179.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixAddPartitions
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 902:9: -> ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:902:12: ^( TOK_ALTERVIEW_ADDPARTS alterStatementSuffixAddPartitions )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_ADDPARTS, "TOK_ALTERVIEW_ADDPARTS")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitions.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:903:7: alterStatementSuffixDropPartitions
                    {
                    pushFollow(FOLLOW_alterStatementSuffixDropPartitions_in_alterViewStatementSuffix3639);
                    alterStatementSuffixDropPartitions180=alterStatementSuffixDropPartitions();

                    state._fsp--;

                    stream_alterStatementSuffixDropPartitions.add(alterStatementSuffixDropPartitions180.getTree());

                    // AST REWRITE
                    // elements: alterStatementSuffixDropPartitions
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 904:9: -> ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:904:12: ^( TOK_ALTERVIEW_DROPPARTS alterStatementSuffixDropPartitions )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_DROPPARTS, "TOK_ALTERVIEW_DROPPARTS")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterStatementSuffixDropPartitions.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:905:7: name= tableName KW_AS selectStatement
                    {
                    pushFollow(FOLLOW_tableName_in_alterViewStatementSuffix3665);
                    name=tableName();

                    state._fsp--;

                    stream_tableName.add(name.getTree());

                    KW_AS181=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_alterViewStatementSuffix3667);  
                    stream_KW_AS.add(KW_AS181);


                    pushFollow(FOLLOW_selectStatement_in_alterViewStatementSuffix3669);
                    selectStatement182=selectStatement();

                    state._fsp--;

                    stream_selectStatement.add(selectStatement182.getTree());

                    // AST REWRITE
                    // elements: selectStatement, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 906:9: -> ^( TOK_ALTERVIEW_AS $name selectStatement )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:906:12: ^( TOK_ALTERVIEW_AS $name selectStatement )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_AS, "TOK_ALTERVIEW_AS")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_selectStatement.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewStatementSuffix"


    public static class alterIndexStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterIndexStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:909:1: alterIndexStatementSuffix : indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) ) ;
    public final HiveParser.alterIndexStatementSuffix_return alterIndexStatementSuffix() throws RecognitionException {
        HiveParser.alterIndexStatementSuffix_return retval = new HiveParser.alterIndexStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ON183=null;
        Token KW_REBUILD185=null;
        Token KW_SET186=null;
        Token KW_IDXPROPERTIES187=null;
        HiveParser_IdentifiersParser.identifier_return indexName =null;

        HiveParser_IdentifiersParser.identifier_return tableNameId =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec184 =null;

        HiveParser.indexProperties_return indexProperties188 =null;


        CommonTree KW_ON183_tree=null;
        CommonTree KW_REBUILD185_tree=null;
        CommonTree KW_SET186_tree=null;
        CommonTree KW_IDXPROPERTIES187_tree=null;
        RewriteRuleTokenStream stream_KW_REBUILD=new RewriteRuleTokenStream(adaptor,"token KW_REBUILD");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_IDXPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_IDXPROPERTIES");
        RewriteRuleSubtreeStream stream_indexProperties=new RewriteRuleSubtreeStream(adaptor,"rule indexProperties");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("alter index statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:5: (indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:912:7: indexName= identifier ( KW_ON tableNameId= identifier ) ( partitionSpec )? ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) )
            {
            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix3717);
            indexName=identifier();

            state._fsp--;

            stream_identifier.add(indexName.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:913:7: ( KW_ON tableNameId= identifier )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:913:8: KW_ON tableNameId= identifier
            {
            KW_ON183=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_alterIndexStatementSuffix3726);  
            stream_KW_ON.add(KW_ON183);


            pushFollow(FOLLOW_identifier_in_alterIndexStatementSuffix3730);
            tableNameId=identifier();

            state._fsp--;

            stream_identifier.add(tableNameId.getTree());

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:7: ( partitionSpec )?
            int alt50=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt50=1;
                    }
                    break;
            }

            switch (alt50) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:914:7: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_alterIndexStatementSuffix3739);
                    partitionSpec184=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec184.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:915:5: ( KW_REBUILD -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? ) | KW_SET KW_IDXPROPERTIES indexProperties -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties ) )
            int alt51=2;
            switch ( input.LA(1) ) {
            case KW_REBUILD:
                {
                alt51=1;
                }
                break;
            case KW_SET:
                {
                alt51=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;

            }

            switch (alt51) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:916:7: KW_REBUILD
                    {
                    KW_REBUILD185=(Token)match(input,KW_REBUILD,FOLLOW_KW_REBUILD_in_alterIndexStatementSuffix3754);  
                    stream_KW_REBUILD.add(KW_REBUILD185);


                    // AST REWRITE
                    // elements: tableNameId, indexName, partitionSpec
                    // token labels: 
                    // rule labels: retval, tableNameId, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tableNameId=new RewriteRuleSubtreeStream(adaptor,"rule tableNameId",tableNameId!=null?tableNameId.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 917:7: -> ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:917:9: ^( TOK_ALTERINDEX_REBUILD $tableNameId $indexName ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_REBUILD, "TOK_ALTERINDEX_REBUILD")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableNameId.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:917:58: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:919:7: KW_SET KW_IDXPROPERTIES indexProperties
                    {
                    KW_SET186=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterIndexStatementSuffix3788);  
                    stream_KW_SET.add(KW_SET186);


                    KW_IDXPROPERTIES187=(Token)match(input,KW_IDXPROPERTIES,FOLLOW_KW_IDXPROPERTIES_in_alterIndexStatementSuffix3790);  
                    stream_KW_IDXPROPERTIES.add(KW_IDXPROPERTIES187);


                    pushFollow(FOLLOW_indexProperties_in_alterIndexStatementSuffix3798);
                    indexProperties188=indexProperties();

                    state._fsp--;

                    stream_indexProperties.add(indexProperties188.getTree());

                    // AST REWRITE
                    // elements: indexName, tableNameId, indexProperties
                    // token labels: 
                    // rule labels: retval, tableNameId, indexName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tableNameId=new RewriteRuleSubtreeStream(adaptor,"rule tableNameId",tableNameId!=null?tableNameId.tree:null);
                    RewriteRuleSubtreeStream stream_indexName=new RewriteRuleSubtreeStream(adaptor,"rule indexName",indexName!=null?indexName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 921:7: -> ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:921:9: ^( TOK_ALTERINDEX_PROPERTIES $tableNameId $indexName indexProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERINDEX_PROPERTIES, "TOK_ALTERINDEX_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableNameId.nextTree());

                        adaptor.addChild(root_1, stream_indexName.nextTree());

                        adaptor.addChild(root_1, stream_indexProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterIndexStatementSuffix"


    public static class alterDatabaseStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:925:1: alterDatabaseStatementSuffix : alterDatabaseSuffixProperties ;
    public final HiveParser.alterDatabaseStatementSuffix_return alterDatabaseStatementSuffix() throws RecognitionException {
        HiveParser.alterDatabaseStatementSuffix_return retval = new HiveParser.alterDatabaseStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties189 =null;



         msgs.push("alter database statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:928:5: ( alterDatabaseSuffixProperties )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:928:7: alterDatabaseSuffixProperties
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_alterDatabaseSuffixProperties_in_alterDatabaseStatementSuffix3850);
            alterDatabaseSuffixProperties189=alterDatabaseSuffixProperties();

            state._fsp--;

            adaptor.addChild(root_0, alterDatabaseSuffixProperties189.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseStatementSuffix"


    public static class alterDatabaseSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterDatabaseSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:931:1: alterDatabaseSuffixProperties : name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) ;
    public final HiveParser.alterDatabaseSuffixProperties_return alterDatabaseSuffixProperties() throws RecognitionException {
        HiveParser.alterDatabaseSuffixProperties_return retval = new HiveParser.alterDatabaseSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET190=null;
        Token KW_DBPROPERTIES191=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.dbProperties_return dbProperties192 =null;


        CommonTree KW_SET190_tree=null;
        CommonTree KW_DBPROPERTIES191_tree=null;
        RewriteRuleTokenStream stream_KW_DBPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_DBPROPERTIES");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_dbProperties=new RewriteRuleSubtreeStream(adaptor,"rule dbProperties");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("alter database properties statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:934:5: (name= identifier KW_SET KW_DBPROPERTIES dbProperties -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:934:7: name= identifier KW_SET KW_DBPROPERTIES dbProperties
            {
            pushFollow(FOLLOW_identifier_in_alterDatabaseSuffixProperties3879);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            KW_SET190=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterDatabaseSuffixProperties3881);  
            stream_KW_SET.add(KW_SET190);


            KW_DBPROPERTIES191=(Token)match(input,KW_DBPROPERTIES,FOLLOW_KW_DBPROPERTIES_in_alterDatabaseSuffixProperties3883);  
            stream_KW_DBPROPERTIES.add(KW_DBPROPERTIES191);


            pushFollow(FOLLOW_dbProperties_in_alterDatabaseSuffixProperties3885);
            dbProperties192=dbProperties();

            state._fsp--;

            stream_dbProperties.add(dbProperties192.getTree());

            // AST REWRITE
            // elements: name, dbProperties
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 935:5: -> ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:935:8: ^( TOK_ALTERDATABASE_PROPERTIES $name dbProperties )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERDATABASE_PROPERTIES, "TOK_ALTERDATABASE_PROPERTIES")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_dbProperties.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterDatabaseSuffixProperties"


    public static class alterStatementSuffixRename_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRename"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:938:1: alterStatementSuffixRename : oldName= identifier KW_RENAME KW_TO newName= identifier -> ^( TOK_ALTERTABLE_RENAME $oldName $newName) ;
    public final HiveParser.alterStatementSuffixRename_return alterStatementSuffixRename() throws RecognitionException {
        HiveParser.alterStatementSuffixRename_return retval = new HiveParser.alterStatementSuffixRename_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME193=null;
        Token KW_TO194=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;


        CommonTree KW_RENAME193_tree=null;
        CommonTree KW_TO194_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("rename statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:941:5: (oldName= identifier KW_RENAME KW_TO newName= identifier -> ^( TOK_ALTERTABLE_RENAME $oldName $newName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:941:7: oldName= identifier KW_RENAME KW_TO newName= identifier
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRename3929);
            oldName=identifier();

            state._fsp--;

            stream_identifier.add(oldName.getTree());

            KW_RENAME193=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRename3931);  
            stream_KW_RENAME.add(KW_RENAME193);


            KW_TO194=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRename3933);  
            stream_KW_TO.add(KW_TO194);


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRename3937);
            newName=identifier();

            state._fsp--;

            stream_identifier.add(newName.getTree());

            // AST REWRITE
            // elements: oldName, newName
            // token labels: 
            // rule labels: retval, newName, oldName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 942:5: -> ^( TOK_ALTERTABLE_RENAME $oldName $newName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:942:8: ^( TOK_ALTERTABLE_RENAME $oldName $newName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAME, "TOK_ALTERTABLE_RENAME")
                , root_1);

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRename"


    public static class alterStatementSuffixAddCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:945:1: alterStatementSuffixAddCol : identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList ) -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList ) ;
    public final HiveParser.alterStatementSuffixAddCol_return alterStatementSuffixAddCol() throws RecognitionException {
        HiveParser.alterStatementSuffixAddCol_return retval = new HiveParser.alterStatementSuffixAddCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token add=null;
        Token replace=null;
        Token KW_COLUMNS196=null;
        Token LPAREN197=null;
        Token RPAREN199=null;
        HiveParser_IdentifiersParser.identifier_return identifier195 =null;

        HiveParser.columnNameTypeList_return columnNameTypeList198 =null;


        CommonTree add_tree=null;
        CommonTree replace_tree=null;
        CommonTree KW_COLUMNS196_tree=null;
        CommonTree LPAREN197_tree=null;
        CommonTree RPAREN199_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_REPLACE=new RewriteRuleTokenStream(adaptor,"token KW_REPLACE");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("add column statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:5: ( identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList ) -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:7: identifier (add= KW_ADD |replace= KW_REPLACE ) KW_COLUMNS LPAREN columnNameTypeList RPAREN
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixAddCol3980);
            identifier195=identifier();

            state._fsp--;

            stream_identifier.add(identifier195.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:18: (add= KW_ADD |replace= KW_REPLACE )
            int alt52=2;
            switch ( input.LA(1) ) {
            case KW_ADD:
                {
                alt52=1;
                }
                break;
            case KW_REPLACE:
                {
                alt52=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 52, 0, input);

                throw nvae;

            }

            switch (alt52) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:19: add= KW_ADD
                    {
                    add=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddCol3985);  
                    stream_KW_ADD.add(add);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:948:32: replace= KW_REPLACE
                    {
                    replace=(Token)match(input,KW_REPLACE,FOLLOW_KW_REPLACE_in_alterStatementSuffixAddCol3991);  
                    stream_KW_REPLACE.add(replace);


                    }
                    break;

            }


            KW_COLUMNS196=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_alterStatementSuffixAddCol3994);  
            stream_KW_COLUMNS.add(KW_COLUMNS196);


            LPAREN197=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterStatementSuffixAddCol3996);  
            stream_LPAREN.add(LPAREN197);


            pushFollow(FOLLOW_columnNameTypeList_in_alterStatementSuffixAddCol3998);
            columnNameTypeList198=columnNameTypeList();

            state._fsp--;

            stream_columnNameTypeList.add(columnNameTypeList198.getTree());

            RPAREN199=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterStatementSuffixAddCol4000);  
            stream_RPAREN.add(RPAREN199);


            // AST REWRITE
            // elements: identifier, identifier, columnNameTypeList, columnNameTypeList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 949:5: -> {$add != null}? ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList )
            if (add != null) {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:949:24: ^( TOK_ALTERTABLE_ADDCOLS identifier columnNameTypeList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDCOLS, "TOK_ALTERTABLE_ADDCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            else // 950:5: -> ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:950:24: ^( TOK_ALTERTABLE_REPLACECOLS identifier columnNameTypeList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_REPLACECOLS, "TOK_ALTERTABLE_REPLACECOLS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddCol"


    public static class alterStatementSuffixRenameCol_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenameCol"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:953:1: alterStatementSuffixRenameCol : identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ) ;
    public final HiveParser.alterStatementSuffixRenameCol_return alterStatementSuffixRenameCol() throws RecognitionException {
        HiveParser.alterStatementSuffixRenameCol_return retval = new HiveParser.alterStatementSuffixRenameCol_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_CHANGE201=null;
        Token KW_COLUMN202=null;
        Token KW_COMMENT204=null;
        HiveParser_IdentifiersParser.identifier_return oldName =null;

        HiveParser_IdentifiersParser.identifier_return newName =null;

        HiveParser_IdentifiersParser.identifier_return identifier200 =null;

        HiveParser.colType_return colType203 =null;

        HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition205 =null;


        CommonTree comment_tree=null;
        CommonTree KW_CHANGE201_tree=null;
        CommonTree KW_COLUMN202_tree=null;
        CommonTree KW_COMMENT204_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_KW_CHANGE=new RewriteRuleTokenStream(adaptor,"token KW_CHANGE");
        RewriteRuleSubtreeStream stream_alterStatementChangeColPosition=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementChangeColPosition");
        RewriteRuleSubtreeStream stream_colType=new RewriteRuleSubtreeStream(adaptor,"rule colType");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("rename column name"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:5: ( identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )? -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:7: identifier KW_CHANGE ( KW_COLUMN )? oldName= identifier newName= identifier colType ( KW_COMMENT comment= StringLiteral )? ( alterStatementChangeColPosition )?
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4073);
            identifier200=identifier();

            state._fsp--;

            stream_identifier.add(identifier200.getTree());

            KW_CHANGE201=(Token)match(input,KW_CHANGE,FOLLOW_KW_CHANGE_in_alterStatementSuffixRenameCol4075);  
            stream_KW_CHANGE.add(KW_CHANGE201);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:28: ( KW_COLUMN )?
            int alt53=2;
            switch ( input.LA(1) ) {
                case KW_COLUMN:
                    {
                    alt53=1;
                    }
                    break;
            }

            switch (alt53) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:28: KW_COLUMN
                    {
                    KW_COLUMN202=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterStatementSuffixRenameCol4077);  
                    stream_KW_COLUMN.add(KW_COLUMN202);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4082);
            oldName=identifier();

            state._fsp--;

            stream_identifier.add(oldName.getTree());

            pushFollow(FOLLOW_identifier_in_alterStatementSuffixRenameCol4086);
            newName=identifier();

            state._fsp--;

            stream_identifier.add(newName.getTree());

            pushFollow(FOLLOW_colType_in_alterStatementSuffixRenameCol4088);
            colType203=colType();

            state._fsp--;

            stream_colType.add(colType203.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:85: ( KW_COMMENT comment= StringLiteral )?
            int alt54=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt54=1;
                    }
                    break;
            }

            switch (alt54) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:86: KW_COMMENT comment= StringLiteral
                    {
                    KW_COMMENT204=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_alterStatementSuffixRenameCol4091);  
                    stream_KW_COMMENT.add(KW_COMMENT204);


                    comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixRenameCol4095);  
                    stream_StringLiteral.add(comment);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:121: ( alterStatementChangeColPosition )?
            int alt55=2;
            switch ( input.LA(1) ) {
                case KW_AFTER:
                case KW_FIRST:
                    {
                    alt55=1;
                    }
                    break;
            }

            switch (alt55) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:956:121: alterStatementChangeColPosition
                    {
                    pushFollow(FOLLOW_alterStatementChangeColPosition_in_alterStatementSuffixRenameCol4099);
                    alterStatementChangeColPosition205=alterStatementChangeColPosition();

                    state._fsp--;

                    stream_alterStatementChangeColPosition.add(alterStatementChangeColPosition205.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: identifier, newName, oldName, comment, colType, alterStatementChangeColPosition
            // token labels: comment
            // rule labels: retval, newName, oldName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_newName=new RewriteRuleSubtreeStream(adaptor,"rule newName",newName!=null?newName.tree:null);
            RewriteRuleSubtreeStream stream_oldName=new RewriteRuleSubtreeStream(adaptor,"rule oldName",oldName!=null?oldName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 957:5: -> ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:7: ^( TOK_ALTERTABLE_RENAMECOL identifier $oldName $newName colType ( $comment)? ( alterStatementChangeColPosition )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMECOL, "TOK_ALTERTABLE_RENAMECOL")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, stream_oldName.nextTree());

                adaptor.addChild(root_1, stream_newName.nextTree());

                adaptor.addChild(root_1, stream_colType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:72: ( $comment)?
                if ( stream_comment.hasNext() ) {
                    adaptor.addChild(root_1, stream_comment.nextNode());

                }
                stream_comment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:957:81: ( alterStatementChangeColPosition )?
                if ( stream_alterStatementChangeColPosition.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementChangeColPosition.nextTree());

                }
                stream_alterStatementChangeColPosition.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenameCol"


    public static class alterStatementChangeColPosition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementChangeColPosition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:960:1: alterStatementChangeColPosition : (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) );
    public final HiveParser.alterStatementChangeColPosition_return alterStatementChangeColPosition() throws RecognitionException {
        HiveParser.alterStatementChangeColPosition_return retval = new HiveParser.alterStatementChangeColPosition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token first=null;
        Token KW_AFTER206=null;
        HiveParser_IdentifiersParser.identifier_return afterCol =null;


        CommonTree first_tree=null;
        CommonTree KW_AFTER206_tree=null;
        RewriteRuleTokenStream stream_KW_AFTER=new RewriteRuleTokenStream(adaptor,"token KW_AFTER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:961:5: (first= KW_FIRST | KW_AFTER afterCol= identifier -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION ) -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol) )
            int alt56=2;
            switch ( input.LA(1) ) {
            case KW_FIRST:
                {
                alt56=1;
                }
                break;
            case KW_AFTER:
                {
                alt56=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;

            }

            switch (alt56) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:961:7: first= KW_FIRST
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    first=(Token)match(input,KW_FIRST,FOLLOW_KW_FIRST_in_alterStatementChangeColPosition4145); 
                    first_tree = 
                    (CommonTree)adaptor.create(first)
                    ;
                    adaptor.addChild(root_0, first_tree);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:961:22: KW_AFTER afterCol= identifier
                    {
                    KW_AFTER206=(Token)match(input,KW_AFTER,FOLLOW_KW_AFTER_in_alterStatementChangeColPosition4147);  
                    stream_KW_AFTER.add(KW_AFTER206);


                    pushFollow(FOLLOW_identifier_in_alterStatementChangeColPosition4151);
                    afterCol=identifier();

                    state._fsp--;

                    stream_identifier.add(afterCol.getTree());

                    // AST REWRITE
                    // elements: afterCol
                    // token labels: 
                    // rule labels: retval, afterCol
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_afterCol=new RewriteRuleSubtreeStream(adaptor,"rule afterCol",afterCol!=null?afterCol.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 962:5: -> {$first != null}? ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                    if (first != null) {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:962:25: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 963:5: -> ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:963:8: ^( TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION $afterCol)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION, "TOK_ALTERTABLE_CHANGECOL_AFTER_POSITION")
                        , root_1);

                        adaptor.addChild(root_1, stream_afterCol.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementChangeColPosition"


    public static class alterStatementSuffixAddPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:966:1: alterStatementSuffixAddPartitions : identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) ;
    public final HiveParser.alterStatementSuffixAddPartitions_return alterStatementSuffixAddPartitions() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitions_return retval = new HiveParser.alterStatementSuffixAddPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ADD208=null;
        HiveParser_IdentifiersParser.identifier_return identifier207 =null;

        HiveParser.ifNotExists_return ifNotExists209 =null;

        HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement210 =null;


        CommonTree KW_ADD208_tree=null;
        RewriteRuleTokenStream stream_KW_ADD=new RewriteRuleTokenStream(adaptor,"token KW_ADD");
        RewriteRuleSubtreeStream stream_alterStatementSuffixAddPartitionsElement=new RewriteRuleSubtreeStream(adaptor,"rule alterStatementSuffixAddPartitionsElement");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("add partition statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:5: ( identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:7: identifier KW_ADD ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixAddPartitions4203);
            identifier207=identifier();

            state._fsp--;

            stream_identifier.add(identifier207.getTree());

            KW_ADD208=(Token)match(input,KW_ADD,FOLLOW_KW_ADD_in_alterStatementSuffixAddPartitions4205);  
            stream_KW_ADD.add(KW_ADD208);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:25: ( ifNotExists )?
            int alt57=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt57=1;
                    }
                    break;
            }

            switch (alt57) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:25: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_alterStatementSuffixAddPartitions4207);
                    ifNotExists209=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists209.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:38: ( alterStatementSuffixAddPartitionsElement )+
            int cnt58=0;
            loop58:
            do {
                int alt58=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt58=1;
                    }
                    break;

                }

                switch (alt58) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:969:38: alterStatementSuffixAddPartitionsElement
            	    {
            	    pushFollow(FOLLOW_alterStatementSuffixAddPartitionsElement_in_alterStatementSuffixAddPartitions4210);
            	    alterStatementSuffixAddPartitionsElement210=alterStatementSuffixAddPartitionsElement();

            	    state._fsp--;

            	    stream_alterStatementSuffixAddPartitionsElement.add(alterStatementSuffixAddPartitionsElement210.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt58 >= 1 ) break loop58;
                        EarlyExitException eee =
                            new EarlyExitException(58, input);
                        throw eee;
                }
                cnt58++;
            } while (true);


            // AST REWRITE
            // elements: alterStatementSuffixAddPartitionsElement, ifNotExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 970:5: -> ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:8: ^( TOK_ALTERTABLE_ADDPARTS identifier ( ifNotExists )? ( alterStatementSuffixAddPartitionsElement )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ADDPARTS, "TOK_ALTERTABLE_ADDPARTS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:970:45: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                if ( !(stream_alterStatementSuffixAddPartitionsElement.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_alterStatementSuffixAddPartitionsElement.hasNext() ) {
                    adaptor.addChild(root_1, stream_alterStatementSuffixAddPartitionsElement.nextTree());

                }
                stream_alterStatementSuffixAddPartitionsElement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitions"


    public static class alterStatementSuffixAddPartitionsElement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixAddPartitionsElement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:973:1: alterStatementSuffixAddPartitionsElement : partitionSpec ( partitionLocation )? ;
    public final HiveParser.alterStatementSuffixAddPartitionsElement_return alterStatementSuffixAddPartitionsElement() throws RecognitionException {
        HiveParser.alterStatementSuffixAddPartitionsElement_return retval = new HiveParser.alterStatementSuffixAddPartitionsElement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec211 =null;

        HiveParser.partitionLocation_return partitionLocation212 =null;



        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:5: ( partitionSpec ( partitionLocation )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:7: partitionSpec ( partitionLocation )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixAddPartitionsElement4246);
            partitionSpec211=partitionSpec();

            state._fsp--;

            adaptor.addChild(root_0, partitionSpec211.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:21: ( partitionLocation )?
            int alt59=2;
            switch ( input.LA(1) ) {
                case KW_LOCATION:
                    {
                    alt59=1;
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:974:21: partitionLocation
                    {
                    pushFollow(FOLLOW_partitionLocation_in_alterStatementSuffixAddPartitionsElement4248);
                    partitionLocation212=partitionLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, partitionLocation212.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixAddPartitionsElement"


    public static class alterStatementSuffixTouch_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixTouch"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:977:1: alterStatementSuffixTouch : identifier KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixTouch_return alterStatementSuffixTouch() throws RecognitionException {
        HiveParser.alterStatementSuffixTouch_return retval = new HiveParser.alterStatementSuffixTouch_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_TOUCH214=null;
        HiveParser_IdentifiersParser.identifier_return identifier213 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec215 =null;


        CommonTree KW_TOUCH214_tree=null;
        RewriteRuleTokenStream stream_KW_TOUCH=new RewriteRuleTokenStream(adaptor,"token KW_TOUCH");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("touch statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:980:5: ( identifier KW_TOUCH ( partitionSpec )* -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:980:7: identifier KW_TOUCH ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixTouch4276);
            identifier213=identifier();

            state._fsp--;

            stream_identifier.add(identifier213.getTree());

            KW_TOUCH214=(Token)match(input,KW_TOUCH,FOLLOW_KW_TOUCH_in_alterStatementSuffixTouch4278);  
            stream_KW_TOUCH.add(KW_TOUCH214);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:980:27: ( partitionSpec )*
            loop60:
            do {
                int alt60=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt60=1;
                    }
                    break;

                }

                switch (alt60) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:980:28: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixTouch4281);
            	    partitionSpec215=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec215.getTree());

            	    }
            	    break;

            	default :
            	    break loop60;
                }
            } while (true);


            // AST REWRITE
            // elements: identifier, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 981:5: -> ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:981:8: ^( TOK_ALTERTABLE_TOUCH identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_TOUCH, "TOK_ALTERTABLE_TOUCH")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:981:42: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixTouch"


    public static class alterStatementSuffixArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:984:1: alterStatementSuffixArchive : identifier KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixArchive_return alterStatementSuffixArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixArchive_return retval = new HiveParser.alterStatementSuffixArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ARCHIVE217=null;
        HiveParser_IdentifiersParser.identifier_return identifier216 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec218 =null;


        CommonTree KW_ARCHIVE217_tree=null;
        RewriteRuleTokenStream stream_KW_ARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_ARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("archive statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:987:5: ( identifier KW_ARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:987:7: identifier KW_ARCHIVE ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixArchive4327);
            identifier216=identifier();

            state._fsp--;

            stream_identifier.add(identifier216.getTree());

            KW_ARCHIVE217=(Token)match(input,KW_ARCHIVE,FOLLOW_KW_ARCHIVE_in_alterStatementSuffixArchive4329);  
            stream_KW_ARCHIVE.add(KW_ARCHIVE217);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:987:29: ( partitionSpec )*
            loop61:
            do {
                int alt61=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt61=1;
                    }
                    break;

                }

                switch (alt61) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:987:30: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixArchive4332);
            	    partitionSpec218=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec218.getTree());

            	    }
            	    break;

            	default :
            	    break loop61;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 988:5: -> ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:8: ^( TOK_ALTERTABLE_ARCHIVE identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ARCHIVE, "TOK_ALTERTABLE_ARCHIVE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:988:44: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixArchive"


    public static class alterStatementSuffixUnArchive_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixUnArchive"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:991:1: alterStatementSuffixUnArchive : identifier KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* ) ;
    public final HiveParser.alterStatementSuffixUnArchive_return alterStatementSuffixUnArchive() throws RecognitionException {
        HiveParser.alterStatementSuffixUnArchive_return retval = new HiveParser.alterStatementSuffixUnArchive_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNARCHIVE220=null;
        HiveParser_IdentifiersParser.identifier_return identifier219 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec221 =null;


        CommonTree KW_UNARCHIVE220_tree=null;
        RewriteRuleTokenStream stream_KW_UNARCHIVE=new RewriteRuleTokenStream(adaptor,"token KW_UNARCHIVE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("unarchive statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:994:5: ( identifier KW_UNARCHIVE ( partitionSpec )* -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:994:7: identifier KW_UNARCHIVE ( partitionSpec )*
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixUnArchive4378);
            identifier219=identifier();

            state._fsp--;

            stream_identifier.add(identifier219.getTree());

            KW_UNARCHIVE220=(Token)match(input,KW_UNARCHIVE,FOLLOW_KW_UNARCHIVE_in_alterStatementSuffixUnArchive4380);  
            stream_KW_UNARCHIVE.add(KW_UNARCHIVE220);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:994:31: ( partitionSpec )*
            loop62:
            do {
                int alt62=2;
                switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt62=1;
                    }
                    break;

                }

                switch (alt62) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:994:32: partitionSpec
            	    {
            	    pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixUnArchive4383);
            	    partitionSpec221=partitionSpec();

            	    state._fsp--;

            	    stream_partitionSpec.add(partitionSpec221.getTree());

            	    }
            	    break;

            	default :
            	    break loop62;
                }
            } while (true);


            // AST REWRITE
            // elements: partitionSpec, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 995:5: -> ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:8: ^( TOK_ALTERTABLE_UNARCHIVE identifier ( partitionSpec )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_UNARCHIVE, "TOK_ALTERTABLE_UNARCHIVE")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:995:46: ( partitionSpec )*
                while ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixUnArchive"


    public static class partitionLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partitionLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:998:1: partitionLocation : KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) ;
    public final HiveParser.partitionLocation_return partitionLocation() throws RecognitionException {
        HiveParser.partitionLocation_return retval = new HiveParser.partitionLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token locn=null;
        Token KW_LOCATION222=null;

        CommonTree locn_tree=null;
        CommonTree KW_LOCATION222_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

         msgs.push("partition location"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1001:5: ( KW_LOCATION locn= StringLiteral -> ^( TOK_PARTITIONLOCATION $locn) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1002:7: KW_LOCATION locn= StringLiteral
            {
            KW_LOCATION222=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_partitionLocation4435);  
            stream_KW_LOCATION.add(KW_LOCATION222);


            locn=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_partitionLocation4439);  
            stream_StringLiteral.add(locn);


            // AST REWRITE
            // elements: locn
            // token labels: locn
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_locn=new RewriteRuleTokenStream(adaptor,"token locn",locn);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1002:38: -> ^( TOK_PARTITIONLOCATION $locn)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1002:41: ^( TOK_PARTITIONLOCATION $locn)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PARTITIONLOCATION, "TOK_PARTITIONLOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_locn.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partitionLocation"


    public static class alterStatementSuffixDropPartitions_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixDropPartitions"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1005:1: alterStatementSuffixDropPartitions : identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) ;
    public final HiveParser.alterStatementSuffixDropPartitions_return alterStatementSuffixDropPartitions() throws RecognitionException {
        HiveParser.alterStatementSuffixDropPartitions_return retval = new HiveParser.alterStatementSuffixDropPartitions_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP224=null;
        Token COMMA227=null;
        HiveParser_IdentifiersParser.identifier_return identifier223 =null;

        HiveParser.ifExists_return ifExists225 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec226 =null;

        HiveParser_IdentifiersParser.dropPartitionSpec_return dropPartitionSpec228 =null;

        HiveParser.ignoreProtection_return ignoreProtection229 =null;


        CommonTree KW_DROP224_tree=null;
        CommonTree COMMA227_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_dropPartitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule dropPartitionSpec");
        RewriteRuleSubtreeStream stream_ignoreProtection=new RewriteRuleSubtreeStream(adaptor,"rule ignoreProtection");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("drop partition statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:5: ( identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )? -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:7: identifier KW_DROP ( ifExists )? dropPartitionSpec ( COMMA dropPartitionSpec )* ( ignoreProtection )?
            {
            pushFollow(FOLLOW_identifier_in_alterStatementSuffixDropPartitions4475);
            identifier223=identifier();

            state._fsp--;

            stream_identifier.add(identifier223.getTree());

            KW_DROP224=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_alterStatementSuffixDropPartitions4477);  
            stream_KW_DROP.add(KW_DROP224);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:26: ( ifExists )?
            int alt63=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt63=1;
                    }
                    break;
            }

            switch (alt63) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:26: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_alterStatementSuffixDropPartitions4479);
                    ifExists225=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists225.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4482);
            dropPartitionSpec226=dropPartitionSpec();

            state._fsp--;

            stream_dropPartitionSpec.add(dropPartitionSpec226.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:54: ( COMMA dropPartitionSpec )*
            loop64:
            do {
                int alt64=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt64=1;
                    }
                    break;

                }

                switch (alt64) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:55: COMMA dropPartitionSpec
            	    {
            	    COMMA227=(Token)match(input,COMMA,FOLLOW_COMMA_in_alterStatementSuffixDropPartitions4485);  
            	    stream_COMMA.add(COMMA227);


            	    pushFollow(FOLLOW_dropPartitionSpec_in_alterStatementSuffixDropPartitions4487);
            	    dropPartitionSpec228=dropPartitionSpec();

            	    state._fsp--;

            	    stream_dropPartitionSpec.add(dropPartitionSpec228.getTree());

            	    }
            	    break;

            	default :
            	    break loop64;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:81: ( ignoreProtection )?
            int alt65=2;
            switch ( input.LA(1) ) {
                case KW_IGNORE:
                    {
                    alt65=1;
                    }
                    break;
            }

            switch (alt65) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1008:81: ignoreProtection
                    {
                    pushFollow(FOLLOW_ignoreProtection_in_alterStatementSuffixDropPartitions4491);
                    ignoreProtection229=ignoreProtection();

                    state._fsp--;

                    stream_ignoreProtection.add(ignoreProtection229.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: ignoreProtection, dropPartitionSpec, ifExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1009:5: -> ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1009:8: ^( TOK_ALTERTABLE_DROPPARTS identifier ( dropPartitionSpec )+ ( ifExists )? ( ignoreProtection )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_DROPPARTS, "TOK_ALTERTABLE_DROPPARTS")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                if ( !(stream_dropPartitionSpec.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_dropPartitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_dropPartitionSpec.nextTree());

                }
                stream_dropPartitionSpec.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1009:65: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1009:75: ( ignoreProtection )?
                if ( stream_ignoreProtection.hasNext() ) {
                    adaptor.addChild(root_1, stream_ignoreProtection.nextTree());

                }
                stream_ignoreProtection.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixDropPartitions"


    public static class alterStatementSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1012:1: alterStatementSuffixProperties : (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? ) );
    public final HiveParser.alterStatementSuffixProperties_return alterStatementSuffixProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixProperties_return retval = new HiveParser.alterStatementSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET230=null;
        Token KW_TBLPROPERTIES231=null;
        Token KW_UNSET233=null;
        Token KW_TBLPROPERTIES234=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableProperties_return tableProperties232 =null;

        HiveParser.ifExists_return ifExists235 =null;

        HiveParser.tableProperties_return tableProperties236 =null;


        CommonTree KW_SET230_tree=null;
        CommonTree KW_TBLPROPERTIES231_tree=null;
        CommonTree KW_UNSET233_tree=null;
        CommonTree KW_TBLPROPERTIES234_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("alter properties statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1015:5: (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? ) )
            int alt67=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt67=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt67=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 67, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt67=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt67=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 67, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 67, 0, input);

                throw nvae;

            }

            switch (alt67) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1015:7: name= identifier KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixProperties4542);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_SET230=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixProperties4544);  
                    stream_KW_SET.add(KW_SET230);


                    KW_TBLPROPERTIES231=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties4546);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES231);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties4548);
                    tableProperties232=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties232.getTree());

                    // AST REWRITE
                    // elements: tableProperties, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1016:5: -> ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1016:8: ^( TOK_ALTERTABLE_PROPERTIES $name tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_PROPERTIES, "TOK_ALTERTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:7: name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixProperties4573);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_UNSET233=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterStatementSuffixProperties4575);  
                    stream_KW_UNSET.add(KW_UNSET233);


                    KW_TBLPROPERTIES234=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterStatementSuffixProperties4577);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES234);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:49: ( ifExists )?
                    int alt66=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt66=1;
                            }
                            break;
                    }

                    switch (alt66) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1017:49: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterStatementSuffixProperties4579);
                            ifExists235=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists235.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixProperties4582);
                    tableProperties236=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties236.getTree());

                    // AST REWRITE
                    // elements: tableProperties, name, ifExists
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1018:5: -> ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1018:8: ^( TOK_DROPTABLE_PROPERTIES $name tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DROPTABLE_PROPERTIES, "TOK_DROPTABLE_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1018:57: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProperties"


    public static class alterViewSuffixProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterViewSuffixProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1021:1: alterViewSuffixProperties : (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? ) );
    public final HiveParser.alterViewSuffixProperties_return alterViewSuffixProperties() throws RecognitionException {
        HiveParser.alterViewSuffixProperties_return retval = new HiveParser.alterViewSuffixProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET237=null;
        Token KW_TBLPROPERTIES238=null;
        Token KW_UNSET240=null;
        Token KW_TBLPROPERTIES241=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableProperties_return tableProperties239 =null;

        HiveParser.ifExists_return ifExists242 =null;

        HiveParser.tableProperties_return tableProperties243 =null;


        CommonTree KW_SET237_tree=null;
        CommonTree KW_TBLPROPERTIES238_tree=null;
        CommonTree KW_UNSET240_tree=null;
        CommonTree KW_TBLPROPERTIES241_tree=null;
        RewriteRuleTokenStream stream_KW_UNSET=new RewriteRuleTokenStream(adaptor,"token KW_UNSET");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("alter view properties statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1024:5: (name= identifier KW_SET KW_TBLPROPERTIES tableProperties -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties ) |name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? ) )
            int alt69=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt69=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt69=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 69, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SET:
                    {
                    alt69=1;
                    }
                    break;
                case KW_UNSET:
                    {
                    alt69=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 69, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }

            switch (alt69) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1024:7: name= identifier KW_SET KW_TBLPROPERTIES tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterViewSuffixProperties4629);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_SET237=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterViewSuffixProperties4631);  
                    stream_KW_SET.add(KW_SET237);


                    KW_TBLPROPERTIES238=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties4633);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES238);


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties4635);
                    tableProperties239=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties239.getTree());

                    // AST REWRITE
                    // elements: tableProperties, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1025:5: -> ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1025:8: ^( TOK_ALTERVIEW_PROPERTIES $name tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERVIEW_PROPERTIES, "TOK_ALTERVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:7: name= identifier KW_UNSET KW_TBLPROPERTIES ( ifExists )? tableProperties
                    {
                    pushFollow(FOLLOW_identifier_in_alterViewSuffixProperties4660);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_UNSET240=(Token)match(input,KW_UNSET,FOLLOW_KW_UNSET_in_alterViewSuffixProperties4662);  
                    stream_KW_UNSET.add(KW_UNSET240);


                    KW_TBLPROPERTIES241=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_alterViewSuffixProperties4664);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES241);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:49: ( ifExists )?
                    int alt68=2;
                    switch ( input.LA(1) ) {
                        case KW_IF:
                            {
                            alt68=1;
                            }
                            break;
                    }

                    switch (alt68) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1026:49: ifExists
                            {
                            pushFollow(FOLLOW_ifExists_in_alterViewSuffixProperties4666);
                            ifExists242=ifExists();

                            state._fsp--;

                            stream_ifExists.add(ifExists242.getTree());

                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableProperties_in_alterViewSuffixProperties4669);
                    tableProperties243=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties243.getTree());

                    // AST REWRITE
                    // elements: ifExists, tableProperties, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1027:5: -> ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1027:8: ^( TOK_DROPVIEW_PROPERTIES $name tableProperties ( ifExists )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DROPVIEW_PROPERTIES, "TOK_DROPVIEW_PROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1027:56: ( ifExists )?
                        if ( stream_ifExists.hasNext() ) {
                            adaptor.addChild(root_1, stream_ifExists.nextTree());

                        }
                        stream_ifExists.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterViewSuffixProperties"


    public static class alterStatementSuffixSerdeProperties_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSerdeProperties"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1030:1: alterStatementSuffixSerdeProperties : ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) );
    public final HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties() throws RecognitionException {
        HiveParser.alterStatementSuffixSerdeProperties_return retval = new HiveParser.alterStatementSuffixSerdeProperties_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token serdeName=null;
        Token KW_SET244=null;
        Token KW_SERDE245=null;
        Token KW_WITH246=null;
        Token KW_SERDEPROPERTIES247=null;
        Token KW_SET249=null;
        Token KW_SERDEPROPERTIES250=null;
        HiveParser.tableProperties_return tableProperties248 =null;

        HiveParser.tableProperties_return tableProperties251 =null;


        CommonTree serdeName_tree=null;
        CommonTree KW_SET244_tree=null;
        CommonTree KW_SERDE245_tree=null;
        CommonTree KW_WITH246_tree=null;
        CommonTree KW_SERDEPROPERTIES247_tree=null;
        CommonTree KW_SET249_tree=null;
        CommonTree KW_SERDEPROPERTIES250_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_SERDE=new RewriteRuleTokenStream(adaptor,"token KW_SERDE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_SERDEPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_SERDEPROPERTIES");
        RewriteRuleSubtreeStream stream_tableProperties=new RewriteRuleSubtreeStream(adaptor,"rule tableProperties");
         msgs.push("alter serdes statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:5: ( KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )? -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? ) | KW_SET KW_SERDEPROPERTIES tableProperties -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties ) )
            int alt71=2;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_SERDE:
                    {
                    alt71=1;
                    }
                    break;
                case KW_SERDEPROPERTIES:
                    {
                    alt71=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 71, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;

            }

            switch (alt71) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:7: KW_SET KW_SERDE serdeName= StringLiteral ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    {
                    KW_SET244=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties4714);  
                    stream_KW_SET.add(KW_SET244);


                    KW_SERDE245=(Token)match(input,KW_SERDE,FOLLOW_KW_SERDE_in_alterStatementSuffixSerdeProperties4716);  
                    stream_KW_SERDE.add(KW_SERDE245);


                    serdeName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixSerdeProperties4720);  
                    stream_StringLiteral.add(serdeName);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:47: ( KW_WITH KW_SERDEPROPERTIES tableProperties )?
                    int alt70=2;
                    switch ( input.LA(1) ) {
                        case KW_WITH:
                            {
                            alt70=1;
                            }
                            break;
                    }

                    switch (alt70) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1033:48: KW_WITH KW_SERDEPROPERTIES tableProperties
                            {
                            KW_WITH246=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixSerdeProperties4723);  
                            stream_KW_WITH.add(KW_WITH246);


                            KW_SERDEPROPERTIES247=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties4725);  
                            stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES247);


                            pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties4727);
                            tableProperties248=tableProperties();

                            state._fsp--;

                            stream_tableProperties.add(tableProperties248.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: serdeName, tableProperties
                    // token labels: serdeName
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_serdeName=new RewriteRuleTokenStream(adaptor,"token serdeName",serdeName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1034:5: -> ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:8: ^( TOK_ALTERTABLE_SERIALIZER $serdeName ( tableProperties )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERIALIZER, "TOK_ALTERTABLE_SERIALIZER")
                        , root_1);

                        adaptor.addChild(root_1, stream_serdeName.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1034:47: ( tableProperties )?
                        if ( stream_tableProperties.hasNext() ) {
                            adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        }
                        stream_tableProperties.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1035:7: KW_SET KW_SERDEPROPERTIES tableProperties
                    {
                    KW_SET249=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixSerdeProperties4753);  
                    stream_KW_SET.add(KW_SET249);


                    KW_SERDEPROPERTIES250=(Token)match(input,KW_SERDEPROPERTIES,FOLLOW_KW_SERDEPROPERTIES_in_alterStatementSuffixSerdeProperties4755);  
                    stream_KW_SERDEPROPERTIES.add(KW_SERDEPROPERTIES250);


                    pushFollow(FOLLOW_tableProperties_in_alterStatementSuffixSerdeProperties4757);
                    tableProperties251=tableProperties();

                    state._fsp--;

                    stream_tableProperties.add(tableProperties251.getTree());

                    // AST REWRITE
                    // elements: tableProperties
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1036:5: -> ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1036:8: ^( TOK_ALTERTABLE_SERDEPROPERTIES tableProperties )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SERDEPROPERTIES, "TOK_ALTERTABLE_SERDEPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableProperties.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSerdeProperties"


    public static class tablePartitionPrefix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tablePartitionPrefix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1039:1: tablePartitionPrefix : name= identifier ( partitionSpec )? -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? ) ;
    public final HiveParser.tablePartitionPrefix_return tablePartitionPrefix() throws RecognitionException {
        HiveParser.tablePartitionPrefix_return retval = new HiveParser.tablePartitionPrefix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec252 =null;


        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("table partition prefix");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:3: (name= identifier ( partitionSpec )? -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:4: name= identifier ( partitionSpec )?
            {
            pushFollow(FOLLOW_identifier_in_tablePartitionPrefix4795);
            name=identifier();

            state._fsp--;

            stream_identifier.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:20: ( partitionSpec )?
            int alt72=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt72=1;
                    }
                    break;
            }

            switch (alt72) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1042:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_tablePartitionPrefix4797);
                    partitionSpec252=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec252.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, name
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1043:3: -> ^( TOK_TABLE_PARTITION $name ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1043:5: ^( TOK_TABLE_PARTITION $name ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLE_PARTITION, "TOK_TABLE_PARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1043:33: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tablePartitionPrefix"


    public static class alterTblPartitionStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1046:1: alterTblPartitionStatement : ( tablePartitionPrefix alterTblPartitionStatementSuffix -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix ) | Identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_ALTERPARTS Identifier columnNameType ) );
    public final HiveParser.alterTblPartitionStatement_return alterTblPartitionStatement() throws RecognitionException {
        HiveParser.alterTblPartitionStatement_return retval = new HiveParser.alterTblPartitionStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token Identifier255=null;
        Token KW_PARTITION256=null;
        Token KW_COLUMN257=null;
        Token LPAREN258=null;
        Token RPAREN260=null;
        HiveParser.tablePartitionPrefix_return tablePartitionPrefix253 =null;

        HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix254 =null;

        HiveParser.columnNameType_return columnNameType259 =null;


        CommonTree Identifier255_tree=null;
        CommonTree KW_PARTITION256_tree=null;
        CommonTree KW_COLUMN257_tree=null;
        CommonTree LPAREN258_tree=null;
        CommonTree RPAREN260_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_COLUMN=new RewriteRuleTokenStream(adaptor,"token KW_COLUMN");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_PARTITION=new RewriteRuleTokenStream(adaptor,"token KW_PARTITION");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameType=new RewriteRuleSubtreeStream(adaptor,"rule columnNameType");
        RewriteRuleSubtreeStream stream_alterTblPartitionStatementSuffix=new RewriteRuleSubtreeStream(adaptor,"rule alterTblPartitionStatementSuffix");
        RewriteRuleSubtreeStream stream_tablePartitionPrefix=new RewriteRuleSubtreeStream(adaptor,"rule tablePartitionPrefix");
        msgs.push("alter table partition statement");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1049:3: ( tablePartitionPrefix alterTblPartitionStatementSuffix -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix ) | Identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN -> ^( TOK_ALTERTABLE_ALTERPARTS Identifier columnNameType ) )
            int alt73=2;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_PARTITION:
                    {
                    switch ( input.LA(3) ) {
                    case KW_COLUMN:
                        {
                        alt73=2;
                        }
                        break;
                    case LPAREN:
                        {
                        alt73=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 73, 3, input);

                        throw nvae;

                    }

                    }
                    break;
                case KW_CLUSTERED:
                case KW_CONCATENATE:
                case KW_DISABLE:
                case KW_ENABLE:
                case KW_INTO:
                case KW_NOT:
                case KW_RENAME:
                case KW_SET:
                    {
                    alt73=1;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 73, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt73=1;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;

            }

            switch (alt73) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1049:5: tablePartitionPrefix alterTblPartitionStatementSuffix
                    {
                    pushFollow(FOLLOW_tablePartitionPrefix_in_alterTblPartitionStatement4834);
                    tablePartitionPrefix253=tablePartitionPrefix();

                    state._fsp--;

                    stream_tablePartitionPrefix.add(tablePartitionPrefix253.getTree());

                    pushFollow(FOLLOW_alterTblPartitionStatementSuffix_in_alterTblPartitionStatement4836);
                    alterTblPartitionStatementSuffix254=alterTblPartitionStatementSuffix();

                    state._fsp--;

                    stream_alterTblPartitionStatementSuffix.add(alterTblPartitionStatementSuffix254.getTree());

                    // AST REWRITE
                    // elements: tablePartitionPrefix, alterTblPartitionStatementSuffix
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1050:3: -> ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1050:6: ^( TOK_ALTERTABLE_PARTITION tablePartitionPrefix alterTblPartitionStatementSuffix )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_PARTITION, "TOK_ALTERTABLE_PARTITION")
                        , root_1);

                        adaptor.addChild(root_1, stream_tablePartitionPrefix.nextTree());

                        adaptor.addChild(root_1, stream_alterTblPartitionStatementSuffix.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1051:4: Identifier KW_PARTITION KW_COLUMN LPAREN columnNameType RPAREN
                    {
                    Identifier255=(Token)match(input,Identifier,FOLLOW_Identifier_in_alterTblPartitionStatement4853);  
                    stream_Identifier.add(Identifier255);


                    KW_PARTITION256=(Token)match(input,KW_PARTITION,FOLLOW_KW_PARTITION_in_alterTblPartitionStatement4855);  
                    stream_KW_PARTITION.add(KW_PARTITION256);


                    KW_COLUMN257=(Token)match(input,KW_COLUMN,FOLLOW_KW_COLUMN_in_alterTblPartitionStatement4857);  
                    stream_KW_COLUMN.add(KW_COLUMN257);


                    LPAREN258=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_alterTblPartitionStatement4859);  
                    stream_LPAREN.add(LPAREN258);


                    pushFollow(FOLLOW_columnNameType_in_alterTblPartitionStatement4861);
                    columnNameType259=columnNameType();

                    state._fsp--;

                    stream_columnNameType.add(columnNameType259.getTree());

                    RPAREN260=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_alterTblPartitionStatement4863);  
                    stream_RPAREN.add(RPAREN260);


                    // AST REWRITE
                    // elements: Identifier, columnNameType
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1052:3: -> ^( TOK_ALTERTABLE_ALTERPARTS Identifier columnNameType )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1052:6: ^( TOK_ALTERTABLE_ALTERPARTS Identifier columnNameType )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_ALTERPARTS, "TOK_ALTERTABLE_ALTERPARTS")
                        , root_1);

                        adaptor.addChild(root_1, 
                        stream_Identifier.nextNode()
                        );

                        adaptor.addChild(root_1, stream_columnNameType.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatement"


    public static class alterTblPartitionStatementSuffix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffix"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1055:1: alterTblPartitionStatementSuffix : ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby );
    public final HiveParser.alterTblPartitionStatementSuffix_return alterTblPartitionStatementSuffix() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffix_return retval = new HiveParser.alterTblPartitionStatementSuffix_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat261 =null;

        HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation262 =null;

        HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode263 =null;

        HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles264 =null;

        HiveParser.alterStatementSuffixSerdeProperties_return alterStatementSuffixSerdeProperties265 =null;

        HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart266 =null;

        HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum267 =null;

        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation268 =null;

        HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby269 =null;



        msgs.push("alter table partition statement suffix");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:3: ( alterStatementSuffixFileFormat | alterStatementSuffixLocation | alterStatementSuffixProtectMode | alterStatementSuffixMergeFiles | alterStatementSuffixSerdeProperties | alterStatementSuffixRenamePart | alterStatementSuffixBucketNum | alterTblPartitionStatementSuffixSkewedLocation | alterStatementSuffixClusterbySortby )
            int alt74=9;
            switch ( input.LA(1) ) {
            case KW_SET:
                {
                switch ( input.LA(2) ) {
                case KW_FILEFORMAT:
                    {
                    alt74=1;
                    }
                    break;
                case KW_LOCATION:
                    {
                    alt74=2;
                    }
                    break;
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                    {
                    alt74=5;
                    }
                    break;
                case KW_SKEWED:
                    {
                    alt74=8;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 74, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DISABLE:
            case KW_ENABLE:
                {
                alt74=3;
                }
                break;
            case KW_CONCATENATE:
                {
                alt74=4;
                }
                break;
            case KW_RENAME:
                {
                alt74=6;
                }
                break;
            case KW_INTO:
                {
                alt74=7;
                }
                break;
            case KW_CLUSTERED:
            case KW_NOT:
                {
                alt74=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }

            switch (alt74) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1058:5: alterStatementSuffixFileFormat
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixFileFormat_in_alterTblPartitionStatementSuffix4898);
                    alterStatementSuffixFileFormat261=alterStatementSuffixFileFormat();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixFileFormat261.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1059:5: alterStatementSuffixLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixLocation_in_alterTblPartitionStatementSuffix4904);
                    alterStatementSuffixLocation262=alterStatementSuffixLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixLocation262.getTree());

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1060:5: alterStatementSuffixProtectMode
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixProtectMode_in_alterTblPartitionStatementSuffix4910);
                    alterStatementSuffixProtectMode263=alterStatementSuffixProtectMode();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixProtectMode263.getTree());

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1061:5: alterStatementSuffixMergeFiles
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixMergeFiles_in_alterTblPartitionStatementSuffix4916);
                    alterStatementSuffixMergeFiles264=alterStatementSuffixMergeFiles();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixMergeFiles264.getTree());

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1062:5: alterStatementSuffixSerdeProperties
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixSerdeProperties_in_alterTblPartitionStatementSuffix4922);
                    alterStatementSuffixSerdeProperties265=alterStatementSuffixSerdeProperties();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixSerdeProperties265.getTree());

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1063:5: alterStatementSuffixRenamePart
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixRenamePart_in_alterTblPartitionStatementSuffix4928);
                    alterStatementSuffixRenamePart266=alterStatementSuffixRenamePart();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixRenamePart266.getTree());

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1064:5: alterStatementSuffixBucketNum
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixBucketNum_in_alterTblPartitionStatementSuffix4934);
                    alterStatementSuffixBucketNum267=alterStatementSuffixBucketNum();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixBucketNum267.getTree());

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1065:5: alterTblPartitionStatementSuffixSkewedLocation
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterTblPartitionStatementSuffixSkewedLocation_in_alterTblPartitionStatementSuffix4940);
                    alterTblPartitionStatementSuffixSkewedLocation268=alterTblPartitionStatementSuffixSkewedLocation();

                    state._fsp--;

                    adaptor.addChild(root_0, alterTblPartitionStatementSuffixSkewedLocation268.getTree());

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1066:5: alterStatementSuffixClusterbySortby
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_alterStatementSuffixClusterbySortby_in_alterTblPartitionStatementSuffix4946);
                    alterStatementSuffixClusterbySortby269=alterStatementSuffixClusterbySortby();

                    state._fsp--;

                    adaptor.addChild(root_0, alterStatementSuffixClusterbySortby269.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffix"


    public static class alterStatementSuffixFileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixFileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1069:1: alterStatementSuffixFileFormat : KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) ;
    public final HiveParser.alterStatementSuffixFileFormat_return alterStatementSuffixFileFormat() throws RecognitionException {
        HiveParser.alterStatementSuffixFileFormat_return retval = new HiveParser.alterStatementSuffixFileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET270=null;
        Token KW_FILEFORMAT271=null;
        HiveParser.fileFormat_return fileFormat272 =null;


        CommonTree KW_SET270_tree=null;
        CommonTree KW_FILEFORMAT271_tree=null;
        RewriteRuleTokenStream stream_KW_FILEFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_FILEFORMAT");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_fileFormat=new RewriteRuleSubtreeStream(adaptor,"rule fileFormat");
        msgs.push("alter fileformat statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:2: ( KW_SET KW_FILEFORMAT fileFormat -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1072:4: KW_SET KW_FILEFORMAT fileFormat
            {
            KW_SET270=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixFileFormat4968);  
            stream_KW_SET.add(KW_SET270);


            KW_FILEFORMAT271=(Token)match(input,KW_FILEFORMAT,FOLLOW_KW_FILEFORMAT_in_alterStatementSuffixFileFormat4970);  
            stream_KW_FILEFORMAT.add(KW_FILEFORMAT271);


            pushFollow(FOLLOW_fileFormat_in_alterStatementSuffixFileFormat4972);
            fileFormat272=fileFormat();

            state._fsp--;

            stream_fileFormat.add(fileFormat272.getTree());

            // AST REWRITE
            // elements: fileFormat
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1073:2: -> ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1073:5: ^( TOK_ALTERTABLE_FILEFORMAT fileFormat )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_FILEFORMAT, "TOK_ALTERTABLE_FILEFORMAT")
                , root_1);

                adaptor.addChild(root_1, stream_fileFormat.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixFileFormat"


    public static class alterStatementSuffixClusterbySortby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixClusterbySortby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1076:1: alterStatementSuffixClusterbySortby : ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) );
    public final HiveParser.alterStatementSuffixClusterbySortby_return alterStatementSuffixClusterbySortby() throws RecognitionException {
        HiveParser.alterStatementSuffixClusterbySortby_return retval = new HiveParser.alterStatementSuffixClusterbySortby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT273=null;
        Token KW_CLUSTERED274=null;
        Token KW_NOT275=null;
        Token KW_SORTED276=null;
        HiveParser.tableBuckets_return tableBuckets277 =null;


        CommonTree KW_NOT273_tree=null;
        CommonTree KW_CLUSTERED274_tree=null;
        CommonTree KW_NOT275_tree=null;
        CommonTree KW_SORTED276_tree=null;
        RewriteRuleTokenStream stream_KW_CLUSTERED=new RewriteRuleTokenStream(adaptor,"token KW_CLUSTERED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleTokenStream stream_KW_SORTED=new RewriteRuleTokenStream(adaptor,"token KW_SORTED");
        RewriteRuleSubtreeStream stream_tableBuckets=new RewriteRuleSubtreeStream(adaptor,"rule tableBuckets");
        msgs.push("alter partition cluster by sort by statement");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:3: ( KW_NOT KW_CLUSTERED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED ) | KW_NOT KW_SORTED -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED ) | tableBuckets -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets ) )
            int alt75=3;
            switch ( input.LA(1) ) {
            case KW_NOT:
                {
                switch ( input.LA(2) ) {
                case KW_CLUSTERED:
                    {
                    alt75=1;
                    }
                    break;
                case KW_SORTED:
                    {
                    alt75=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 75, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_CLUSTERED:
                {
                alt75=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 75, 0, input);

                throw nvae;

            }

            switch (alt75) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:5: KW_NOT KW_CLUSTERED
                    {
                    KW_NOT273=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5003);  
                    stream_KW_NOT.add(KW_NOT273);


                    KW_CLUSTERED274=(Token)match(input,KW_CLUSTERED,FOLLOW_KW_CLUSTERED_in_alterStatementSuffixClusterbySortby5005);  
                    stream_KW_CLUSTERED.add(KW_CLUSTERED274);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1079:25: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1079:28: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_CLUSTERED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_CLUSTERED, "TOK_NOT_CLUSTERED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1080:5: KW_NOT KW_SORTED
                    {
                    KW_NOT275=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixClusterbySortby5019);  
                    stream_KW_NOT.add(KW_NOT275);


                    KW_SORTED276=(Token)match(input,KW_SORTED,FOLLOW_KW_SORTED_in_alterStatementSuffixClusterbySortby5021);  
                    stream_KW_SORTED.add(KW_SORTED276);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1080:22: -> ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1080:25: ^( TOK_ALTERTABLE_CLUSTER_SORT TOK_NOT_SORTED )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_NOT_SORTED, "TOK_NOT_SORTED")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:5: tableBuckets
                    {
                    pushFollow(FOLLOW_tableBuckets_in_alterStatementSuffixClusterbySortby5035);
                    tableBuckets277=tableBuckets();

                    state._fsp--;

                    stream_tableBuckets.add(tableBuckets277.getTree());

                    // AST REWRITE
                    // elements: tableBuckets
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1081:18: -> ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1081:21: ^( TOK_ALTERTABLE_CLUSTER_SORT tableBuckets )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_CLUSTER_SORT, "TOK_ALTERTABLE_CLUSTER_SORT")
                        , root_1);

                        adaptor.addChild(root_1, stream_tableBuckets.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixClusterbySortby"


    public static class alterTblPartitionStatementSuffixSkewedLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterTblPartitionStatementSuffixSkewedLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1084:1: alterTblPartitionStatementSuffixSkewedLocation : KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations ) ;
    public final HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return alterTblPartitionStatementSuffixSkewedLocation() throws RecognitionException {
        HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return retval = new HiveParser.alterTblPartitionStatementSuffixSkewedLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET278=null;
        Token KW_SKEWED279=null;
        Token KW_LOCATION280=null;
        HiveParser.skewedLocations_return skewedLocations281 =null;


        CommonTree KW_SET278_tree=null;
        CommonTree KW_SKEWED279_tree=null;
        CommonTree KW_LOCATION280_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");
        RewriteRuleSubtreeStream stream_skewedLocations=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocations");
        msgs.push("alter partition skewed location");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1087:3: ( KW_SET KW_SKEWED KW_LOCATION skewedLocations -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1087:5: KW_SET KW_SKEWED KW_LOCATION skewedLocations
            {
            KW_SET278=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterTblPartitionStatementSuffixSkewedLocation5066);  
            stream_KW_SET.add(KW_SET278);


            KW_SKEWED279=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterTblPartitionStatementSuffixSkewedLocation5068);  
            stream_KW_SKEWED.add(KW_SKEWED279);


            KW_LOCATION280=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterTblPartitionStatementSuffixSkewedLocation5070);  
            stream_KW_LOCATION.add(KW_LOCATION280);


            pushFollow(FOLLOW_skewedLocations_in_alterTblPartitionStatementSuffixSkewedLocation5072);
            skewedLocations281=skewedLocations();

            state._fsp--;

            stream_skewedLocations.add(skewedLocations281.getTree());

            // AST REWRITE
            // elements: skewedLocations
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1088:3: -> ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1088:6: ^( TOK_ALTERTBLPART_SKEWED_LOCATION skewedLocations )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTBLPART_SKEWED_LOCATION, "TOK_ALTERTBLPART_SKEWED_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocations.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterTblPartitionStatementSuffixSkewedLocation"


    public static class skewedLocations_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocations"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1091:1: skewedLocations : LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) ;
    public final HiveParser.skewedLocations_return skewedLocations() throws RecognitionException {
        HiveParser.skewedLocations_return retval = new HiveParser.skewedLocations_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN282=null;
        Token RPAREN284=null;
        HiveParser.skewedLocationsList_return skewedLocationsList283 =null;


        CommonTree LPAREN282_tree=null;
        CommonTree RPAREN284_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_skewedLocationsList=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationsList");
         msgs.push("skewed locations"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1094:5: ( LPAREN skewedLocationsList RPAREN -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:7: LPAREN skewedLocationsList RPAREN
            {
            LPAREN282=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_skewedLocations5115);  
            stream_LPAREN.add(LPAREN282);


            pushFollow(FOLLOW_skewedLocationsList_in_skewedLocations5117);
            skewedLocationsList283=skewedLocationsList();

            state._fsp--;

            stream_skewedLocationsList.add(skewedLocationsList283.getTree());

            RPAREN284=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_skewedLocations5119);  
            stream_RPAREN.add(RPAREN284);


            // AST REWRITE
            // elements: skewedLocationsList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1095:41: -> ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1095:44: ^( TOK_SKEWED_LOCATIONS skewedLocationsList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATIONS, "TOK_SKEWED_LOCATIONS")
                , root_1);

                adaptor.addChild(root_1, stream_skewedLocationsList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocations"


    public static class skewedLocationsList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationsList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1098:1: skewedLocationsList : skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) ;
    public final HiveParser.skewedLocationsList_return skewedLocationsList() throws RecognitionException {
        HiveParser.skewedLocationsList_return retval = new HiveParser.skewedLocationsList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA286=null;
        HiveParser.skewedLocationMap_return skewedLocationMap285 =null;

        HiveParser.skewedLocationMap_return skewedLocationMap287 =null;


        CommonTree COMMA286_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_skewedLocationMap=new RewriteRuleSubtreeStream(adaptor,"rule skewedLocationMap");
         msgs.push("skewed locations list"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1101:5: ( skewedLocationMap ( COMMA skewedLocationMap )* -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:7: skewedLocationMap ( COMMA skewedLocationMap )*
            {
            pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5160);
            skewedLocationMap285=skewedLocationMap();

            state._fsp--;

            stream_skewedLocationMap.add(skewedLocationMap285.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:25: ( COMMA skewedLocationMap )*
            loop76:
            do {
                int alt76=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt76=1;
                    }
                    break;

                }

                switch (alt76) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:26: COMMA skewedLocationMap
            	    {
            	    COMMA286=(Token)match(input,COMMA,FOLLOW_COMMA_in_skewedLocationsList5163);  
            	    stream_COMMA.add(COMMA286);


            	    pushFollow(FOLLOW_skewedLocationMap_in_skewedLocationsList5165);
            	    skewedLocationMap287=skewedLocationMap();

            	    state._fsp--;

            	    stream_skewedLocationMap.add(skewedLocationMap287.getTree());

            	    }
            	    break;

            	default :
            	    break loop76;
                }
            } while (true);


            // AST REWRITE
            // elements: skewedLocationMap
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1102:52: -> ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1102:55: ^( TOK_SKEWED_LOCATION_LIST ( skewedLocationMap )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_LIST, "TOK_SKEWED_LOCATION_LIST")
                , root_1);

                if ( !(stream_skewedLocationMap.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_skewedLocationMap.hasNext() ) {
                    adaptor.addChild(root_1, stream_skewedLocationMap.nextTree());

                }
                stream_skewedLocationMap.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationsList"


    public static class skewedLocationMap_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "skewedLocationMap"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1105:1: skewedLocationMap : key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) ;
    public final HiveParser.skewedLocationMap_return skewedLocationMap() throws RecognitionException {
        HiveParser.skewedLocationMap_return retval = new HiveParser.skewedLocationMap_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token value=null;
        Token EQUAL288=null;
        HiveParser.skewedValueLocationElement_return key =null;


        CommonTree value_tree=null;
        CommonTree EQUAL288_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
        RewriteRuleSubtreeStream stream_skewedValueLocationElement=new RewriteRuleSubtreeStream(adaptor,"rule skewedValueLocationElement");
         msgs.push("specifying skewed location map"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1108:5: (key= skewedValueLocationElement EQUAL value= StringLiteral -> ^( TOK_SKEWED_LOCATION_MAP $key $value) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:7: key= skewedValueLocationElement EQUAL value= StringLiteral
            {
            pushFollow(FOLLOW_skewedValueLocationElement_in_skewedLocationMap5211);
            key=skewedValueLocationElement();

            state._fsp--;

            stream_skewedValueLocationElement.add(key.getTree());

            EQUAL288=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_skewedLocationMap5213);  
            stream_EQUAL.add(EQUAL288);


            value=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_skewedLocationMap5217);  
            stream_StringLiteral.add(value);


            // AST REWRITE
            // elements: value, key
            // token labels: value
            // rule labels: retval, key
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_value=new RewriteRuleTokenStream(adaptor,"token value",value);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_key=new RewriteRuleSubtreeStream(adaptor,"rule key",key!=null?key.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1109:64: -> ^( TOK_SKEWED_LOCATION_MAP $key $value)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1109:67: ^( TOK_SKEWED_LOCATION_MAP $key $value)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SKEWED_LOCATION_MAP, "TOK_SKEWED_LOCATION_MAP")
                , root_1);

                adaptor.addChild(root_1, stream_key.nextTree());

                adaptor.addChild(root_1, stream_value.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "skewedLocationMap"


    public static class alterStatementSuffixLocation_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixLocation"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1112:1: alterStatementSuffixLocation : KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) ;
    public final HiveParser.alterStatementSuffixLocation_return alterStatementSuffixLocation() throws RecognitionException {
        HiveParser.alterStatementSuffixLocation_return retval = new HiveParser.alterStatementSuffixLocation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token newLoc=null;
        Token KW_SET289=null;
        Token KW_LOCATION290=null;

        CommonTree newLoc_tree=null;
        CommonTree KW_SET289_tree=null;
        CommonTree KW_LOCATION290_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleTokenStream stream_KW_LOCATION=new RewriteRuleTokenStream(adaptor,"token KW_LOCATION");

        msgs.push("alter location");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1115:3: ( KW_SET KW_LOCATION newLoc= StringLiteral -> ^( TOK_ALTERTABLE_LOCATION $newLoc) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1115:5: KW_SET KW_LOCATION newLoc= StringLiteral
            {
            KW_SET289=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_alterStatementSuffixLocation5254);  
            stream_KW_SET.add(KW_SET289);


            KW_LOCATION290=(Token)match(input,KW_LOCATION,FOLLOW_KW_LOCATION_in_alterStatementSuffixLocation5256);  
            stream_KW_LOCATION.add(KW_LOCATION290);


            newLoc=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_alterStatementSuffixLocation5260);  
            stream_StringLiteral.add(newLoc);


            // AST REWRITE
            // elements: newLoc
            // token labels: newLoc
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_newLoc=new RewriteRuleTokenStream(adaptor,"token newLoc",newLoc);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1116:3: -> ^( TOK_ALTERTABLE_LOCATION $newLoc)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1116:6: ^( TOK_ALTERTABLE_LOCATION $newLoc)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_LOCATION, "TOK_ALTERTABLE_LOCATION")
                , root_1);

                adaptor.addChild(root_1, stream_newLoc.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixLocation"


    public static class alterStatementSuffixSkewedby_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixSkewedby"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1120:1: alterStatementSuffixSkewedby : (name= identifier tableSkewed -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed ) |name= identifier KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED $name) |name= identifier KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs ) );
    public final HiveParser.alterStatementSuffixSkewedby_return alterStatementSuffixSkewedby() throws RecognitionException {
        HiveParser.alterStatementSuffixSkewedby_return retval = new HiveParser.alterStatementSuffixSkewedby_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_NOT292=null;
        Token KW_SKEWED293=null;
        Token KW_NOT294=null;
        HiveParser_IdentifiersParser.identifier_return name =null;

        HiveParser.tableSkewed_return tableSkewed291 =null;

        HiveParser.storedAsDirs_return storedAsDirs295 =null;


        CommonTree KW_NOT292_tree=null;
        CommonTree KW_SKEWED293_tree=null;
        CommonTree KW_NOT294_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_KW_NOT=new RewriteRuleTokenStream(adaptor,"token KW_NOT");
        RewriteRuleSubtreeStream stream_storedAsDirs=new RewriteRuleSubtreeStream(adaptor,"rule storedAsDirs");
        RewriteRuleSubtreeStream stream_tableSkewed=new RewriteRuleSubtreeStream(adaptor,"rule tableSkewed");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("alter skewed by statement");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1123:2: (name= identifier tableSkewed -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed ) |name= identifier KW_NOT KW_SKEWED -> ^( TOK_ALTERTABLE_SKEWED $name) |name= identifier KW_NOT storedAsDirs -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs ) )
            int alt77=3;
            switch ( input.LA(1) ) {
            case Identifier:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt77=1;
                    }
                    break;
                case KW_NOT:
                    {
                    switch ( input.LA(3) ) {
                    case KW_SKEWED:
                        {
                        alt77=2;
                        }
                        break;
                    case KW_STORED:
                        {
                        alt77=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 77, 4, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 77, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                switch ( input.LA(2) ) {
                case KW_SKEWED:
                    {
                    alt77=1;
                    }
                    break;
                case KW_NOT:
                    {
                    switch ( input.LA(3) ) {
                    case KW_SKEWED:
                        {
                        alt77=2;
                        }
                        break;
                    case KW_STORED:
                        {
                        alt77=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 77, 6, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 77, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;

            }

            switch (alt77) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1123:3: name= identifier tableSkewed
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5295);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    pushFollow(FOLLOW_tableSkewed_in_alterStatementSuffixSkewedby5297);
                    tableSkewed291=tableSkewed();

                    state._fsp--;

                    stream_tableSkewed.add(tableSkewed291.getTree());

                    // AST REWRITE
                    // elements: tableSkewed, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1124:2: -> ^( TOK_ALTERTABLE_SKEWED $name tableSkewed )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1124:4: ^( TOK_ALTERTABLE_SKEWED $name tableSkewed )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_tableSkewed.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1126:2: name= identifier KW_NOT KW_SKEWED
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5316);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_NOT292=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5318);  
                    stream_KW_NOT.add(KW_NOT292);


                    KW_SKEWED293=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_alterStatementSuffixSkewedby5320);  
                    stream_KW_SKEWED.add(KW_SKEWED293);


                    // AST REWRITE
                    // elements: name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1127:2: -> ^( TOK_ALTERTABLE_SKEWED $name)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1127:4: ^( TOK_ALTERTABLE_SKEWED $name)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1129:2: name= identifier KW_NOT storedAsDirs
                    {
                    pushFollow(FOLLOW_identifier_in_alterStatementSuffixSkewedby5337);
                    name=identifier();

                    state._fsp--;

                    stream_identifier.add(name.getTree());

                    KW_NOT294=(Token)match(input,KW_NOT,FOLLOW_KW_NOT_in_alterStatementSuffixSkewedby5339);  
                    stream_KW_NOT.add(KW_NOT294);


                    pushFollow(FOLLOW_storedAsDirs_in_alterStatementSuffixSkewedby5341);
                    storedAsDirs295=storedAsDirs();

                    state._fsp--;

                    stream_storedAsDirs.add(storedAsDirs295.getTree());

                    // AST REWRITE
                    // elements: storedAsDirs, name
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1130:2: -> ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1130:4: ^( TOK_ALTERTABLE_SKEWED $name storedAsDirs )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ALTERTABLE_SKEWED, "TOK_ALTERTABLE_SKEWED")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        adaptor.addChild(root_1, stream_storedAsDirs.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixSkewedby"


    public static class alterStatementSuffixExchangePartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixExchangePartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1133:1: alterStatementSuffixExchangePartition : name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename) ;
    public final HiveParser.alterStatementSuffixExchangePartition_return alterStatementSuffixExchangePartition() throws RecognitionException {
        HiveParser.alterStatementSuffixExchangePartition_return retval = new HiveParser.alterStatementSuffixExchangePartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_EXCHANGE296=null;
        Token KW_WITH298=null;
        Token KW_TABLE299=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser_FromClauseParser.tableName_return exchangename =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec297 =null;


        CommonTree KW_EXCHANGE296_tree=null;
        CommonTree KW_WITH298_tree=null;
        CommonTree KW_TABLE299_tree=null;
        RewriteRuleTokenStream stream_KW_EXCHANGE=new RewriteRuleTokenStream(adaptor,"token KW_EXCHANGE");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        msgs.push("alter exchange partition");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1136:5: (name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1136:7: name= tableName KW_EXCHANGE partitionSpec KW_WITH KW_TABLE exchangename= tableName
            {
            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5377);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            KW_EXCHANGE296=(Token)match(input,KW_EXCHANGE,FOLLOW_KW_EXCHANGE_in_alterStatementSuffixExchangePartition5379);  
            stream_KW_EXCHANGE.add(KW_EXCHANGE296);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixExchangePartition5381);
            partitionSpec297=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec297.getTree());

            KW_WITH298=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_alterStatementSuffixExchangePartition5383);  
            stream_KW_WITH.add(KW_WITH298);


            KW_TABLE299=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_alterStatementSuffixExchangePartition5385);  
            stream_KW_TABLE.add(KW_TABLE299);


            pushFollow(FOLLOW_tableName_in_alterStatementSuffixExchangePartition5389);
            exchangename=tableName();

            state._fsp--;

            stream_tableName.add(exchangename.getTree());

            // AST REWRITE
            // elements: exchangename, name, partitionSpec
            // token labels: 
            // rule labels: exchangename, retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_exchangename=new RewriteRuleSubtreeStream(adaptor,"rule exchangename",exchangename!=null?exchangename.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1137:5: -> ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1137:8: ^( TOK_EXCHANGEPARTITION $name partitionSpec $exchangename)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_EXCHANGEPARTITION, "TOK_EXCHANGEPARTITION")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_1, stream_exchangename.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixExchangePartition"


    public static class alterStatementSuffixProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1140:1: alterStatementSuffixProtectMode : alterProtectMode -> ^( TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE alterProtectMode ) ;
    public final HiveParser.alterStatementSuffixProtectMode_return alterStatementSuffixProtectMode() throws RecognitionException {
        HiveParser.alterStatementSuffixProtectMode_return retval = new HiveParser.alterStatementSuffixProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.alterProtectMode_return alterProtectMode300 =null;


        RewriteRuleSubtreeStream stream_alterProtectMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectMode");
         msgs.push("alter partition protect mode statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:5: ( alterProtectMode -> ^( TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE alterProtectMode ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1143:7: alterProtectMode
            {
            pushFollow(FOLLOW_alterProtectMode_in_alterStatementSuffixProtectMode5434);
            alterProtectMode300=alterProtectMode();

            state._fsp--;

            stream_alterProtectMode.add(alterProtectMode300.getTree());

            // AST REWRITE
            // elements: alterProtectMode
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1144:5: -> ^( TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE alterProtectMode )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1144:8: ^( TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE alterProtectMode )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE, "TOK_ALTERTABLE_ALTERPARTS_PROTECTMODE")
                , root_1);

                adaptor.addChild(root_1, stream_alterProtectMode.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixProtectMode"


    public static class alterStatementSuffixRenamePart_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixRenamePart"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1147:1: alterStatementSuffixRenamePart : KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) ;
    public final HiveParser.alterStatementSuffixRenamePart_return alterStatementSuffixRenamePart() throws RecognitionException {
        HiveParser.alterStatementSuffixRenamePart_return retval = new HiveParser.alterStatementSuffixRenamePart_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_RENAME301=null;
        Token KW_TO302=null;
        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec303 =null;


        CommonTree KW_RENAME301_tree=null;
        CommonTree KW_TO302_tree=null;
        RewriteRuleTokenStream stream_KW_RENAME=new RewriteRuleTokenStream(adaptor,"token KW_RENAME");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         msgs.push("alter table rename partition statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1150:5: ( KW_RENAME KW_TO partitionSpec -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1150:7: KW_RENAME KW_TO partitionSpec
            {
            KW_RENAME301=(Token)match(input,KW_RENAME,FOLLOW_KW_RENAME_in_alterStatementSuffixRenamePart5473);  
            stream_KW_RENAME.add(KW_RENAME301);


            KW_TO302=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_alterStatementSuffixRenamePart5475);  
            stream_KW_TO.add(KW_TO302);


            pushFollow(FOLLOW_partitionSpec_in_alterStatementSuffixRenamePart5477);
            partitionSpec303=partitionSpec();

            state._fsp--;

            stream_partitionSpec.add(partitionSpec303.getTree());

            // AST REWRITE
            // elements: partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1151:5: -> ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1151:7: ^( TOK_ALTERTABLE_RENAMEPART partitionSpec )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_RENAMEPART, "TOK_ALTERTABLE_RENAMEPART")
                , root_1);

                adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixRenamePart"


    public static class alterStatementSuffixMergeFiles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixMergeFiles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1154:1: alterStatementSuffixMergeFiles : KW_CONCATENATE -> ^( TOK_ALTERTABLE_ALTERPARTS_MERGEFILES ) ;
    public final HiveParser.alterStatementSuffixMergeFiles_return alterStatementSuffixMergeFiles() throws RecognitionException {
        HiveParser.alterStatementSuffixMergeFiles_return retval = new HiveParser.alterStatementSuffixMergeFiles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CONCATENATE304=null;

        CommonTree KW_CONCATENATE304_tree=null;
        RewriteRuleTokenStream stream_KW_CONCATENATE=new RewriteRuleTokenStream(adaptor,"token KW_CONCATENATE");

         msgs.push(""); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1157:5: ( KW_CONCATENATE -> ^( TOK_ALTERTABLE_ALTERPARTS_MERGEFILES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1157:7: KW_CONCATENATE
            {
            KW_CONCATENATE304=(Token)match(input,KW_CONCATENATE,FOLLOW_KW_CONCATENATE_in_alterStatementSuffixMergeFiles5515);  
            stream_KW_CONCATENATE.add(KW_CONCATENATE304);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1158:5: -> ^( TOK_ALTERTABLE_ALTERPARTS_MERGEFILES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1158:8: ^( TOK_ALTERTABLE_ALTERPARTS_MERGEFILES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ALTERTABLE_ALTERPARTS_MERGEFILES, "TOK_ALTERTABLE_ALTERPARTS_MERGEFILES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixMergeFiles"


    public static class alterProtectMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1161:1: alterProtectMode : ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) );
    public final HiveParser.alterProtectMode_return alterProtectMode() throws RecognitionException {
        HiveParser.alterProtectMode_return retval = new HiveParser.alterProtectMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ENABLE305=null;
        Token KW_DISABLE307=null;
        HiveParser.alterProtectModeMode_return alterProtectModeMode306 =null;

        HiveParser.alterProtectModeMode_return alterProtectModeMode308 =null;


        CommonTree KW_ENABLE305_tree=null;
        CommonTree KW_DISABLE307_tree=null;
        RewriteRuleTokenStream stream_KW_DISABLE=new RewriteRuleTokenStream(adaptor,"token KW_DISABLE");
        RewriteRuleTokenStream stream_KW_ENABLE=new RewriteRuleTokenStream(adaptor,"token KW_ENABLE");
        RewriteRuleSubtreeStream stream_alterProtectModeMode=new RewriteRuleSubtreeStream(adaptor,"rule alterProtectModeMode");
         msgs.push("protect mode specification enable"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1164:5: ( KW_ENABLE alterProtectModeMode -> ^( TOK_ENABLE alterProtectModeMode ) | KW_DISABLE alterProtectModeMode -> ^( TOK_DISABLE alterProtectModeMode ) )
            int alt78=2;
            switch ( input.LA(1) ) {
            case KW_ENABLE:
                {
                alt78=1;
                }
                break;
            case KW_DISABLE:
                {
                alt78=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }

            switch (alt78) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1164:7: KW_ENABLE alterProtectModeMode
                    {
                    KW_ENABLE305=(Token)match(input,KW_ENABLE,FOLLOW_KW_ENABLE_in_alterProtectMode5552);  
                    stream_KW_ENABLE.add(KW_ENABLE305);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5554);
                    alterProtectModeMode306=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode306.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1164:39: -> ^( TOK_ENABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1164:42: ^( TOK_ENABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ENABLE, "TOK_ENABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:7: KW_DISABLE alterProtectModeMode
                    {
                    KW_DISABLE307=(Token)match(input,KW_DISABLE,FOLLOW_KW_DISABLE_in_alterProtectMode5571);  
                    stream_KW_DISABLE.add(KW_DISABLE307);


                    pushFollow(FOLLOW_alterProtectModeMode_in_alterProtectMode5573);
                    alterProtectModeMode308=alterProtectModeMode();

                    state._fsp--;

                    stream_alterProtectModeMode.add(alterProtectModeMode308.getTree());

                    // AST REWRITE
                    // elements: alterProtectModeMode
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1165:40: -> ^( TOK_DISABLE alterProtectModeMode )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1165:43: ^( TOK_DISABLE alterProtectModeMode )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DISABLE, "TOK_DISABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_alterProtectModeMode.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectMode"


    public static class alterProtectModeMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterProtectModeMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1168:1: alterProtectModeMode : ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) );
    public final HiveParser.alterProtectModeMode_return alterProtectModeMode() throws RecognitionException {
        HiveParser.alterProtectModeMode_return retval = new HiveParser.alterProtectModeMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_OFFLINE309=null;
        Token KW_NO_DROP310=null;
        Token KW_CASCADE311=null;
        Token KW_READONLY312=null;

        CommonTree KW_OFFLINE309_tree=null;
        CommonTree KW_NO_DROP310_tree=null;
        CommonTree KW_CASCADE311_tree=null;
        CommonTree KW_READONLY312_tree=null;
        RewriteRuleTokenStream stream_KW_READONLY=new RewriteRuleTokenStream(adaptor,"token KW_READONLY");
        RewriteRuleTokenStream stream_KW_NO_DROP=new RewriteRuleTokenStream(adaptor,"token KW_NO_DROP");
        RewriteRuleTokenStream stream_KW_CASCADE=new RewriteRuleTokenStream(adaptor,"token KW_CASCADE");
        RewriteRuleTokenStream stream_KW_OFFLINE=new RewriteRuleTokenStream(adaptor,"token KW_OFFLINE");

         msgs.push("protect mode specification enable"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:5: ( KW_OFFLINE -> ^( TOK_OFFLINE ) | KW_NO_DROP ( KW_CASCADE )? -> ^( TOK_NO_DROP ( KW_CASCADE )? ) | KW_READONLY -> ^( TOK_READONLY ) )
            int alt80=3;
            switch ( input.LA(1) ) {
            case KW_OFFLINE:
                {
                alt80=1;
                }
                break;
            case KW_NO_DROP:
                {
                alt80=2;
                }
                break;
            case KW_READONLY:
                {
                alt80=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;

            }

            switch (alt80) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:7: KW_OFFLINE
                    {
                    KW_OFFLINE309=(Token)match(input,KW_OFFLINE,FOLLOW_KW_OFFLINE_in_alterProtectModeMode5609);  
                    stream_KW_OFFLINE.add(KW_OFFLINE309);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1171:19: -> ^( TOK_OFFLINE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1171:22: ^( TOK_OFFLINE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_OFFLINE, "TOK_OFFLINE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:7: KW_NO_DROP ( KW_CASCADE )?
                    {
                    KW_NO_DROP310=(Token)match(input,KW_NO_DROP,FOLLOW_KW_NO_DROP_in_alterProtectModeMode5624);  
                    stream_KW_NO_DROP.add(KW_NO_DROP310);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:18: ( KW_CASCADE )?
                    int alt79=2;
                    switch ( input.LA(1) ) {
                        case KW_CASCADE:
                            {
                            alt79=1;
                            }
                            break;
                    }

                    switch (alt79) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:18: KW_CASCADE
                            {
                            KW_CASCADE311=(Token)match(input,KW_CASCADE,FOLLOW_KW_CASCADE_in_alterProtectModeMode5626);  
                            stream_KW_CASCADE.add(KW_CASCADE311);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: KW_CASCADE
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1172:30: -> ^( TOK_NO_DROP ( KW_CASCADE )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:33: ^( TOK_NO_DROP ( KW_CASCADE )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_NO_DROP, "TOK_NO_DROP")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1172:47: ( KW_CASCADE )?
                        if ( stream_KW_CASCADE.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_CASCADE.nextNode()
                            );

                        }
                        stream_KW_CASCADE.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1173:7: KW_READONLY
                    {
                    KW_READONLY312=(Token)match(input,KW_READONLY,FOLLOW_KW_READONLY_in_alterProtectModeMode5644);  
                    stream_KW_READONLY.add(KW_READONLY312);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1173:20: -> ^( TOK_READONLY )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1173:23: ^( TOK_READONLY )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_READONLY, "TOK_READONLY")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterProtectModeMode"


    public static class alterStatementSuffixBucketNum_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "alterStatementSuffixBucketNum"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1176:1: alterStatementSuffixBucketNum : KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $num) ;
    public final HiveParser.alterStatementSuffixBucketNum_return alterStatementSuffixBucketNum() throws RecognitionException {
        HiveParser.alterStatementSuffixBucketNum_return retval = new HiveParser.alterStatementSuffixBucketNum_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token num=null;
        Token KW_INTO313=null;
        Token KW_BUCKETS314=null;

        CommonTree num_tree=null;
        CommonTree KW_INTO313_tree=null;
        CommonTree KW_BUCKETS314_tree=null;
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_Number=new RewriteRuleTokenStream(adaptor,"token Number");
        RewriteRuleTokenStream stream_KW_BUCKETS=new RewriteRuleTokenStream(adaptor,"token KW_BUCKETS");

         msgs.push(""); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:5: ( KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $num) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1179:7: KW_INTO num= Number KW_BUCKETS
            {
            KW_INTO313=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_alterStatementSuffixBucketNum5678);  
            stream_KW_INTO.add(KW_INTO313);


            num=(Token)match(input,Number,FOLLOW_Number_in_alterStatementSuffixBucketNum5682);  
            stream_Number.add(num);


            KW_BUCKETS314=(Token)match(input,KW_BUCKETS,FOLLOW_KW_BUCKETS_in_alterStatementSuffixBucketNum5684);  
            stream_KW_BUCKETS.add(KW_BUCKETS314);


            // AST REWRITE
            // elements: num
            // token labels: num
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_num=new RewriteRuleTokenStream(adaptor,"token num",num);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1180:5: -> ^( TOK_TABLEBUCKETS $num)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1180:8: ^( TOK_TABLEBUCKETS $num)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLEBUCKETS, "TOK_TABLEBUCKETS")
                , root_1);

                adaptor.addChild(root_1, stream_num.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "alterStatementSuffixBucketNum"


    public static class fileFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fileFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1183:1: fileFormat : ( KW_SEQUENCEFILE -> ^( TOK_TBLSEQUENCEFILE ) | KW_TEXTFILE -> ^( TOK_TBLTEXTFILE ) | KW_RCFILE -> ^( TOK_TBLRCFILE ) | KW_ORCFILE -> ^( TOK_TBLORCFILE ) | KW_PARQUETFILE -> ^( TOK_TBLPARQUETFILE ) | KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) );
    public final HiveParser.fileFormat_return fileFormat() throws RecognitionException {
        HiveParser.fileFormat_return retval = new HiveParser.fileFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token inFmt=null;
        Token outFmt=null;
        Token inDriver=null;
        Token outDriver=null;
        Token KW_SEQUENCEFILE315=null;
        Token KW_TEXTFILE316=null;
        Token KW_RCFILE317=null;
        Token KW_ORCFILE318=null;
        Token KW_PARQUETFILE319=null;
        Token KW_INPUTFORMAT320=null;
        Token KW_OUTPUTFORMAT321=null;
        Token KW_INPUTDRIVER322=null;
        Token KW_OUTPUTDRIVER323=null;
        HiveParser_IdentifiersParser.identifier_return genericSpec =null;


        CommonTree inFmt_tree=null;
        CommonTree outFmt_tree=null;
        CommonTree inDriver_tree=null;
        CommonTree outDriver_tree=null;
        CommonTree KW_SEQUENCEFILE315_tree=null;
        CommonTree KW_TEXTFILE316_tree=null;
        CommonTree KW_RCFILE317_tree=null;
        CommonTree KW_ORCFILE318_tree=null;
        CommonTree KW_PARQUETFILE319_tree=null;
        CommonTree KW_INPUTFORMAT320_tree=null;
        CommonTree KW_OUTPUTFORMAT321_tree=null;
        CommonTree KW_INPUTDRIVER322_tree=null;
        CommonTree KW_OUTPUTDRIVER323_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_INPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_INPUTDRIVER");
        RewriteRuleTokenStream stream_KW_RCFILE=new RewriteRuleTokenStream(adaptor,"token KW_RCFILE");
        RewriteRuleTokenStream stream_KW_INPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_INPUTFORMAT");
        RewriteRuleTokenStream stream_KW_OUTPUTFORMAT=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTFORMAT");
        RewriteRuleTokenStream stream_KW_PARQUETFILE=new RewriteRuleTokenStream(adaptor,"token KW_PARQUETFILE");
        RewriteRuleTokenStream stream_KW_OUTPUTDRIVER=new RewriteRuleTokenStream(adaptor,"token KW_OUTPUTDRIVER");
        RewriteRuleTokenStream stream_KW_SEQUENCEFILE=new RewriteRuleTokenStream(adaptor,"token KW_SEQUENCEFILE");
        RewriteRuleTokenStream stream_KW_ORCFILE=new RewriteRuleTokenStream(adaptor,"token KW_ORCFILE");
        RewriteRuleTokenStream stream_KW_TEXTFILE=new RewriteRuleTokenStream(adaptor,"token KW_TEXTFILE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("file format specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:5: ( KW_SEQUENCEFILE -> ^( TOK_TBLSEQUENCEFILE ) | KW_TEXTFILE -> ^( TOK_TBLTEXTFILE ) | KW_RCFILE -> ^( TOK_TBLRCFILE ) | KW_ORCFILE -> ^( TOK_TBLORCFILE ) | KW_PARQUETFILE -> ^( TOK_TBLPARQUETFILE ) | KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )? -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? ) |genericSpec= identifier -> ^( TOK_FILEFORMAT_GENERIC $genericSpec) )
            int alt82=7;
            switch ( input.LA(1) ) {
            case KW_SEQUENCEFILE:
                {
                alt82=1;
                }
                break;
            case KW_TEXTFILE:
                {
                alt82=2;
                }
                break;
            case KW_RCFILE:
                {
                alt82=3;
                }
                break;
            case KW_ORCFILE:
                {
                alt82=4;
                }
                break;
            case KW_PARQUETFILE:
                {
                alt82=5;
                }
                break;
            case KW_INPUTFORMAT:
                {
                switch ( input.LA(2) ) {
                case StringLiteral:
                    {
                    alt82=6;
                    }
                    break;
                case EOF:
                    {
                    alt82=7;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 82, 6, input);

                    throw nvae;

                }

                }
                break;
            case Identifier:
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt82=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;

            }

            switch (alt82) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:7: KW_SEQUENCEFILE
                    {
                    KW_SEQUENCEFILE315=(Token)match(input,KW_SEQUENCEFILE,FOLLOW_KW_SEQUENCEFILE_in_fileFormat5724);  
                    stream_KW_SEQUENCEFILE.add(KW_SEQUENCEFILE315);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1186:24: -> ^( TOK_TBLSEQUENCEFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1186:27: ^( TOK_TBLSEQUENCEFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLSEQUENCEFILE, "TOK_TBLSEQUENCEFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1187:7: KW_TEXTFILE
                    {
                    KW_TEXTFILE316=(Token)match(input,KW_TEXTFILE,FOLLOW_KW_TEXTFILE_in_fileFormat5739);  
                    stream_KW_TEXTFILE.add(KW_TEXTFILE316);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1187:20: -> ^( TOK_TBLTEXTFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1187:23: ^( TOK_TBLTEXTFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLTEXTFILE, "TOK_TBLTEXTFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:7: KW_RCFILE
                    {
                    KW_RCFILE317=(Token)match(input,KW_RCFILE,FOLLOW_KW_RCFILE_in_fileFormat5754);  
                    stream_KW_RCFILE.add(KW_RCFILE317);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1188:18: -> ^( TOK_TBLRCFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1188:21: ^( TOK_TBLRCFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLRCFILE, "TOK_TBLRCFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1189:7: KW_ORCFILE
                    {
                    KW_ORCFILE318=(Token)match(input,KW_ORCFILE,FOLLOW_KW_ORCFILE_in_fileFormat5769);  
                    stream_KW_ORCFILE.add(KW_ORCFILE318);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1189:18: -> ^( TOK_TBLORCFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1189:21: ^( TOK_TBLORCFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLORCFILE, "TOK_TBLORCFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1190:7: KW_PARQUETFILE
                    {
                    KW_PARQUETFILE319=(Token)match(input,KW_PARQUETFILE,FOLLOW_KW_PARQUETFILE_in_fileFormat5783);  
                    stream_KW_PARQUETFILE.add(KW_PARQUETFILE319);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1190:22: -> ^( TOK_TBLPARQUETFILE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1190:25: ^( TOK_TBLPARQUETFILE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TBLPARQUETFILE, "TOK_TBLPARQUETFILE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1191:7: KW_INPUTFORMAT inFmt= StringLiteral KW_OUTPUTFORMAT outFmt= StringLiteral ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    {
                    KW_INPUTFORMAT320=(Token)match(input,KW_INPUTFORMAT,FOLLOW_KW_INPUTFORMAT_in_fileFormat5797);  
                    stream_KW_INPUTFORMAT.add(KW_INPUTFORMAT320);


                    inFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat5801);  
                    stream_StringLiteral.add(inFmt);


                    KW_OUTPUTFORMAT321=(Token)match(input,KW_OUTPUTFORMAT,FOLLOW_KW_OUTPUTFORMAT_in_fileFormat5803);  
                    stream_KW_OUTPUTFORMAT.add(KW_OUTPUTFORMAT321);


                    outFmt=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat5807);  
                    stream_StringLiteral.add(outFmt);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1191:79: ( KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral )?
                    int alt81=2;
                    switch ( input.LA(1) ) {
                        case KW_INPUTDRIVER:
                            {
                            alt81=1;
                            }
                            break;
                    }

                    switch (alt81) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1191:80: KW_INPUTDRIVER inDriver= StringLiteral KW_OUTPUTDRIVER outDriver= StringLiteral
                            {
                            KW_INPUTDRIVER322=(Token)match(input,KW_INPUTDRIVER,FOLLOW_KW_INPUTDRIVER_in_fileFormat5810);  
                            stream_KW_INPUTDRIVER.add(KW_INPUTDRIVER322);


                            inDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat5814);  
                            stream_StringLiteral.add(inDriver);


                            KW_OUTPUTDRIVER323=(Token)match(input,KW_OUTPUTDRIVER,FOLLOW_KW_OUTPUTDRIVER_in_fileFormat5816);  
                            stream_KW_OUTPUTDRIVER.add(KW_OUTPUTDRIVER323);


                            outDriver=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_fileFormat5820);  
                            stream_StringLiteral.add(outDriver);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: inDriver, outFmt, inFmt, outDriver
                    // token labels: outDriver, outFmt, inDriver, inFmt
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_outDriver=new RewriteRuleTokenStream(adaptor,"token outDriver",outDriver);
                    RewriteRuleTokenStream stream_outFmt=new RewriteRuleTokenStream(adaptor,"token outFmt",outFmt);
                    RewriteRuleTokenStream stream_inDriver=new RewriteRuleTokenStream(adaptor,"token inDriver",inDriver);
                    RewriteRuleTokenStream stream_inFmt=new RewriteRuleTokenStream(adaptor,"token inFmt",inFmt);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1192:7: -> ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1192:10: ^( TOK_TABLEFILEFORMAT $inFmt $outFmt ( $inDriver)? ( $outDriver)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_TABLEFILEFORMAT, "TOK_TABLEFILEFORMAT")
                        , root_1);

                        adaptor.addChild(root_1, stream_inFmt.nextNode());

                        adaptor.addChild(root_1, stream_outFmt.nextNode());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1192:48: ( $inDriver)?
                        if ( stream_inDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_inDriver.nextNode());

                        }
                        stream_inDriver.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1192:59: ( $outDriver)?
                        if ( stream_outDriver.hasNext() ) {
                            adaptor.addChild(root_1, stream_outDriver.nextNode());

                        }
                        stream_outDriver.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1193:7: genericSpec= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_fileFormat5858);
                    genericSpec=identifier();

                    state._fsp--;

                    stream_identifier.add(genericSpec.getTree());

                    // AST REWRITE
                    // elements: genericSpec
                    // token labels: 
                    // rule labels: retval, genericSpec
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_genericSpec=new RewriteRuleSubtreeStream(adaptor,"rule genericSpec",genericSpec!=null?genericSpec.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1193:30: -> ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1193:33: ^( TOK_FILEFORMAT_GENERIC $genericSpec)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_FILEFORMAT_GENERIC, "TOK_FILEFORMAT_GENERIC")
                        , root_1);

                        adaptor.addChild(root_1, stream_genericSpec.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fileFormat"


    public static class tabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1196:1: tabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ;
    public final HiveParser.tabTypeExpr_return tabTypeExpr() throws RecognitionException {
        HiveParser.tabTypeExpr_return retval = new HiveParser.tabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT325=null;
        Token KW_ELEM_TYPE326=null;
        Token KW_KEY_TYPE327=null;
        Token KW_VALUE_TYPE328=null;
        HiveParser_IdentifiersParser.identifier_return identifier324 =null;

        HiveParser_IdentifiersParser.identifier_return identifier329 =null;


        CommonTree DOT325_tree=null;
        CommonTree KW_ELEM_TYPE326_tree=null;
        CommonTree KW_KEY_TYPE327_tree=null;
        CommonTree KW_VALUE_TYPE328_tree=null;

         msgs.push("specifying table types"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_tabTypeExpr5894);
            identifier324=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier324.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop84:
            do {
                int alt84=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt84=1;
                    }
                    break;

                }

                switch (alt84) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT325=(Token)match(input,DOT,FOLLOW_DOT_in_tabTypeExpr5897); 
            	    DOT325_tree = 
            	    (CommonTree)adaptor.create(DOT325)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT325_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt83=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt83=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt83=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt83=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORCFILE:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_RCFILE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SEQUENCEFILE:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SERVER:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TEXTFILE:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_URI:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt83=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 83, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt83) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE326=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_tabTypeExpr5901); 
            	            KW_ELEM_TYPE326_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE326)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE326_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE327=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_tabTypeExpr5905); 
            	            KW_KEY_TYPE327_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE327)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE327_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE328=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_tabTypeExpr5909); 
            	            KW_VALUE_TYPE328_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE328)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE328_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1200:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_tabTypeExpr5913);
            	            identifier329=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier329.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop84;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tabTypeExpr"


    public static class descTabTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descTabTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1203:1: descTabTypeExpr : identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? ;
    public final HiveParser.descTabTypeExpr_return descTabTypeExpr() throws RecognitionException {
        HiveParser.descTabTypeExpr_return retval = new HiveParser.descTabTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token DOT331=null;
        Token KW_ELEM_TYPE332=null;
        Token KW_KEY_TYPE333=null;
        Token KW_VALUE_TYPE334=null;
        HiveParser_IdentifiersParser.identifier_return identifier330 =null;

        HiveParser_IdentifiersParser.identifier_return identifier335 =null;

        HiveParser_IdentifiersParser.identifier_return identifier336 =null;


        CommonTree DOT331_tree=null;
        CommonTree KW_ELEM_TYPE332_tree=null;
        CommonTree KW_KEY_TYPE333_tree=null;
        CommonTree KW_VALUE_TYPE334_tree=null;

         msgs.push("specifying describe table types"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:4: ( identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )? )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:6: identifier ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )* ( identifier )?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_identifier_in_descTabTypeExpr5942);
            identifier330=identifier();

            state._fsp--;

            adaptor.addChild(root_0, identifier330.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:17: ( DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier ) )*
            loop86:
            do {
                int alt86=2;
                switch ( input.LA(1) ) {
                case DOT:
                    {
                    alt86=1;
                    }
                    break;

                }

                switch (alt86) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:18: DOT ^ ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    {
            	    DOT331=(Token)match(input,DOT,FOLLOW_DOT_in_descTabTypeExpr5945); 
            	    DOT331_tree = 
            	    (CommonTree)adaptor.create(DOT331)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT331_tree, root_0);


            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:23: ( KW_ELEM_TYPE | KW_KEY_TYPE | KW_VALUE_TYPE | identifier )
            	    int alt85=4;
            	    switch ( input.LA(1) ) {
            	    case KW_ELEM_TYPE:
            	        {
            	        alt85=1;
            	        }
            	        break;
            	    case KW_KEY_TYPE:
            	        {
            	        alt85=2;
            	        }
            	        break;
            	    case KW_VALUE_TYPE:
            	        {
            	        alt85=3;
            	        }
            	        break;
            	    case Identifier:
            	    case KW_ADD:
            	    case KW_AFTER:
            	    case KW_ALL:
            	    case KW_ALTER:
            	    case KW_ANALYZE:
            	    case KW_ARCHIVE:
            	    case KW_ARRAY:
            	    case KW_AS:
            	    case KW_ASC:
            	    case KW_BEFORE:
            	    case KW_BETWEEN:
            	    case KW_BIGINT:
            	    case KW_BINARY:
            	    case KW_BOOLEAN:
            	    case KW_BOTH:
            	    case KW_BUCKET:
            	    case KW_BUCKETS:
            	    case KW_BY:
            	    case KW_CASCADE:
            	    case KW_CHANGE:
            	    case KW_CLUSTER:
            	    case KW_CLUSTERED:
            	    case KW_CLUSTERSTATUS:
            	    case KW_COLLECTION:
            	    case KW_COLUMNS:
            	    case KW_COMMENT:
            	    case KW_COMPUTE:
            	    case KW_CONCATENATE:
            	    case KW_CONTINUE:
            	    case KW_CREATE:
            	    case KW_CUBE:
            	    case KW_CURSOR:
            	    case KW_DATA:
            	    case KW_DATABASES:
            	    case KW_DATE:
            	    case KW_DATETIME:
            	    case KW_DBPROPERTIES:
            	    case KW_DECIMAL:
            	    case KW_DEFAULT:
            	    case KW_DEFERRED:
            	    case KW_DEFINED:
            	    case KW_DELETE:
            	    case KW_DELIMITED:
            	    case KW_DEPENDENCY:
            	    case KW_DESC:
            	    case KW_DESCRIBE:
            	    case KW_DIRECTORIES:
            	    case KW_DIRECTORY:
            	    case KW_DISABLE:
            	    case KW_DISTRIBUTE:
            	    case KW_DOUBLE:
            	    case KW_DROP:
            	    case KW_ENABLE:
            	    case KW_ESCAPED:
            	    case KW_EXCLUSIVE:
            	    case KW_EXISTS:
            	    case KW_EXPLAIN:
            	    case KW_EXPORT:
            	    case KW_EXTERNAL:
            	    case KW_FALSE:
            	    case KW_FETCH:
            	    case KW_FIELDS:
            	    case KW_FILEFORMAT:
            	    case KW_FIRST:
            	    case KW_FLOAT:
            	    case KW_FOR:
            	    case KW_FORMAT:
            	    case KW_FORMATTED:
            	    case KW_FULL:
            	    case KW_FUNCTIONS:
            	    case KW_GRANT:
            	    case KW_GROUP:
            	    case KW_GROUPING:
            	    case KW_HOLD_DDLTIME:
            	    case KW_IDXPROPERTIES:
            	    case KW_IGNORE:
            	    case KW_IMPORT:
            	    case KW_IN:
            	    case KW_INDEX:
            	    case KW_INDEXES:
            	    case KW_INNER:
            	    case KW_INPATH:
            	    case KW_INPUTDRIVER:
            	    case KW_INPUTFORMAT:
            	    case KW_INSERT:
            	    case KW_INT:
            	    case KW_INTERSECT:
            	    case KW_INTO:
            	    case KW_IS:
            	    case KW_ITEMS:
            	    case KW_KEYS:
            	    case KW_LATERAL:
            	    case KW_LEFT:
            	    case KW_LIKE:
            	    case KW_LIMIT:
            	    case KW_LINES:
            	    case KW_LOAD:
            	    case KW_LOCAL:
            	    case KW_LOCATION:
            	    case KW_LOCK:
            	    case KW_LOCKS:
            	    case KW_LOGICAL:
            	    case KW_LONG:
            	    case KW_MAPJOIN:
            	    case KW_MATERIALIZED:
            	    case KW_MINUS:
            	    case KW_MSCK:
            	    case KW_NONE:
            	    case KW_NOSCAN:
            	    case KW_NO_DROP:
            	    case KW_NULL:
            	    case KW_OF:
            	    case KW_OFFLINE:
            	    case KW_OPTION:
            	    case KW_ORCFILE:
            	    case KW_ORDER:
            	    case KW_OUT:
            	    case KW_OUTER:
            	    case KW_OUTPUTDRIVER:
            	    case KW_OUTPUTFORMAT:
            	    case KW_OVERWRITE:
            	    case KW_PARTITION:
            	    case KW_PARTITIONED:
            	    case KW_PARTITIONS:
            	    case KW_PERCENT:
            	    case KW_PLUS:
            	    case KW_PRETTY:
            	    case KW_PROCEDURE:
            	    case KW_PROTECTION:
            	    case KW_PURGE:
            	    case KW_RANGE:
            	    case KW_RCFILE:
            	    case KW_READ:
            	    case KW_READONLY:
            	    case KW_READS:
            	    case KW_REBUILD:
            	    case KW_RECORDREADER:
            	    case KW_RECORDWRITER:
            	    case KW_REGEXP:
            	    case KW_RENAME:
            	    case KW_REPAIR:
            	    case KW_REPLACE:
            	    case KW_RESTRICT:
            	    case KW_REVOKE:
            	    case KW_RIGHT:
            	    case KW_RLIKE:
            	    case KW_ROLE:
            	    case KW_ROLES:
            	    case KW_ROLLUP:
            	    case KW_ROW:
            	    case KW_ROWS:
            	    case KW_SCHEMA:
            	    case KW_SCHEMAS:
            	    case KW_SEMI:
            	    case KW_SEQUENCEFILE:
            	    case KW_SERDE:
            	    case KW_SERDEPROPERTIES:
            	    case KW_SERVER:
            	    case KW_SET:
            	    case KW_SETS:
            	    case KW_SHARED:
            	    case KW_SHOW:
            	    case KW_SHOW_DATABASE:
            	    case KW_SKEWED:
            	    case KW_SMALLINT:
            	    case KW_SORT:
            	    case KW_SORTED:
            	    case KW_SSL:
            	    case KW_STATISTICS:
            	    case KW_STORED:
            	    case KW_STREAMTABLE:
            	    case KW_STRING:
            	    case KW_STRUCT:
            	    case KW_TABLE:
            	    case KW_TABLES:
            	    case KW_TBLPROPERTIES:
            	    case KW_TEMPORARY:
            	    case KW_TERMINATED:
            	    case KW_TEXTFILE:
            	    case KW_TIMESTAMP:
            	    case KW_TINYINT:
            	    case KW_TO:
            	    case KW_TOUCH:
            	    case KW_TRIGGER:
            	    case KW_TRUE:
            	    case KW_TRUNCATE:
            	    case KW_UNARCHIVE:
            	    case KW_UNDO:
            	    case KW_UNION:
            	    case KW_UNIONTYPE:
            	    case KW_UNLOCK:
            	    case KW_UNSET:
            	    case KW_UNSIGNED:
            	    case KW_UPDATE:
            	    case KW_URI:
            	    case KW_USE:
            	    case KW_USER:
            	    case KW_USING:
            	    case KW_UTC:
            	    case KW_UTCTIMESTAMP:
            	    case KW_VIEW:
            	    case KW_WHILE:
            	    case KW_WITH:
            	        {
            	        alt85=4;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 85, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt85) {
            	        case 1 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:24: KW_ELEM_TYPE
            	            {
            	            KW_ELEM_TYPE332=(Token)match(input,KW_ELEM_TYPE,FOLLOW_KW_ELEM_TYPE_in_descTabTypeExpr5949); 
            	            KW_ELEM_TYPE332_tree = 
            	            (CommonTree)adaptor.create(KW_ELEM_TYPE332)
            	            ;
            	            adaptor.addChild(root_0, KW_ELEM_TYPE332_tree);


            	            }
            	            break;
            	        case 2 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:39: KW_KEY_TYPE
            	            {
            	            KW_KEY_TYPE333=(Token)match(input,KW_KEY_TYPE,FOLLOW_KW_KEY_TYPE_in_descTabTypeExpr5953); 
            	            KW_KEY_TYPE333_tree = 
            	            (CommonTree)adaptor.create(KW_KEY_TYPE333)
            	            ;
            	            adaptor.addChild(root_0, KW_KEY_TYPE333_tree);


            	            }
            	            break;
            	        case 3 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:53: KW_VALUE_TYPE
            	            {
            	            KW_VALUE_TYPE334=(Token)match(input,KW_VALUE_TYPE,FOLLOW_KW_VALUE_TYPE_in_descTabTypeExpr5957); 
            	            KW_VALUE_TYPE334_tree = 
            	            (CommonTree)adaptor.create(KW_VALUE_TYPE334)
            	            ;
            	            adaptor.addChild(root_0, KW_VALUE_TYPE334_tree);


            	            }
            	            break;
            	        case 4 :
            	            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:69: identifier
            	            {
            	            pushFollow(FOLLOW_identifier_in_descTabTypeExpr5961);
            	            identifier335=identifier();

            	            state._fsp--;

            	            adaptor.addChild(root_0, identifier335.getTree());

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop86;
                }
            } while (true);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:83: ( identifier )?
            int alt87=2;
            switch ( input.LA(1) ) {
                case Identifier:
                case KW_ADD:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt87=1;
                    }
                    break;
                case KW_PARTITION:
                    {
                    switch ( input.LA(2) ) {
                        case EOF:
                        case KW_PARTITION:
                            {
                            alt87=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt87) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1207:83: identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descTabTypeExpr5966);
                    identifier336=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier336.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descTabTypeExpr"


    public static class partTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "partTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1210:1: partTypeExpr : tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.partTypeExpr_return partTypeExpr() throws RecognitionException {
        HiveParser.partTypeExpr_return retval = new HiveParser.partTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.tabTypeExpr_return tabTypeExpr337 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec338 =null;


        RewriteRuleSubtreeStream stream_tabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule tabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         msgs.push("specifying table partitions"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:5: ( tabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:8: tabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_tabTypeExpr_in_partTypeExpr5994);
            tabTypeExpr337=tabTypeExpr();

            state._fsp--;

            stream_tabTypeExpr.add(tabTypeExpr337.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:20: ( partitionSpec )?
            int alt88=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt88=1;
                    }
                    break;
            }

            switch (alt88) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:20: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_partTypeExpr5996);
                    partitionSpec338=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec338.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: partitionSpec, tabTypeExpr
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1213:35: -> ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:38: ^( TOK_TABTYPE tabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_tabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1213:64: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "partTypeExpr"


    public static class descPartTypeExpr_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descPartTypeExpr"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1216:1: descPartTypeExpr : descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) ;
    public final HiveParser.descPartTypeExpr_return descPartTypeExpr() throws RecognitionException {
        HiveParser.descPartTypeExpr_return retval = new HiveParser.descPartTypeExpr_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.descTabTypeExpr_return descTabTypeExpr339 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec340 =null;


        RewriteRuleSubtreeStream stream_descTabTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descTabTypeExpr");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         msgs.push("specifying describe table partitions"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:5: ( descTabTypeExpr ( partitionSpec )? -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:8: descTabTypeExpr ( partitionSpec )?
            {
            pushFollow(FOLLOW_descTabTypeExpr_in_descPartTypeExpr6036);
            descTabTypeExpr339=descTabTypeExpr();

            state._fsp--;

            stream_descTabTypeExpr.add(descTabTypeExpr339.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:24: ( partitionSpec )?
            int alt89=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt89=1;
                    }
                    break;
            }

            switch (alt89) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:24: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_descPartTypeExpr6038);
                    partitionSpec340=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec340.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: descTabTypeExpr, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1219:39: -> ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:42: ^( TOK_TABTYPE descTabTypeExpr ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABTYPE, "TOK_TABTYPE")
                , root_1);

                adaptor.addChild(root_1, stream_descTabTypeExpr.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1219:72: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descPartTypeExpr"


    public static class descStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1222:1: descStatement : ( ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) );
    public final HiveParser.descStatement_return descStatement() throws RecognitionException {
        HiveParser.descStatement_return retval = new HiveParser.descStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token descOptions=null;
        Token KW_DESCRIBE341=null;
        Token KW_DESC342=null;
        Token KW_DESCRIBE343=null;
        Token KW_DESC344=null;
        Token KW_FUNCTION345=null;
        Token KW_EXTENDED346=null;
        Token KW_DESCRIBE347=null;
        Token KW_DESC348=null;
        Token KW_DATABASE349=null;
        Token KW_EXTENDED350=null;
        HiveParser.descPartTypeExpr_return parttype =null;

        HiveParser_IdentifiersParser.descFuncNames_return name =null;

        HiveParser_IdentifiersParser.identifier_return dbName =null;


        CommonTree descOptions_tree=null;
        CommonTree KW_DESCRIBE341_tree=null;
        CommonTree KW_DESC342_tree=null;
        CommonTree KW_DESCRIBE343_tree=null;
        CommonTree KW_DESC344_tree=null;
        CommonTree KW_FUNCTION345_tree=null;
        CommonTree KW_EXTENDED346_tree=null;
        CommonTree KW_DESCRIBE347_tree=null;
        CommonTree KW_DESC348_tree=null;
        CommonTree KW_DATABASE349_tree=null;
        CommonTree KW_EXTENDED350_tree=null;
        RewriteRuleTokenStream stream_KW_DESC=new RewriteRuleTokenStream(adaptor,"token KW_DESC");
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_PRETTY=new RewriteRuleTokenStream(adaptor,"token KW_PRETTY");
        RewriteRuleTokenStream stream_KW_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token KW_DESCRIBE");
        RewriteRuleSubtreeStream stream_descPartTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule descPartTypeExpr");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_descFuncNames=new RewriteRuleSubtreeStream(adaptor,"rule descFuncNames");
         msgs.push("describe statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:5: ( ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr ) -> ^( TOK_DESCTABLE $parttype ( $descOptions)? ) | ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames ) -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? ) | ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier ) -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? ) )
            int alt96=3;
            switch ( input.LA(1) ) {
            case KW_DESCRIBE:
                {
                switch ( input.LA(2) ) {
                case Identifier:
                case KW_ADD:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt96=1;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt96=2;
                    }
                    break;
                case KW_DATABASE:
                    {
                    alt96=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 1, input);

                    throw nvae;

                }

                }
                break;
            case KW_DESC:
                {
                switch ( input.LA(2) ) {
                case Identifier:
                case KW_ADD:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTENDED:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt96=1;
                    }
                    break;
                case KW_FUNCTION:
                    {
                    alt96=2;
                    }
                    break;
                case KW_DATABASE:
                    {
                    alt96=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 96, 2, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;

            }

            switch (alt96) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:7: ( KW_DESCRIBE | KW_DESC ) (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )? (parttype= descPartTypeExpr )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:7: ( KW_DESCRIBE | KW_DESC )
                    int alt90=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt90=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt90=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 90, 0, input);

                        throw nvae;

                    }

                    switch (alt90) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE341=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6078);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE341);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:20: KW_DESC
                            {
                            KW_DESC342=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6080);  
                            stream_KW_DESC.add(KW_DESC342);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:29: (descOptions= KW_FORMATTED |descOptions= KW_EXTENDED |descOptions= KW_PRETTY )?
                    int alt91=4;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt91=1;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt91=1;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt91=1;
                                    }
                                    break;
                            }

                            }
                            break;
                        case KW_EXTENDED:
                            {
                            alt91=2;
                            }
                            break;
                        case KW_PRETTY:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                    {
                                    alt91=3;
                                    }
                                    break;
                                case KW_PARTITION:
                                    {
                                    alt91=3;
                                    }
                                    break;
                                case KW_ADD:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt91=3;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt91) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:30: descOptions= KW_FORMATTED
                            {
                            descOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_descStatement6086);  
                            stream_KW_FORMATTED.add(descOptions);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:55: descOptions= KW_EXTENDED
                            {
                            descOptions=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6090);  
                            stream_KW_EXTENDED.add(descOptions);


                            }
                            break;
                        case 3 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:79: descOptions= KW_PRETTY
                            {
                            descOptions=(Token)match(input,KW_PRETTY,FOLLOW_KW_PRETTY_in_descStatement6094);  
                            stream_KW_PRETTY.add(descOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:103: (parttype= descPartTypeExpr )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:104: parttype= descPartTypeExpr
                    {
                    pushFollow(FOLLOW_descPartTypeExpr_in_descStatement6101);
                    parttype=descPartTypeExpr();

                    state._fsp--;

                    stream_descPartTypeExpr.add(parttype.getTree());

                    }


                    // AST REWRITE
                    // elements: descOptions, parttype
                    // token labels: descOptions
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_descOptions=new RewriteRuleTokenStream(adaptor,"token descOptions",descOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1225:131: -> ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:134: ^( TOK_DESCTABLE $parttype ( $descOptions)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCTABLE, "TOK_DESCTABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_parttype.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1225:161: ( $descOptions)?
                        if ( stream_descOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_descOptions.nextNode());

                        }
                        stream_descOptions.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:7: ( KW_DESCRIBE | KW_DESC ) KW_FUNCTION ( KW_EXTENDED )? (name= descFuncNames )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:7: ( KW_DESCRIBE | KW_DESC )
                    int alt92=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt92=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt92=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 92, 0, input);

                        throw nvae;

                    }

                    switch (alt92) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE343=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6124);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE343);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:20: KW_DESC
                            {
                            KW_DESC344=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6126);  
                            stream_KW_DESC.add(KW_DESC344);


                            }
                            break;

                    }


                    KW_FUNCTION345=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_descStatement6129);  
                    stream_KW_FUNCTION.add(KW_FUNCTION345);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:41: ( KW_EXTENDED )?
                    int alt93=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt93=1;
                            }
                            break;
                    }

                    switch (alt93) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:41: KW_EXTENDED
                            {
                            KW_EXTENDED346=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6131);  
                            stream_KW_EXTENDED.add(KW_EXTENDED346);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:54: (name= descFuncNames )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:55: name= descFuncNames
                    {
                    pushFollow(FOLLOW_descFuncNames_in_descStatement6137);
                    name=descFuncNames();

                    state._fsp--;

                    stream_descFuncNames.add(name.getTree());

                    }


                    // AST REWRITE
                    // elements: name, KW_EXTENDED
                    // token labels: 
                    // rule labels: retval, name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1226:75: -> ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:78: ^( TOK_DESCFUNCTION $name ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCFUNCTION, "TOK_DESCFUNCTION")
                        , root_1);

                        adaptor.addChild(root_1, stream_name.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1226:103: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:7: ( KW_DESCRIBE | KW_DESC ) KW_DATABASE ( KW_EXTENDED )? (dbName= identifier )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:7: ( KW_DESCRIBE | KW_DESC )
                    int alt94=2;
                    switch ( input.LA(1) ) {
                    case KW_DESCRIBE:
                        {
                        alt94=1;
                        }
                        break;
                    case KW_DESC:
                        {
                        alt94=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 94, 0, input);

                        throw nvae;

                    }

                    switch (alt94) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:8: KW_DESCRIBE
                            {
                            KW_DESCRIBE347=(Token)match(input,KW_DESCRIBE,FOLLOW_KW_DESCRIBE_in_descStatement6159);  
                            stream_KW_DESCRIBE.add(KW_DESCRIBE347);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:20: KW_DESC
                            {
                            KW_DESC348=(Token)match(input,KW_DESC,FOLLOW_KW_DESC_in_descStatement6161);  
                            stream_KW_DESC.add(KW_DESC348);


                            }
                            break;

                    }


                    KW_DATABASE349=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_descStatement6164);  
                    stream_KW_DATABASE.add(KW_DATABASE349);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:41: ( KW_EXTENDED )?
                    int alt95=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt95=1;
                            }
                            break;
                    }

                    switch (alt95) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:41: KW_EXTENDED
                            {
                            KW_EXTENDED350=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_descStatement6166);  
                            stream_KW_EXTENDED.add(KW_EXTENDED350);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:54: (dbName= identifier )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:55: dbName= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_descStatement6172);
                    dbName=identifier();

                    state._fsp--;

                    stream_identifier.add(dbName.getTree());

                    }


                    // AST REWRITE
                    // elements: dbName, KW_EXTENDED
                    // token labels: 
                    // rule labels: retval, dbName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_dbName=new RewriteRuleSubtreeStream(adaptor,"rule dbName",dbName!=null?dbName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1227:74: -> ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:77: ^( TOK_DESCDATABASE $dbName ( KW_EXTENDED )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_DESCDATABASE, "TOK_DESCDATABASE")
                        , root_1);

                        adaptor.addChild(root_1, stream_dbName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1227:104: ( KW_EXTENDED )?
                        if ( stream_KW_EXTENDED.hasNext() ) {
                            adaptor.addChild(root_1, 
                            stream_KW_EXTENDED.nextNode()
                            );

                        }
                        stream_KW_EXTENDED.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descStatement"


    public static class analyzeStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "analyzeStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1230:1: analyzeStatement : KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? ) ;
    public final HiveParser.analyzeStatement_return analyzeStatement() throws RecognitionException {
        HiveParser.analyzeStatement_return retval = new HiveParser.analyzeStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token noscan=null;
        Token partialscan=null;
        Token KW_ANALYZE351=null;
        Token KW_TABLE352=null;
        Token KW_COMPUTE353=null;
        Token KW_STATISTICS354=null;
        Token KW_FOR355=null;
        Token KW_COLUMNS356=null;
        HiveParser_IdentifiersParser.tableOrPartition_return parttype =null;

        HiveParser.columnNameList_return statsColumnName =null;


        CommonTree noscan_tree=null;
        CommonTree partialscan_tree=null;
        CommonTree KW_ANALYZE351_tree=null;
        CommonTree KW_TABLE352_tree=null;
        CommonTree KW_COMPUTE353_tree=null;
        CommonTree KW_STATISTICS354_tree=null;
        CommonTree KW_FOR355_tree=null;
        CommonTree KW_COLUMNS356_tree=null;
        RewriteRuleTokenStream stream_KW_ANALYZE=new RewriteRuleTokenStream(adaptor,"token KW_ANALYZE");
        RewriteRuleTokenStream stream_KW_NOSCAN=new RewriteRuleTokenStream(adaptor,"token KW_NOSCAN");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_STATISTICS=new RewriteRuleTokenStream(adaptor,"token KW_STATISTICS");
        RewriteRuleTokenStream stream_KW_FOR=new RewriteRuleTokenStream(adaptor,"token KW_FOR");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_COMPUTE=new RewriteRuleTokenStream(adaptor,"token KW_COMPUTE");
        RewriteRuleTokenStream stream_KW_PARTIALSCAN=new RewriteRuleTokenStream(adaptor,"token KW_PARTIALSCAN");
        RewriteRuleSubtreeStream stream_tableOrPartition=new RewriteRuleSubtreeStream(adaptor,"rule tableOrPartition");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         msgs.push("analyze statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:5: ( KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )? -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:7: KW_ANALYZE KW_TABLE (parttype= tableOrPartition ) KW_COMPUTE KW_STATISTICS ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )?
            {
            KW_ANALYZE351=(Token)match(input,KW_ANALYZE,FOLLOW_KW_ANALYZE_in_analyzeStatement6212);  
            stream_KW_ANALYZE.add(KW_ANALYZE351);


            KW_TABLE352=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_analyzeStatement6214);  
            stream_KW_TABLE.add(KW_TABLE352);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:27: (parttype= tableOrPartition )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:28: parttype= tableOrPartition
            {
            pushFollow(FOLLOW_tableOrPartition_in_analyzeStatement6219);
            parttype=tableOrPartition();

            state._fsp--;

            stream_tableOrPartition.add(parttype.getTree());

            }


            KW_COMPUTE353=(Token)match(input,KW_COMPUTE,FOLLOW_KW_COMPUTE_in_analyzeStatement6222);  
            stream_KW_COMPUTE.add(KW_COMPUTE353);


            KW_STATISTICS354=(Token)match(input,KW_STATISTICS,FOLLOW_KW_STATISTICS_in_analyzeStatement6224);  
            stream_KW_STATISTICS.add(KW_STATISTICS354);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:80: ( (noscan= KW_NOSCAN ) | (partialscan= KW_PARTIALSCAN ) | ( KW_FOR KW_COLUMNS statsColumnName= columnNameList ) )?
            int alt97=4;
            switch ( input.LA(1) ) {
                case KW_NOSCAN:
                    {
                    alt97=1;
                    }
                    break;
                case KW_PARTIALSCAN:
                    {
                    alt97=2;
                    }
                    break;
                case KW_FOR:
                    {
                    alt97=3;
                    }
                    break;
            }

            switch (alt97) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:81: (noscan= KW_NOSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:81: (noscan= KW_NOSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:82: noscan= KW_NOSCAN
                    {
                    noscan=(Token)match(input,KW_NOSCAN,FOLLOW_KW_NOSCAN_in_analyzeStatement6230);  
                    stream_KW_NOSCAN.add(noscan);


                    }


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:102: (partialscan= KW_PARTIALSCAN )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:102: (partialscan= KW_PARTIALSCAN )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:103: partialscan= KW_PARTIALSCAN
                    {
                    partialscan=(Token)match(input,KW_PARTIALSCAN,FOLLOW_KW_PARTIALSCAN_in_analyzeStatement6238);  
                    stream_KW_PARTIALSCAN.add(partialscan);


                    }


                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:133: ( KW_FOR KW_COLUMNS statsColumnName= columnNameList )
                    {
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:133: ( KW_FOR KW_COLUMNS statsColumnName= columnNameList )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:134: KW_FOR KW_COLUMNS statsColumnName= columnNameList
                    {
                    KW_FOR355=(Token)match(input,KW_FOR,FOLLOW_KW_FOR_in_analyzeStatement6244);  
                    stream_KW_FOR.add(KW_FOR355);


                    KW_COLUMNS356=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_analyzeStatement6246);  
                    stream_KW_COLUMNS.add(KW_COLUMNS356);


                    pushFollow(FOLLOW_columnNameList_in_analyzeStatement6250);
                    statsColumnName=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(statsColumnName.getTree());

                    }


                    }
                    break;

            }


            // AST REWRITE
            // elements: statsColumnName, partialscan, noscan, parttype
            // token labels: partialscan, noscan
            // rule labels: retval, parttype, statsColumnName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_partialscan=new RewriteRuleTokenStream(adaptor,"token partialscan",partialscan);
            RewriteRuleTokenStream stream_noscan=new RewriteRuleTokenStream(adaptor,"token noscan",noscan);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);
            RewriteRuleSubtreeStream stream_statsColumnName=new RewriteRuleSubtreeStream(adaptor,"rule statsColumnName",statsColumnName!=null?statsColumnName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1233:186: -> ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:189: ^( TOK_ANALYZE $parttype ( $noscan)? ( $partialscan)? ( $statsColumnName)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_ANALYZE, "TOK_ANALYZE")
                , root_1);

                adaptor.addChild(root_1, stream_parttype.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:214: ( $noscan)?
                if ( stream_noscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_noscan.nextNode());

                }
                stream_noscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:223: ( $partialscan)?
                if ( stream_partialscan.hasNext() ) {
                    adaptor.addChild(root_1, stream_partialscan.nextNode());

                }
                stream_partialscan.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1233:237: ( $statsColumnName)?
                if ( stream_statsColumnName.hasNext() ) {
                    adaptor.addChild(root_1, stream_statsColumnName.nextTree());

                }
                stream_statsColumnName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "analyzeStatement"


    public static class showStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1236:1: showStatement : ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname) | KW_SHOW KW_FUNCTIONS ( showStmtIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( showStmtIdentifier )? ) | KW_SHOW KW_PARTITIONS identifier ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS identifier ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) );
    public final HiveParser.showStatement_return showStatement() throws RecognitionException {
        HiveParser.showStatement_return retval = new HiveParser.showStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token prptyName=null;
        Token isExtended=null;
        Token showOptions=null;
        Token KW_SHOW357=null;
        Token KW_DATABASES358=null;
        Token KW_SCHEMAS359=null;
        Token KW_LIKE360=null;
        Token KW_SHOW362=null;
        Token KW_TABLES363=null;
        Token KW_FROM364=null;
        Token KW_IN365=null;
        Token KW_LIKE366=null;
        Token KW_SHOW369=null;
        Token KW_COLUMNS370=null;
        Token KW_FROM371=null;
        Token KW_IN372=null;
        Token KW_FROM373=null;
        Token KW_IN374=null;
        Token KW_SHOW375=null;
        Token KW_FUNCTIONS376=null;
        Token KW_SHOW378=null;
        Token KW_PARTITIONS379=null;
        Token KW_SHOW382=null;
        Token KW_CREATE383=null;
        Token KW_TABLE384=null;
        Token KW_SHOW385=null;
        Token KW_TABLE386=null;
        Token KW_EXTENDED387=null;
        Token KW_FROM388=null;
        Token KW_IN389=null;
        Token KW_LIKE390=null;
        Token KW_SHOW393=null;
        Token KW_TBLPROPERTIES394=null;
        Token LPAREN395=null;
        Token RPAREN396=null;
        Token KW_SHOW397=null;
        Token KW_LOCKS398=null;
        Token KW_SHOW399=null;
        Token KW_INDEX400=null;
        Token KW_INDEXES401=null;
        Token KW_ON402=null;
        Token KW_FROM404=null;
        Token KW_IN405=null;
        HiveParser_IdentifiersParser.identifier_return db_name =null;

        HiveParser_FromClauseParser.tableName_return tabname =null;

        HiveParser_FromClauseParser.tableName_return tabName =null;

        HiveParser_IdentifiersParser.identifier_return tblName =null;

        HiveParser.partTypeExpr_return parttype =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier361 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier367 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier368 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier377 =null;

        HiveParser_IdentifiersParser.identifier_return identifier380 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec381 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier391 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec392 =null;

        HiveParser.showStmtIdentifier_return showStmtIdentifier403 =null;


        CommonTree prptyName_tree=null;
        CommonTree isExtended_tree=null;
        CommonTree showOptions_tree=null;
        CommonTree KW_SHOW357_tree=null;
        CommonTree KW_DATABASES358_tree=null;
        CommonTree KW_SCHEMAS359_tree=null;
        CommonTree KW_LIKE360_tree=null;
        CommonTree KW_SHOW362_tree=null;
        CommonTree KW_TABLES363_tree=null;
        CommonTree KW_FROM364_tree=null;
        CommonTree KW_IN365_tree=null;
        CommonTree KW_LIKE366_tree=null;
        CommonTree KW_SHOW369_tree=null;
        CommonTree KW_COLUMNS370_tree=null;
        CommonTree KW_FROM371_tree=null;
        CommonTree KW_IN372_tree=null;
        CommonTree KW_FROM373_tree=null;
        CommonTree KW_IN374_tree=null;
        CommonTree KW_SHOW375_tree=null;
        CommonTree KW_FUNCTIONS376_tree=null;
        CommonTree KW_SHOW378_tree=null;
        CommonTree KW_PARTITIONS379_tree=null;
        CommonTree KW_SHOW382_tree=null;
        CommonTree KW_CREATE383_tree=null;
        CommonTree KW_TABLE384_tree=null;
        CommonTree KW_SHOW385_tree=null;
        CommonTree KW_TABLE386_tree=null;
        CommonTree KW_EXTENDED387_tree=null;
        CommonTree KW_FROM388_tree=null;
        CommonTree KW_IN389_tree=null;
        CommonTree KW_LIKE390_tree=null;
        CommonTree KW_SHOW393_tree=null;
        CommonTree KW_TBLPROPERTIES394_tree=null;
        CommonTree LPAREN395_tree=null;
        CommonTree RPAREN396_tree=null;
        CommonTree KW_SHOW397_tree=null;
        CommonTree KW_LOCKS398_tree=null;
        CommonTree KW_SHOW399_tree=null;
        CommonTree KW_INDEX400_tree=null;
        CommonTree KW_INDEXES401_tree=null;
        CommonTree KW_ON402_tree=null;
        CommonTree KW_FROM404_tree=null;
        CommonTree KW_IN405_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_LOCKS=new RewriteRuleTokenStream(adaptor,"token KW_LOCKS");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_LIKE=new RewriteRuleTokenStream(adaptor,"token KW_LIKE");
        RewriteRuleTokenStream stream_KW_FORMATTED=new RewriteRuleTokenStream(adaptor,"token KW_FORMATTED");
        RewriteRuleTokenStream stream_KW_COLUMNS=new RewriteRuleTokenStream(adaptor,"token KW_COLUMNS");
        RewriteRuleTokenStream stream_KW_PARTITIONS=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONS");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_FUNCTIONS=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTIONS");
        RewriteRuleTokenStream stream_KW_IN=new RewriteRuleTokenStream(adaptor,"token KW_IN");
        RewriteRuleTokenStream stream_KW_INDEXES=new RewriteRuleTokenStream(adaptor,"token KW_INDEXES");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_SCHEMAS=new RewriteRuleTokenStream(adaptor,"token KW_SCHEMAS");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_TABLES=new RewriteRuleTokenStream(adaptor,"token KW_TABLES");
        RewriteRuleTokenStream stream_KW_EXTENDED=new RewriteRuleTokenStream(adaptor,"token KW_EXTENDED");
        RewriteRuleTokenStream stream_KW_DATABASES=new RewriteRuleTokenStream(adaptor,"token KW_DATABASES");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_TBLPROPERTIES=new RewriteRuleTokenStream(adaptor,"token KW_TBLPROPERTIES");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_showStmtIdentifier=new RewriteRuleSubtreeStream(adaptor,"rule showStmtIdentifier");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_partTypeExpr=new RewriteRuleSubtreeStream(adaptor,"rule partTypeExpr");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("show statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:5: ( KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )? -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? ) | KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )? -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? ) | KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname) | KW_SHOW KW_FUNCTIONS ( showStmtIdentifier )? -> ^( TOK_SHOWFUNCTIONS ( showStmtIdentifier )? ) | KW_SHOW KW_PARTITIONS identifier ( partitionSpec )? -> ^( TOK_SHOWPARTITIONS identifier ( partitionSpec )? ) | KW_SHOW KW_CREATE KW_TABLE tabName= tableName -> ^( TOK_SHOW_CREATETABLE $tabName) | KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )? -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? ) | KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )? -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? ) | KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )? -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? ) | KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )? -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? ) )
            int alt118=10;
            switch ( input.LA(1) ) {
            case KW_SHOW:
                {
                switch ( input.LA(2) ) {
                case KW_TABLES:
                    {
                    alt118=2;
                    }
                    break;
                case KW_COLUMNS:
                    {
                    alt118=3;
                    }
                    break;
                case KW_FUNCTIONS:
                    {
                    alt118=4;
                    }
                    break;
                case KW_PARTITIONS:
                    {
                    alt118=5;
                    }
                    break;
                case KW_CREATE:
                    {
                    alt118=6;
                    }
                    break;
                case KW_TABLE:
                    {
                    alt118=7;
                    }
                    break;
                case KW_TBLPROPERTIES:
                    {
                    alt118=8;
                    }
                    break;
                case KW_LOCKS:
                    {
                    alt118=9;
                    }
                    break;
                case KW_DATABASES:
                case KW_SCHEMAS:
                    {
                    alt118=1;
                    }
                    break;
                case KW_FORMATTED:
                case KW_INDEX:
                case KW_INDEXES:
                    {
                    alt118=10;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 118, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 118, 0, input);

                throw nvae;

            }

            switch (alt118) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:7: KW_SHOW ( KW_DATABASES | KW_SCHEMAS ) ( KW_LIKE showStmtIdentifier )?
                    {
                    KW_SHOW357=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6301);  
                    stream_KW_SHOW.add(KW_SHOW357);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:15: ( KW_DATABASES | KW_SCHEMAS )
                    int alt98=2;
                    switch ( input.LA(1) ) {
                    case KW_DATABASES:
                        {
                        alt98=1;
                        }
                        break;
                    case KW_SCHEMAS:
                        {
                        alt98=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 98, 0, input);

                        throw nvae;

                    }

                    switch (alt98) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:16: KW_DATABASES
                            {
                            KW_DATABASES358=(Token)match(input,KW_DATABASES,FOLLOW_KW_DATABASES_in_showStatement6304);  
                            stream_KW_DATABASES.add(KW_DATABASES358);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:29: KW_SCHEMAS
                            {
                            KW_SCHEMAS359=(Token)match(input,KW_SCHEMAS,FOLLOW_KW_SCHEMAS_in_showStatement6306);  
                            stream_KW_SCHEMAS.add(KW_SCHEMAS359);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:41: ( KW_LIKE showStmtIdentifier )?
                    int alt99=2;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            alt99=1;
                            }
                            break;
                    }

                    switch (alt99) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:42: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE360=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6310);  
                            stream_KW_LIKE.add(KW_LIKE360);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6312);
                            showStmtIdentifier361=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier361.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1239:71: -> ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:74: ^( TOK_SHOWDATABASES ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWDATABASES, "TOK_SHOWDATABASES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1239:94: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:7: KW_SHOW KW_TABLES ( ( KW_FROM | KW_IN ) db_name= identifier )? ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    {
                    KW_SHOW362=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6331);  
                    stream_KW_SHOW.add(KW_SHOW362);


                    KW_TABLES363=(Token)match(input,KW_TABLES,FOLLOW_KW_TABLES_in_showStatement6333);  
                    stream_KW_TABLES.add(KW_TABLES363);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:25: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt101=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                            {
                            alt101=1;
                            }
                            break;
                        case KW_IN:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                    {
                                    alt101=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt101) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:26: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:26: ( KW_FROM | KW_IN )
                            int alt100=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt100=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt100=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 100, 0, input);

                                throw nvae;

                            }

                            switch (alt100) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:27: KW_FROM
                                    {
                                    KW_FROM364=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6337);  
                                    stream_KW_FROM.add(KW_FROM364);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:35: KW_IN
                                    {
                                    KW_IN365=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6339);  
                                    stream_KW_IN.add(KW_IN365);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6344);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:63: ( KW_LIKE showStmtIdentifier | showStmtIdentifier )?
                    int alt102=3;
                    switch ( input.LA(1) ) {
                        case KW_LIKE:
                            {
                            switch ( input.LA(2) ) {
                                case Identifier:
                                case KW_ADD:
                                case KW_AFTER:
                                case KW_ALL:
                                case KW_ALTER:
                                case KW_ANALYZE:
                                case KW_ARCHIVE:
                                case KW_ARRAY:
                                case KW_AS:
                                case KW_ASC:
                                case KW_BEFORE:
                                case KW_BETWEEN:
                                case KW_BIGINT:
                                case KW_BINARY:
                                case KW_BOOLEAN:
                                case KW_BOTH:
                                case KW_BUCKET:
                                case KW_BUCKETS:
                                case KW_BY:
                                case KW_CASCADE:
                                case KW_CHANGE:
                                case KW_CLUSTER:
                                case KW_CLUSTERED:
                                case KW_CLUSTERSTATUS:
                                case KW_COLLECTION:
                                case KW_COLUMNS:
                                case KW_COMMENT:
                                case KW_COMPUTE:
                                case KW_CONCATENATE:
                                case KW_CONTINUE:
                                case KW_CREATE:
                                case KW_CUBE:
                                case KW_CURSOR:
                                case KW_DATA:
                                case KW_DATABASES:
                                case KW_DATE:
                                case KW_DATETIME:
                                case KW_DBPROPERTIES:
                                case KW_DECIMAL:
                                case KW_DEFAULT:
                                case KW_DEFERRED:
                                case KW_DEFINED:
                                case KW_DELETE:
                                case KW_DELIMITED:
                                case KW_DEPENDENCY:
                                case KW_DESC:
                                case KW_DESCRIBE:
                                case KW_DIRECTORIES:
                                case KW_DIRECTORY:
                                case KW_DISABLE:
                                case KW_DISTRIBUTE:
                                case KW_DOUBLE:
                                case KW_DROP:
                                case KW_ELEM_TYPE:
                                case KW_ENABLE:
                                case KW_ESCAPED:
                                case KW_EXCLUSIVE:
                                case KW_EXISTS:
                                case KW_EXPLAIN:
                                case KW_EXPORT:
                                case KW_EXTERNAL:
                                case KW_FALSE:
                                case KW_FETCH:
                                case KW_FIELDS:
                                case KW_FILEFORMAT:
                                case KW_FIRST:
                                case KW_FLOAT:
                                case KW_FOR:
                                case KW_FORMAT:
                                case KW_FORMATTED:
                                case KW_FULL:
                                case KW_FUNCTIONS:
                                case KW_GRANT:
                                case KW_GROUP:
                                case KW_GROUPING:
                                case KW_HOLD_DDLTIME:
                                case KW_IDXPROPERTIES:
                                case KW_IGNORE:
                                case KW_IMPORT:
                                case KW_IN:
                                case KW_INDEX:
                                case KW_INDEXES:
                                case KW_INNER:
                                case KW_INPATH:
                                case KW_INPUTDRIVER:
                                case KW_INPUTFORMAT:
                                case KW_INSERT:
                                case KW_INT:
                                case KW_INTERSECT:
                                case KW_INTO:
                                case KW_IS:
                                case KW_ITEMS:
                                case KW_KEYS:
                                case KW_KEY_TYPE:
                                case KW_LATERAL:
                                case KW_LEFT:
                                case KW_LIKE:
                                case KW_LIMIT:
                                case KW_LINES:
                                case KW_LOAD:
                                case KW_LOCAL:
                                case KW_LOCATION:
                                case KW_LOCK:
                                case KW_LOCKS:
                                case KW_LOGICAL:
                                case KW_LONG:
                                case KW_MAPJOIN:
                                case KW_MATERIALIZED:
                                case KW_MINUS:
                                case KW_MSCK:
                                case KW_NONE:
                                case KW_NOSCAN:
                                case KW_NO_DROP:
                                case KW_NULL:
                                case KW_OF:
                                case KW_OFFLINE:
                                case KW_OPTION:
                                case KW_ORCFILE:
                                case KW_ORDER:
                                case KW_OUT:
                                case KW_OUTER:
                                case KW_OUTPUTDRIVER:
                                case KW_OUTPUTFORMAT:
                                case KW_OVERWRITE:
                                case KW_PARTITION:
                                case KW_PARTITIONED:
                                case KW_PARTITIONS:
                                case KW_PERCENT:
                                case KW_PLUS:
                                case KW_PRETTY:
                                case KW_PROCEDURE:
                                case KW_PROTECTION:
                                case KW_PURGE:
                                case KW_RANGE:
                                case KW_RCFILE:
                                case KW_READ:
                                case KW_READONLY:
                                case KW_READS:
                                case KW_REBUILD:
                                case KW_RECORDREADER:
                                case KW_RECORDWRITER:
                                case KW_REGEXP:
                                case KW_RENAME:
                                case KW_REPAIR:
                                case KW_REPLACE:
                                case KW_RESTRICT:
                                case KW_REVOKE:
                                case KW_RIGHT:
                                case KW_RLIKE:
                                case KW_ROLE:
                                case KW_ROLES:
                                case KW_ROLLUP:
                                case KW_ROW:
                                case KW_ROWS:
                                case KW_SCHEMA:
                                case KW_SCHEMAS:
                                case KW_SEMI:
                                case KW_SEQUENCEFILE:
                                case KW_SERDE:
                                case KW_SERDEPROPERTIES:
                                case KW_SERVER:
                                case KW_SET:
                                case KW_SETS:
                                case KW_SHARED:
                                case KW_SHOW:
                                case KW_SHOW_DATABASE:
                                case KW_SKEWED:
                                case KW_SMALLINT:
                                case KW_SORT:
                                case KW_SORTED:
                                case KW_SSL:
                                case KW_STATISTICS:
                                case KW_STORED:
                                case KW_STREAMTABLE:
                                case KW_STRING:
                                case KW_STRUCT:
                                case KW_TABLE:
                                case KW_TABLES:
                                case KW_TBLPROPERTIES:
                                case KW_TEMPORARY:
                                case KW_TERMINATED:
                                case KW_TEXTFILE:
                                case KW_TIMESTAMP:
                                case KW_TINYINT:
                                case KW_TO:
                                case KW_TOUCH:
                                case KW_TRIGGER:
                                case KW_TRUE:
                                case KW_TRUNCATE:
                                case KW_UNARCHIVE:
                                case KW_UNDO:
                                case KW_UNION:
                                case KW_UNIONTYPE:
                                case KW_UNLOCK:
                                case KW_UNSET:
                                case KW_UNSIGNED:
                                case KW_UPDATE:
                                case KW_URI:
                                case KW_USE:
                                case KW_USER:
                                case KW_USING:
                                case KW_UTC:
                                case KW_UTCTIMESTAMP:
                                case KW_VALUE_TYPE:
                                case KW_VIEW:
                                case KW_WHILE:
                                case KW_WITH:
                                case StringLiteral:
                                    {
                                    alt102=1;
                                    }
                                    break;
                                case EOF:
                                    {
                                    alt102=2;
                                    }
                                    break;
                            }

                            }
                            break;
                        case Identifier:
                        case KW_ADD:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt102=2;
                            }
                            break;
                    }

                    switch (alt102) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:64: KW_LIKE showStmtIdentifier
                            {
                            KW_LIKE366=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6349);  
                            stream_KW_LIKE.add(KW_LIKE366);


                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6351);
                            showStmtIdentifier367=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier367.getTree());

                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:91: showStmtIdentifier
                            {
                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6353);
                            showStmtIdentifier368=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier368.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, db_name
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1240:113: -> ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:116: ^( TOK_SHOWTABLES ( TOK_FROM $db_name)? ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWTABLES, "TOK_SHOWTABLES")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:133: ( TOK_FROM $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, 
                            (CommonTree)adaptor.create(TOK_FROM, "TOK_FROM")
                            );

                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1240:154: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:7: KW_SHOW KW_COLUMNS ( KW_FROM | KW_IN ) tabname= tableName ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW369=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6381);  
                    stream_KW_SHOW.add(KW_SHOW369);


                    KW_COLUMNS370=(Token)match(input,KW_COLUMNS,FOLLOW_KW_COLUMNS_in_showStatement6383);  
                    stream_KW_COLUMNS.add(KW_COLUMNS370);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:26: ( KW_FROM | KW_IN )
                    int alt103=2;
                    switch ( input.LA(1) ) {
                    case KW_FROM:
                        {
                        alt103=1;
                        }
                        break;
                    case KW_IN:
                        {
                        alt103=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 103, 0, input);

                        throw nvae;

                    }

                    switch (alt103) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:27: KW_FROM
                            {
                            KW_FROM371=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6386);  
                            stream_KW_FROM.add(KW_FROM371);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:35: KW_IN
                            {
                            KW_IN372=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6388);  
                            stream_KW_IN.add(KW_IN372);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_tableName_in_showStatement6393);
                    tabname=tableName();

                    state._fsp--;

                    stream_tableName.add(tabname.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:60: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt105=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt105=1;
                            }
                            break;
                    }

                    switch (alt105) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:61: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:61: ( KW_FROM | KW_IN )
                            int alt104=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt104=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt104=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 104, 0, input);

                                throw nvae;

                            }

                            switch (alt104) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:62: KW_FROM
                                    {
                                    KW_FROM373=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6397);  
                                    stream_KW_FROM.add(KW_FROM373);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1241:70: KW_IN
                                    {
                                    KW_IN374=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6399);  
                                    stream_KW_IN.add(KW_IN374);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6404);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tabname, db_name
                    // token labels: 
                    // rule labels: retval, db_name, tabname
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);
                    RewriteRuleSubtreeStream stream_tabname=new RewriteRuleSubtreeStream(adaptor,"rule tabname",tabname!=null?tabname.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1242:5: -> ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1242:8: ^( TOK_SHOWCOLUMNS ( $db_name)? $tabname)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWCOLUMNS, "TOK_SHOWCOLUMNS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1242:27: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_1, stream_tabname.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:7: KW_SHOW KW_FUNCTIONS ( showStmtIdentifier )?
                    {
                    KW_SHOW375=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6432);  
                    stream_KW_SHOW.add(KW_SHOW375);


                    KW_FUNCTIONS376=(Token)match(input,KW_FUNCTIONS,FOLLOW_KW_FUNCTIONS_in_showStatement6434);  
                    stream_KW_FUNCTIONS.add(KW_FUNCTIONS376);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:28: ( showStmtIdentifier )?
                    int alt106=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                        case StringLiteral:
                            {
                            alt106=1;
                            }
                            break;
                    }

                    switch (alt106) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:28: showStmtIdentifier
                            {
                            pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6436);
                            showStmtIdentifier377=showStmtIdentifier();

                            state._fsp--;

                            stream_showStmtIdentifier.add(showStmtIdentifier377.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1243:49: -> ^( TOK_SHOWFUNCTIONS ( showStmtIdentifier )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:52: ^( TOK_SHOWFUNCTIONS ( showStmtIdentifier )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWFUNCTIONS, "TOK_SHOWFUNCTIONS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1243:72: ( showStmtIdentifier )?
                        if ( stream_showStmtIdentifier.hasNext() ) {
                            adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        }
                        stream_showStmtIdentifier.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:7: KW_SHOW KW_PARTITIONS identifier ( partitionSpec )?
                    {
                    KW_SHOW378=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6455);  
                    stream_KW_SHOW.add(KW_SHOW378);


                    KW_PARTITIONS379=(Token)match(input,KW_PARTITIONS,FOLLOW_KW_PARTITIONS_in_showStatement6457);  
                    stream_KW_PARTITIONS.add(KW_PARTITIONS379);


                    pushFollow(FOLLOW_identifier_in_showStatement6459);
                    identifier380=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier380.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:40: ( partitionSpec )?
                    int alt107=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt107=1;
                            }
                            break;
                    }

                    switch (alt107) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:40: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6461);
                            partitionSpec381=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec381.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: identifier, partitionSpec
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1244:55: -> ^( TOK_SHOWPARTITIONS identifier ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:58: ^( TOK_SHOWPARTITIONS identifier ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWPARTITIONS, "TOK_SHOWPARTITIONS")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1244:90: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1245:7: KW_SHOW KW_CREATE KW_TABLE tabName= tableName
                    {
                    KW_SHOW382=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6481);  
                    stream_KW_SHOW.add(KW_SHOW382);


                    KW_CREATE383=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_showStatement6483);  
                    stream_KW_CREATE.add(KW_CREATE383);


                    KW_TABLE384=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6485);  
                    stream_KW_TABLE.add(KW_TABLE384);


                    pushFollow(FOLLOW_tableName_in_showStatement6489);
                    tabName=tableName();

                    state._fsp--;

                    stream_tableName.add(tabName.getTree());

                    // AST REWRITE
                    // elements: tabName
                    // token labels: 
                    // rule labels: retval, tabName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tabName=new RewriteRuleSubtreeStream(adaptor,"rule tabName",tabName!=null?tabName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1245:52: -> ^( TOK_SHOW_CREATETABLE $tabName)
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1245:55: ^( TOK_SHOW_CREATETABLE $tabName)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_CREATETABLE, "TOK_SHOW_CREATETABLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_tabName.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:7: KW_SHOW KW_TABLE KW_EXTENDED ( ( KW_FROM | KW_IN ) db_name= identifier )? KW_LIKE showStmtIdentifier ( partitionSpec )?
                    {
                    KW_SHOW385=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6506);  
                    stream_KW_SHOW.add(KW_SHOW385);


                    KW_TABLE386=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_showStatement6508);  
                    stream_KW_TABLE.add(KW_TABLE386);


                    KW_EXTENDED387=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6510);  
                    stream_KW_EXTENDED.add(KW_EXTENDED387);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:36: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt109=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt109=1;
                            }
                            break;
                    }

                    switch (alt109) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:37: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:37: ( KW_FROM | KW_IN )
                            int alt108=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt108=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt108=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 108, 0, input);

                                throw nvae;

                            }

                            switch (alt108) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:38: KW_FROM
                                    {
                                    KW_FROM388=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6514);  
                                    stream_KW_FROM.add(KW_FROM388);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:46: KW_IN
                                    {
                                    KW_IN389=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6516);  
                                    stream_KW_IN.add(KW_IN389);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6521);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    KW_LIKE390=(Token)match(input,KW_LIKE,FOLLOW_KW_LIKE_in_showStatement6525);  
                    stream_KW_LIKE.add(KW_LIKE390);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6527);
                    showStmtIdentifier391=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier391.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:101: ( partitionSpec )?
                    int alt110=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt110=1;
                            }
                            break;
                    }

                    switch (alt110) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1246:101: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_showStatement6529);
                            partitionSpec392=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec392.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: partitionSpec, showStmtIdentifier, db_name
                    // token labels: 
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1247:5: -> ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1247:8: ^( TOK_SHOW_TABLESTATUS showStmtIdentifier ( $db_name)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TABLESTATUS, "TOK_SHOW_TABLESTATUS")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1247:51: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1247:60: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:7: KW_SHOW KW_TBLPROPERTIES tblName= identifier ( LPAREN prptyName= StringLiteral RPAREN )?
                    {
                    KW_SHOW393=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6557);  
                    stream_KW_SHOW.add(KW_SHOW393);


                    KW_TBLPROPERTIES394=(Token)match(input,KW_TBLPROPERTIES,FOLLOW_KW_TBLPROPERTIES_in_showStatement6559);  
                    stream_KW_TBLPROPERTIES.add(KW_TBLPROPERTIES394);


                    pushFollow(FOLLOW_identifier_in_showStatement6563);
                    tblName=identifier();

                    state._fsp--;

                    stream_identifier.add(tblName.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:51: ( LPAREN prptyName= StringLiteral RPAREN )?
                    int alt111=2;
                    switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt111=1;
                            }
                            break;
                    }

                    switch (alt111) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:52: LPAREN prptyName= StringLiteral RPAREN
                            {
                            LPAREN395=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_showStatement6566);  
                            stream_LPAREN.add(LPAREN395);


                            prptyName=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStatement6570);  
                            stream_StringLiteral.add(prptyName);


                            RPAREN396=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_showStatement6572);  
                            stream_RPAREN.add(RPAREN396);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: tblName, prptyName
                    // token labels: prptyName
                    // rule labels: retval, tblName
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_prptyName=new RewriteRuleTokenStream(adaptor,"token prptyName",prptyName);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_tblName=new RewriteRuleSubtreeStream(adaptor,"rule tblName",tblName!=null?tblName.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1248:92: -> ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:95: ^( TOK_SHOW_TBLPROPERTIES $tblName ( $prptyName)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOW_TBLPROPERTIES, "TOK_SHOW_TBLPROPERTIES")
                        , root_1);

                        adaptor.addChild(root_1, stream_tblName.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1248:130: ( $prptyName)?
                        if ( stream_prptyName.hasNext() ) {
                            adaptor.addChild(root_1, stream_prptyName.nextNode());

                        }
                        stream_prptyName.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:7: KW_SHOW KW_LOCKS (parttype= partTypeExpr )? (isExtended= KW_EXTENDED )?
                    {
                    KW_SHOW397=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6595);  
                    stream_KW_SHOW.add(KW_SHOW397);


                    KW_LOCKS398=(Token)match(input,KW_LOCKS,FOLLOW_KW_LOCKS_in_showStatement6597);  
                    stream_KW_LOCKS.add(KW_LOCKS398);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:24: (parttype= partTypeExpr )?
                    int alt112=2;
                    switch ( input.LA(1) ) {
                        case Identifier:
                        case KW_ADD:
                        case KW_AFTER:
                        case KW_ALL:
                        case KW_ALTER:
                        case KW_ANALYZE:
                        case KW_ARCHIVE:
                        case KW_ARRAY:
                        case KW_AS:
                        case KW_ASC:
                        case KW_BEFORE:
                        case KW_BETWEEN:
                        case KW_BIGINT:
                        case KW_BINARY:
                        case KW_BOOLEAN:
                        case KW_BOTH:
                        case KW_BUCKET:
                        case KW_BUCKETS:
                        case KW_BY:
                        case KW_CASCADE:
                        case KW_CHANGE:
                        case KW_CLUSTER:
                        case KW_CLUSTERED:
                        case KW_CLUSTERSTATUS:
                        case KW_COLLECTION:
                        case KW_COLUMNS:
                        case KW_COMMENT:
                        case KW_COMPUTE:
                        case KW_CONCATENATE:
                        case KW_CONTINUE:
                        case KW_CREATE:
                        case KW_CUBE:
                        case KW_CURSOR:
                        case KW_DATA:
                        case KW_DATABASES:
                        case KW_DATE:
                        case KW_DATETIME:
                        case KW_DBPROPERTIES:
                        case KW_DECIMAL:
                        case KW_DEFAULT:
                        case KW_DEFERRED:
                        case KW_DEFINED:
                        case KW_DELETE:
                        case KW_DELIMITED:
                        case KW_DEPENDENCY:
                        case KW_DESC:
                        case KW_DESCRIBE:
                        case KW_DIRECTORIES:
                        case KW_DIRECTORY:
                        case KW_DISABLE:
                        case KW_DISTRIBUTE:
                        case KW_DOUBLE:
                        case KW_DROP:
                        case KW_ELEM_TYPE:
                        case KW_ENABLE:
                        case KW_ESCAPED:
                        case KW_EXCLUSIVE:
                        case KW_EXISTS:
                        case KW_EXPLAIN:
                        case KW_EXPORT:
                        case KW_EXTERNAL:
                        case KW_FALSE:
                        case KW_FETCH:
                        case KW_FIELDS:
                        case KW_FILEFORMAT:
                        case KW_FIRST:
                        case KW_FLOAT:
                        case KW_FOR:
                        case KW_FORMAT:
                        case KW_FORMATTED:
                        case KW_FULL:
                        case KW_FUNCTIONS:
                        case KW_GRANT:
                        case KW_GROUP:
                        case KW_GROUPING:
                        case KW_HOLD_DDLTIME:
                        case KW_IDXPROPERTIES:
                        case KW_IGNORE:
                        case KW_IMPORT:
                        case KW_IN:
                        case KW_INDEX:
                        case KW_INDEXES:
                        case KW_INNER:
                        case KW_INPATH:
                        case KW_INPUTDRIVER:
                        case KW_INPUTFORMAT:
                        case KW_INSERT:
                        case KW_INT:
                        case KW_INTERSECT:
                        case KW_INTO:
                        case KW_IS:
                        case KW_ITEMS:
                        case KW_KEYS:
                        case KW_KEY_TYPE:
                        case KW_LATERAL:
                        case KW_LEFT:
                        case KW_LIKE:
                        case KW_LIMIT:
                        case KW_LINES:
                        case KW_LOAD:
                        case KW_LOCAL:
                        case KW_LOCATION:
                        case KW_LOCK:
                        case KW_LOCKS:
                        case KW_LOGICAL:
                        case KW_LONG:
                        case KW_MAPJOIN:
                        case KW_MATERIALIZED:
                        case KW_MINUS:
                        case KW_MSCK:
                        case KW_NONE:
                        case KW_NOSCAN:
                        case KW_NO_DROP:
                        case KW_NULL:
                        case KW_OF:
                        case KW_OFFLINE:
                        case KW_OPTION:
                        case KW_ORCFILE:
                        case KW_ORDER:
                        case KW_OUT:
                        case KW_OUTER:
                        case KW_OUTPUTDRIVER:
                        case KW_OUTPUTFORMAT:
                        case KW_OVERWRITE:
                        case KW_PARTITION:
                        case KW_PARTITIONED:
                        case KW_PARTITIONS:
                        case KW_PERCENT:
                        case KW_PLUS:
                        case KW_PRETTY:
                        case KW_PROCEDURE:
                        case KW_PROTECTION:
                        case KW_PURGE:
                        case KW_RANGE:
                        case KW_RCFILE:
                        case KW_READ:
                        case KW_READONLY:
                        case KW_READS:
                        case KW_REBUILD:
                        case KW_RECORDREADER:
                        case KW_RECORDWRITER:
                        case KW_REGEXP:
                        case KW_RENAME:
                        case KW_REPAIR:
                        case KW_REPLACE:
                        case KW_RESTRICT:
                        case KW_REVOKE:
                        case KW_RIGHT:
                        case KW_RLIKE:
                        case KW_ROLE:
                        case KW_ROLES:
                        case KW_ROLLUP:
                        case KW_ROW:
                        case KW_ROWS:
                        case KW_SCHEMA:
                        case KW_SCHEMAS:
                        case KW_SEMI:
                        case KW_SEQUENCEFILE:
                        case KW_SERDE:
                        case KW_SERDEPROPERTIES:
                        case KW_SERVER:
                        case KW_SET:
                        case KW_SETS:
                        case KW_SHARED:
                        case KW_SHOW:
                        case KW_SHOW_DATABASE:
                        case KW_SKEWED:
                        case KW_SMALLINT:
                        case KW_SORT:
                        case KW_SORTED:
                        case KW_SSL:
                        case KW_STATISTICS:
                        case KW_STORED:
                        case KW_STREAMTABLE:
                        case KW_STRING:
                        case KW_STRUCT:
                        case KW_TABLE:
                        case KW_TABLES:
                        case KW_TBLPROPERTIES:
                        case KW_TEMPORARY:
                        case KW_TERMINATED:
                        case KW_TEXTFILE:
                        case KW_TIMESTAMP:
                        case KW_TINYINT:
                        case KW_TO:
                        case KW_TOUCH:
                        case KW_TRIGGER:
                        case KW_TRUE:
                        case KW_TRUNCATE:
                        case KW_UNARCHIVE:
                        case KW_UNDO:
                        case KW_UNION:
                        case KW_UNIONTYPE:
                        case KW_UNLOCK:
                        case KW_UNSET:
                        case KW_UNSIGNED:
                        case KW_UPDATE:
                        case KW_URI:
                        case KW_USE:
                        case KW_USER:
                        case KW_USING:
                        case KW_UTC:
                        case KW_UTCTIMESTAMP:
                        case KW_VALUE_TYPE:
                        case KW_VIEW:
                        case KW_WHILE:
                        case KW_WITH:
                            {
                            alt112=1;
                            }
                            break;
                    }

                    switch (alt112) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:25: parttype= partTypeExpr
                            {
                            pushFollow(FOLLOW_partTypeExpr_in_showStatement6602);
                            parttype=partTypeExpr();

                            state._fsp--;

                            stream_partTypeExpr.add(parttype.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:49: (isExtended= KW_EXTENDED )?
                    int alt113=2;
                    switch ( input.LA(1) ) {
                        case KW_EXTENDED:
                            {
                            alt113=1;
                            }
                            break;
                    }

                    switch (alt113) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:50: isExtended= KW_EXTENDED
                            {
                            isExtended=(Token)match(input,KW_EXTENDED,FOLLOW_KW_EXTENDED_in_showStatement6609);  
                            stream_KW_EXTENDED.add(isExtended);


                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: isExtended, parttype
                    // token labels: isExtended
                    // rule labels: retval, parttype
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_isExtended=new RewriteRuleTokenStream(adaptor,"token isExtended",isExtended);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_parttype=new RewriteRuleSubtreeStream(adaptor,"rule parttype",parttype!=null?parttype.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1249:75: -> ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:78: ^( TOK_SHOWLOCKS ( $parttype)? ( $isExtended)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWLOCKS, "TOK_SHOWLOCKS")
                        , root_1);

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:95: ( $parttype)?
                        if ( stream_parttype.hasNext() ) {
                            adaptor.addChild(root_1, stream_parttype.nextTree());

                        }
                        stream_parttype.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1249:106: ( $isExtended)?
                        if ( stream_isExtended.hasNext() ) {
                            adaptor.addChild(root_1, stream_isExtended.nextNode());

                        }
                        stream_isExtended.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:7: KW_SHOW (showOptions= KW_FORMATTED )? ( KW_INDEX | KW_INDEXES ) KW_ON showStmtIdentifier ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    {
                    KW_SHOW399=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showStatement6633);  
                    stream_KW_SHOW.add(KW_SHOW399);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:15: (showOptions= KW_FORMATTED )?
                    int alt114=2;
                    switch ( input.LA(1) ) {
                        case KW_FORMATTED:
                            {
                            alt114=1;
                            }
                            break;
                    }

                    switch (alt114) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:16: showOptions= KW_FORMATTED
                            {
                            showOptions=(Token)match(input,KW_FORMATTED,FOLLOW_KW_FORMATTED_in_showStatement6638);  
                            stream_KW_FORMATTED.add(showOptions);


                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:43: ( KW_INDEX | KW_INDEXES )
                    int alt115=2;
                    switch ( input.LA(1) ) {
                    case KW_INDEX:
                        {
                        alt115=1;
                        }
                        break;
                    case KW_INDEXES:
                        {
                        alt115=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 115, 0, input);

                        throw nvae;

                    }

                    switch (alt115) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:44: KW_INDEX
                            {
                            KW_INDEX400=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_showStatement6643);  
                            stream_KW_INDEX.add(KW_INDEX400);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:53: KW_INDEXES
                            {
                            KW_INDEXES401=(Token)match(input,KW_INDEXES,FOLLOW_KW_INDEXES_in_showStatement6645);  
                            stream_KW_INDEXES.add(KW_INDEXES401);


                            }
                            break;

                    }


                    KW_ON402=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_showStatement6648);  
                    stream_KW_ON.add(KW_ON402);


                    pushFollow(FOLLOW_showStmtIdentifier_in_showStatement6650);
                    showStmtIdentifier403=showStmtIdentifier();

                    state._fsp--;

                    stream_showStmtIdentifier.add(showStmtIdentifier403.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:90: ( ( KW_FROM | KW_IN ) db_name= identifier )?
                    int alt117=2;
                    switch ( input.LA(1) ) {
                        case KW_FROM:
                        case KW_IN:
                            {
                            alt117=1;
                            }
                            break;
                    }

                    switch (alt117) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:91: ( KW_FROM | KW_IN ) db_name= identifier
                            {
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:91: ( KW_FROM | KW_IN )
                            int alt116=2;
                            switch ( input.LA(1) ) {
                            case KW_FROM:
                                {
                                alt116=1;
                                }
                                break;
                            case KW_IN:
                                {
                                alt116=2;
                                }
                                break;
                            default:
                                NoViableAltException nvae =
                                    new NoViableAltException("", 116, 0, input);

                                throw nvae;

                            }

                            switch (alt116) {
                                case 1 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:92: KW_FROM
                                    {
                                    KW_FROM404=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_showStatement6654);  
                                    stream_KW_FROM.add(KW_FROM404);


                                    }
                                    break;
                                case 2 :
                                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1250:100: KW_IN
                                    {
                                    KW_IN405=(Token)match(input,KW_IN,FOLLOW_KW_IN_in_showStatement6656);  
                                    stream_KW_IN.add(KW_IN405);


                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_identifier_in_showStatement6661);
                            db_name=identifier();

                            state._fsp--;

                            stream_identifier.add(db_name.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: showStmtIdentifier, showOptions, db_name
                    // token labels: showOptions
                    // rule labels: retval, db_name
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_showOptions=new RewriteRuleTokenStream(adaptor,"token showOptions",showOptions);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_db_name=new RewriteRuleSubtreeStream(adaptor,"rule db_name",db_name!=null?db_name.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1251:5: -> ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1251:8: ^( TOK_SHOWINDEXES showStmtIdentifier ( $showOptions)? ( $db_name)? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_SHOWINDEXES, "TOK_SHOWINDEXES")
                        , root_1);

                        adaptor.addChild(root_1, stream_showStmtIdentifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1251:46: ( $showOptions)?
                        if ( stream_showOptions.hasNext() ) {
                            adaptor.addChild(root_1, stream_showOptions.nextNode());

                        }
                        stream_showOptions.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1251:60: ( $db_name)?
                        if ( stream_db_name.hasNext() ) {
                            adaptor.addChild(root_1, stream_db_name.nextTree());

                        }
                        stream_db_name.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showStatement"


    public static class lockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1254:1: lockStatement : KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) ;
    public final HiveParser.lockStatement_return lockStatement() throws RecognitionException {
        HiveParser.lockStatement_return retval = new HiveParser.lockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_LOCK406=null;
        Token KW_TABLE407=null;
        HiveParser_FromClauseParser.tableName_return tableName408 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec409 =null;

        HiveParser.lockMode_return lockMode410 =null;


        CommonTree KW_LOCK406_tree=null;
        CommonTree KW_TABLE407_tree=null;
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_lockMode=new RewriteRuleSubtreeStream(adaptor,"rule lockMode");
         msgs.push("lock statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:5: ( KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:7: KW_LOCK KW_TABLE tableName ( partitionSpec )? lockMode
            {
            KW_LOCK406=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_lockStatement6710);  
            stream_KW_LOCK.add(KW_LOCK406);


            KW_TABLE407=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_lockStatement6712);  
            stream_KW_TABLE.add(KW_TABLE407);


            pushFollow(FOLLOW_tableName_in_lockStatement6714);
            tableName408=tableName();

            state._fsp--;

            stream_tableName.add(tableName408.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:34: ( partitionSpec )?
            int alt119=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt119=1;
                    }
                    break;
            }

            switch (alt119) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:34: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_lockStatement6716);
                    partitionSpec409=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec409.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_lockMode_in_lockStatement6719);
            lockMode410=lockMode();

            state._fsp--;

            stream_lockMode.add(lockMode410.getTree());

            // AST REWRITE
            // elements: partitionSpec, lockMode, tableName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1257:58: -> ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:61: ^( TOK_LOCKTABLE tableName lockMode ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_LOCKTABLE, "TOK_LOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                adaptor.addChild(root_1, stream_lockMode.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1257:96: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockStatement"


    public static class lockMode_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lockMode"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1260:1: lockMode : ( KW_SHARED | KW_EXCLUSIVE );
    public final HiveParser.lockMode_return lockMode() throws RecognitionException {
        HiveParser.lockMode_return retval = new HiveParser.lockMode_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token set411=null;

        CommonTree set411_tree=null;

         msgs.push("lock mode"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1263:5: ( KW_SHARED | KW_EXCLUSIVE )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set411=(Token)input.LT(1);

            if ( input.LA(1)==KW_EXCLUSIVE||input.LA(1)==KW_SHARED ) {
                input.consume();
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set411)
                );
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lockMode"


    public static class unlockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unlockStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1266:1: unlockStatement : KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) ;
    public final HiveParser.unlockStatement_return unlockStatement() throws RecognitionException {
        HiveParser.unlockStatement_return retval = new HiveParser.unlockStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_UNLOCK412=null;
        Token KW_TABLE413=null;
        HiveParser_FromClauseParser.tableName_return tableName414 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec415 =null;


        CommonTree KW_UNLOCK412_tree=null;
        CommonTree KW_TABLE413_tree=null;
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_UNLOCK=new RewriteRuleTokenStream(adaptor,"token KW_UNLOCK");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
         msgs.push("unlock statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:5: ( KW_UNLOCK KW_TABLE tableName ( partitionSpec )? -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:7: KW_UNLOCK KW_TABLE tableName ( partitionSpec )?
            {
            KW_UNLOCK412=(Token)match(input,KW_UNLOCK,FOLLOW_KW_UNLOCK_in_unlockStatement6790);  
            stream_KW_UNLOCK.add(KW_UNLOCK412);


            KW_TABLE413=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_unlockStatement6792);  
            stream_KW_TABLE.add(KW_TABLE413);


            pushFollow(FOLLOW_tableName_in_unlockStatement6794);
            tableName414=tableName();

            state._fsp--;

            stream_tableName.add(tableName414.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:36: ( partitionSpec )?
            int alt120=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt120=1;
                    }
                    break;
            }

            switch (alt120) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:36: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_unlockStatement6796);
                    partitionSpec415=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec415.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: tableName, partitionSpec
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1269:52: -> ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:55: ^( TOK_UNLOCKTABLE tableName ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_UNLOCKTABLE, "TOK_UNLOCKTABLE")
                , root_1);

                adaptor.addChild(root_1, stream_tableName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1269:83: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unlockStatement"


    public static class createRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1272:1: createRoleStatement : KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) ;
    public final HiveParser.createRoleStatement_return createRoleStatement() throws RecognitionException {
        HiveParser.createRoleStatement_return retval = new HiveParser.createRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE416=null;
        Token KW_ROLE417=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_CREATE416_tree=null;
        CommonTree KW_ROLE417_tree=null;
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("create role"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1275:5: ( KW_CREATE KW_ROLE roleName= identifier -> ^( TOK_CREATEROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1275:7: KW_CREATE KW_ROLE roleName= identifier
            {
            KW_CREATE416=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createRoleStatement6836);  
            stream_KW_CREATE.add(KW_CREATE416);


            KW_ROLE417=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_createRoleStatement6838);  
            stream_KW_ROLE.add(KW_ROLE417);


            pushFollow(FOLLOW_identifier_in_createRoleStatement6842);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1276:5: -> ^( TOK_CREATEROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1276:8: ^( TOK_CREATEROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEROLE, "TOK_CREATEROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createRoleStatement"


    public static class dropRoleStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropRoleStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1279:1: dropRoleStatement : KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) ;
    public final HiveParser.dropRoleStatement_return dropRoleStatement() throws RecognitionException {
        HiveParser.dropRoleStatement_return retval = new HiveParser.dropRoleStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP418=null;
        Token KW_ROLE419=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_DROP418_tree=null;
        CommonTree KW_ROLE419_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("drop role");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1282:5: ( KW_DROP KW_ROLE roleName= identifier -> ^( TOK_DROPROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1282:7: KW_DROP KW_ROLE roleName= identifier
            {
            KW_DROP418=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropRoleStatement6882);  
            stream_KW_DROP.add(KW_DROP418);


            KW_ROLE419=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_dropRoleStatement6884);  
            stream_KW_ROLE.add(KW_ROLE419);


            pushFollow(FOLLOW_identifier_in_dropRoleStatement6888);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1283:5: -> ^( TOK_DROPROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1283:8: ^( TOK_DROPROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPROLE, "TOK_DROPROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropRoleStatement"


    public static class grantPrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantPrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1286:1: grantPrivileges : KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( KW_WITH withOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withOption )? ) ;
    public final HiveParser.grantPrivileges_return grantPrivileges() throws RecognitionException {
        HiveParser.grantPrivileges_return retval = new HiveParser.grantPrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT420=null;
        Token KW_TO422=null;
        Token KW_WITH424=null;
        HiveParser.privilegeList_return privList =null;

        HiveParser.privilegeObject_return privilegeObject421 =null;

        HiveParser.principalSpecification_return principalSpecification423 =null;

        HiveParser.withOption_return withOption425 =null;


        CommonTree KW_GRANT420_tree=null;
        CommonTree KW_TO422_tree=null;
        CommonTree KW_WITH424_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_WITH=new RewriteRuleTokenStream(adaptor,"token KW_WITH");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_withOption=new RewriteRuleSubtreeStream(adaptor,"rule withOption");
        msgs.push("grant privileges");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:5: ( KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( KW_WITH withOption )? -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withOption )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1289:7: KW_GRANT privList= privilegeList ( privilegeObject )? KW_TO principalSpecification ( KW_WITH withOption )?
            {
            KW_GRANT420=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantPrivileges6928);  
            stream_KW_GRANT.add(KW_GRANT420);


            pushFollow(FOLLOW_privilegeList_in_grantPrivileges6932);
            privList=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privList.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:7: ( privilegeObject )?
            int alt121=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt121=1;
                    }
                    break;
            }

            switch (alt121) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1290:7: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_grantPrivileges6940);
                    privilegeObject421=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject421.getTree());

                    }
                    break;

            }


            KW_TO422=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantPrivileges6949);  
            stream_KW_TO.add(KW_TO422);


            pushFollow(FOLLOW_principalSpecification_in_grantPrivileges6951);
            principalSpecification423=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification423.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1292:7: ( KW_WITH withOption )?
            int alt122=2;
            switch ( input.LA(1) ) {
                case KW_WITH:
                    {
                    alt122=1;
                    }
                    break;
            }

            switch (alt122) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1292:8: KW_WITH withOption
                    {
                    KW_WITH424=(Token)match(input,KW_WITH,FOLLOW_KW_WITH_in_grantPrivileges6960);  
                    stream_KW_WITH.add(KW_WITH424);


                    pushFollow(FOLLOW_withOption_in_grantPrivileges6962);
                    withOption425=withOption();

                    state._fsp--;

                    stream_withOption.add(withOption425.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: principalSpecification, privilegeObject, withOption, privList
            // token labels: 
            // rule labels: retval, privList
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_privList=new RewriteRuleSubtreeStream(adaptor,"rule privList",privList!=null?privList.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1293:5: -> ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withOption )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1293:8: ^( TOK_GRANT $privList principalSpecification ( privilegeObject )? ( withOption )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT, "TOK_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_privList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1293:53: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1293:70: ( withOption )?
                if ( stream_withOption.hasNext() ) {
                    adaptor.addChild(root_1, stream_withOption.nextTree());

                }
                stream_withOption.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantPrivileges"


    public static class revokePrivileges_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokePrivileges"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1296:1: revokePrivileges : KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ) ;
    public final HiveParser.revokePrivileges_return revokePrivileges() throws RecognitionException {
        HiveParser.revokePrivileges_return retval = new HiveParser.revokePrivileges_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE426=null;
        Token KW_FROM429=null;
        HiveParser.privilegeList_return privilegeList427 =null;

        HiveParser.privilegeObject_return privilegeObject428 =null;

        HiveParser.principalSpecification_return principalSpecification430 =null;


        CommonTree KW_REVOKE426_tree=null;
        CommonTree KW_FROM429_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_privilegeList=new RewriteRuleSubtreeStream(adaptor,"rule privilegeList");
        RewriteRuleSubtreeStream stream_privilegeObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeObject");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        msgs.push("revoke privileges");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1299:5: ( KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1299:7: KW_REVOKE privilegeList ( privilegeObject )? KW_FROM principalSpecification
            {
            KW_REVOKE426=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokePrivileges7012);  
            stream_KW_REVOKE.add(KW_REVOKE426);


            pushFollow(FOLLOW_privilegeList_in_revokePrivileges7014);
            privilegeList427=privilegeList();

            state._fsp--;

            stream_privilegeList.add(privilegeList427.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1299:31: ( privilegeObject )?
            int alt123=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt123=1;
                    }
                    break;
            }

            switch (alt123) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1299:31: privilegeObject
                    {
                    pushFollow(FOLLOW_privilegeObject_in_revokePrivileges7016);
                    privilegeObject428=privilegeObject();

                    state._fsp--;

                    stream_privilegeObject.add(privilegeObject428.getTree());

                    }
                    break;

            }


            KW_FROM429=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokePrivileges7019);  
            stream_KW_FROM.add(KW_FROM429);


            pushFollow(FOLLOW_principalSpecification_in_revokePrivileges7021);
            principalSpecification430=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification430.getTree());

            // AST REWRITE
            // elements: privilegeList, principalSpecification, privilegeObject
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1300:5: -> ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1300:8: ^( TOK_REVOKE privilegeList principalSpecification ( privilegeObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE, "TOK_REVOKE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeList.nextTree());

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1300:58: ( privilegeObject )?
                if ( stream_privilegeObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeObject.nextTree());

                }
                stream_privilegeObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokePrivileges"


    public static class grantRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1303:1: grantRole : KW_GRANT KW_ROLE identifier ( COMMA identifier )* KW_TO principalSpecification -> ^( TOK_GRANT_ROLE principalSpecification ( identifier )+ ) ;
    public final HiveParser.grantRole_return grantRole() throws RecognitionException {
        HiveParser.grantRole_return retval = new HiveParser.grantRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT431=null;
        Token KW_ROLE432=null;
        Token COMMA434=null;
        Token KW_TO436=null;
        HiveParser_IdentifiersParser.identifier_return identifier433 =null;

        HiveParser_IdentifiersParser.identifier_return identifier435 =null;

        HiveParser.principalSpecification_return principalSpecification437 =null;


        CommonTree KW_GRANT431_tree=null;
        CommonTree KW_ROLE432_tree=null;
        CommonTree COMMA434_tree=null;
        CommonTree KW_TO436_tree=null;
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_TO=new RewriteRuleTokenStream(adaptor,"token KW_TO");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("grant role");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1306:5: ( KW_GRANT KW_ROLE identifier ( COMMA identifier )* KW_TO principalSpecification -> ^( TOK_GRANT_ROLE principalSpecification ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1306:7: KW_GRANT KW_ROLE identifier ( COMMA identifier )* KW_TO principalSpecification
            {
            KW_GRANT431=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_grantRole7065);  
            stream_KW_GRANT.add(KW_GRANT431);


            KW_ROLE432=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_grantRole7067);  
            stream_KW_ROLE.add(KW_ROLE432);


            pushFollow(FOLLOW_identifier_in_grantRole7069);
            identifier433=identifier();

            state._fsp--;

            stream_identifier.add(identifier433.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1306:35: ( COMMA identifier )*
            loop124:
            do {
                int alt124=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt124=1;
                    }
                    break;

                }

                switch (alt124) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1306:36: COMMA identifier
            	    {
            	    COMMA434=(Token)match(input,COMMA,FOLLOW_COMMA_in_grantRole7072);  
            	    stream_COMMA.add(COMMA434);


            	    pushFollow(FOLLOW_identifier_in_grantRole7074);
            	    identifier435=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier435.getTree());

            	    }
            	    break;

            	default :
            	    break loop124;
                }
            } while (true);


            KW_TO436=(Token)match(input,KW_TO,FOLLOW_KW_TO_in_grantRole7078);  
            stream_KW_TO.add(KW_TO436);


            pushFollow(FOLLOW_principalSpecification_in_grantRole7080);
            principalSpecification437=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification437.getTree());

            // AST REWRITE
            // elements: principalSpecification, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1307:5: -> ^( TOK_GRANT_ROLE principalSpecification ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1307:8: ^( TOK_GRANT_ROLE principalSpecification ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT_ROLE, "TOK_GRANT_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantRole"


    public static class revokeRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "revokeRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1310:1: revokeRole : KW_REVOKE KW_ROLE identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( identifier )+ ) ;
    public final HiveParser.revokeRole_return revokeRole() throws RecognitionException {
        HiveParser.revokeRole_return retval = new HiveParser.revokeRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_REVOKE438=null;
        Token KW_ROLE439=null;
        Token COMMA441=null;
        Token KW_FROM443=null;
        HiveParser_IdentifiersParser.identifier_return identifier440 =null;

        HiveParser_IdentifiersParser.identifier_return identifier442 =null;

        HiveParser.principalSpecification_return principalSpecification444 =null;


        CommonTree KW_REVOKE438_tree=null;
        CommonTree KW_ROLE439_tree=null;
        CommonTree COMMA441_tree=null;
        CommonTree KW_FROM443_tree=null;
        RewriteRuleTokenStream stream_KW_REVOKE=new RewriteRuleTokenStream(adaptor,"token KW_REVOKE");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_FROM=new RewriteRuleTokenStream(adaptor,"token KW_FROM");
        RewriteRuleSubtreeStream stream_principalSpecification=new RewriteRuleSubtreeStream(adaptor,"rule principalSpecification");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("revoke role");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:5: ( KW_REVOKE KW_ROLE identifier ( COMMA identifier )* KW_FROM principalSpecification -> ^( TOK_REVOKE_ROLE principalSpecification ( identifier )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:7: KW_REVOKE KW_ROLE identifier ( COMMA identifier )* KW_FROM principalSpecification
            {
            KW_REVOKE438=(Token)match(input,KW_REVOKE,FOLLOW_KW_REVOKE_in_revokeRole7122);  
            stream_KW_REVOKE.add(KW_REVOKE438);


            KW_ROLE439=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_revokeRole7124);  
            stream_KW_ROLE.add(KW_ROLE439);


            pushFollow(FOLLOW_identifier_in_revokeRole7126);
            identifier440=identifier();

            state._fsp--;

            stream_identifier.add(identifier440.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:36: ( COMMA identifier )*
            loop125:
            do {
                int alt125=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt125=1;
                    }
                    break;

                }

                switch (alt125) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1313:37: COMMA identifier
            	    {
            	    COMMA441=(Token)match(input,COMMA,FOLLOW_COMMA_in_revokeRole7129);  
            	    stream_COMMA.add(COMMA441);


            	    pushFollow(FOLLOW_identifier_in_revokeRole7131);
            	    identifier442=identifier();

            	    state._fsp--;

            	    stream_identifier.add(identifier442.getTree());

            	    }
            	    break;

            	default :
            	    break loop125;
                }
            } while (true);


            KW_FROM443=(Token)match(input,KW_FROM,FOLLOW_KW_FROM_in_revokeRole7135);  
            stream_KW_FROM.add(KW_FROM443);


            pushFollow(FOLLOW_principalSpecification_in_revokeRole7137);
            principalSpecification444=principalSpecification();

            state._fsp--;

            stream_principalSpecification.add(principalSpecification444.getTree());

            // AST REWRITE
            // elements: principalSpecification, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1314:5: -> ^( TOK_REVOKE_ROLE principalSpecification ( identifier )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1314:8: ^( TOK_REVOKE_ROLE principalSpecification ( identifier )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_REVOKE_ROLE, "TOK_REVOKE_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_principalSpecification.nextTree());

                if ( !(stream_identifier.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_identifier.hasNext() ) {
                    adaptor.addChild(root_1, stream_identifier.nextTree());

                }
                stream_identifier.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "revokeRole"


    public static class showRoleGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoleGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1317:1: showRoleGrants : KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) ;
    public final HiveParser.showRoleGrants_return showRoleGrants() throws RecognitionException {
        HiveParser.showRoleGrants_return retval = new HiveParser.showRoleGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW445=null;
        Token KW_ROLE446=null;
        Token KW_GRANT447=null;
        HiveParser.principalName_return principalName448 =null;


        CommonTree KW_SHOW445_tree=null;
        CommonTree KW_ROLE446_tree=null;
        CommonTree KW_GRANT447_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        msgs.push("show role grants");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:5: ( KW_SHOW KW_ROLE KW_GRANT principalName -> ^( TOK_SHOW_ROLE_GRANT principalName ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1320:7: KW_SHOW KW_ROLE KW_GRANT principalName
            {
            KW_SHOW445=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoleGrants7179);  
            stream_KW_SHOW.add(KW_SHOW445);


            KW_ROLE446=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_showRoleGrants7181);  
            stream_KW_ROLE.add(KW_ROLE446);


            KW_GRANT447=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showRoleGrants7183);  
            stream_KW_GRANT.add(KW_GRANT447);


            pushFollow(FOLLOW_principalName_in_showRoleGrants7185);
            principalName448=principalName();

            state._fsp--;

            stream_principalName.add(principalName448.getTree());

            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1321:5: -> ^( TOK_SHOW_ROLE_GRANT principalName )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1321:8: ^( TOK_SHOW_ROLE_GRANT principalName )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLE_GRANT, "TOK_SHOW_ROLE_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_principalName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoleGrants"


    public static class showRoles_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showRoles"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1324:1: showRoles : KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) ;
    public final HiveParser.showRoles_return showRoles() throws RecognitionException {
        HiveParser.showRoles_return retval = new HiveParser.showRoles_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW449=null;
        Token KW_ROLES450=null;

        CommonTree KW_SHOW449_tree=null;
        CommonTree KW_ROLES450_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        msgs.push("show roles");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1327:5: ( KW_SHOW KW_ROLES -> ^( TOK_SHOW_ROLES ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1327:7: KW_SHOW KW_ROLES
            {
            KW_SHOW449=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showRoles7224);  
            stream_KW_SHOW.add(KW_SHOW449);


            KW_ROLES450=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showRoles7226);  
            stream_KW_ROLES.add(KW_ROLES450);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1328:5: -> ^( TOK_SHOW_ROLES )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1328:8: ^( TOK_SHOW_ROLES )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_ROLES, "TOK_SHOW_ROLES")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showRoles"


    public static class showCurrentRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showCurrentRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1331:1: showCurrentRole : KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) ;
    public final HiveParser.showCurrentRole_return showCurrentRole() throws RecognitionException {
        HiveParser.showCurrentRole_return retval = new HiveParser.showCurrentRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW451=null;
        Token KW_CURRENT452=null;
        Token KW_ROLES453=null;

        CommonTree KW_SHOW451_tree=null;
        CommonTree KW_CURRENT452_tree=null;
        CommonTree KW_ROLES453_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_CURRENT=new RewriteRuleTokenStream(adaptor,"token KW_CURRENT");
        RewriteRuleTokenStream stream_KW_ROLES=new RewriteRuleTokenStream(adaptor,"token KW_ROLES");

        msgs.push("show current role");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1334:5: ( KW_SHOW KW_CURRENT KW_ROLES -> ^( TOK_SHOW_SET_ROLE ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1334:7: KW_SHOW KW_CURRENT KW_ROLES
            {
            KW_SHOW451=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showCurrentRole7263);  
            stream_KW_SHOW.add(KW_SHOW451);


            KW_CURRENT452=(Token)match(input,KW_CURRENT,FOLLOW_KW_CURRENT_in_showCurrentRole7265);  
            stream_KW_CURRENT.add(KW_CURRENT452);


            KW_ROLES453=(Token)match(input,KW_ROLES,FOLLOW_KW_ROLES_in_showCurrentRole7267);  
            stream_KW_ROLES.add(KW_ROLES453);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1335:5: -> ^( TOK_SHOW_SET_ROLE )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1335:8: ^( TOK_SHOW_SET_ROLE )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showCurrentRole"


    public static class setRole_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setRole"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1338:1: setRole : KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) ;
    public final HiveParser.setRole_return setRole() throws RecognitionException {
        HiveParser.setRole_return retval = new HiveParser.setRole_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SET454=null;
        Token KW_ROLE455=null;
        HiveParser_IdentifiersParser.identifier_return roleName =null;


        CommonTree KW_SET454_tree=null;
        CommonTree KW_ROLE455_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_SET=new RewriteRuleTokenStream(adaptor,"token KW_SET");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("set role");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:5: ( KW_SET KW_ROLE roleName= identifier -> ^( TOK_SHOW_SET_ROLE $roleName) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1341:7: KW_SET KW_ROLE roleName= identifier
            {
            KW_SET454=(Token)match(input,KW_SET,FOLLOW_KW_SET_in_setRole7304);  
            stream_KW_SET.add(KW_SET454);


            KW_ROLE455=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_setRole7306);  
            stream_KW_ROLE.add(KW_ROLE455);


            pushFollow(FOLLOW_identifier_in_setRole7310);
            roleName=identifier();

            state._fsp--;

            stream_identifier.add(roleName.getTree());

            // AST REWRITE
            // elements: roleName
            // token labels: 
            // rule labels: retval, roleName
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_roleName=new RewriteRuleSubtreeStream(adaptor,"rule roleName",roleName!=null?roleName.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1342:5: -> ^( TOK_SHOW_SET_ROLE $roleName)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1342:8: ^( TOK_SHOW_SET_ROLE $roleName)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_SET_ROLE, "TOK_SHOW_SET_ROLE")
                , root_1);

                adaptor.addChild(root_1, stream_roleName.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setRole"


    public static class showGrants_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showGrants"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1345:1: showGrants : KW_SHOW KW_GRANT principalName ( privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT principalName ( privilegeIncludeColObject )? ) ;
    public final HiveParser.showGrants_return showGrants() throws RecognitionException {
        HiveParser.showGrants_return retval = new HiveParser.showGrants_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SHOW456=null;
        Token KW_GRANT457=null;
        HiveParser.principalName_return principalName458 =null;

        HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject459 =null;


        CommonTree KW_SHOW456_tree=null;
        CommonTree KW_GRANT457_tree=null;
        RewriteRuleTokenStream stream_KW_SHOW=new RewriteRuleTokenStream(adaptor,"token KW_SHOW");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
        RewriteRuleSubtreeStream stream_privilegeIncludeColObject=new RewriteRuleSubtreeStream(adaptor,"rule privilegeIncludeColObject");
        msgs.push("show grants");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:5: ( KW_SHOW KW_GRANT principalName ( privilegeIncludeColObject )? -> ^( TOK_SHOW_GRANT principalName ( privilegeIncludeColObject )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:7: KW_SHOW KW_GRANT principalName ( privilegeIncludeColObject )?
            {
            KW_SHOW456=(Token)match(input,KW_SHOW,FOLLOW_KW_SHOW_in_showGrants7350);  
            stream_KW_SHOW.add(KW_SHOW456);


            KW_GRANT457=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_showGrants7352);  
            stream_KW_GRANT.add(KW_GRANT457);


            pushFollow(FOLLOW_principalName_in_showGrants7354);
            principalName458=principalName();

            state._fsp--;

            stream_principalName.add(principalName458.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:38: ( privilegeIncludeColObject )?
            int alt126=2;
            switch ( input.LA(1) ) {
                case KW_ON:
                    {
                    alt126=1;
                    }
                    break;
            }

            switch (alt126) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1348:38: privilegeIncludeColObject
                    {
                    pushFollow(FOLLOW_privilegeIncludeColObject_in_showGrants7356);
                    privilegeIncludeColObject459=privilegeIncludeColObject();

                    state._fsp--;

                    stream_privilegeIncludeColObject.add(privilegeIncludeColObject459.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: privilegeIncludeColObject, principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1349:5: -> ^( TOK_SHOW_GRANT principalName ( privilegeIncludeColObject )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:8: ^( TOK_SHOW_GRANT principalName ( privilegeIncludeColObject )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_SHOW_GRANT, "TOK_SHOW_GRANT")
                , root_1);

                adaptor.addChild(root_1, stream_principalName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1349:39: ( privilegeIncludeColObject )?
                if ( stream_privilegeIncludeColObject.hasNext() ) {
                    adaptor.addChild(root_1, stream_privilegeIncludeColObject.nextTree());

                }
                stream_privilegeIncludeColObject.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showGrants"


    public static class privilegeIncludeColObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeIncludeColObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1352:1: privilegeIncludeColObject : KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )? -> ^( TOK_PRIV_OBJECT_COL identifier ( $table)? ( $cols)? ( partitionSpec )? ) ;
    public final HiveParser.privilegeIncludeColObject_return privilegeIncludeColObject() throws RecognitionException {
        HiveParser.privilegeIncludeColObject_return retval = new HiveParser.privilegeIncludeColObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token table=null;
        Token KW_ON460=null;
        Token KW_DATABASE461=null;
        Token LPAREN463=null;
        Token RPAREN464=null;
        HiveParser.columnNameList_return cols =null;

        HiveParser_IdentifiersParser.identifier_return identifier462 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec465 =null;


        CommonTree table_tree=null;
        CommonTree KW_ON460_tree=null;
        CommonTree KW_DATABASE461_tree=null;
        CommonTree LPAREN463_tree=null;
        CommonTree RPAREN464_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("privilege object including columns");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:5: ( KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )? -> ^( TOK_PRIV_OBJECT_COL identifier ( $table)? ( $cols)? ( partitionSpec )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:7: KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( LPAREN cols= columnNameList RPAREN )? ( partitionSpec )?
            {
            KW_ON460=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeIncludeColObject7399);  
            stream_KW_ON.add(KW_ON460);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:13: (table= KW_TABLE | KW_DATABASE )
            int alt127=2;
            switch ( input.LA(1) ) {
            case KW_TABLE:
                {
                alt127=1;
                }
                break;
            case KW_DATABASE:
                {
                alt127=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 127, 0, input);

                throw nvae;

            }

            switch (alt127) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:14: table= KW_TABLE
                    {
                    table=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_privilegeIncludeColObject7404);  
                    stream_KW_TABLE.add(table);


                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:29: KW_DATABASE
                    {
                    KW_DATABASE461=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_privilegeIncludeColObject7406);  
                    stream_KW_DATABASE.add(KW_DATABASE461);


                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_privilegeIncludeColObject7409);
            identifier462=identifier();

            state._fsp--;

            stream_identifier.add(identifier462.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:53: ( LPAREN cols= columnNameList RPAREN )?
            int alt128=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    alt128=1;
                    }
                    break;
            }

            switch (alt128) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:54: LPAREN cols= columnNameList RPAREN
                    {
                    LPAREN463=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_privilegeIncludeColObject7412);  
                    stream_LPAREN.add(LPAREN463);


                    pushFollow(FOLLOW_columnNameList_in_privilegeIncludeColObject7416);
                    cols=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(cols.getTree());

                    RPAREN464=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_privilegeIncludeColObject7418);  
                    stream_RPAREN.add(RPAREN464);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:90: ( partitionSpec )?
            int alt129=2;
            switch ( input.LA(1) ) {
                case KW_PARTITION:
                    {
                    alt129=1;
                    }
                    break;
            }

            switch (alt129) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1355:90: partitionSpec
                    {
                    pushFollow(FOLLOW_partitionSpec_in_privilegeIncludeColObject7422);
                    partitionSpec465=partitionSpec();

                    state._fsp--;

                    stream_partitionSpec.add(partitionSpec465.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: table, cols, identifier, partitionSpec
            // token labels: table
            // rule labels: retval, cols
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_table=new RewriteRuleTokenStream(adaptor,"token table",table);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_cols=new RewriteRuleSubtreeStream(adaptor,"rule cols",cols!=null?cols.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1356:5: -> ^( TOK_PRIV_OBJECT_COL identifier ( $table)? ( $cols)? ( partitionSpec )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:8: ^( TOK_PRIV_OBJECT_COL identifier ( $table)? ( $cols)? ( partitionSpec )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIV_OBJECT_COL, "TOK_PRIV_OBJECT_COL")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:42: ( $table)?
                if ( stream_table.hasNext() ) {
                    adaptor.addChild(root_1, stream_table.nextNode());

                }
                stream_table.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:50: ( $cols)?
                if ( stream_cols.hasNext() ) {
                    adaptor.addChild(root_1, stream_cols.nextTree());

                }
                stream_cols.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1356:56: ( partitionSpec )?
                if ( stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                }
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeIncludeColObject"


    public static class privilegeObject_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeObject"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1359:1: privilegeObject : ( KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( partitionSpec )? -> ^( TOK_PRIV_OBJECT identifier ( $table)? ( partitionSpec )? ) | KW_ON KW_URI (path= StringLiteral ) -> ^( TOK_PRIV_OBJECT $path TOK_URI ) | KW_ON KW_SERVER identifier -> ^( TOK_PRIV_OBJECT identifier TOK_SERVER ) );
    public final HiveParser.privilegeObject_return privilegeObject() throws RecognitionException {
        HiveParser.privilegeObject_return retval = new HiveParser.privilegeObject_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token table=null;
        Token path=null;
        Token KW_ON466=null;
        Token KW_DATABASE467=null;
        Token KW_ON470=null;
        Token KW_URI471=null;
        Token KW_ON472=null;
        Token KW_SERVER473=null;
        HiveParser_IdentifiersParser.identifier_return identifier468 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec469 =null;

        HiveParser_IdentifiersParser.identifier_return identifier474 =null;


        CommonTree table_tree=null;
        CommonTree path_tree=null;
        CommonTree KW_ON466_tree=null;
        CommonTree KW_DATABASE467_tree=null;
        CommonTree KW_ON470_tree=null;
        CommonTree KW_URI471_tree=null;
        CommonTree KW_ON472_tree=null;
        CommonTree KW_SERVER473_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_SERVER=new RewriteRuleTokenStream(adaptor,"token KW_SERVER");
        RewriteRuleTokenStream stream_KW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_DATABASE");
        RewriteRuleTokenStream stream_KW_URI=new RewriteRuleTokenStream(adaptor,"token KW_URI");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("privilege subject");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:5: ( KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( partitionSpec )? -> ^( TOK_PRIV_OBJECT identifier ( $table)? ( partitionSpec )? ) | KW_ON KW_URI (path= StringLiteral ) -> ^( TOK_PRIV_OBJECT $path TOK_URI ) | KW_ON KW_SERVER identifier -> ^( TOK_PRIV_OBJECT identifier TOK_SERVER ) )
            int alt132=3;
            switch ( input.LA(1) ) {
            case KW_ON:
                {
                switch ( input.LA(2) ) {
                case KW_URI:
                    {
                    alt132=2;
                    }
                    break;
                case KW_SERVER:
                    {
                    alt132=3;
                    }
                    break;
                case KW_DATABASE:
                case KW_TABLE:
                    {
                    alt132=1;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 132, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 132, 0, input);

                throw nvae;

            }

            switch (alt132) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:7: KW_ON (table= KW_TABLE | KW_DATABASE ) identifier ( partitionSpec )?
                    {
                    KW_ON466=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeObject7473);  
                    stream_KW_ON.add(KW_ON466);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:13: (table= KW_TABLE | KW_DATABASE )
                    int alt130=2;
                    switch ( input.LA(1) ) {
                    case KW_TABLE:
                        {
                        alt130=1;
                        }
                        break;
                    case KW_DATABASE:
                        {
                        alt130=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 130, 0, input);

                        throw nvae;

                    }

                    switch (alt130) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:14: table= KW_TABLE
                            {
                            table=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_privilegeObject7478);  
                            stream_KW_TABLE.add(table);


                            }
                            break;
                        case 2 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:29: KW_DATABASE
                            {
                            KW_DATABASE467=(Token)match(input,KW_DATABASE,FOLLOW_KW_DATABASE_in_privilegeObject7480);  
                            stream_KW_DATABASE.add(KW_DATABASE467);


                            }
                            break;

                    }


                    pushFollow(FOLLOW_identifier_in_privilegeObject7483);
                    identifier468=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier468.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:53: ( partitionSpec )?
                    int alt131=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt131=1;
                            }
                            break;
                    }

                    switch (alt131) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1362:53: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_privilegeObject7485);
                            partitionSpec469=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec469.getTree());

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: identifier, partitionSpec, table
                    // token labels: table
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_table=new RewriteRuleTokenStream(adaptor,"token table",table);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1363:5: -> ^( TOK_PRIV_OBJECT identifier ( $table)? ( partitionSpec )? )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1363:8: ^( TOK_PRIV_OBJECT identifier ( $table)? ( partitionSpec )? )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_OBJECT, "TOK_PRIV_OBJECT")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1363:38: ( $table)?
                        if ( stream_table.hasNext() ) {
                            adaptor.addChild(root_1, stream_table.nextNode());

                        }
                        stream_table.reset();

                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1363:45: ( partitionSpec )?
                        if ( stream_partitionSpec.hasNext() ) {
                            adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                        }
                        stream_partitionSpec.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1364:7: KW_ON KW_URI (path= StringLiteral )
                    {
                    KW_ON470=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeObject7513);  
                    stream_KW_ON.add(KW_ON470);


                    KW_URI471=(Token)match(input,KW_URI,FOLLOW_KW_URI_in_privilegeObject7515);  
                    stream_KW_URI.add(KW_URI471);


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1364:20: (path= StringLiteral )
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1364:21: path= StringLiteral
                    {
                    path=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_privilegeObject7520);  
                    stream_StringLiteral.add(path);


                    }


                    // AST REWRITE
                    // elements: path
                    // token labels: path
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleTokenStream stream_path=new RewriteRuleTokenStream(adaptor,"token path",path);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1364:41: -> ^( TOK_PRIV_OBJECT $path TOK_URI )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1364:44: ^( TOK_PRIV_OBJECT $path TOK_URI )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_OBJECT, "TOK_PRIV_OBJECT")
                        , root_1);

                        adaptor.addChild(root_1, stream_path.nextNode());

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_URI, "TOK_URI")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1365:7: KW_ON KW_SERVER identifier
                    {
                    KW_ON472=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_privilegeObject7540);  
                    stream_KW_ON.add(KW_ON472);


                    KW_SERVER473=(Token)match(input,KW_SERVER,FOLLOW_KW_SERVER_in_privilegeObject7542);  
                    stream_KW_SERVER.add(KW_SERVER473);


                    pushFollow(FOLLOW_identifier_in_privilegeObject7544);
                    identifier474=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier474.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1365:34: -> ^( TOK_PRIV_OBJECT identifier TOK_SERVER )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1365:37: ^( TOK_PRIV_OBJECT identifier TOK_SERVER )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_OBJECT, "TOK_PRIV_OBJECT")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(TOK_SERVER, "TOK_SERVER")
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeObject"


    public static class privilegeList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeList"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1368:1: privilegeList : privlegeDef ( COMMA privlegeDef )* -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ ) ;
    public final HiveParser.privilegeList_return privilegeList() throws RecognitionException {
        HiveParser.privilegeList_return retval = new HiveParser.privilegeList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA476=null;
        HiveParser.privlegeDef_return privlegeDef475 =null;

        HiveParser.privlegeDef_return privlegeDef477 =null;


        CommonTree COMMA476_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_privlegeDef=new RewriteRuleSubtreeStream(adaptor,"rule privlegeDef");
        msgs.push("grant privilege list");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:5: ( privlegeDef ( COMMA privlegeDef )* -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:7: privlegeDef ( COMMA privlegeDef )*
            {
            pushFollow(FOLLOW_privlegeDef_in_privilegeList7581);
            privlegeDef475=privlegeDef();

            state._fsp--;

            stream_privlegeDef.add(privlegeDef475.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:19: ( COMMA privlegeDef )*
            loop133:
            do {
                int alt133=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt133=1;
                    }
                    break;

                }

                switch (alt133) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1371:20: COMMA privlegeDef
            	    {
            	    COMMA476=(Token)match(input,COMMA,FOLLOW_COMMA_in_privilegeList7584);  
            	    stream_COMMA.add(COMMA476);


            	    pushFollow(FOLLOW_privlegeDef_in_privilegeList7586);
            	    privlegeDef477=privlegeDef();

            	    state._fsp--;

            	    stream_privlegeDef.add(privlegeDef477.getTree());

            	    }
            	    break;

            	default :
            	    break loop133;
                }
            } while (true);


            // AST REWRITE
            // elements: privlegeDef
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1372:5: -> ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1372:8: ^( TOK_PRIVILEGE_LIST ( privlegeDef )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIVILEGE_LIST, "TOK_PRIVILEGE_LIST")
                , root_1);

                if ( !(stream_privlegeDef.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_privlegeDef.hasNext() ) {
                    adaptor.addChild(root_1, stream_privlegeDef.nextTree());

                }
                stream_privlegeDef.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeList"


    public static class privlegeDef_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privlegeDef"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1375:1: privlegeDef : privilegeType ( LPAREN cols= columnNameList RPAREN )? -> ^( TOK_PRIVILEGE privilegeType ( $cols)? ) ;
    public final HiveParser.privlegeDef_return privlegeDef() throws RecognitionException {
        HiveParser.privlegeDef_return retval = new HiveParser.privlegeDef_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token LPAREN479=null;
        Token RPAREN480=null;
        HiveParser.columnNameList_return cols =null;

        HiveParser.privilegeType_return privilegeType478 =null;


        CommonTree LPAREN479_tree=null;
        CommonTree RPAREN480_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_privilegeType=new RewriteRuleSubtreeStream(adaptor,"rule privilegeType");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        msgs.push("grant privilege");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:5: ( privilegeType ( LPAREN cols= columnNameList RPAREN )? -> ^( TOK_PRIVILEGE privilegeType ( $cols)? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:7: privilegeType ( LPAREN cols= columnNameList RPAREN )?
            {
            pushFollow(FOLLOW_privilegeType_in_privlegeDef7628);
            privilegeType478=privilegeType();

            state._fsp--;

            stream_privilegeType.add(privilegeType478.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:21: ( LPAREN cols= columnNameList RPAREN )?
            int alt134=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    alt134=1;
                    }
                    break;
            }

            switch (alt134) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1378:22: LPAREN cols= columnNameList RPAREN
                    {
                    LPAREN479=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_privlegeDef7631);  
                    stream_LPAREN.add(LPAREN479);


                    pushFollow(FOLLOW_columnNameList_in_privlegeDef7635);
                    cols=columnNameList();

                    state._fsp--;

                    stream_columnNameList.add(cols.getTree());

                    RPAREN480=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_privlegeDef7637);  
                    stream_RPAREN.add(RPAREN480);


                    }
                    break;

            }


            // AST REWRITE
            // elements: cols, privilegeType
            // token labels: 
            // rule labels: retval, cols
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_cols=new RewriteRuleSubtreeStream(adaptor,"rule cols",cols!=null?cols.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1379:5: -> ^( TOK_PRIVILEGE privilegeType ( $cols)? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1379:8: ^( TOK_PRIVILEGE privilegeType ( $cols)? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRIVILEGE, "TOK_PRIVILEGE")
                , root_1);

                adaptor.addChild(root_1, stream_privilegeType.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1379:39: ( $cols)?
                if ( stream_cols.hasNext() ) {
                    adaptor.addChild(root_1, stream_cols.nextTree());

                }
                stream_cols.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privlegeDef"


    public static class privilegeType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "privilegeType"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1382:1: privilegeType : ( KW_ALL -> ^( TOK_PRIV_ALL ) | KW_ALTER -> ^( TOK_PRIV_ALTER_METADATA ) | KW_UPDATE -> ^( TOK_PRIV_ALTER_DATA ) | KW_CREATE -> ^( TOK_PRIV_CREATE ) | KW_DROP -> ^( TOK_PRIV_DROP ) | KW_INDEX -> ^( TOK_PRIV_INDEX ) | KW_LOCK -> ^( TOK_PRIV_LOCK ) | KW_SELECT -> ^( TOK_PRIV_SELECT ) | KW_SHOW_DATABASE -> ^( TOK_PRIV_SHOW_DATABASE ) | KW_INSERT -> ^( TOK_PRIV_INSERT ) );
    public final HiveParser.privilegeType_return privilegeType() throws RecognitionException {
        HiveParser.privilegeType_return retval = new HiveParser.privilegeType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_ALL481=null;
        Token KW_ALTER482=null;
        Token KW_UPDATE483=null;
        Token KW_CREATE484=null;
        Token KW_DROP485=null;
        Token KW_INDEX486=null;
        Token KW_LOCK487=null;
        Token KW_SELECT488=null;
        Token KW_SHOW_DATABASE489=null;
        Token KW_INSERT490=null;

        CommonTree KW_ALL481_tree=null;
        CommonTree KW_ALTER482_tree=null;
        CommonTree KW_UPDATE483_tree=null;
        CommonTree KW_CREATE484_tree=null;
        CommonTree KW_DROP485_tree=null;
        CommonTree KW_INDEX486_tree=null;
        CommonTree KW_LOCK487_tree=null;
        CommonTree KW_SELECT488_tree=null;
        CommonTree KW_SHOW_DATABASE489_tree=null;
        CommonTree KW_INSERT490_tree=null;
        RewriteRuleTokenStream stream_KW_ALTER=new RewriteRuleTokenStream(adaptor,"token KW_ALTER");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_ALL=new RewriteRuleTokenStream(adaptor,"token KW_ALL");
        RewriteRuleTokenStream stream_KW_SELECT=new RewriteRuleTokenStream(adaptor,"token KW_SELECT");
        RewriteRuleTokenStream stream_KW_UPDATE=new RewriteRuleTokenStream(adaptor,"token KW_UPDATE");
        RewriteRuleTokenStream stream_KW_SHOW_DATABASE=new RewriteRuleTokenStream(adaptor,"token KW_SHOW_DATABASE");
        RewriteRuleTokenStream stream_KW_INDEX=new RewriteRuleTokenStream(adaptor,"token KW_INDEX");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_LOCK=new RewriteRuleTokenStream(adaptor,"token KW_LOCK");
        RewriteRuleTokenStream stream_KW_INSERT=new RewriteRuleTokenStream(adaptor,"token KW_INSERT");

        msgs.push("privilege type");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:5: ( KW_ALL -> ^( TOK_PRIV_ALL ) | KW_ALTER -> ^( TOK_PRIV_ALTER_METADATA ) | KW_UPDATE -> ^( TOK_PRIV_ALTER_DATA ) | KW_CREATE -> ^( TOK_PRIV_CREATE ) | KW_DROP -> ^( TOK_PRIV_DROP ) | KW_INDEX -> ^( TOK_PRIV_INDEX ) | KW_LOCK -> ^( TOK_PRIV_LOCK ) | KW_SELECT -> ^( TOK_PRIV_SELECT ) | KW_SHOW_DATABASE -> ^( TOK_PRIV_SHOW_DATABASE ) | KW_INSERT -> ^( TOK_PRIV_INSERT ) )
            int alt135=10;
            switch ( input.LA(1) ) {
            case KW_ALL:
                {
                alt135=1;
                }
                break;
            case KW_ALTER:
                {
                alt135=2;
                }
                break;
            case KW_UPDATE:
                {
                alt135=3;
                }
                break;
            case KW_CREATE:
                {
                alt135=4;
                }
                break;
            case KW_DROP:
                {
                alt135=5;
                }
                break;
            case KW_INDEX:
                {
                alt135=6;
                }
                break;
            case KW_LOCK:
                {
                alt135=7;
                }
                break;
            case KW_SELECT:
                {
                alt135=8;
                }
                break;
            case KW_SHOW_DATABASE:
                {
                alt135=9;
                }
                break;
            case KW_INSERT:
                {
                alt135=10;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 135, 0, input);

                throw nvae;

            }

            switch (alt135) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:7: KW_ALL
                    {
                    KW_ALL481=(Token)match(input,KW_ALL,FOLLOW_KW_ALL_in_privilegeType7682);  
                    stream_KW_ALL.add(KW_ALL481);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1385:14: -> ^( TOK_PRIV_ALL )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1385:17: ^( TOK_PRIV_ALL )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALL, "TOK_PRIV_ALL")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:7: KW_ALTER
                    {
                    KW_ALTER482=(Token)match(input,KW_ALTER,FOLLOW_KW_ALTER_in_privilegeType7696);  
                    stream_KW_ALTER.add(KW_ALTER482);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1386:16: -> ^( TOK_PRIV_ALTER_METADATA )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1386:19: ^( TOK_PRIV_ALTER_METADATA )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALTER_METADATA, "TOK_PRIV_ALTER_METADATA")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1387:7: KW_UPDATE
                    {
                    KW_UPDATE483=(Token)match(input,KW_UPDATE,FOLLOW_KW_UPDATE_in_privilegeType7710);  
                    stream_KW_UPDATE.add(KW_UPDATE483);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1387:17: -> ^( TOK_PRIV_ALTER_DATA )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1387:20: ^( TOK_PRIV_ALTER_DATA )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_ALTER_DATA, "TOK_PRIV_ALTER_DATA")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 4 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1388:7: KW_CREATE
                    {
                    KW_CREATE484=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_privilegeType7724);  
                    stream_KW_CREATE.add(KW_CREATE484);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1388:17: -> ^( TOK_PRIV_CREATE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1388:20: ^( TOK_PRIV_CREATE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_CREATE, "TOK_PRIV_CREATE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 5 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1389:7: KW_DROP
                    {
                    KW_DROP485=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_privilegeType7738);  
                    stream_KW_DROP.add(KW_DROP485);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1389:15: -> ^( TOK_PRIV_DROP )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1389:18: ^( TOK_PRIV_DROP )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_DROP, "TOK_PRIV_DROP")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 6 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1390:7: KW_INDEX
                    {
                    KW_INDEX486=(Token)match(input,KW_INDEX,FOLLOW_KW_INDEX_in_privilegeType7752);  
                    stream_KW_INDEX.add(KW_INDEX486);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1390:16: -> ^( TOK_PRIV_INDEX )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1390:19: ^( TOK_PRIV_INDEX )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_INDEX, "TOK_PRIV_INDEX")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 7 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1391:7: KW_LOCK
                    {
                    KW_LOCK487=(Token)match(input,KW_LOCK,FOLLOW_KW_LOCK_in_privilegeType7766);  
                    stream_KW_LOCK.add(KW_LOCK487);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1391:15: -> ^( TOK_PRIV_LOCK )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1391:18: ^( TOK_PRIV_LOCK )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_LOCK, "TOK_PRIV_LOCK")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 8 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:7: KW_SELECT
                    {
                    KW_SELECT488=(Token)match(input,KW_SELECT,FOLLOW_KW_SELECT_in_privilegeType7780);  
                    stream_KW_SELECT.add(KW_SELECT488);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1392:17: -> ^( TOK_PRIV_SELECT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1392:20: ^( TOK_PRIV_SELECT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_SELECT, "TOK_PRIV_SELECT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 9 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:7: KW_SHOW_DATABASE
                    {
                    KW_SHOW_DATABASE489=(Token)match(input,KW_SHOW_DATABASE,FOLLOW_KW_SHOW_DATABASE_in_privilegeType7794);  
                    stream_KW_SHOW_DATABASE.add(KW_SHOW_DATABASE489);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1393:24: -> ^( TOK_PRIV_SHOW_DATABASE )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1393:27: ^( TOK_PRIV_SHOW_DATABASE )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_SHOW_DATABASE, "TOK_PRIV_SHOW_DATABASE")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 10 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:7: KW_INSERT
                    {
                    KW_INSERT490=(Token)match(input,KW_INSERT,FOLLOW_KW_INSERT_in_privilegeType7808);  
                    stream_KW_INSERT.add(KW_INSERT490);


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1394:17: -> ^( TOK_PRIV_INSERT )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1394:20: ^( TOK_PRIV_INSERT )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_PRIV_INSERT, "TOK_PRIV_INSERT")
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "privilegeType"


    public static class principalSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "principalSpecification"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1397:1: principalSpecification : principalName ( COMMA principalName )* -> ^( TOK_PRINCIPAL_NAME ( principalName )+ ) ;
    public final HiveParser.principalSpecification_return principalSpecification() throws RecognitionException {
        HiveParser.principalSpecification_return retval = new HiveParser.principalSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token COMMA492=null;
        HiveParser.principalName_return principalName491 =null;

        HiveParser.principalName_return principalName493 =null;


        CommonTree COMMA492_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_principalName=new RewriteRuleSubtreeStream(adaptor,"rule principalName");
         msgs.push("user/group/role name list"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:5: ( principalName ( COMMA principalName )* -> ^( TOK_PRINCIPAL_NAME ( principalName )+ ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:7: principalName ( COMMA principalName )*
            {
            pushFollow(FOLLOW_principalName_in_principalSpecification7841);
            principalName491=principalName();

            state._fsp--;

            stream_principalName.add(principalName491.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:21: ( COMMA principalName )*
            loop136:
            do {
                int alt136=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt136=1;
                    }
                    break;

                }

                switch (alt136) {
            	case 1 :
            	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:22: COMMA principalName
            	    {
            	    COMMA492=(Token)match(input,COMMA,FOLLOW_COMMA_in_principalSpecification7844);  
            	    stream_COMMA.add(COMMA492);


            	    pushFollow(FOLLOW_principalName_in_principalSpecification7846);
            	    principalName493=principalName();

            	    state._fsp--;

            	    stream_principalName.add(principalName493.getTree());

            	    }
            	    break;

            	default :
            	    break loop136;
                }
            } while (true);


            // AST REWRITE
            // elements: principalName
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1400:44: -> ^( TOK_PRINCIPAL_NAME ( principalName )+ )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1400:47: ^( TOK_PRINCIPAL_NAME ( principalName )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_PRINCIPAL_NAME, "TOK_PRINCIPAL_NAME")
                , root_1);

                if ( !(stream_principalName.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_principalName.hasNext() ) {
                    adaptor.addChild(root_1, stream_principalName.nextTree());

                }
                stream_principalName.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "principalSpecification"


    public static class principalName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "principalName"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1403:1: principalName : ( KW_USER identifier -> ^( TOK_USER identifier ) | KW_GROUP identifier -> ^( TOK_GROUP identifier ) | KW_ROLE identifier -> ^( TOK_ROLE identifier ) );
    public final HiveParser.principalName_return principalName() throws RecognitionException {
        HiveParser.principalName_return retval = new HiveParser.principalName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_USER494=null;
        Token KW_GROUP496=null;
        Token KW_ROLE498=null;
        HiveParser_IdentifiersParser.identifier_return identifier495 =null;

        HiveParser_IdentifiersParser.identifier_return identifier497 =null;

        HiveParser_IdentifiersParser.identifier_return identifier499 =null;


        CommonTree KW_USER494_tree=null;
        CommonTree KW_GROUP496_tree=null;
        CommonTree KW_ROLE498_tree=null;
        RewriteRuleTokenStream stream_KW_ROLE=new RewriteRuleTokenStream(adaptor,"token KW_ROLE");
        RewriteRuleTokenStream stream_KW_GROUP=new RewriteRuleTokenStream(adaptor,"token KW_GROUP");
        RewriteRuleTokenStream stream_KW_USER=new RewriteRuleTokenStream(adaptor,"token KW_USER");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        msgs.push("user|group|role name");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:5: ( KW_USER identifier -> ^( TOK_USER identifier ) | KW_GROUP identifier -> ^( TOK_GROUP identifier ) | KW_ROLE identifier -> ^( TOK_ROLE identifier ) )
            int alt137=3;
            switch ( input.LA(1) ) {
            case KW_USER:
                {
                alt137=1;
                }
                break;
            case KW_GROUP:
                {
                alt137=2;
                }
                break;
            case KW_ROLE:
                {
                alt137=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 137, 0, input);

                throw nvae;

            }

            switch (alt137) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:7: KW_USER identifier
                    {
                    KW_USER494=(Token)match(input,KW_USER,FOLLOW_KW_USER_in_principalName7884);  
                    stream_KW_USER.add(KW_USER494);


                    pushFollow(FOLLOW_identifier_in_principalName7886);
                    identifier495=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier495.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1406:26: -> ^( TOK_USER identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1406:29: ^( TOK_USER identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_USER, "TOK_USER")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1407:7: KW_GROUP identifier
                    {
                    KW_GROUP496=(Token)match(input,KW_GROUP,FOLLOW_KW_GROUP_in_principalName7902);  
                    stream_KW_GROUP.add(KW_GROUP496);


                    pushFollow(FOLLOW_identifier_in_principalName7904);
                    identifier497=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier497.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1407:27: -> ^( TOK_GROUP identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1407:30: ^( TOK_GROUP identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_GROUP, "TOK_GROUP")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;
                case 3 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:7: KW_ROLE identifier
                    {
                    KW_ROLE498=(Token)match(input,KW_ROLE,FOLLOW_KW_ROLE_in_principalName7920);  
                    stream_KW_ROLE.add(KW_ROLE498);


                    pushFollow(FOLLOW_identifier_in_principalName7922);
                    identifier499=identifier();

                    state._fsp--;

                    stream_identifier.add(identifier499.getTree());

                    // AST REWRITE
                    // elements: identifier
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 1408:26: -> ^( TOK_ROLE identifier )
                    {
                        // org/apache/hadoop/hive/ql/parse/HiveParser.g:1408:29: ^( TOK_ROLE identifier )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(TOK_ROLE, "TOK_ROLE")
                        , root_1);

                        adaptor.addChild(root_1, stream_identifier.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "principalName"


    public static class withOption_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withOption"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1411:1: withOption : KW_GRANT KW_OPTION -> ^( TOK_GRANT_WITH_OPTION ) ;
    public final HiveParser.withOption_return withOption() throws RecognitionException {
        HiveParser.withOption_return retval = new HiveParser.withOption_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_GRANT500=null;
        Token KW_OPTION501=null;

        CommonTree KW_GRANT500_tree=null;
        CommonTree KW_OPTION501_tree=null;
        RewriteRuleTokenStream stream_KW_OPTION=new RewriteRuleTokenStream(adaptor,"token KW_OPTION");
        RewriteRuleTokenStream stream_KW_GRANT=new RewriteRuleTokenStream(adaptor,"token KW_GRANT");

        msgs.push("grant with option");
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:5: ( KW_GRANT KW_OPTION -> ^( TOK_GRANT_WITH_OPTION ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1414:7: KW_GRANT KW_OPTION
            {
            KW_GRANT500=(Token)match(input,KW_GRANT,FOLLOW_KW_GRANT_in_withOption7957);  
            stream_KW_GRANT.add(KW_GRANT500);


            KW_OPTION501=(Token)match(input,KW_OPTION,FOLLOW_KW_OPTION_in_withOption7959);  
            stream_KW_OPTION.add(KW_OPTION501);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1415:5: -> ^( TOK_GRANT_WITH_OPTION )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1415:8: ^( TOK_GRANT_WITH_OPTION )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_GRANT_WITH_OPTION, "TOK_GRANT_WITH_OPTION")
                , root_1);

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

            msgs.pop();
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "withOption"


    public static class metastoreCheck_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "metastoreCheck"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1418:1: metastoreCheck : KW_MSCK (repair= KW_REPAIR )? ( KW_TABLE table= identifier ( partitionSpec )? ( COMMA partitionSpec )* )? -> ^( TOK_MSCK ( $repair)? ( $table ( partitionSpec )* )? ) ;
    public final HiveParser.metastoreCheck_return metastoreCheck() throws RecognitionException {
        HiveParser.metastoreCheck_return retval = new HiveParser.metastoreCheck_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token repair=null;
        Token KW_MSCK502=null;
        Token KW_TABLE503=null;
        Token COMMA505=null;
        HiveParser_IdentifiersParser.identifier_return table =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec504 =null;

        HiveParser_IdentifiersParser.partitionSpec_return partitionSpec506 =null;


        CommonTree repair_tree=null;
        CommonTree KW_MSCK502_tree=null;
        CommonTree KW_TABLE503_tree=null;
        CommonTree COMMA505_tree=null;
        RewriteRuleTokenStream stream_KW_MSCK=new RewriteRuleTokenStream(adaptor,"token KW_MSCK");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleTokenStream stream_KW_REPAIR=new RewriteRuleTokenStream(adaptor,"token KW_REPAIR");
        RewriteRuleTokenStream stream_KW_TABLE=new RewriteRuleTokenStream(adaptor,"token KW_TABLE");
        RewriteRuleSubtreeStream stream_partitionSpec=new RewriteRuleSubtreeStream(adaptor,"rule partitionSpec");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("metastore check statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:5: ( KW_MSCK (repair= KW_REPAIR )? ( KW_TABLE table= identifier ( partitionSpec )? ( COMMA partitionSpec )* )? -> ^( TOK_MSCK ( $repair)? ( $table ( partitionSpec )* )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:7: KW_MSCK (repair= KW_REPAIR )? ( KW_TABLE table= identifier ( partitionSpec )? ( COMMA partitionSpec )* )?
            {
            KW_MSCK502=(Token)match(input,KW_MSCK,FOLLOW_KW_MSCK_in_metastoreCheck7996);  
            stream_KW_MSCK.add(KW_MSCK502);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:15: (repair= KW_REPAIR )?
            int alt138=2;
            switch ( input.LA(1) ) {
                case KW_REPAIR:
                    {
                    alt138=1;
                    }
                    break;
            }

            switch (alt138) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:16: repair= KW_REPAIR
                    {
                    repair=(Token)match(input,KW_REPAIR,FOLLOW_KW_REPAIR_in_metastoreCheck8001);  
                    stream_KW_REPAIR.add(repair);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:35: ( KW_TABLE table= identifier ( partitionSpec )? ( COMMA partitionSpec )* )?
            int alt141=2;
            switch ( input.LA(1) ) {
                case KW_TABLE:
                    {
                    alt141=1;
                    }
                    break;
            }

            switch (alt141) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:36: KW_TABLE table= identifier ( partitionSpec )? ( COMMA partitionSpec )*
                    {
                    KW_TABLE503=(Token)match(input,KW_TABLE,FOLLOW_KW_TABLE_in_metastoreCheck8006);  
                    stream_KW_TABLE.add(KW_TABLE503);


                    pushFollow(FOLLOW_identifier_in_metastoreCheck8010);
                    table=identifier();

                    state._fsp--;

                    stream_identifier.add(table.getTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:62: ( partitionSpec )?
                    int alt139=2;
                    switch ( input.LA(1) ) {
                        case KW_PARTITION:
                            {
                            alt139=1;
                            }
                            break;
                    }

                    switch (alt139) {
                        case 1 :
                            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:62: partitionSpec
                            {
                            pushFollow(FOLLOW_partitionSpec_in_metastoreCheck8012);
                            partitionSpec504=partitionSpec();

                            state._fsp--;

                            stream_partitionSpec.add(partitionSpec504.getTree());

                            }
                            break;

                    }


                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:77: ( COMMA partitionSpec )*
                    loop140:
                    do {
                        int alt140=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt140=1;
                            }
                            break;

                        }

                        switch (alt140) {
                    	case 1 :
                    	    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1421:78: COMMA partitionSpec
                    	    {
                    	    COMMA505=(Token)match(input,COMMA,FOLLOW_COMMA_in_metastoreCheck8016);  
                    	    stream_COMMA.add(COMMA505);


                    	    pushFollow(FOLLOW_partitionSpec_in_metastoreCheck8018);
                    	    partitionSpec506=partitionSpec();

                    	    state._fsp--;

                    	    stream_partitionSpec.add(partitionSpec506.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop140;
                        }
                    } while (true);


                    }
                    break;

            }


            // AST REWRITE
            // elements: table, partitionSpec, repair
            // token labels: repair
            // rule labels: retval, table
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_repair=new RewriteRuleTokenStream(adaptor,"token repair",repair);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_table=new RewriteRuleSubtreeStream(adaptor,"rule table",table!=null?table.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1422:5: -> ^( TOK_MSCK ( $repair)? ( $table ( partitionSpec )* )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:8: ^( TOK_MSCK ( $repair)? ( $table ( partitionSpec )* )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_MSCK, "TOK_MSCK")
                , root_1);

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:20: ( $repair)?
                if ( stream_repair.hasNext() ) {
                    adaptor.addChild(root_1, stream_repair.nextNode());

                }
                stream_repair.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:28: ( $table ( partitionSpec )* )?
                if ( stream_table.hasNext()||stream_partitionSpec.hasNext() ) {
                    adaptor.addChild(root_1, stream_table.nextTree());

                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1422:36: ( partitionSpec )*
                    while ( stream_partitionSpec.hasNext() ) {
                        adaptor.addChild(root_1, stream_partitionSpec.nextTree());

                    }
                    stream_partitionSpec.reset();

                }
                stream_table.reset();
                stream_partitionSpec.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "metastoreCheck"


    public static class createFunctionStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createFunctionStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1425:1: createFunctionStatement : KW_CREATE KW_TEMPORARY KW_FUNCTION identifier KW_AS StringLiteral -> ^( TOK_CREATEFUNCTION identifier StringLiteral ) ;
    public final HiveParser.createFunctionStatement_return createFunctionStatement() throws RecognitionException {
        HiveParser.createFunctionStatement_return retval = new HiveParser.createFunctionStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE507=null;
        Token KW_TEMPORARY508=null;
        Token KW_FUNCTION509=null;
        Token KW_AS511=null;
        Token StringLiteral512=null;
        HiveParser_IdentifiersParser.identifier_return identifier510 =null;


        CommonTree KW_CREATE507_tree=null;
        CommonTree KW_TEMPORARY508_tree=null;
        CommonTree KW_FUNCTION509_tree=null;
        CommonTree KW_AS511_tree=null;
        CommonTree StringLiteral512_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("create function statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:5: ( KW_CREATE KW_TEMPORARY KW_FUNCTION identifier KW_AS StringLiteral -> ^( TOK_CREATEFUNCTION identifier StringLiteral ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1428:7: KW_CREATE KW_TEMPORARY KW_FUNCTION identifier KW_AS StringLiteral
            {
            KW_CREATE507=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createFunctionStatement8072);  
            stream_KW_CREATE.add(KW_CREATE507);


            KW_TEMPORARY508=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_createFunctionStatement8074);  
            stream_KW_TEMPORARY.add(KW_TEMPORARY508);


            KW_FUNCTION509=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_createFunctionStatement8076);  
            stream_KW_FUNCTION.add(KW_FUNCTION509);


            pushFollow(FOLLOW_identifier_in_createFunctionStatement8078);
            identifier510=identifier();

            state._fsp--;

            stream_identifier.add(identifier510.getTree());

            KW_AS511=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createFunctionStatement8080);  
            stream_KW_AS.add(KW_AS511);


            StringLiteral512=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_createFunctionStatement8082);  
            stream_StringLiteral.add(StringLiteral512);


            // AST REWRITE
            // elements: StringLiteral, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1429:5: -> ^( TOK_CREATEFUNCTION identifier StringLiteral )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1429:8: ^( TOK_CREATEFUNCTION identifier StringLiteral )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEFUNCTION, "TOK_CREATEFUNCTION")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                adaptor.addChild(root_1, 
                stream_StringLiteral.nextNode()
                );

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createFunctionStatement"


    public static class dropFunctionStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropFunctionStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1432:1: dropFunctionStatement : KW_DROP KW_TEMPORARY KW_FUNCTION ( ifExists )? identifier -> ^( TOK_DROPFUNCTION identifier ( ifExists )? ) ;
    public final HiveParser.dropFunctionStatement_return dropFunctionStatement() throws RecognitionException {
        HiveParser.dropFunctionStatement_return retval = new HiveParser.dropFunctionStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP513=null;
        Token KW_TEMPORARY514=null;
        Token KW_FUNCTION515=null;
        HiveParser.ifExists_return ifExists516 =null;

        HiveParser_IdentifiersParser.identifier_return identifier517 =null;


        CommonTree KW_DROP513_tree=null;
        CommonTree KW_TEMPORARY514_tree=null;
        CommonTree KW_FUNCTION515_tree=null;
        RewriteRuleTokenStream stream_KW_FUNCTION=new RewriteRuleTokenStream(adaptor,"token KW_FUNCTION");
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
         msgs.push("drop temporary function statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:5: ( KW_DROP KW_TEMPORARY KW_FUNCTION ( ifExists )? identifier -> ^( TOK_DROPFUNCTION identifier ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:7: KW_DROP KW_TEMPORARY KW_FUNCTION ( ifExists )? identifier
            {
            KW_DROP513=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropFunctionStatement8123);  
            stream_KW_DROP.add(KW_DROP513);


            KW_TEMPORARY514=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_dropFunctionStatement8125);  
            stream_KW_TEMPORARY.add(KW_TEMPORARY514);


            KW_FUNCTION515=(Token)match(input,KW_FUNCTION,FOLLOW_KW_FUNCTION_in_dropFunctionStatement8127);  
            stream_KW_FUNCTION.add(KW_FUNCTION515);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:40: ( ifExists )?
            int alt142=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt142=1;
                    }
                    break;
            }

            switch (alt142) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1435:40: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropFunctionStatement8129);
                    ifExists516=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists516.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_identifier_in_dropFunctionStatement8132);
            identifier517=identifier();

            state._fsp--;

            stream_identifier.add(identifier517.getTree());

            // AST REWRITE
            // elements: ifExists, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1436:5: -> ^( TOK_DROPFUNCTION identifier ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:8: ^( TOK_DROPFUNCTION identifier ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPFUNCTION, "TOK_DROPFUNCTION")
                , root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1436:38: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropFunctionStatement"


    public static class createMacroStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createMacroStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1439:1: createMacroStatement : KW_CREATE KW_TEMPORARY KW_MACRO Identifier LPAREN ( columnNameTypeList )? RPAREN expression -> ^( TOK_CREATEMACRO Identifier ( columnNameTypeList )? expression ) ;
    public final HiveParser.createMacroStatement_return createMacroStatement() throws RecognitionException {
        HiveParser.createMacroStatement_return retval = new HiveParser.createMacroStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE518=null;
        Token KW_TEMPORARY519=null;
        Token KW_MACRO520=null;
        Token Identifier521=null;
        Token LPAREN522=null;
        Token RPAREN524=null;
        HiveParser.columnNameTypeList_return columnNameTypeList523 =null;

        HiveParser_IdentifiersParser.expression_return expression525 =null;


        CommonTree KW_CREATE518_tree=null;
        CommonTree KW_TEMPORARY519_tree=null;
        CommonTree KW_MACRO520_tree=null;
        CommonTree Identifier521_tree=null;
        CommonTree LPAREN522_tree=null;
        CommonTree RPAREN524_tree=null;
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_MACRO=new RewriteRuleTokenStream(adaptor,"token KW_MACRO");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
         msgs.push("create macro statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:5: ( KW_CREATE KW_TEMPORARY KW_MACRO Identifier LPAREN ( columnNameTypeList )? RPAREN expression -> ^( TOK_CREATEMACRO Identifier ( columnNameTypeList )? expression ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1442:7: KW_CREATE KW_TEMPORARY KW_MACRO Identifier LPAREN ( columnNameTypeList )? RPAREN expression
            {
            KW_CREATE518=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createMacroStatement8174);  
            stream_KW_CREATE.add(KW_CREATE518);


            KW_TEMPORARY519=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_createMacroStatement8176);  
            stream_KW_TEMPORARY.add(KW_TEMPORARY519);


            KW_MACRO520=(Token)match(input,KW_MACRO,FOLLOW_KW_MACRO_in_createMacroStatement8178);  
            stream_KW_MACRO.add(KW_MACRO520);


            Identifier521=(Token)match(input,Identifier,FOLLOW_Identifier_in_createMacroStatement8180);  
            stream_Identifier.add(Identifier521);


            LPAREN522=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createMacroStatement8188);  
            stream_LPAREN.add(LPAREN522);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1443:14: ( columnNameTypeList )?
            int alt143=2;
            switch ( input.LA(1) ) {
                case Identifier:
                case KW_ADD:
                case KW_AFTER:
                case KW_ALL:
                case KW_ALTER:
                case KW_ANALYZE:
                case KW_ARCHIVE:
                case KW_ARRAY:
                case KW_AS:
                case KW_ASC:
                case KW_BEFORE:
                case KW_BETWEEN:
                case KW_BIGINT:
                case KW_BINARY:
                case KW_BOOLEAN:
                case KW_BOTH:
                case KW_BUCKET:
                case KW_BUCKETS:
                case KW_BY:
                case KW_CASCADE:
                case KW_CHANGE:
                case KW_CLUSTER:
                case KW_CLUSTERED:
                case KW_CLUSTERSTATUS:
                case KW_COLLECTION:
                case KW_COLUMNS:
                case KW_COMMENT:
                case KW_COMPUTE:
                case KW_CONCATENATE:
                case KW_CONTINUE:
                case KW_CREATE:
                case KW_CUBE:
                case KW_CURSOR:
                case KW_DATA:
                case KW_DATABASES:
                case KW_DATE:
                case KW_DATETIME:
                case KW_DBPROPERTIES:
                case KW_DECIMAL:
                case KW_DEFAULT:
                case KW_DEFERRED:
                case KW_DEFINED:
                case KW_DELETE:
                case KW_DELIMITED:
                case KW_DEPENDENCY:
                case KW_DESC:
                case KW_DESCRIBE:
                case KW_DIRECTORIES:
                case KW_DIRECTORY:
                case KW_DISABLE:
                case KW_DISTRIBUTE:
                case KW_DOUBLE:
                case KW_DROP:
                case KW_ELEM_TYPE:
                case KW_ENABLE:
                case KW_ESCAPED:
                case KW_EXCLUSIVE:
                case KW_EXISTS:
                case KW_EXPLAIN:
                case KW_EXPORT:
                case KW_EXTERNAL:
                case KW_FALSE:
                case KW_FETCH:
                case KW_FIELDS:
                case KW_FILEFORMAT:
                case KW_FIRST:
                case KW_FLOAT:
                case KW_FOR:
                case KW_FORMAT:
                case KW_FORMATTED:
                case KW_FULL:
                case KW_FUNCTIONS:
                case KW_GRANT:
                case KW_GROUP:
                case KW_GROUPING:
                case KW_HOLD_DDLTIME:
                case KW_IDXPROPERTIES:
                case KW_IGNORE:
                case KW_IMPORT:
                case KW_IN:
                case KW_INDEX:
                case KW_INDEXES:
                case KW_INNER:
                case KW_INPATH:
                case KW_INPUTDRIVER:
                case KW_INPUTFORMAT:
                case KW_INSERT:
                case KW_INT:
                case KW_INTERSECT:
                case KW_INTO:
                case KW_IS:
                case KW_ITEMS:
                case KW_KEYS:
                case KW_KEY_TYPE:
                case KW_LATERAL:
                case KW_LEFT:
                case KW_LIKE:
                case KW_LIMIT:
                case KW_LINES:
                case KW_LOAD:
                case KW_LOCAL:
                case KW_LOCATION:
                case KW_LOCK:
                case KW_LOCKS:
                case KW_LOGICAL:
                case KW_LONG:
                case KW_MAPJOIN:
                case KW_MATERIALIZED:
                case KW_MINUS:
                case KW_MSCK:
                case KW_NONE:
                case KW_NOSCAN:
                case KW_NO_DROP:
                case KW_NULL:
                case KW_OF:
                case KW_OFFLINE:
                case KW_OPTION:
                case KW_ORCFILE:
                case KW_ORDER:
                case KW_OUT:
                case KW_OUTER:
                case KW_OUTPUTDRIVER:
                case KW_OUTPUTFORMAT:
                case KW_OVERWRITE:
                case KW_PARTITION:
                case KW_PARTITIONED:
                case KW_PARTITIONS:
                case KW_PERCENT:
                case KW_PLUS:
                case KW_PRETTY:
                case KW_PROCEDURE:
                case KW_PROTECTION:
                case KW_PURGE:
                case KW_RANGE:
                case KW_RCFILE:
                case KW_READ:
                case KW_READONLY:
                case KW_READS:
                case KW_REBUILD:
                case KW_RECORDREADER:
                case KW_RECORDWRITER:
                case KW_REGEXP:
                case KW_RENAME:
                case KW_REPAIR:
                case KW_REPLACE:
                case KW_RESTRICT:
                case KW_REVOKE:
                case KW_RIGHT:
                case KW_RLIKE:
                case KW_ROLE:
                case KW_ROLES:
                case KW_ROLLUP:
                case KW_ROW:
                case KW_ROWS:
                case KW_SCHEMA:
                case KW_SCHEMAS:
                case KW_SEMI:
                case KW_SEQUENCEFILE:
                case KW_SERDE:
                case KW_SERDEPROPERTIES:
                case KW_SERVER:
                case KW_SET:
                case KW_SETS:
                case KW_SHARED:
                case KW_SHOW:
                case KW_SHOW_DATABASE:
                case KW_SKEWED:
                case KW_SMALLINT:
                case KW_SORT:
                case KW_SORTED:
                case KW_SSL:
                case KW_STATISTICS:
                case KW_STORED:
                case KW_STREAMTABLE:
                case KW_STRING:
                case KW_STRUCT:
                case KW_TABLE:
                case KW_TABLES:
                case KW_TBLPROPERTIES:
                case KW_TEMPORARY:
                case KW_TERMINATED:
                case KW_TEXTFILE:
                case KW_TIMESTAMP:
                case KW_TINYINT:
                case KW_TO:
                case KW_TOUCH:
                case KW_TRIGGER:
                case KW_TRUE:
                case KW_TRUNCATE:
                case KW_UNARCHIVE:
                case KW_UNDO:
                case KW_UNION:
                case KW_UNIONTYPE:
                case KW_UNLOCK:
                case KW_UNSET:
                case KW_UNSIGNED:
                case KW_UPDATE:
                case KW_URI:
                case KW_USE:
                case KW_USER:
                case KW_USING:
                case KW_UTC:
                case KW_UTCTIMESTAMP:
                case KW_VALUE_TYPE:
                case KW_VIEW:
                case KW_WHILE:
                case KW_WITH:
                    {
                    alt143=1;
                    }
                    break;
            }

            switch (alt143) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1443:14: columnNameTypeList
                    {
                    pushFollow(FOLLOW_columnNameTypeList_in_createMacroStatement8190);
                    columnNameTypeList523=columnNameTypeList();

                    state._fsp--;

                    stream_columnNameTypeList.add(columnNameTypeList523.getTree());

                    }
                    break;

            }


            RPAREN524=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createMacroStatement8193);  
            stream_RPAREN.add(RPAREN524);


            pushFollow(FOLLOW_expression_in_createMacroStatement8195);
            expression525=expression();

            state._fsp--;

            stream_expression.add(expression525.getTree());

            // AST REWRITE
            // elements: Identifier, expression, columnNameTypeList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1444:5: -> ^( TOK_CREATEMACRO Identifier ( columnNameTypeList )? expression )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1444:8: ^( TOK_CREATEMACRO Identifier ( columnNameTypeList )? expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEMACRO, "TOK_CREATEMACRO")
                , root_1);

                adaptor.addChild(root_1, 
                stream_Identifier.nextNode()
                );

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1444:37: ( columnNameTypeList )?
                if ( stream_columnNameTypeList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                }
                stream_columnNameTypeList.reset();

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createMacroStatement"


    public static class dropMacroStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropMacroStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1447:1: dropMacroStatement : KW_DROP KW_TEMPORARY KW_MACRO ( ifExists )? Identifier -> ^( TOK_DROPMACRO Identifier ( ifExists )? ) ;
    public final HiveParser.dropMacroStatement_return dropMacroStatement() throws RecognitionException {
        HiveParser.dropMacroStatement_return retval = new HiveParser.dropMacroStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP526=null;
        Token KW_TEMPORARY527=null;
        Token KW_MACRO528=null;
        Token Identifier530=null;
        HiveParser.ifExists_return ifExists529 =null;


        CommonTree KW_DROP526_tree=null;
        CommonTree KW_TEMPORARY527_tree=null;
        CommonTree KW_MACRO528_tree=null;
        CommonTree Identifier530_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_TEMPORARY=new RewriteRuleTokenStream(adaptor,"token KW_TEMPORARY");
        RewriteRuleTokenStream stream_Identifier=new RewriteRuleTokenStream(adaptor,"token Identifier");
        RewriteRuleTokenStream stream_KW_MACRO=new RewriteRuleTokenStream(adaptor,"token KW_MACRO");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         msgs.push("drop macro statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:5: ( KW_DROP KW_TEMPORARY KW_MACRO ( ifExists )? Identifier -> ^( TOK_DROPMACRO Identifier ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:7: KW_DROP KW_TEMPORARY KW_MACRO ( ifExists )? Identifier
            {
            KW_DROP526=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropMacroStatement8239);  
            stream_KW_DROP.add(KW_DROP526);


            KW_TEMPORARY527=(Token)match(input,KW_TEMPORARY,FOLLOW_KW_TEMPORARY_in_dropMacroStatement8241);  
            stream_KW_TEMPORARY.add(KW_TEMPORARY527);


            KW_MACRO528=(Token)match(input,KW_MACRO,FOLLOW_KW_MACRO_in_dropMacroStatement8243);  
            stream_KW_MACRO.add(KW_MACRO528);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:37: ( ifExists )?
            int alt144=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt144=1;
                    }
                    break;
            }

            switch (alt144) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1450:37: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropMacroStatement8245);
                    ifExists529=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists529.getTree());

                    }
                    break;

            }


            Identifier530=(Token)match(input,Identifier,FOLLOW_Identifier_in_dropMacroStatement8248);  
            stream_Identifier.add(Identifier530);


            // AST REWRITE
            // elements: ifExists, Identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1451:5: -> ^( TOK_DROPMACRO Identifier ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:8: ^( TOK_DROPMACRO Identifier ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPMACRO, "TOK_DROPMACRO")
                , root_1);

                adaptor.addChild(root_1, 
                stream_Identifier.nextNode()
                );

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1451:35: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropMacroStatement"


    public static class createViewStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createViewStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1454:1: createViewStatement : KW_CREATE ( orReplace )? KW_VIEW ( ifNotExists )? name= tableName ( LPAREN columnNameCommentList RPAREN )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? KW_AS selectStatement -> ^( TOK_CREATEVIEW $name ( orReplace )? ( ifNotExists )? ( columnNameCommentList )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? selectStatement ) ;
    public final HiveParser.createViewStatement_return createViewStatement() throws RecognitionException {
        HiveParser.createViewStatement_return retval = new HiveParser.createViewStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_CREATE531=null;
        Token KW_VIEW533=null;
        Token LPAREN535=null;
        Token RPAREN537=null;
        Token KW_AS541=null;
        HiveParser_FromClauseParser.tableName_return name =null;

        HiveParser.orReplace_return orReplace532 =null;

        HiveParser.ifNotExists_return ifNotExists534 =null;

        HiveParser.columnNameCommentList_return columnNameCommentList536 =null;

        HiveParser.tableComment_return tableComment538 =null;

        HiveParser.viewPartition_return viewPartition539 =null;

        HiveParser.tablePropertiesPrefixed_return tablePropertiesPrefixed540 =null;

        HiveParser.selectStatement_return selectStatement542 =null;


        CommonTree KW_CREATE531_tree=null;
        CommonTree KW_VIEW533_tree=null;
        CommonTree LPAREN535_tree=null;
        CommonTree RPAREN537_tree=null;
        CommonTree KW_AS541_tree=null;
        RewriteRuleTokenStream stream_KW_AS=new RewriteRuleTokenStream(adaptor,"token KW_AS");
        RewriteRuleTokenStream stream_KW_CREATE=new RewriteRuleTokenStream(adaptor,"token KW_CREATE");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_VIEW=new RewriteRuleTokenStream(adaptor,"token KW_VIEW");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_selectStatement=new RewriteRuleSubtreeStream(adaptor,"rule selectStatement");
        RewriteRuleSubtreeStream stream_columnNameCommentList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameCommentList");
        RewriteRuleSubtreeStream stream_tableName=new RewriteRuleSubtreeStream(adaptor,"rule tableName");
        RewriteRuleSubtreeStream stream_orReplace=new RewriteRuleSubtreeStream(adaptor,"rule orReplace");
        RewriteRuleSubtreeStream stream_tableComment=new RewriteRuleSubtreeStream(adaptor,"rule tableComment");
        RewriteRuleSubtreeStream stream_tablePropertiesPrefixed=new RewriteRuleSubtreeStream(adaptor,"rule tablePropertiesPrefixed");
        RewriteRuleSubtreeStream stream_viewPartition=new RewriteRuleSubtreeStream(adaptor,"rule viewPartition");
        RewriteRuleSubtreeStream stream_ifNotExists=new RewriteRuleSubtreeStream(adaptor,"rule ifNotExists");

            msgs.push("create view statement");

        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:5: ( KW_CREATE ( orReplace )? KW_VIEW ( ifNotExists )? name= tableName ( LPAREN columnNameCommentList RPAREN )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? KW_AS selectStatement -> ^( TOK_CREATEVIEW $name ( orReplace )? ( ifNotExists )? ( columnNameCommentList )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? selectStatement ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:7: KW_CREATE ( orReplace )? KW_VIEW ( ifNotExists )? name= tableName ( LPAREN columnNameCommentList RPAREN )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? KW_AS selectStatement
            {
            KW_CREATE531=(Token)match(input,KW_CREATE,FOLLOW_KW_CREATE_in_createViewStatement8290);  
            stream_KW_CREATE.add(KW_CREATE531);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:17: ( orReplace )?
            int alt145=2;
            switch ( input.LA(1) ) {
                case KW_OR:
                    {
                    alt145=1;
                    }
                    break;
            }

            switch (alt145) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:18: orReplace
                    {
                    pushFollow(FOLLOW_orReplace_in_createViewStatement8293);
                    orReplace532=orReplace();

                    state._fsp--;

                    stream_orReplace.add(orReplace532.getTree());

                    }
                    break;

            }


            KW_VIEW533=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_createViewStatement8297);  
            stream_KW_VIEW.add(KW_VIEW533);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:38: ( ifNotExists )?
            int alt146=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt146=1;
                    }
                    break;
            }

            switch (alt146) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1459:39: ifNotExists
                    {
                    pushFollow(FOLLOW_ifNotExists_in_createViewStatement8300);
                    ifNotExists534=ifNotExists();

                    state._fsp--;

                    stream_ifNotExists.add(ifNotExists534.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_tableName_in_createViewStatement8306);
            name=tableName();

            state._fsp--;

            stream_tableName.add(name.getTree());

            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:9: ( LPAREN columnNameCommentList RPAREN )?
            int alt147=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    alt147=1;
                    }
                    break;
            }

            switch (alt147) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:10: LPAREN columnNameCommentList RPAREN
                    {
                    LPAREN535=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_createViewStatement8317);  
                    stream_LPAREN.add(LPAREN535);


                    pushFollow(FOLLOW_columnNameCommentList_in_createViewStatement8319);
                    columnNameCommentList536=columnNameCommentList();

                    state._fsp--;

                    stream_columnNameCommentList.add(columnNameCommentList536.getTree());

                    RPAREN537=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_createViewStatement8321);  
                    stream_RPAREN.add(RPAREN537);


                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:48: ( tableComment )?
            int alt148=2;
            switch ( input.LA(1) ) {
                case KW_COMMENT:
                    {
                    alt148=1;
                    }
                    break;
            }

            switch (alt148) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:48: tableComment
                    {
                    pushFollow(FOLLOW_tableComment_in_createViewStatement8325);
                    tableComment538=tableComment();

                    state._fsp--;

                    stream_tableComment.add(tableComment538.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:62: ( viewPartition )?
            int alt149=2;
            switch ( input.LA(1) ) {
                case KW_PARTITIONED:
                    {
                    alt149=1;
                    }
                    break;
            }

            switch (alt149) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1460:62: viewPartition
                    {
                    pushFollow(FOLLOW_viewPartition_in_createViewStatement8328);
                    viewPartition539=viewPartition();

                    state._fsp--;

                    stream_viewPartition.add(viewPartition539.getTree());

                    }
                    break;

            }


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1461:9: ( tablePropertiesPrefixed )?
            int alt150=2;
            switch ( input.LA(1) ) {
                case KW_TBLPROPERTIES:
                    {
                    alt150=1;
                    }
                    break;
            }

            switch (alt150) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1461:9: tablePropertiesPrefixed
                    {
                    pushFollow(FOLLOW_tablePropertiesPrefixed_in_createViewStatement8339);
                    tablePropertiesPrefixed540=tablePropertiesPrefixed();

                    state._fsp--;

                    stream_tablePropertiesPrefixed.add(tablePropertiesPrefixed540.getTree());

                    }
                    break;

            }


            KW_AS541=(Token)match(input,KW_AS,FOLLOW_KW_AS_in_createViewStatement8350);  
            stream_KW_AS.add(KW_AS541);


            pushFollow(FOLLOW_selectStatement_in_createViewStatement8360);
            selectStatement542=selectStatement();

            state._fsp--;

            stream_selectStatement.add(selectStatement542.getTree());

            // AST REWRITE
            // elements: viewPartition, columnNameCommentList, tablePropertiesPrefixed, tableComment, selectStatement, orReplace, name, ifNotExists
            // token labels: 
            // rule labels: retval, name
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name",name!=null?name.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1464:5: -> ^( TOK_CREATEVIEW $name ( orReplace )? ( ifNotExists )? ( columnNameCommentList )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? selectStatement )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:8: ^( TOK_CREATEVIEW $name ( orReplace )? ( ifNotExists )? ( columnNameCommentList )? ( tableComment )? ( viewPartition )? ( tablePropertiesPrefixed )? selectStatement )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_CREATEVIEW, "TOK_CREATEVIEW")
                , root_1);

                adaptor.addChild(root_1, stream_name.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1464:31: ( orReplace )?
                if ( stream_orReplace.hasNext() ) {
                    adaptor.addChild(root_1, stream_orReplace.nextTree());

                }
                stream_orReplace.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1465:10: ( ifNotExists )?
                if ( stream_ifNotExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifNotExists.nextTree());

                }
                stream_ifNotExists.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1466:10: ( columnNameCommentList )?
                if ( stream_columnNameCommentList.hasNext() ) {
                    adaptor.addChild(root_1, stream_columnNameCommentList.nextTree());

                }
                stream_columnNameCommentList.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1467:10: ( tableComment )?
                if ( stream_tableComment.hasNext() ) {
                    adaptor.addChild(root_1, stream_tableComment.nextTree());

                }
                stream_tableComment.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1468:10: ( viewPartition )?
                if ( stream_viewPartition.hasNext() ) {
                    adaptor.addChild(root_1, stream_viewPartition.nextTree());

                }
                stream_viewPartition.reset();

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1469:10: ( tablePropertiesPrefixed )?
                if ( stream_tablePropertiesPrefixed.hasNext() ) {
                    adaptor.addChild(root_1, stream_tablePropertiesPrefixed.nextTree());

                }
                stream_tablePropertiesPrefixed.reset();

                adaptor.addChild(root_1, stream_selectStatement.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createViewStatement"


    public static class viewPartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "viewPartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1474:1: viewPartition : KW_PARTITIONED KW_ON LPAREN columnNameList RPAREN -> ^( TOK_VIEWPARTCOLS columnNameList ) ;
    public final HiveParser.viewPartition_return viewPartition() throws RecognitionException {
        HiveParser.viewPartition_return retval = new HiveParser.viewPartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_PARTITIONED543=null;
        Token KW_ON544=null;
        Token LPAREN545=null;
        Token RPAREN547=null;
        HiveParser.columnNameList_return columnNameList546 =null;


        CommonTree KW_PARTITIONED543_tree=null;
        CommonTree KW_ON544_tree=null;
        CommonTree LPAREN545_tree=null;
        CommonTree RPAREN547_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_PARTITIONED=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONED");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
         msgs.push("view partition specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1477:5: ( KW_PARTITIONED KW_ON LPAREN columnNameList RPAREN -> ^( TOK_VIEWPARTCOLS columnNameList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1477:7: KW_PARTITIONED KW_ON LPAREN columnNameList RPAREN
            {
            KW_PARTITIONED543=(Token)match(input,KW_PARTITIONED,FOLLOW_KW_PARTITIONED_in_viewPartition8483);  
            stream_KW_PARTITIONED.add(KW_PARTITIONED543);


            KW_ON544=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_viewPartition8485);  
            stream_KW_ON.add(KW_ON544);


            LPAREN545=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_viewPartition8487);  
            stream_LPAREN.add(LPAREN545);


            pushFollow(FOLLOW_columnNameList_in_viewPartition8489);
            columnNameList546=columnNameList();

            state._fsp--;

            stream_columnNameList.add(columnNameList546.getTree());

            RPAREN547=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_viewPartition8491);  
            stream_RPAREN.add(RPAREN547);


            // AST REWRITE
            // elements: columnNameList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1478:5: -> ^( TOK_VIEWPARTCOLS columnNameList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1478:8: ^( TOK_VIEWPARTCOLS columnNameList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_VIEWPARTCOLS, "TOK_VIEWPARTCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "viewPartition"


    public static class dropViewStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dropViewStatement"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1481:1: dropViewStatement : KW_DROP KW_VIEW ( ifExists )? viewName -> ^( TOK_DROPVIEW viewName ( ifExists )? ) ;
    public final HiveParser.dropViewStatement_return dropViewStatement() throws RecognitionException {
        HiveParser.dropViewStatement_return retval = new HiveParser.dropViewStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_DROP548=null;
        Token KW_VIEW549=null;
        HiveParser.ifExists_return ifExists550 =null;

        HiveParser_FromClauseParser.viewName_return viewName551 =null;


        CommonTree KW_DROP548_tree=null;
        CommonTree KW_VIEW549_tree=null;
        RewriteRuleTokenStream stream_KW_DROP=new RewriteRuleTokenStream(adaptor,"token KW_DROP");
        RewriteRuleTokenStream stream_KW_VIEW=new RewriteRuleTokenStream(adaptor,"token KW_VIEW");
        RewriteRuleSubtreeStream stream_viewName=new RewriteRuleSubtreeStream(adaptor,"rule viewName");
        RewriteRuleSubtreeStream stream_ifExists=new RewriteRuleSubtreeStream(adaptor,"rule ifExists");
         msgs.push("drop view statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:5: ( KW_DROP KW_VIEW ( ifExists )? viewName -> ^( TOK_DROPVIEW viewName ( ifExists )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:7: KW_DROP KW_VIEW ( ifExists )? viewName
            {
            KW_DROP548=(Token)match(input,KW_DROP,FOLLOW_KW_DROP_in_dropViewStatement8530);  
            stream_KW_DROP.add(KW_DROP548);


            KW_VIEW549=(Token)match(input,KW_VIEW,FOLLOW_KW_VIEW_in_dropViewStatement8532);  
            stream_KW_VIEW.add(KW_VIEW549);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:23: ( ifExists )?
            int alt151=2;
            switch ( input.LA(1) ) {
                case KW_IF:
                    {
                    alt151=1;
                    }
                    break;
            }

            switch (alt151) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:23: ifExists
                    {
                    pushFollow(FOLLOW_ifExists_in_dropViewStatement8534);
                    ifExists550=ifExists();

                    state._fsp--;

                    stream_ifExists.add(ifExists550.getTree());

                    }
                    break;

            }


            pushFollow(FOLLOW_viewName_in_dropViewStatement8537);
            viewName551=viewName();

            state._fsp--;

            stream_viewName.add(viewName551.getTree());

            // AST REWRITE
            // elements: viewName, ifExists
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1484:42: -> ^( TOK_DROPVIEW viewName ( ifExists )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:45: ^( TOK_DROPVIEW viewName ( ifExists )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_DROPVIEW, "TOK_DROPVIEW")
                , root_1);

                adaptor.addChild(root_1, stream_viewName.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1484:69: ( ifExists )?
                if ( stream_ifExists.hasNext() ) {
                    adaptor.addChild(root_1, stream_ifExists.nextTree());

                }
                stream_ifExists.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dropViewStatement"


    public static class showStmtIdentifier_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "showStmtIdentifier"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1487:1: showStmtIdentifier : ( identifier | StringLiteral );
    public final HiveParser.showStmtIdentifier_return showStmtIdentifier() throws RecognitionException {
        HiveParser.showStmtIdentifier_return retval = new HiveParser.showStmtIdentifier_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token StringLiteral553=null;
        HiveParser_IdentifiersParser.identifier_return identifier552 =null;


        CommonTree StringLiteral553_tree=null;

         msgs.push("identifier for show statement"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:5: ( identifier | StringLiteral )
            int alt152=2;
            switch ( input.LA(1) ) {
            case Identifier:
            case KW_ADD:
            case KW_AFTER:
            case KW_ALL:
            case KW_ALTER:
            case KW_ANALYZE:
            case KW_ARCHIVE:
            case KW_ARRAY:
            case KW_AS:
            case KW_ASC:
            case KW_BEFORE:
            case KW_BETWEEN:
            case KW_BIGINT:
            case KW_BINARY:
            case KW_BOOLEAN:
            case KW_BOTH:
            case KW_BUCKET:
            case KW_BUCKETS:
            case KW_BY:
            case KW_CASCADE:
            case KW_CHANGE:
            case KW_CLUSTER:
            case KW_CLUSTERED:
            case KW_CLUSTERSTATUS:
            case KW_COLLECTION:
            case KW_COLUMNS:
            case KW_COMMENT:
            case KW_COMPUTE:
            case KW_CONCATENATE:
            case KW_CONTINUE:
            case KW_CREATE:
            case KW_CUBE:
            case KW_CURSOR:
            case KW_DATA:
            case KW_DATABASES:
            case KW_DATE:
            case KW_DATETIME:
            case KW_DBPROPERTIES:
            case KW_DECIMAL:
            case KW_DEFAULT:
            case KW_DEFERRED:
            case KW_DEFINED:
            case KW_DELETE:
            case KW_DELIMITED:
            case KW_DEPENDENCY:
            case KW_DESC:
            case KW_DESCRIBE:
            case KW_DIRECTORIES:
            case KW_DIRECTORY:
            case KW_DISABLE:
            case KW_DISTRIBUTE:
            case KW_DOUBLE:
            case KW_DROP:
            case KW_ELEM_TYPE:
            case KW_ENABLE:
            case KW_ESCAPED:
            case KW_EXCLUSIVE:
            case KW_EXISTS:
            case KW_EXPLAIN:
            case KW_EXPORT:
            case KW_EXTERNAL:
            case KW_FALSE:
            case KW_FETCH:
            case KW_FIELDS:
            case KW_FILEFORMAT:
            case KW_FIRST:
            case KW_FLOAT:
            case KW_FOR:
            case KW_FORMAT:
            case KW_FORMATTED:
            case KW_FULL:
            case KW_FUNCTIONS:
            case KW_GRANT:
            case KW_GROUP:
            case KW_GROUPING:
            case KW_HOLD_DDLTIME:
            case KW_IDXPROPERTIES:
            case KW_IGNORE:
            case KW_IMPORT:
            case KW_IN:
            case KW_INDEX:
            case KW_INDEXES:
            case KW_INNER:
            case KW_INPATH:
            case KW_INPUTDRIVER:
            case KW_INPUTFORMAT:
            case KW_INSERT:
            case KW_INT:
            case KW_INTERSECT:
            case KW_INTO:
            case KW_IS:
            case KW_ITEMS:
            case KW_KEYS:
            case KW_KEY_TYPE:
            case KW_LATERAL:
            case KW_LEFT:
            case KW_LIKE:
            case KW_LIMIT:
            case KW_LINES:
            case KW_LOAD:
            case KW_LOCAL:
            case KW_LOCATION:
            case KW_LOCK:
            case KW_LOCKS:
            case KW_LOGICAL:
            case KW_LONG:
            case KW_MAPJOIN:
            case KW_MATERIALIZED:
            case KW_MINUS:
            case KW_MSCK:
            case KW_NONE:
            case KW_NOSCAN:
            case KW_NO_DROP:
            case KW_NULL:
            case KW_OF:
            case KW_OFFLINE:
            case KW_OPTION:
            case KW_ORCFILE:
            case KW_ORDER:
            case KW_OUT:
            case KW_OUTER:
            case KW_OUTPUTDRIVER:
            case KW_OUTPUTFORMAT:
            case KW_OVERWRITE:
            case KW_PARTITION:
            case KW_PARTITIONED:
            case KW_PARTITIONS:
            case KW_PERCENT:
            case KW_PLUS:
            case KW_PRETTY:
            case KW_PROCEDURE:
            case KW_PROTECTION:
            case KW_PURGE:
            case KW_RANGE:
            case KW_RCFILE:
            case KW_READ:
            case KW_READONLY:
            case KW_READS:
            case KW_REBUILD:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REGEXP:
            case KW_RENAME:
            case KW_REPAIR:
            case KW_REPLACE:
            case KW_RESTRICT:
            case KW_REVOKE:
            case KW_RIGHT:
            case KW_RLIKE:
            case KW_ROLE:
            case KW_ROLES:
            case KW_ROLLUP:
            case KW_ROW:
            case KW_ROWS:
            case KW_SCHEMA:
            case KW_SCHEMAS:
            case KW_SEMI:
            case KW_SEQUENCEFILE:
            case KW_SERDE:
            case KW_SERDEPROPERTIES:
            case KW_SERVER:
            case KW_SET:
            case KW_SETS:
            case KW_SHARED:
            case KW_SHOW:
            case KW_SHOW_DATABASE:
            case KW_SKEWED:
            case KW_SMALLINT:
            case KW_SORT:
            case KW_SORTED:
            case KW_SSL:
            case KW_STATISTICS:
            case KW_STORED:
            case KW_STREAMTABLE:
            case KW_STRING:
            case KW_STRUCT:
            case KW_TABLE:
            case KW_TABLES:
            case KW_TBLPROPERTIES:
            case KW_TEMPORARY:
            case KW_TERMINATED:
            case KW_TEXTFILE:
            case KW_TIMESTAMP:
            case KW_TINYINT:
            case KW_TO:
            case KW_TOUCH:
            case KW_TRIGGER:
            case KW_TRUE:
            case KW_TRUNCATE:
            case KW_UNARCHIVE:
            case KW_UNDO:
            case KW_UNION:
            case KW_UNIONTYPE:
            case KW_UNLOCK:
            case KW_UNSET:
            case KW_UNSIGNED:
            case KW_UPDATE:
            case KW_URI:
            case KW_USE:
            case KW_USER:
            case KW_USING:
            case KW_UTC:
            case KW_UTCTIMESTAMP:
            case KW_VALUE_TYPE:
            case KW_VIEW:
            case KW_WHILE:
            case KW_WITH:
                {
                alt152=1;
                }
                break;
            case StringLiteral:
                {
                alt152=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 152, 0, input);

                throw nvae;

            }

            switch (alt152) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1490:7: identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_identifier_in_showStmtIdentifier8575);
                    identifier552=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier552.getTree());

                    }
                    break;
                case 2 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1491:7: StringLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    StringLiteral553=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_showStmtIdentifier8583); 
                    StringLiteral553_tree = 
                    (CommonTree)adaptor.create(StringLiteral553)
                    ;
                    adaptor.addChild(root_0, StringLiteral553_tree);


                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "showStmtIdentifier"


    public static class tableComment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tableComment"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1494:1: tableComment : KW_COMMENT comment= StringLiteral -> ^( TOK_TABLECOMMENT $comment) ;
    public final HiveParser.tableComment_return tableComment() throws RecognitionException {
        HiveParser.tableComment_return retval = new HiveParser.tableComment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token comment=null;
        Token KW_COMMENT554=null;

        CommonTree comment_tree=null;
        CommonTree KW_COMMENT554_tree=null;
        RewriteRuleTokenStream stream_StringLiteral=new RewriteRuleTokenStream(adaptor,"token StringLiteral");
        RewriteRuleTokenStream stream_KW_COMMENT=new RewriteRuleTokenStream(adaptor,"token KW_COMMENT");

         msgs.push("table's comment"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1497:5: ( KW_COMMENT comment= StringLiteral -> ^( TOK_TABLECOMMENT $comment) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1498:7: KW_COMMENT comment= StringLiteral
            {
            KW_COMMENT554=(Token)match(input,KW_COMMENT,FOLLOW_KW_COMMENT_in_tableComment8616);  
            stream_KW_COMMENT.add(KW_COMMENT554);


            comment=(Token)match(input,StringLiteral,FOLLOW_StringLiteral_in_tableComment8620);  
            stream_StringLiteral.add(comment);


            // AST REWRITE
            // elements: comment
            // token labels: comment
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_comment=new RewriteRuleTokenStream(adaptor,"token comment",comment);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1498:41: -> ^( TOK_TABLECOMMENT $comment)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1498:44: ^( TOK_TABLECOMMENT $comment)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLECOMMENT, "TOK_TABLECOMMENT")
                , root_1);

                adaptor.addChild(root_1, stream_comment.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tableComment"


    public static class tablePartition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tablePartition"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1501:1: tablePartition : KW_PARTITIONED KW_BY LPAREN columnNameTypeList RPAREN -> ^( TOK_TABLEPARTCOLS columnNameTypeList ) ;
    public final HiveParser.tablePartition_return tablePartition() throws RecognitionException {
        HiveParser.tablePartition_return retval = new HiveParser.tablePartition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_PARTITIONED555=null;
        Token KW_BY556=null;
        Token LPAREN557=null;
        Token RPAREN559=null;
        HiveParser.columnNameTypeList_return columnNameTypeList558 =null;


        CommonTree KW_PARTITIONED555_tree=null;
        CommonTree KW_BY556_tree=null;
        CommonTree LPAREN557_tree=null;
        CommonTree RPAREN559_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_PARTITIONED=new RewriteRuleTokenStream(adaptor,"token KW_PARTITIONED");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_BY=new RewriteRuleTokenStream(adaptor,"token KW_BY");
        RewriteRuleSubtreeStream stream_columnNameTypeList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameTypeList");
         msgs.push("table partition specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1504:5: ( KW_PARTITIONED KW_BY LPAREN columnNameTypeList RPAREN -> ^( TOK_TABLEPARTCOLS columnNameTypeList ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1504:7: KW_PARTITIONED KW_BY LPAREN columnNameTypeList RPAREN
            {
            KW_PARTITIONED555=(Token)match(input,KW_PARTITIONED,FOLLOW_KW_PARTITIONED_in_tablePartition8657);  
            stream_KW_PARTITIONED.add(KW_PARTITIONED555);


            KW_BY556=(Token)match(input,KW_BY,FOLLOW_KW_BY_in_tablePartition8659);  
            stream_KW_BY.add(KW_BY556);


            LPAREN557=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_tablePartition8661);  
            stream_LPAREN.add(LPAREN557);


            pushFollow(FOLLOW_columnNameTypeList_in_tablePartition8663);
            columnNameTypeList558=columnNameTypeList();

            state._fsp--;

            stream_columnNameTypeList.add(columnNameTypeList558.getTree());

            RPAREN559=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_tablePartition8665);  
            stream_RPAREN.add(RPAREN559);


            // AST REWRITE
            // elements: columnNameTypeList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1505:5: -> ^( TOK_TABLEPARTCOLS columnNameTypeList )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1505:8: ^( TOK_TABLEPARTCOLS columnNameTypeList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLEPARTCOLS, "TOK_TABLEPARTCOLS")
                , root_1);

                adaptor.addChild(root_1, stream_columnNameTypeList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tablePartition"


    public static class tableBuckets_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tableBuckets"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1508:1: tableBuckets : KW_CLUSTERED KW_BY LPAREN bucketCols= columnNameList RPAREN ( KW_SORTED KW_BY LPAREN sortCols= columnNameOrderList RPAREN )? KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $bucketCols ( $sortCols)? $num) ;
    public final HiveParser.tableBuckets_return tableBuckets() throws RecognitionException {
        HiveParser.tableBuckets_return retval = new HiveParser.tableBuckets_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token num=null;
        Token KW_CLUSTERED560=null;
        Token KW_BY561=null;
        Token LPAREN562=null;
        Token RPAREN563=null;
        Token KW_SORTED564=null;
        Token KW_BY565=null;
        Token LPAREN566=null;
        Token RPAREN567=null;
        Token KW_INTO568=null;
        Token KW_BUCKETS569=null;
        HiveParser.columnNameList_return bucketCols =null;

        HiveParser.columnNameOrderList_return sortCols =null;


        CommonTree num_tree=null;
        CommonTree KW_CLUSTERED560_tree=null;
        CommonTree KW_BY561_tree=null;
        CommonTree LPAREN562_tree=null;
        CommonTree RPAREN563_tree=null;
        CommonTree KW_SORTED564_tree=null;
        CommonTree KW_BY565_tree=null;
        CommonTree LPAREN566_tree=null;
        CommonTree RPAREN567_tree=null;
        CommonTree KW_INTO568_tree=null;
        CommonTree KW_BUCKETS569_tree=null;
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_KW_INTO=new RewriteRuleTokenStream(adaptor,"token KW_INTO");
        RewriteRuleTokenStream stream_Number=new RewriteRuleTokenStream(adaptor,"token Number");
        RewriteRuleTokenStream stream_KW_BUCKETS=new RewriteRuleTokenStream(adaptor,"token KW_BUCKETS");
        RewriteRuleTokenStream stream_KW_CLUSTERED=new RewriteRuleTokenStream(adaptor,"token KW_CLUSTERED");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_BY=new RewriteRuleTokenStream(adaptor,"token KW_BY");
        RewriteRuleTokenStream stream_KW_SORTED=new RewriteRuleTokenStream(adaptor,"token KW_SORTED");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_columnNameOrderList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameOrderList");
         msgs.push("table buckets specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1511:5: ( KW_CLUSTERED KW_BY LPAREN bucketCols= columnNameList RPAREN ( KW_SORTED KW_BY LPAREN sortCols= columnNameOrderList RPAREN )? KW_INTO num= Number KW_BUCKETS -> ^( TOK_TABLEBUCKETS $bucketCols ( $sortCols)? $num) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:7: KW_CLUSTERED KW_BY LPAREN bucketCols= columnNameList RPAREN ( KW_SORTED KW_BY LPAREN sortCols= columnNameOrderList RPAREN )? KW_INTO num= Number KW_BUCKETS
            {
            KW_CLUSTERED560=(Token)match(input,KW_CLUSTERED,FOLLOW_KW_CLUSTERED_in_tableBuckets8710);  
            stream_KW_CLUSTERED.add(KW_CLUSTERED560);


            KW_BY561=(Token)match(input,KW_BY,FOLLOW_KW_BY_in_tableBuckets8712);  
            stream_KW_BY.add(KW_BY561);


            LPAREN562=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_tableBuckets8714);  
            stream_LPAREN.add(LPAREN562);


            pushFollow(FOLLOW_columnNameList_in_tableBuckets8718);
            bucketCols=columnNameList();

            state._fsp--;

            stream_columnNameList.add(bucketCols.getTree());

            RPAREN563=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_tableBuckets8720);  
            stream_RPAREN.add(RPAREN563);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:66: ( KW_SORTED KW_BY LPAREN sortCols= columnNameOrderList RPAREN )?
            int alt153=2;
            switch ( input.LA(1) ) {
                case KW_SORTED:
                    {
                    alt153=1;
                    }
                    break;
            }

            switch (alt153) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1512:67: KW_SORTED KW_BY LPAREN sortCols= columnNameOrderList RPAREN
                    {
                    KW_SORTED564=(Token)match(input,KW_SORTED,FOLLOW_KW_SORTED_in_tableBuckets8723);  
                    stream_KW_SORTED.add(KW_SORTED564);


                    KW_BY565=(Token)match(input,KW_BY,FOLLOW_KW_BY_in_tableBuckets8725);  
                    stream_KW_BY.add(KW_BY565);


                    LPAREN566=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_tableBuckets8727);  
                    stream_LPAREN.add(LPAREN566);


                    pushFollow(FOLLOW_columnNameOrderList_in_tableBuckets8731);
                    sortCols=columnNameOrderList();

                    state._fsp--;

                    stream_columnNameOrderList.add(sortCols.getTree());

                    RPAREN567=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_tableBuckets8733);  
                    stream_RPAREN.add(RPAREN567);


                    }
                    break;

            }


            KW_INTO568=(Token)match(input,KW_INTO,FOLLOW_KW_INTO_in_tableBuckets8737);  
            stream_KW_INTO.add(KW_INTO568);


            num=(Token)match(input,Number,FOLLOW_Number_in_tableBuckets8741);  
            stream_Number.add(num);


            KW_BUCKETS569=(Token)match(input,KW_BUCKETS,FOLLOW_KW_BUCKETS_in_tableBuckets8743);  
            stream_KW_BUCKETS.add(KW_BUCKETS569);


            // AST REWRITE
            // elements: bucketCols, sortCols, num
            // token labels: num
            // rule labels: sortCols, retval, bucketCols
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleTokenStream stream_num=new RewriteRuleTokenStream(adaptor,"token num",num);
            RewriteRuleSubtreeStream stream_sortCols=new RewriteRuleSubtreeStream(adaptor,"rule sortCols",sortCols!=null?sortCols.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_bucketCols=new RewriteRuleSubtreeStream(adaptor,"rule bucketCols",bucketCols!=null?bucketCols.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1513:5: -> ^( TOK_TABLEBUCKETS $bucketCols ( $sortCols)? $num)
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1513:8: ^( TOK_TABLEBUCKETS $bucketCols ( $sortCols)? $num)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLEBUCKETS, "TOK_TABLEBUCKETS")
                , root_1);

                adaptor.addChild(root_1, stream_bucketCols.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1513:40: ( $sortCols)?
                if ( stream_sortCols.hasNext() ) {
                    adaptor.addChild(root_1, stream_sortCols.nextTree());

                }
                stream_sortCols.reset();

                adaptor.addChild(root_1, stream_num.nextNode());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tableBuckets"


    public static class tableSkewed_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "tableSkewed"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1516:1: tableSkewed : KW_SKEWED KW_BY LPAREN skewedCols= columnNameList RPAREN KW_ON LPAREN (skewedValues= skewedValueElement ) RPAREN ( storedAsDirs )? -> ^( TOK_TABLESKEWED $skewedCols $skewedValues ( storedAsDirs )? ) ;
    public final HiveParser.tableSkewed_return tableSkewed() throws RecognitionException {
        HiveParser.tableSkewed_return retval = new HiveParser.tableSkewed_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        Token KW_SKEWED570=null;
        Token KW_BY571=null;
        Token LPAREN572=null;
        Token RPAREN573=null;
        Token KW_ON574=null;
        Token LPAREN575=null;
        Token RPAREN576=null;
        HiveParser.columnNameList_return skewedCols =null;

        HiveParser.skewedValueElement_return skewedValues =null;

        HiveParser.storedAsDirs_return storedAsDirs577 =null;


        CommonTree KW_SKEWED570_tree=null;
        CommonTree KW_BY571_tree=null;
        CommonTree LPAREN572_tree=null;
        CommonTree RPAREN573_tree=null;
        CommonTree KW_ON574_tree=null;
        CommonTree LPAREN575_tree=null;
        CommonTree RPAREN576_tree=null;
        RewriteRuleTokenStream stream_KW_SKEWED=new RewriteRuleTokenStream(adaptor,"token KW_SKEWED");
        RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
        RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
        RewriteRuleTokenStream stream_KW_ON=new RewriteRuleTokenStream(adaptor,"token KW_ON");
        RewriteRuleTokenStream stream_KW_BY=new RewriteRuleTokenStream(adaptor,"token KW_BY");
        RewriteRuleSubtreeStream stream_columnNameList=new RewriteRuleSubtreeStream(adaptor,"rule columnNameList");
        RewriteRuleSubtreeStream stream_storedAsDirs=new RewriteRuleSubtreeStream(adaptor,"rule storedAsDirs");
        RewriteRuleSubtreeStream stream_skewedValueElement=new RewriteRuleSubtreeStream(adaptor,"rule skewedValueElement");
         msgs.push("table skewed specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1519:5: ( KW_SKEWED KW_BY LPAREN skewedCols= columnNameList RPAREN KW_ON LPAREN (skewedValues= skewedValueElement ) RPAREN ( storedAsDirs )? -> ^( TOK_TABLESKEWED $skewedCols $skewedValues ( storedAsDirs )? ) )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1520:6: KW_SKEWED KW_BY LPAREN skewedCols= columnNameList RPAREN KW_ON LPAREN (skewedValues= skewedValueElement ) RPAREN ( storedAsDirs )?
            {
            KW_SKEWED570=(Token)match(input,KW_SKEWED,FOLLOW_KW_SKEWED_in_tableSkewed8795);  
            stream_KW_SKEWED.add(KW_SKEWED570);


            KW_BY571=(Token)match(input,KW_BY,FOLLOW_KW_BY_in_tableSkewed8797);  
            stream_KW_BY.add(KW_BY571);


            LPAREN572=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_tableSkewed8799);  
            stream_LPAREN.add(LPAREN572);


            pushFollow(FOLLOW_columnNameList_in_tableSkewed8803);
            skewedCols=columnNameList();

            state._fsp--;

            stream_columnNameList.add(skewedCols.getTree());

            RPAREN573=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_tableSkewed8805);  
            stream_RPAREN.add(RPAREN573);


            KW_ON574=(Token)match(input,KW_ON,FOLLOW_KW_ON_in_tableSkewed8807);  
            stream_KW_ON.add(KW_ON574);


            LPAREN575=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_tableSkewed8809);  
            stream_LPAREN.add(LPAREN575);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1520:75: (skewedValues= skewedValueElement )
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1520:76: skewedValues= skewedValueElement
            {
            pushFollow(FOLLOW_skewedValueElement_in_tableSkewed8814);
            skewedValues=skewedValueElement();

            state._fsp--;

            stream_skewedValueElement.add(skewedValues.getTree());

            }


            RPAREN576=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_tableSkewed8817);  
            stream_RPAREN.add(RPAREN576);


            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1520:116: ( storedAsDirs )?
            int alt154=2;
            switch ( input.LA(1) ) {
                case KW_STORED:
                    {
                    switch ( input.LA(2) ) {
                        case KW_AS:
                            {
                            switch ( input.LA(3) ) {
                                case KW_DIRECTORIES:
                                    {
                                    alt154=1;
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt154) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1520:117: storedAsDirs
                    {
                    pushFollow(FOLLOW_storedAsDirs_in_tableSkewed8820);
                    storedAsDirs577=storedAsDirs();

                    state._fsp--;

                    stream_storedAsDirs.add(storedAsDirs577.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: storedAsDirs, skewedCols, skewedValues
            // token labels: 
            // rule labels: retval, skewedValues, skewedCols
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_skewedValues=new RewriteRuleSubtreeStream(adaptor,"rule skewedValues",skewedValues!=null?skewedValues.tree:null);
            RewriteRuleSubtreeStream stream_skewedCols=new RewriteRuleSubtreeStream(adaptor,"rule skewedCols",skewedCols!=null?skewedCols.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 1521:5: -> ^( TOK_TABLESKEWED $skewedCols $skewedValues ( storedAsDirs )? )
            {
                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1521:8: ^( TOK_TABLESKEWED $skewedCols $skewedValues ( storedAsDirs )? )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(TOK_TABLESKEWED, "TOK_TABLESKEWED")
                , root_1);

                adaptor.addChild(root_1, stream_skewedCols.nextTree());

                adaptor.addChild(root_1, stream_skewedValues.nextTree());

                // org/apache/hadoop/hive/ql/parse/HiveParser.g:1521:52: ( storedAsDirs )?
                if ( stream_storedAsDirs.hasNext() ) {
                    adaptor.addChild(root_1, stream_storedAsDirs.nextTree());

                }
                stream_storedAsDirs.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;

            }

            retval.stop = input.LT(-1);


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

             msgs.pop(); 
        }

        catch (RecognitionException e) {
         reportError(e);
          throw e;
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "tableSkewed"


    public static class rowFormat_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rowFormat"
    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1524:1: rowFormat : ( rowFormatSerde -> ^( TOK_SERDE rowFormatSerde ) | rowFormatDelimited -> ^( TOK_SERDE rowFormatDelimited ) | -> ^( TOK_SERDE ) );
    public final HiveParser.rowFormat_return rowFormat() throws RecognitionException {
        HiveParser.rowFormat_return retval = new HiveParser.rowFormat_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        HiveParser.rowFormatSerde_return rowFormatSerde578 =null;

        HiveParser.rowFormatDelimited_return rowFormatDelimited579 =null;


        RewriteRuleSubtreeStream stream_rowFormatSerde=new RewriteRuleSubtreeStream(adaptor,"rule rowFormatSerde");
        RewriteRuleSubtreeStream stream_rowFormatDelimited=new RewriteRuleSubtreeStream(adaptor,"rule rowFormatDelimited");
         msgs.push("serde specification"); 
        try {
            // org/apache/hadoop/hive/ql/parse/HiveParser.g:1527:5: ( rowFormatSerde -> ^( TOK_SERDE rowFormatSerde ) | rowFormatDelimited -> ^( TOK_SERDE rowFormatDelimited ) | -> ^( TOK_SERDE ) )
            int alt155=3;
            switch ( input.LA(1) ) {
            case KW_ROW:
                {
                switch ( input.LA(2) ) {
                case KW_FORMAT:
                    {
                    switch ( input.LA(3) ) {
                    case KW_SERDE:
                        {
                        alt155=1;
                        }
                        break;
                    case KW_DELIMITED:
                        {
                        alt155=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 155, 23, input);

                        throw nvae;

                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 155, 1, input);

                    throw nvae;

                }

                }
                break;
            case EOF:
            case KW_CLUSTER:
            case KW_DISTRIBUTE:
            case KW_FROM:
            case KW_GROUP:
            case KW_HAVING:
            case KW_INSERT:
            case KW_LATERAL:
            case KW_LIMIT:
            case KW_MAP:
            case KW_ORDER:
            case KW_RECORDREADER:
            case KW_RECORDWRITER:
            case KW_REDUCE:
            case KW_SELECT:
            case KW_SORT:
            case KW_UNION:
            case KW_USING:
            case KW_WHERE:
            case KW_WINDOW:
            case RPAREN:
                {
                alt155=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 155, 0, input);

                throw nvae;

            }

            switch (alt155) {
                case 1 :
                    // org/apache/hadoop/hive/ql/parse/HiveParser.g:1527:7: rowFormatSerde
                    {
                    pushFollow(FOLLOW_rowFormatSerde_in_rowFormat8868);
                    rowFormatSerde578=rowFormatSerde();

                    state._fsp--;

                    stream_rowFormatSerde.add(rowFormatSerde578.getTree());

                    // AST REWRITE
                    // elements: rowFormatSerde
                    // token labels: 
                    // rule labels: retval
               