/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.ql;

import java.util.List;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

/**
 * Context information provided by Hive to implementations of
 * HiveDriverFilterHook.
 */
public interface HiveDriverFilterHookResult extends Configurable{
  public HiveOperation getHiveOperation ();
  public void setHiveOperation(HiveOperation operation);
  public String getUserName();
  public void setUserName(String userName);
  public List<String> getResult();
  public void setResult(List<String> result);
}
