/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.mockito.internal.util.reflection.InstanceField;

public class ReflectionUtil {
    private static final Cache<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE;
    private static final Class<?>[] EMPTY_ARRAY;
    private static final Class<?> jobConfClass;
    private static final Class<?> jobConfigurableClass;
    private static final Method configureMethod;

    public static <T> T newInstance(Class<T> theClass, Configuration conf) {
        T result;
        try {
            Constructor<T> ctor = (Constructor<T>)CONSTRUCTOR_CACHE.getIfPresent(theClass);
            if (ctor == null) {
                ctor = theClass.getDeclaredConstructor(EMPTY_ARRAY);
                ctor.setAccessible(true);
                CONSTRUCTOR_CACHE.put(theClass, ctor);
            }
            result = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtil.setConf(result, conf);
        return result;
    }

    public static void setConf(Object theObject, Configuration conf) {
        if (conf != null) {
            if (theObject instanceof Configurable) {
                Configurable configurable = (Configurable)theObject;
                configurable.setConf(conf);
            }
            ReflectionUtil.setJobConf(theObject, conf);
        }
    }

    private static void setJobConf(Object theObject, Configuration conf) {
        if (configureMethod == null) {
            return;
        }
        try {
            if (jobConfClass.isAssignableFrom(conf.getClass()) && jobConfigurableClass.isAssignableFrom(theObject.getClass())) {
                configureMethod.invoke(theObject, conf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in configuring object", e);
        }
    }

    public static void setField(Object object, String field, Object value) {
        try {
            Field fieldToChange = object.getClass().getDeclaredField(field);
            ReflectionUtil.setField(object, fieldToChange, value);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Cannot find field %s in object %s".formatted(field, object.getClass()));
        }
    }

    public static void setField(Object object, Field fld, Object value) {
        try {
            fld.setAccessible(true);
            fld.set(object, value);
        }
        catch (IllegalAccessException e) {
            String fieldName = null == fld ? "n/a" : fld.getName();
            throw new RuntimeException("Failed to set " + fieldName + " of object", e);
        }
    }

    public static void setInAllFields(Object object, String field, Object value) {
        try {
            Field fieldToChange = Arrays.stream(FieldUtils.getAllFields(object.getClass())).filter(f -> f.getName().equals(field)).findFirst().orElseThrow(NoSuchFieldException::new);
            fieldToChange.setAccessible(true);
            fieldToChange.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Cannot set field %s in object %s".formatted(field, object.getClass()));
        }
    }

    public static void setStaticFinalFieldsModifiable(Field field) {
        try {
            field.setAccessible(true);
            VarHandle modifiersHandle = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup()).findVarHandle(Field.class, "modifiers", Integer.TYPE);
            int modifiers = field.getModifiers();
            modifiersHandle.set(field, modifiers & 0xFFFFFFEF);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Cannot make static final field %s modifiable".formatted(field));
        }
    }

    public static List<InstanceField> allDeclaredFieldsOf(Object testInstance) {
        ArrayList<InstanceField> result = new ArrayList<InstanceField>();
        for (Class<?> clazz = testInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                result.add(new InstanceField(field, testInstance));
            }
        }
        return result;
    }

    static {
        Method configureMethodLocal;
        Class<?> jobConfigurableClassLocal;
        Class<?> jobConfClassLocal;
        CONSTRUCTOR_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).concurrencyLevel(64).weakKeys().weakValues().build();
        EMPTY_ARRAY = new Class[0];
        try {
            jobConfClassLocal = Class.forName("org.apache.hadoop.mapred.JobConf");
            jobConfigurableClassLocal = Class.forName("org.apache.hadoop.mapred.JobConfigurable");
            configureMethodLocal = jobConfigurableClassLocal.getMethod("configure", jobConfClassLocal);
        }
        catch (Throwable t) {
            jobConfigurableClassLocal = null;
            jobConfClassLocal = null;
            configureMethodLocal = null;
        }
        jobConfClass = jobConfClassLocal;
        jobConfigurableClass = jobConfigurableClassLocal;
        configureMethod = configureMethodLocal;
    }
}

