/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http.security;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.security.sasl.AuthenticationException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jpam.Pam;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.http.security.PamUserIdentity;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;

public class PamAuthenticator
extends LoginAuthenticator {
    private final String pamServiceNames;

    public PamAuthenticator(HiveConf conf) throws AuthenticationException {
        this.pamServiceNames = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES);
        if (this.pamServiceNames == null || this.pamServiceNames.trim().isEmpty()) {
            throw new AuthenticationException("No PAM services are set.");
        }
    }

    public String getAuthMethod() {
        return "pam";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            String method;
            int space;
            if (!mandatory) {
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
                String password;
                String username;
                UserIdentity user;
                credentials = credentials.substring(space + 1);
                int i = (credentials = B64Code.decode((String)credentials, (Charset)StandardCharsets.ISO_8859_1)).indexOf(58);
                if (i > 0 && (user = this.login(username = credentials.substring(0, i), password = credentials.substring(i + 1))) != null) {
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                return Authentication.UNAUTHENTICATED;
            }
            response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "basic realm=\"" + this._loginService.getName() + '\"');
            response.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    protected UserIdentity login(String username, String password) throws AuthenticationException {
        PamUserIdentity user = null;
        if (this.authenticate(username, password)) {
            user = new PamUserIdentity(username);
        }
        return user;
    }

    private boolean authenticate(String user, String password) throws AuthenticationException {
        String[] pamServices = this.pamServiceNames.split(",");
        String errorMsg = "Error authenticating with the PAM service: ";
        for (String pamService : pamServices) {
            try {
                Pam pam = new Pam(pamService);
                if (pam.authenticateSuccessful(user, password)) continue;
                return false;
            }
            catch (Throwable e) {
                throw new AuthenticationException(errorMsg + pamService, e);
            }
        }
        return true;
    }

    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean b, Authentication.User user) throws ServerAuthException {
        return true;
    }
}

