/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.common.cli.ShellCmdExecutor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.ClientCommandHookFactory;
import org.apache.hive.beeline.ClientHook;
import org.apache.hive.beeline.ColorBuffer;
import org.apache.hive.beeline.DatabaseConnection;
import org.apache.hive.beeline.OutputFile;
import org.apache.hive.beeline.Rows;
import org.apache.hive.beeline.logs.BeelineInPlaceUpdateStream;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;

public class Commands {
    private final BeeLine beeLine;
    private static final int DEFAULT_QUERY_PROGRESS_INTERVAL = 1000;
    private static final int DEFAULT_QUERY_PROGRESS_THREAD_TIMEOUT = 10000;

    Commands(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    public boolean metadata(String line) {
        this.beeLine.debug(line);
        String[] parts = this.beeLine.split(line);
        LinkedList<String> params = new LinkedList<String>(Arrays.asList(parts));
        if (parts == null || parts.length == 0) {
            return this.dbinfo("");
        }
        params.remove(0);
        params.remove(0);
        this.beeLine.debug(((Object)params).toString());
        return this.metadata(parts[1], params.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean metadata(String cmd, String[] args) {
        block11: {
            if (!this.beeLine.assertConnection()) {
                return false;
            }
            try {
                Method[] m = this.beeLine.getDatabaseMetaData().getClass().getMethods();
                TreeSet<String> methodNames = new TreeSet<String>();
                TreeSet<String> methodNamesUpper = new TreeSet<String>();
                for (int i = 0; i < m.length; ++i) {
                    methodNames.add(m[i].getName());
                    methodNamesUpper.add(m[i].getName().toUpperCase());
                }
                if (!methodNamesUpper.contains(cmd.toUpperCase())) {
                    this.beeLine.error(this.beeLine.loc("no-such-method", cmd));
                    this.beeLine.error(this.beeLine.loc("possible-methods"));
                    Iterator i = methodNames.iterator();
                    while (i.hasNext()) {
                        this.beeLine.error("   " + (String)i.next());
                    }
                    return false;
                }
                Object res = this.beeLine.getReflector().invoke(this.beeLine.getDatabaseMetaData(), DatabaseMetaData.class, cmd, Arrays.asList(args));
                if (res instanceof ResultSet) {
                    ResultSet rs = (ResultSet)res;
                    if (rs == null) break block11;
                    try {
                        this.beeLine.print(rs);
                        break block11;
                    }
                    finally {
                        rs.close();
                    }
                }
                if (res != null) {
                    this.beeLine.output(res.toString());
                }
            }
            catch (Exception e) {
                return this.beeLine.error(e);
            }
        }
        return true;
    }

    public boolean addlocaldrivername(String line) {
        String driverName = this.arg1(line, "driver class name");
        try {
            this.beeLine.setDrivers(this.beeLine.scanDrivers());
        }
        catch (IOException e) {
            this.beeLine.error("Fail to scan drivers due to the exception:" + e);
            this.beeLine.error(e);
        }
        for (Driver d : this.beeLine.getDrivers()) {
            if (!driverName.equals(d.getClass().getName())) continue;
            this.beeLine.addLocalDriverClazz(driverName);
            return true;
        }
        this.beeLine.error("Fail to find a driver which contains the driver class");
        return false;
    }

    public boolean addlocaldriverjar(String line) {
        String jarPath = this.arg1(line, "jar path");
        File p = new File(jarPath);
        if (!p.exists()) {
            this.beeLine.error("The jar file in the path " + jarPath + " can't be found!");
            return false;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.beeLine.debug(jarPath + " is added to the local beeline.");
            URLClassLoader newClassLoader = new URLClassLoader(new URL[]{p.toURL()}, classLoader);
            Thread.currentThread().setContextClassLoader(newClassLoader);
            this.beeLine.setDrivers(this.beeLine.scanDrivers());
        }
        catch (Exception e) {
            this.beeLine.error("Fail to add local jar due to the exception:" + e);
            this.beeLine.error(e);
        }
        return true;
    }

    public boolean history(String line) {
        ListIterator hist = this.beeLine.getConsoleReader().getHistory().entries();
        while (hist.hasNext()) {
            String[] tmp = hist.next().toString().split(":", 2);
            tmp[0] = Integer.toString(Integer.parseInt(tmp[0]) + 1);
            this.beeLine.output(this.beeLine.getColorBuffer().pad(tmp[0], 6).append(":" + tmp[1]));
        }
        return true;
    }

    String arg1(String line, String paramname) {
        return this.arg1(line, paramname, null);
    }

    String arg1(String line, String paramname, String def) {
        String[] ret = this.beeLine.split(line);
        if (ret == null || ret.length != 2) {
            if (def != null) {
                return def;
            }
            throw new IllegalArgumentException(this.beeLine.loc("arg-usage", new Object[]{ret == null || ret.length == 0 ? "" : ret[0], paramname}));
        }
        return ret[1];
    }

    public boolean indexes(String line) throws Exception {
        return this.metadata("getIndexInfo", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name"), "false", "true"});
    }

    public boolean primarykeys(String line) throws Exception {
        return this.metadata("getPrimaryKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean exportedkeys(String line) throws Exception {
        return this.metadata("getExportedKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean importedkeys(String line) throws Exception {
        return this.metadata("getImportedKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean procedures(String line) throws Exception {
        return this.metadata("getProcedures", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "procedure name pattern", "%")});
    }

    public boolean tables(String line) throws Exception {
        return this.metadata("getTables", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name", "%"), null});
    }

    public boolean typeinfo(String line) throws Exception {
        return this.metadata("getTypeInfo", new String[0]);
    }

    public boolean nativesql(String sql) throws Exception {
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        if (sql.startsWith("native")) {
            sql = sql.substring("native".length() + 1);
        }
        String nat = this.beeLine.getConnection().nativeSQL(sql);
        this.beeLine.output(nat);
        return true;
    }

    public boolean columns(String line) throws Exception {
        return this.metadata("getColumns", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name"), "%"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropall(String line) {
        if (this.beeLine.getDatabaseConnection() == null || this.beeLine.getDatabaseConnection().getUrl() == null) {
            return this.beeLine.error(this.beeLine.loc("no-current-connection"));
        }
        try {
            if (!this.beeLine.getConsoleReader().readLine(this.beeLine.loc("really-drop-all")).equals("y")) {
                return this.beeLine.error("abort-drop-all");
            }
            LinkedList<String> cmds = new LinkedList<String>();
            ResultSet rs = this.beeLine.getTables();
            try {
                while (rs.next()) {
                    cmds.add("DROP TABLE " + rs.getString("TABLE_NAME") + this.beeLine.getOpts().getDelimiter());
                }
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.beeLine.error(e);
                }
            }
            return this.beeLine.runCommands(cmds) == cmds.size();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean reconnect(String line) {
        if (this.beeLine.getDatabaseConnection() == null || this.beeLine.getDatabaseConnection().getUrl() == null) {
            String lastConnectedUrl = this.beeLine.getOpts().getLastConnectedUrl();
            if (lastConnectedUrl != null) {
                Properties props = new Properties();
                props.setProperty("url", lastConnectedUrl);
                try {
                    return this.connect(props);
                }
                catch (IOException e) {
                    return this.beeLine.error(e);
                }
            }
            return this.beeLine.error(this.beeLine.loc("no-current-connection"));
        }
        this.beeLine.info(this.beeLine.loc("reconnecting", this.beeLine.getDatabaseConnection().getUrl()));
        try {
            this.beeLine.getDatabaseConnection().reconnect();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        return true;
    }

    public boolean scan(String line) throws IOException {
        TreeSet<String> names = new TreeSet<String>();
        if (this.beeLine.getDrivers() == null) {
            this.beeLine.setDrivers(this.beeLine.scanDrivers());
        }
        this.beeLine.info(this.beeLine.loc("drivers-found-count", this.beeLine.getDrivers().size()));
        Iterator<Driver> i = this.beeLine.getDrivers().iterator();
        while (i.hasNext()) {
            names.add(i.next().getClass().getName());
        }
        this.beeLine.output(this.beeLine.getColorBuffer().bold(this.beeLine.getColorBuffer().pad(this.beeLine.loc("compliant"), 10).getMono()).bold(this.beeLine.getColorBuffer().pad(this.beeLine.loc("jdbc-version"), 8).getMono()).bold(this.beeLine.getColorBuffer(this.beeLine.loc("driver-class")).getMono()));
        i = names.iterator();
        while (i.hasNext()) {
            String name = ((String)((Object)i.next())).toString();
            try {
                Driver driver = (Driver)Class.forName(name).newInstance();
                ColorBuffer msg = this.beeLine.getColorBuffer().pad(driver.jdbcCompliant() ? "yes" : "no", 10).pad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8).append(name);
                if (driver.jdbcCompliant()) {
                    this.beeLine.output(msg);
                    continue;
                }
                this.beeLine.output(this.beeLine.getColorBuffer().red(msg.getMono()));
            }
            catch (Throwable t) {
                this.beeLine.output(this.beeLine.getColorBuffer().red(name));
            }
        }
        return true;
    }

    public boolean save(String line) throws IOException {
        this.beeLine.info(this.beeLine.loc("saving-options", this.beeLine.getOpts().getPropertiesFile()));
        this.beeLine.getOpts().save();
        return true;
    }

    public boolean load(String line) throws IOException {
        this.beeLine.getOpts().load();
        this.beeLine.info(this.beeLine.loc("loaded-options", this.beeLine.getOpts().getPropertiesFile()));
        return true;
    }

    public boolean config(String line) {
        try {
            Properties props = this.beeLine.getOpts().toProperties();
            TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
            for (String string : keys) {
                ColorBuffer colorBuffer = this.beeLine.getColorBuffer();
                ColorBuffer colorBuffer2 = this.beeLine.getColorBuffer();
                this.beeLine.getOpts();
                this.beeLine.output(colorBuffer.green(colorBuffer2.pad(string.substring("beeline.".length()), 20).getMono()).append(props.getProperty(string)));
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        return true;
    }

    public boolean set(String line) {
        if (line == null || line.trim().equals("set") || line.length() == 0) {
            return this.config(null);
        }
        String[] parts = this.beeLine.split(line, 3, "Usage: set <key> <value>");
        if (parts == null) {
            return false;
        }
        String key = parts[1];
        String value = parts[2];
        boolean success = this.beeLine.getOpts().set(key, value, false);
        if (success && this.beeLine.getOpts().getAutosave()) {
            try {
                this.beeLine.getOpts().save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean commit(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (!this.beeLine.assertAutoCommit()) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            this.beeLine.getDatabaseConnection().getConnection().commit();
            long end = System.currentTimeMillis();
            this.beeLine.showWarnings();
            this.beeLine.info(this.beeLine.loc("commit-complete") + " " + this.beeLine.locElapsedTime(end - start));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean rollback(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (!this.beeLine.assertAutoCommit()) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            this.beeLine.getDatabaseConnection().getConnection().rollback();
            long end = System.currentTimeMillis();
            this.beeLine.showWarnings();
            this.beeLine.info(this.beeLine.loc("rollback-complete") + " " + this.beeLine.locElapsedTime(end - start));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean autocommit(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (line.endsWith("on")) {
            this.beeLine.getDatabaseConnection().getConnection().setAutoCommit(true);
        } else if (line.endsWith("off")) {
            this.beeLine.getDatabaseConnection().getConnection().setAutoCommit(false);
        }
        this.beeLine.showWarnings();
        this.beeLine.autocommitStatus(this.beeLine.getDatabaseConnection().getConnection());
        return true;
    }

    public boolean dbinfo(String line) {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        this.beeLine.showWarnings();
        int padlen = 50;
        String[] m = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
        for (int i = 0; i < m.length; ++i) {
            try {
                this.beeLine.output(this.beeLine.getColorBuffer().pad(m[i], padlen).append("" + this.beeLine.getReflector().invoke((Object)this.beeLine.getDatabaseMetaData(), m[i], new Object[0])));
                continue;
            }
            catch (Exception e) {
                this.beeLine.output(this.beeLine.getColorBuffer().pad(m[i], padlen), false);
                this.beeLine.handleException(e);
            }
        }
        return true;
    }

    public boolean verbose(String line) {
        this.beeLine.info("verbose: on");
        return this.set("set verbose true");
    }

    public boolean outputformat(String line) {
        return this.set("set " + line);
    }

    public boolean brief(String line) {
        this.beeLine.info("verbose: off");
        return this.set("set verbose false");
    }

    public boolean isolation(String line) throws SQLException {
        int i;
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (line.endsWith("TRANSACTION_NONE")) {
            i = 0;
        } else if (line.endsWith("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        } else if (line.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        } else if (line.endsWith("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        } else if (line.endsWith("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        } else {
            return this.beeLine.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE>");
        }
        this.beeLine.getDatabaseConnection().getConnection().setTransactionIsolation(i);
        int isol = this.beeLine.getDatabaseConnection().getConnection().getTransactionIsolation();
        this.beeLine.info(this.beeLine.loc("isolation-status", switch (i) {
            case 0 -> "TRANSACTION_NONE";
            case 2 -> "TRANSACTION_READ_COMMITTED";
            case 1 -> "TRANSACTION_READ_UNCOMMITTED";
            case 4 -> "TRANSACTION_REPEATABLE_READ";
            case 8 -> "TRANSACTION_SERIALIZABLE";
            default -> "UNKNOWN";
        }));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batch(String line) {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (this.beeLine.getBatch() == null) {
            this.beeLine.setBatch(new LinkedList<String>());
            this.beeLine.info(this.beeLine.loc("batch-start"));
            return true;
        }
        this.beeLine.info(this.beeLine.loc("running-batch"));
        try {
            this.beeLine.runBatch(this.beeLine.getBatch());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = this.beeLine.error(e);
            return bl;
        }
        finally {
            this.beeLine.setBatch(null);
        }
    }

    public boolean sql(String line) {
        return this.execute(line, false, false);
    }

    private Map<String, String> getHiveVariables() {
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedRows rows = this.getConfInternal(true);
        if (rows != null) {
            while (rows.hasNext()) {
                Rows.Row row = (Rows.Row)rows.next();
                if (row.isMeta) continue;
                result.put(row.values[0], row.values[1]);
            }
        }
        return result;
    }

    public HiveConf getHiveConf(boolean call) {
        HiveConf hiveConf = this.beeLine.getOpts().getConf();
        if (hiveConf != null && call) {
            return hiveConf;
        }
        return this.getHiveConfHelper(call);
    }

    public HiveConf getHiveConfHelper(boolean call) {
        HiveConf conf = new HiveConf();
        BufferedRows rows = this.getConfInternal(call);
        while (rows != null && rows.hasNext()) {
            this.addConf((Rows.Row)rows.next(), conf);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedRows getConfInternal(boolean call) {
        Statement stmnt = null;
        BufferedRows rows = null;
        ResultSet rs = null;
        try {
            boolean hasResults = false;
            DatabaseConnection dbconn = this.beeLine.getDatabaseConnection();
            Connection conn = null;
            if (dbconn != null) {
                conn = dbconn.getConnection();
            }
            if (conn != null) {
                if (call) {
                    stmnt = conn.prepareCall("set");
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.beeLine.createStatement();
                    hasResults = stmnt.execute("set");
                }
            }
            if (hasResults) {
                rs = stmnt.getResultSet();
                rows = new BufferedRows(this.beeLine, rs);
            }
        }
        catch (SQLException e) {
            this.beeLine.error(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e1) {
                    this.beeLine.error(e1);
                }
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException e2) {
                    this.beeLine.error(e2);
                }
            }
        }
        return rows;
    }

    private void addConf(Rows.Row r, HiveConf hiveConf) {
        if (r.isMeta) {
            return;
        }
        if (r.values == null || r.values[0] == null || r.values[0].isEmpty()) {
            return;
        }
        String val = r.values[0];
        if (r.values[0].startsWith("system:") || r.values[0].startsWith("env:")) {
            return;
        }
        String[] kv = val.split("=", 2);
        if (kv.length == 2) {
            hiveConf.set(kv[0], kv[1]);
        }
    }

    private String getFirstCmd(String cmd, int length) {
        return cmd.substring(length).trim();
    }

    private String[] tokenizeCmd(String cmd) {
        return cmd.split("\\s+");
    }

    private boolean isSourceCMD(String cmd) {
        if (cmd == null || cmd.isEmpty()) {
            return false;
        }
        String[] tokens = this.tokenizeCmd(cmd);
        return tokens[0].equalsIgnoreCase("source");
    }

    private boolean sourceFile(String cmd) {
        boolean ret;
        String[] tokens = this.tokenizeCmd(cmd);
        String cmd_1 = this.getFirstCmd(cmd, tokens[0].length());
        cmd_1 = this.substituteVariables(this.getHiveConf(false), cmd_1);
        File sourceFile = new File(cmd_1);
        if (!sourceFile.isFile()) {
            return false;
        }
        try {
            ret = this.sourceFileInternal(sourceFile);
        }
        catch (IOException e) {
            this.beeLine.error(e);
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sourceFileInternal(File sourceFile) throws IOException {
        try (BufferedReader reader = null;){
            String[] cmds;
            String extra;
            reader = new BufferedReader(new FileReader(sourceFile));
            Object lines = null;
            while ((extra = reader.readLine()) != null) {
                if (this.beeLine.isComment(extra)) continue;
                if (lines == null) {
                    lines = extra;
                    continue;
                }
                lines = (String)lines + "\n" + extra;
            }
            for (String c : cmds = ((String)lines).split(this.beeLine.getOpts().getDelimiter())) {
                if (this.executeInternal(c = c.trim(), false)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public String cliToBeelineCmd(String cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.toLowerCase().equals("quit") || cmd.toLowerCase().equals("exit")) {
            return "!" + cmd;
        }
        if (cmd.startsWith("!")) {
            String shell_cmd = cmd.substring(1);
            return "!sh " + shell_cmd;
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String sql, boolean call) {
        String prefix;
        if (!this.beeLine.isBeeLine()) {
            sql = this.cliToBeelineCmd(sql);
        }
        if (sql == null || sql.length() == 0) {
            return true;
        }
        if (this.beeLine.isComment(sql)) {
            return true;
        }
        if (this.isSourceCMD(sql)) {
            return this.sourceFile(sql);
        }
        if (sql.startsWith("!")) {
            return this.beeLine.execCommandWithPrefix(sql);
        }
        String string = prefix = call ? "call" : "sql";
        if (sql.startsWith(prefix)) {
            sql = sql.substring(prefix.length());
        }
        if (this.beeLine.getBatch() != null) {
            this.beeLine.getBatch().add(sql);
            return true;
        }
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        ClientHook hook = ClientCommandHookFactory.get().getHook(this.beeLine, sql);
        try {
            Statement stmnt = null;
            Thread logThread = null;
            try {
                boolean hasResults;
                long start = System.currentTimeMillis();
                if (call) {
                    stmnt = this.beeLine.getDatabaseConnection().getConnection().prepareCall(sql);
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.beeLine.createStatement();
                    if (!this.beeLine.isTestMode() && this.beeLine.getOpts().isSilent()) {
                        hasResults = stmnt.execute(sql);
                    } else {
                        InPlaceUpdateStream.EventNotifier eventNotifier = new InPlaceUpdateStream.EventNotifier();
                        logThread = new Thread(this.createLogRunnable(stmnt, eventNotifier));
                        logThread.setDaemon(true);
                        logThread.start();
                        if (stmnt instanceof HiveStatement) {
                            HiveStatement hiveStatement = (HiveStatement)stmnt;
                            hiveStatement.setInPlaceUpdateStream((InPlaceUpdateStream)new BeelineInPlaceUpdateStream(this.beeLine.getErrorStream(), eventNotifier));
                        }
                        hasResults = stmnt.execute(sql);
                        logThread.interrupt();
                        logThread.join(10000L);
                    }
                }
                this.beeLine.showWarnings();
                if (hasResults) {
                    OutputFile outputFile = this.beeLine.getRecordOutputFile();
                    if (this.beeLine.isTestMode() && outputFile != null && outputFile.isActiveConverter()) {
                        outputFile.fetchStarted();
                        if (!sql.trim().toLowerCase().startsWith("explain")) {
                            outputFile.foundQuery(true);
                        } else {
                            outputFile.foundQuery(false);
                        }
                    }
                    do {
                        ResultSet rs = stmnt.getResultSet();
                        try {
                            int count = this.beeLine.print(rs);
                            long end = System.currentTimeMillis();
                            if (!this.showReport()) continue;
                            this.beeLine.output(this.beeLine.loc("rows-selected", count) + " " + this.beeLine.locElapsedTime(end - start), true, this.beeLine.getErrorStream());
                        }
                        finally {
                            if (logThread != null) {
                                logThread.join(10000L);
                                this.showRemainingLogsIfAny(stmnt);
                                logThread = null;
                            }
                            rs.close();
                        }
                    } while (BeeLine.getMoreResults(stmnt));
                    if (this.beeLine.isTestMode() && outputFile != null && outputFile.isActiveConverter()) {
                        outputFile.fetchFinished();
                    }
                } else {
                    int count = stmnt.getUpdateCount();
                    long end = System.currentTimeMillis();
                    if (this.showReport()) {
                        this.beeLine.output(this.beeLine.loc("rows-affected", count) + " " + this.beeLine.locElapsedTime(end - start), true, this.beeLine.getErrorStream());
                    }
                }
            }
            finally {
                if (logThread != null) {
                    if (!logThread.isInterrupted()) {
                        logThread.interrupt();
                    }
                    logThread.join(10000L);
                    if (stmnt != null) {
                        this.showRemainingLogsIfAny(stmnt);
                    }
                }
                if (stmnt != null) {
                    stmnt.close();
                }
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.beeLine.showWarnings();
        if (hook != null) {
            hook.postHook(this.beeLine);
        }
        return true;
    }

    private boolean showReport() {
        if (this.beeLine.getOpts().isReport() != null) {
            return this.beeLine.getOpts().isReport();
        }
        return !this.beeLine.getOpts().isSilent();
    }

    public String handleMultiLineCmd(String line) throws IOException {
        Character mask;
        line = HiveStringUtils.removeComments((String)line);
        Character c = mask = System.getProperty("jline.terminal", "").equals("jline.UnsupportedTerminal") ? null : Character.valueOf('\u0000');
        while (this.isMultiLine((String)line) && this.beeLine.getOpts().isAllowMultiLineCommand()) {
            StringBuilder prompt = new StringBuilder(this.beeLine.getPrompt());
            if (!this.beeLine.getOpts().isSilent()) {
                for (int i = 0; i < prompt.length() - 1; ++i) {
                    if (prompt.charAt(i) == '>') continue;
                    prompt.setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                }
            }
            if (this.beeLine.getConsoleReader() == null) {
                throw new RuntimeException("Console reader not initialized. This could happen when there is a multi-line command using -e option and which requires further reading from console");
            }
            String extra = this.beeLine.getOpts().isSilent() && this.beeLine.getOpts().getScriptFile() != null ? this.beeLine.getConsoleReader().readLine(null, mask) : this.beeLine.getConsoleReader().readLine(prompt.toString());
            if (extra == null) break;
            if ((extra = HiveStringUtils.removeComments((String)extra)) == null || extra.isEmpty()) continue;
            line = (String)line + "\n" + extra;
        }
        return line;
    }

    private boolean isMultiLine(String line) {
        if ((line = line.trim()).endsWith(this.beeLine.getOpts().getDelimiter()) || this.beeLine.isComment(line)) {
            return false;
        }
        List<String> cmds = this.getCmdList(line, false);
        return cmds.isEmpty() || !cmds.get(cmds.size() - 1).trim().startsWith("--");
    }

    public boolean sql(String line, boolean entireLineAsCommand) {
        return this.execute(line, false, entireLineAsCommand);
    }

    public String substituteVariables(HiveConf conf, String line) {
        if (!this.beeLine.isBeeLine()) {
            return new VariableSubstitution(new HiveVariableSource(){

                public Map<String, String> getHiveVariable() {
                    return Commands.this.getHiveVariables();
                }
            }).substitute(conf, line);
        }
        return line;
    }

    public boolean sh(String line) {
        if (line == null || line.length() == 0) {
            return false;
        }
        if (!line.startsWith("sh")) {
            return false;
        }
        line = line.substring("sh".length()).trim();
        if (!this.beeLine.isBeeLine()) {
            line = this.substituteVariables(this.getHiveConf(false), line.trim());
        }
        try {
            ShellCmdExecutor executor = new ShellCmdExecutor(line, this.beeLine.getOutputStream(), this.beeLine.getErrorStream());
            int ret = executor.execute();
            if (ret != 0) {
                this.beeLine.output("Command failed with exit code = " + ret);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.beeLine.error("Exception raised from Shell command " + e);
            return false;
        }
    }

    public boolean call(String line) {
        return this.execute(line, true, false);
    }

    private boolean execute(String line, boolean call, boolean entireLineAsCommand) {
        if (line == null || line.length() == 0) {
            return false;
        }
        try {
            line = this.handleMultiLineCmd(line);
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        line = line.trim();
        List<String> cmdList = this.getCmdList(line, entireLineAsCommand);
        for (int i = 0; i < cmdList.size(); ++i) {
            String sql = cmdList.get(i).trim();
            if (sql.length() == 0 || this.executeInternal(sql, call)) continue;
            return false;
        }
        return true;
    }

    List<String> getCmdList(String line, boolean entireLineAsCommand) {
        if (entireLineAsCommand) {
            return Stream.of(line).collect(Collectors.toList());
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        StringBuilder command = new StringBuilder();
        SectionType sectionType = null;
        int lastDelimiterIndex = 0;
        boolean wasPrevEscape = false;
        int index = 0;
        while (index < line.length()) {
            if (!wasPrevEscape && sectionType == null && line.startsWith("'", index)) {
                sectionType = SectionType.SINGLE_QUOTED;
                ++index;
                continue;
            }
            if (!wasPrevEscape && sectionType == SectionType.SINGLE_QUOTED && line.startsWith("'", index)) {
                sectionType = null;
                ++index;
                continue;
            }
            if (!wasPrevEscape && sectionType == null && line.startsWith("\"", index)) {
                sectionType = SectionType.DOUBLE_QUOTED;
                ++index;
                continue;
            }
            if (!wasPrevEscape && sectionType == SectionType.DOUBLE_QUOTED && line.startsWith("\"", index)) {
                sectionType = null;
                ++index;
                continue;
            }
            if (sectionType == null && line.startsWith("--", index)) {
                sectionType = SectionType.LINE_COMMENT;
                wasPrevEscape = false;
                index += 2;
                continue;
            }
            if (sectionType == SectionType.LINE_COMMENT && line.startsWith("\n", index)) {
                sectionType = null;
                wasPrevEscape = false;
                ++index;
                continue;
            }
            if (sectionType == null && line.startsWith("/*", index)) {
                sectionType = SectionType.BLOCK_COMMENT;
                wasPrevEscape = false;
                index += 2;
                continue;
            }
            if (sectionType == SectionType.BLOCK_COMMENT && line.startsWith("*/", index)) {
                sectionType = null;
                wasPrevEscape = false;
                index += 2;
                continue;
            }
            if (line.startsWith("\\", index)) {
                wasPrevEscape = !wasPrevEscape;
                ++index;
                continue;
            }
            if (sectionType == null && line.startsWith(this.beeLine.getOpts().getDelimiter(), index)) {
                this.addCmdPart(cmdList, command, line.substring(lastDelimiterIndex, index));
                lastDelimiterIndex = index += this.beeLine.getOpts().getDelimiter().length();
                wasPrevEscape = false;
                continue;
            }
            wasPrevEscape = false;
            ++index;
        }
        if (lastDelimiterIndex != index || line.length() == 0) {
            this.addCmdPart(cmdList, command, line.substring(lastDelimiterIndex, index));
        }
        return cmdList;
    }

    private void addCmdPart(List<String> cmdList, StringBuilder command, String cmdpart) {
        if (cmdpart.endsWith("\\")) {
            command.append(cmdpart.substring(0, cmdpart.length() - 1)).append(this.beeLine.getOpts().getDelimiter());
            return;
        }
        command.append(cmdpart);
        cmdList.add(command.toString());
        command.setLength(0);
    }

    private Runnable createLogRunnable(Statement statement, InPlaceUpdateStream.EventNotifier eventNotifier) {
        if (statement instanceof HiveStatement) {
            return new LogRunnable(this, (HiveStatement)statement, 1000L, eventNotifier);
        }
        this.beeLine.debug("The statement instance is not HiveStatement type: " + statement.getClass());
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    private void error(Throwable throwable) {
        this.beeLine.error(throwable);
    }

    private void debug(String message) {
        this.beeLine.debug(message);
    }

    private void showRemainingLogsIfAny(Statement statement) {
        if (statement instanceof HiveStatement) {
            HiveStatement hiveStatement = (HiveStatement)statement;
            List logs = null;
            do {
                try {
                    logs = hiveStatement.getQueryLog();
                }
                catch (SQLException e) {
                    this.beeLine.error(new SQLWarning(e));
                    return;
                }
                for (String log : logs) {
                    if (!this.beeLine.isTestMode()) {
                        this.beeLine.info(log);
                        continue;
                    }
                    this.beeLine.output(log);
                }
            } while (logs.size() > 0);
        } else {
            this.beeLine.debug("The statement instance is not HiveStatement type: " + statement.getClass());
        }
    }

    public boolean quit(String line) {
        this.beeLine.setExit(true);
        this.close(null);
        return true;
    }

    public boolean exit(String line) {
        return this.quit(line);
    }

    public boolean closeall(String line) {
        if (this.close(null)) {
            while (this.close(null)) {
            }
            return true;
        }
        return false;
    }

    public boolean close(String line) {
        if (this.beeLine.getDatabaseConnection() == null) {
            return false;
        }
        try {
            if (this.beeLine.getDatabaseConnection().getCurrentConnection() != null && !this.beeLine.getDatabaseConnection().getCurrentConnection().isClosed()) {
                int index = this.beeLine.getDatabaseConnections().getIndex();
                this.beeLine.info(this.beeLine.loc("closing", index, this.beeLine.getDatabaseConnection()));
                this.beeLine.getDatabaseConnection().getCurrentConnection().close();
            } else {
                this.beeLine.info(this.beeLine.loc("already-closed"));
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.beeLine.getDatabaseConnections().remove();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean properties(String line) throws Exception {
        Object example = "";
        example = (String)example + "Usage: properties <properties file>" + BeeLine.getSeparator();
        String[] parts = this.beeLine.split(line);
        if (parts.length < 2) {
            return this.beeLine.error((String)example);
        }
        int successes = 0;
        for (int i = 1; i < parts.length; ++i) {
            Properties props = new Properties();
            FileInputStream stream = new FileInputStream(parts[i]);
            try {
                props.load(stream);
            }
            finally {
                IOUtils.closeStream((Closeable)stream);
            }
            if (!this.connect(props)) continue;
            ++successes;
        }
        return successes == parts.length - 1;
    }

    public boolean connect(String line) throws Exception {
        String example = "Usage: connect <url> <username> <password> [driver]" + BeeLine.getSeparator();
        String[] parts = this.beeLine.split(line);
        if (parts == null) {
            return false;
        }
        if (parts.length < 2) {
            return this.beeLine.error(example);
        }
        String url = parts.length < 2 ? null : parts[1];
        String user = parts.length < 3 ? null : parts[2];
        String pass = parts.length < 4 ? null : parts[3];
        String driver = parts.length < 5 ? null : parts[4];
        Properties props = new Properties();
        if (url != null) {
            String saveUrl = this.getUrlToUse(url);
            props.setProperty("url", saveUrl);
        }
        String value = null;
        if (driver != null) {
            props.setProperty("driver", driver);
        } else {
            value = Utils.parsePropertyFromUrl((String)url, (String)"driver");
            if (value != null) {
                props.setProperty("driver", value);
            }
        }
        if (user != null) {
            props.setProperty("user", user);
        } else {
            value = Utils.parsePropertyFromUrl((String)url, (String)"user");
            if (value != null) {
                props.setProperty("user", value);
            }
        }
        if (pass != null) {
            props.setProperty("password", pass);
        } else {
            value = Utils.parsePropertyFromUrl((String)url, (String)"password");
            if (value != null) {
                props.setProperty("password", value);
            }
        }
        value = Utils.parsePropertyFromUrl((String)url, (String)"auth");
        if (value != null) {
            props.setProperty("auth", value);
        }
        return this.connect(props);
    }

    private String getUrlToUse(String urlParam) {
        boolean useIndirectUrl = false;
        try {
            URI tryParse = new URI(urlParam);
            if (tryParse.getScheme() == null) {
                useIndirectUrl = true;
            }
        }
        catch (URISyntaxException e) {
            useIndirectUrl = true;
        }
        if (useIndirectUrl) {
            this.beeLine.getOpts();
            String envUrl = BeeLineOpts.getEnv().get("BEELINE_URL_" + urlParam.toUpperCase());
            if (envUrl != null) {
                return envUrl;
            }
        }
        return urlParam;
    }

    private String getProperty(Properties props, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String string = props.getProperty(keys[i]);
            if (string == null) continue;
            return string;
        }
        for (String string : props.keySet()) {
            for (int j = 0; j < keys.length; ++j) {
                if (!string.endsWith(keys[j])) continue;
                return props.getProperty(string);
            }
        }
        return null;
    }

    public boolean connect(Properties props) throws IOException {
        String url = this.getProperty(props, new String[]{"url", "javax.jdo.option.ConnectionURL", "ConnectionURL"});
        String driver = this.getProperty(props, new String[]{"driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"});
        String username = this.getProperty(props, new String[]{"user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"});
        String password = this.getProperty(props, new String[]{"password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword"});
        if (url == null || url.length() == 0) {
            return this.beeLine.error("Property \"url\" is required");
        }
        if (!(driver != null && driver.length() != 0 || this.beeLine.scanForDriver(url))) {
            return this.beeLine.error(this.beeLine.loc("no-driver", url));
        }
        String auth = this.getProperty(props, new String[]{"auth"});
        if (auth == null && (auth = this.beeLine.getOpts().getAuthType()) != null) {
            props.setProperty("auth", auth);
        }
        this.beeLine.info("Connecting to " + url);
        if (Utils.parsePropertyFromUrl((String)url, (String)"principal") == null && !"browser".equals(auth)) {
            String urlForPrompt = url.substring(0, url.contains(";") ? url.indexOf(59) : url.length());
            if (username == null) {
                username = this.beeLine.getConsoleReader().readLine("Enter username for " + urlForPrompt + ": ");
            }
            props.setProperty("user", username);
            if (password == null) {
                password = this.beeLine.getConsoleReader().readLine("Enter password for " + urlForPrompt + ": ", new Character('*'));
            }
            props.setProperty("password", password);
        }
        try {
            int initScriptExecutionResult;
            this.beeLine.getDatabaseConnections().setConnection(new DatabaseConnection(this.beeLine, driver, url, props));
            this.beeLine.getDatabaseConnection().getConnection();
            if (!this.beeLine.isBeeLine()) {
                this.beeLine.updateOptsForCli();
            }
            if ((initScriptExecutionResult = this.beeLine.runInit()) != 0 && !this.beeLine.getOpts().getForce()) {
                return this.beeLine.error("init script execution failed.");
            }
            this.beeLine.setCompletions();
            this.beeLine.getOpts().setLastConnectedUrl(url);
            return true;
        }
        catch (SQLException sqle) {
            this.beeLine.getDatabaseConnections().remove();
            return this.beeLine.error(sqle);
        }
        catch (IOException ioe) {
            return this.beeLine.error(ioe);
        }
    }

    public boolean rehash(String line) {
        try {
            if (!this.beeLine.assertConnection()) {
                return false;
            }
            if (this.beeLine.getDatabaseConnection() != null) {
                this.beeLine.getDatabaseConnection().setCompletions(false);
            }
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean list(String line) {
        int index = 0;
        this.beeLine.info(this.beeLine.loc("active-connections", this.beeLine.getDatabaseConnections().size()));
        Iterator<DatabaseConnection> i = this.beeLine.getDatabaseConnections().iterator();
        while (i.hasNext()) {
            DatabaseConnection c = i.next();
            boolean closed = false;
            try {
                closed = c.getConnection().isClosed();
            }
            catch (Exception e) {
                closed = true;
            }
            this.beeLine.output(this.beeLine.getColorBuffer().pad(" #" + index, 5).pad(closed ? this.beeLine.loc("closed") : this.beeLine.loc("open"), 9).append(c.getUrl()));
            ++index;
        }
        return true;
    }

    public boolean all(String line) {
        int index = this.beeLine.getDatabaseConnections().getIndex();
        boolean success = true;
        for (int i = 0; i < this.beeLine.getDatabaseConnections().size(); ++i) {
            this.beeLine.getDatabaseConnections().setIndex(i);
            this.beeLine.output(this.beeLine.loc("executing-con", this.beeLine.getDatabaseConnection()));
            success = this.sql(line.substring("all ".length())) && success;
        }
        this.beeLine.getDatabaseConnections().setIndex(index);
        return success;
    }

    public boolean go(String line) {
        String[] parts = this.beeLine.split(line, 2, "Usage: go <connection index>");
        if (parts == null) {
            return false;
        }
        int index = Integer.parseInt(parts[1]);
        if (!this.beeLine.getDatabaseConnections().setIndex(index)) {
            this.beeLine.error(this.beeLine.loc("invalid-connection", "" + index));
            this.list("");
            return false;
        }
        return true;
    }

    public boolean script(String line) {
        if (this.beeLine.getScriptOutputFile() == null) {
            return this.startScript(line);
        }
        return this.stopScript(line);
    }

    private boolean stopScript(String line) {
        try {
            this.beeLine.getScriptOutputFile().close();
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        this.beeLine.output(this.beeLine.loc("script-closed", this.beeLine.getScriptOutputFile()));
        this.beeLine.setScriptOutputFile(null);
        return true;
    }

    private boolean startScript(String line) {
        if (this.beeLine.getScriptOutputFile() != null) {
            return this.beeLine.error(this.beeLine.loc("script-already-running", this.beeLine.getScriptOutputFile()));
        }
        String[] parts = this.beeLine.split(line, 2, "Usage: script <filename>");
        if (parts == null) {
            return false;
        }
        try {
            this.beeLine.setScriptOutputFile(new OutputFile(parts[1]));
            this.beeLine.output(this.beeLine.loc("script-started", this.beeLine.getScriptOutputFile()));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean run(String line) {
        String[] parts = this.beeLine.split(line, 2, "Usage: run <scriptfile>");
        if (parts == null) {
            return false;
        }
        try {
            String[] cmds = this.beeLine.getCommands(new File(parts[1]));
            return this.beeLine.runCommands(cmds) == cmds.length;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean record(String line) {
        if (this.beeLine.getRecordOutputFile() == null) {
            return this.startRecording(line);
        }
        return this.stopRecording(line);
    }

    private boolean stopRecording(String line) {
        try {
            this.beeLine.getRecordOutputFile().close();
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        this.beeLine.setRecordOutputFile(null);
        this.beeLine.output(this.beeLine.loc("record-closed", this.beeLine.getRecordOutputFile()));
        return true;
    }

    private boolean startRecording(String line) {
        if (this.beeLine.getRecordOutputFile() != null) {
            return this.beeLine.error(this.beeLine.loc("record-already-running", this.beeLine.getRecordOutputFile()));
        }
        String[] parts = this.beeLine.split(line, 2, "Usage: record <filename>");
        if (parts == null) {
            return false;
        }
        try {
            OutputFile recordOutput = new OutputFile(parts[1]);
            this.beeLine.output(this.beeLine.loc("record-started", recordOutput));
            this.beeLine.setRecordOutputFile(recordOutput);
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean describe(String line) throws SQLException {
        String[] table = this.beeLine.split(line, 2, "Usage: describe <table name>");
        if (table == null) {
            return false;
        }
        ResultSet rs = table[1].equals("tables") ? this.beeLine.getTables() : this.beeLine.getColumns(table[1]);
        if (rs == null) {
            return false;
        }
        this.beeLine.print(rs);
        rs.close();
        return true;
    }

    public boolean help(String line) {
        String[] parts = this.beeLine.split(line);
        String cmd = parts.length > 1 ? parts[1] : "";
        boolean count = false;
        TreeSet<ColorBuffer> clist = new TreeSet<ColorBuffer>();
        for (int i = 0; i < this.beeLine.commandHandlers.length; ++i) {
            if (cmd.length() != 0 && !Arrays.asList(this.beeLine.commandHandlers[i].getNames()).contains(cmd)) continue;
            clist.add(this.beeLine.getColorBuffer().pad("!" + this.beeLine.commandHandlers[i].getName(), 20).append(this.beeLine.wrap(this.beeLine.commandHandlers[i].getHelpText(), 60, 20)));
        }
        Iterator i = clist.iterator();
        while (i.hasNext()) {
            this.beeLine.output((ColorBuffer)i.next());
        }
        if (cmd.length() == 0) {
            this.beeLine.output("");
            this.beeLine.output(this.beeLine.loc("comments", this.beeLine.getApplicationContactInformation()));
        }
        return true;
    }

    public boolean manual(String line) throws IOException {
        String man;
        InputStream in = BeeLine.class.getResourceAsStream("manual.txt");
        if (in == null) {
            return this.beeLine.error(this.beeLine.loc("no-manual"));
        }
        BufferedReader breader = new BufferedReader(new InputStreamReader(in));
        int index = 0;
        while ((man = breader.readLine()) != null) {
            String ret;
            this.beeLine.output(man);
            if (++index % (this.beeLine.getOpts().getMaxHeight() - 1) != 0 || (ret = this.beeLine.getConsoleReader().readLine(this.beeLine.loc("enter-for-more"))) == null || !ret.startsWith("q")) continue;
            break;
        }
        breader.close();
        return true;
    }

    public boolean delimiter(String line) {
        return this.set("set " + line);
    }

    private static enum SectionType {
        SINGLE_QUOTED,
        DOUBLE_QUOTED,
        LINE_COMMENT,
        BLOCK_COMMENT;

    }

    static class LogRunnable
    implements Runnable {
        private final Commands commands;
        private final HiveStatement hiveStatement;
        private final long queryProgressInterval;
        private final InPlaceUpdateStream.EventNotifier notifier;

        LogRunnable(Commands commands, HiveStatement hiveStatement, long queryProgressInterval, InPlaceUpdateStream.EventNotifier eventNotifier) {
            this.hiveStatement = hiveStatement;
            this.commands = commands;
            this.queryProgressInterval = queryProgressInterval;
            this.notifier = eventNotifier;
        }

        private void updateQueryLog() {
            try {
                List queryLogs = this.hiveStatement.getQueryLog();
                for (String log : queryLogs) {
                    if (!this.commands.beeLine.isTestMode()) {
                        this.commands.beeLine.info(log);
                        continue;
                    }
                    this.commands.beeLine.output(log);
                }
                if (!queryLogs.isEmpty()) {
                    this.notifier.operationLogShowedToUser();
                }
            }
            catch (SQLException e) {
                this.commands.error(new SQLWarning(e));
            }
        }

        @Override
        public void run() {
            try {
                while (this.hiveStatement.hasMoreLogs()) {
                    if (this.notifier.canOutputOperationLogs()) {
                        this.commands.debug("going to print operations logs");
                        this.updateQueryLog();
                        this.commands.debug("printed operations logs");
                    }
                    Thread.sleep(this.queryProgressInterval);
                }
            }
            catch (InterruptedException e) {
                this.commands.debug("Getting log thread is interrupted, since query is done!");
            }
            finally {
                this.commands.showRemainingLogsIfAny((Statement)this.hiveStatement);
            }
        }
    }
}

