/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.serde.AccumuloCompositeRowId;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.ql.metadata.JarUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAccumuloRowIdFactory<T extends AccumuloCompositeRowId>
extends DefaultAccumuloRowIdFactory {
    public static final Logger log = LoggerFactory.getLogger(CompositeAccumuloRowIdFactory.class);
    private final Class<T> keyClass;
    private final Constructor<T> constructor;

    public CompositeAccumuloRowIdFactory(Class<T> keyClass) throws SecurityException, NoSuchMethodException {
        this.keyClass = keyClass;
        this.constructor = keyClass.getDeclaredConstructor(LazySimpleStructObjectInspector.class, Properties.class, Configuration.class);
    }

    @Override
    public void addDependencyJars(Configuration jobConf) throws IOException {
        JarUtils.addDependencyJars((Configuration)jobConf, Collections.singletonList(this.keyClass));
    }

    public T createRowId(ObjectInspector inspector) throws SerDeException {
        try {
            return (T)((Object)((AccumuloCompositeRowId)((Object)this.constructor.newInstance(inspector, this.properties, this.accumuloSerDeParams.getConf()))));
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }
}

