/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.AuthFilter;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@InterfaceAudience.LimitedPrivate(value={"Integration Tests"})
@InterfaceStability.Unstable
public class Main {
    public static final String SERVLET_PATH = "templeton";
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_HOST = IPStackUtils.resolveWildcardAddress();
    public static final String DEFAULT_KEY_STORE_PATH = "";
    public static final String DEFAULT_KEY_STORE_PASSWORD = "";
    public static final String DEFAULT_SSL_PROTOCOL_BLACKLIST = "SSLv2,SSLv3";
    private Server server;
    private static volatile AppConfig conf;

    public static synchronized AppConfig getAppConfigInstance() {
        if (conf == null) {
            LOG.error("Bug: configuration not yet loaded");
        }
        return conf;
    }

    Main(String[] args) {
        this.init(args);
    }

    public void init(String[] args) {
        this.initLogger();
        conf = this.loadConfig(args);
        conf.startCleanup();
        LOG.debug("Loaded conf " + String.valueOf((Object)conf));
    }

    private void initLogger() {
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler h : rootLogger.getHandlers()) {
            rootLogger.removeHandler(h);
        }
        SLF4JBridgeHandler.install();
    }

    public AppConfig loadConfig(String[] args) {
        AppConfig cf = new AppConfig();
        try {
            GenericOptionsParser parser = new GenericOptionsParser((Configuration)cf, args);
            if (parser.getRemainingArgs().length > 0) {
                this.usage();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to parse options: " + String.valueOf(e));
            this.usage();
        }
        return cf;
    }

    public void usage() {
        System.err.println("usage: templeton [-Dtempleton.port=N] [-D...]");
        ExitUtil.terminate((int)1);
    }

    public void run() {
        int port = conf.getInt("templeton.port", 8080);
        try {
            this.checkEnv();
            this.runServer(port);
            port = ArrayUtils.isEmpty((Object[])this.server.getConnectors()) ? -1 : ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
            System.out.println("templeton: listening on port " + port);
            LOG.info("Templeton listening on port " + port);
        }
        catch (Exception e) {
            System.err.println("templeton: Server failed to start: " + e.getMessage());
            LOG.error("Server failed to start: ", (Throwable)e);
            ExitUtil.terminate((int)1);
        }
    }

    void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOG.warn("Failed to stop jetty.Server", (Throwable)ex);
            }
        }
    }

    private void checkEnv() {
        this.checkCurrentDirPermissions();
    }

    private void checkCurrentDirPermissions() {
        File pwd = new File(".");
        if (!pwd.exists()) {
            String msg = "Server failed to start: templeton: Current working directory '.' does not exist!";
            System.err.println(msg);
            LOG.error(msg);
            ExitUtil.terminate((int)1);
        }
    }

    public Server runServer(int port) throws Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)conf.kerberosPrincipal(), (String)"0.0.0.0");
            UserGroupInformation.loginUserFromKeytab((String)serverPrincipal, (String)conf.kerberosKeytab());
        }
        Server server = null;
        if (StringUtils.isEmpty((CharSequence)conf.jettyConfiguration())) {
            server = new Server(port);
        } else {
            FileInputStream jettyConf = new FileInputStream(conf.jettyConfiguration());
            XmlConfiguration configuration = new XmlConfiguration((InputStream)jettyConf);
            server = (Server)configuration.configure();
        }
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/");
        FilterHolder fHolder = this.makeAuthFilter();
        EnumSet<DispatcherType> dispatches = EnumSet.of(DispatcherType.REQUEST);
        root.addFilter(fHolder, "/templeton/v1/ddl/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/pig/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/hive/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/sqoop/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/queue/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/jobs/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/mapreduce/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/status/*", dispatches);
        root.addFilter(fHolder, "/templeton/v1/version/*", dispatches);
        if (conf.getBoolean("templeton.xsrf.filter.enabled", false)) {
            root.addFilter(this.makeXSRFFilter(), "/templeton/*", dispatches);
            LOG.debug("XSRF filter enabled");
        } else {
            LOG.warn("XSRF filter disabled");
        }
        root.addFilter(this.makeFrameOptionFilter(), "/templeton/*", dispatches);
        ServletHolder h = new ServletHolder((Servlet)new ServletContainer((Application)this.makeJerseyConfig()));
        root.addServlet(h, "/templeton/*");
        this.addRedirects(server);
        LowResourceMonitor low = new LowResourceMonitor(server);
        low.setLowResourcesIdleTimeout(10000);
        server.addBean((Object)low);
        server.setConnectors(new Connector[]{this.createChannelConnector(server)});
        server.start();
        this.server = server;
        return server;
    }

    public FilterHolder makeXSRFFilter() {
        String customHeader = null;
        String methodsToIgnore = null;
        FilterHolder fHolder = new FilterHolder(Utils.getXSRFFilter());
        if (customHeader != null) {
            fHolder.setInitParameter("custom-header", customHeader);
        }
        if (methodsToIgnore != null) {
            fHolder.setInitParameter("methods-to-ignore", methodsToIgnore);
        }
        FilterHolder xsrfFilter = fHolder;
        return xsrfFilter;
    }

    private Connector createChannelConnector(Server server) {
        ServerConnector connector;
        HttpConfiguration httpConf = new HttpConfiguration();
        httpConf.setRequestHeaderSize(65536);
        httpConf.setSendServerVersion(false);
        httpConf.setSendXPoweredBy(false);
        HttpConnectionFactory http = new HttpConnectionFactory(httpConf);
        if (conf.getBoolean("templeton.use.ssl", false)) {
            LOG.info("Using SSL for templeton.");
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(conf.get("templeton.keystore.path", ""));
            sslContextFactory.setKeyStorePassword(conf.get("templeton.keystore.password", ""));
            HashSet excludedSSLProtocols = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)Objects.toString(conf.get("templeton.ssl.protocol.blacklist", DEFAULT_SSL_PROTOCOL_BLACKLIST), "")));
            sslContextFactory.addExcludeProtocols(excludedSSLProtocols.toArray(new String[excludedSSLProtocols.size()]));
            connector = new ServerConnector(server, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{http});
        } else {
            connector = new ServerConnector(server, new ConnectionFactory[]{http});
        }
        connector.setReuseAddress(true);
        connector.setHost(conf.get("templeton.host", DEFAULT_HOST));
        connector.setPort(conf.getInt("templeton.port", 8080));
        return connector;
    }

    public FilterHolder makeAuthFilter() throws IOException {
        FilterHolder authFilter = new FilterHolder(AuthFilter.class);
        UserNameHandler.allowAnonymous(authFilter);
        String confPrefix = "dfs.web.authentication";
        String prefix = confPrefix + ".";
        authFilter.setInitParameter("config.prefix", confPrefix);
        authFilter.setInitParameter(prefix + "cookie.path", "/");
        if (UserGroupInformation.isSecurityEnabled()) {
            authFilter.setInitParameter(prefix + "type", "kerberos");
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)conf.kerberosPrincipal(), (String)"0.0.0.0");
            authFilter.setInitParameter(prefix + "kerberos.principal", serverPrincipal);
            authFilter.setInitParameter(prefix + "kerberos.keytab", conf.kerberosKeytab());
            authFilter.setInitParameter(prefix + "signature.secret", conf.kerberosSecret());
        } else {
            authFilter.setInitParameter(prefix + "type", "simple");
        }
        return authFilter;
    }

    public FilterHolder makeFrameOptionFilter() {
        FilterHolder frameOptionFilter = new FilterHolder(XFrameOptionsFilter.class);
        frameOptionFilter.setInitParameter("templeton.frame.options.filter", conf.get("templeton.frame.options.filter"));
        return frameOptionFilter;
    }

    public PackagesResourceConfig makeJerseyConfig() {
        PackagesResourceConfig rc = new PackagesResourceConfig(new String[]{"org.apache.hive.hcatalog.templeton"});
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        props.put("com.sun.jersey.config.property.WadlGeneratorConfig", "org.apache.hive.hcatalog.templeton.WadlConfig");
        rc.setPropertiesAndFeatures(props);
        return rc;
    }

    public void addRedirects(Server server) {
        RewriteHandler rewrite = new RewriteHandler();
        RedirectPatternRule redirect = new RedirectPatternRule();
        redirect.setPattern("/templeton/v1/application.wadl");
        redirect.setLocation("/templeton/application.wadl");
        rewrite.addRule((Rule)redirect);
        HandlerList handlerlist = new HandlerList();
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(rewrite);
        for (org.eclipse.jetty.server.Handler handler : server.getHandlers()) {
            handlers.add(handler);
        }
        org.eclipse.jetty.server.Handler[] newlist = new org.eclipse.jetty.server.Handler[handlers.size()];
        handlerlist.setHandlers(handlers.toArray(newlist));
        server.setHandler((org.eclipse.jetty.server.Handler)handlerlist);
    }

    public static void main(String[] args) {
        Main templeton = new Main(args);
        templeton.run();
    }

    static final class UserNameHandler {
        UserNameHandler() {
        }

        static void allowAnonymous(FilterHolder authFilter) {
            authFilter.setInitParameter("dfs.web.authentication.simple.anonymous.allowed", "true");
        }

        static String getUserName(HttpServletRequest request) {
            if (!UserGroupInformation.isSecurityEnabled() && "POST".equalsIgnoreCase(request.getMethod())) {
                String userName = request.getParameter("user.name");
                if (userName != null) {
                    LOG.warn("user.name is sent as form parameter which is deprecated as of Hive 0.13.  Should send it in the query string.");
                }
                return userName;
            }
            return null;
        }
    }

    public static class XFrameOptionsFilter
    implements Filter {
        private static final String defaultMode = "DENY";
        private String mode = null;

        public void init(FilterConfig filterConfig) throws ServletException {
            this.mode = filterConfig.getInitParameter("templeton.frame.options.filter");
            if (this.mode == null) {
                this.mode = defaultMode;
            }
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletResponse res = (HttpServletResponse)response;
            res.setHeader("X-FRAME-OPTIONS", this.mode);
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

