/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.api.repl.commands.NoopCommand;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;

public class AddPartitionReplicationTask
extends ReplicationTask {
    AddPartitionMessage addPartitionMessage = null;

    public AddPartitionReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "ADD_PARTITION");
        this.addPartitionMessage = messageFactory.getDeserializer().getAddPartitionMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return !this.addPartitionMessage.getPartitions().isEmpty();
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        if (this.addPartitionMessage.getPartitions().isEmpty()) {
            return Collections.singletonList(new NoopCommand(this.event.getEventId()));
        }
        return Iterables.transform((Iterable)this.addPartitionMessage.getPartitions(), (Function)new Function<Map<String, String>, Command>(){

            public Command apply(@Nullable Map<String, String> ptnDesc) {
                return new ExportCommand(AddPartitionReplicationTask.this.addPartitionMessage.getDB(), AddPartitionReplicationTask.this.addPartitionMessage.getTable(), ptnDesc, AddPartitionReplicationTask.this.srcStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(AddPartitionReplicationTask.this.getEvent().getEventId(), AddPartitionReplicationTask.this.addPartitionMessage.getDB(), AddPartitionReplicationTask.this.addPartitionMessage.getTable(), ptnDesc)), false, AddPartitionReplicationTask.this.event.getEventId());
            }
        });
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        if (this.addPartitionMessage.getPartitions().isEmpty()) {
            return Collections.singletonList(new NoopCommand(this.event.getEventId()));
        }
        final String dstDbName = ReplicationUtils.mapIfMapAvailable(this.addPartitionMessage.getDB(), (Function<String, String>)this.dbNameMapping);
        final String dstTableName = ReplicationUtils.mapIfMapAvailable(this.addPartitionMessage.getTable(), (Function<String, String>)this.tableNameMapping);
        return Iterables.transform((Iterable)this.addPartitionMessage.getPartitions(), (Function)new Function<Map<String, String>, Command>(){

            public Command apply(@Nullable Map<String, String> ptnDesc) {
                return new ImportCommand(dstDbName, dstTableName, ptnDesc, AddPartitionReplicationTask.this.dstStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(AddPartitionReplicationTask.this.getEvent().getEventId(), AddPartitionReplicationTask.this.addPartitionMessage.getDB(), AddPartitionReplicationTask.this.addPartitionMessage.getTable(), ptnDesc)), false, AddPartitionReplicationTask.this.event.getEventId());
            }
        });
    }
}

