/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hive.hcatalog.api.HCatDatabase;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.data.ReaderWriter;

public class ReplicationUtils {
    public static final String REPL_STATE_ID = ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString();

    private ReplicationUtils() {
    }

    public static long getLastReplicationId(HCatDatabase db) {
        Map<String, String> props = db.getProperties();
        if (props != null && props.containsKey(REPL_STATE_ID)) {
            return Long.parseLong(props.get(REPL_STATE_ID));
        }
        return 0L;
    }

    public static long getLastReplicationId(HCatTable tbl) {
        Map<String, String> tblProps = tbl.getTblProps();
        if (tblProps != null && tblProps.containsKey(REPL_STATE_ID)) {
            return Long.parseLong(tblProps.get(REPL_STATE_ID));
        }
        return 0L;
    }

    public static long getLastReplicationId(HCatPartition ptn, @Nullable HCatTable parentTable) {
        Map<String, String> parameters = ptn.getParameters();
        if (parameters != null && parameters.containsKey(REPL_STATE_ID)) {
            return Long.parseLong(parameters.get(REPL_STATE_ID));
        }
        if (parentTable != null) {
            return ReplicationUtils.getLastReplicationId(parentTable);
        }
        return 0L;
    }

    public static String getUniqueKey(long eventId, String db, String table, Map<String, String> ptnDesc) {
        StringBuilder sb = new StringBuilder();
        sb.append(eventId);
        sb.append('.');
        sb.append(ReplicationUtils.toStringWordCharsOnly(db));
        sb.append('.');
        sb.append(ReplicationUtils.toStringWordCharsOnly(table));
        sb.append('.');
        sb.append(ReplicationUtils.toStringWordCharsOnly(ptnDesc));
        sb.append('.');
        sb.append(Objects.hashCode((Object[])new Object[]{db, table, ptnDesc}));
        return sb.toString();
    }

    private static String toStringWordCharsOnly(Map<String, String> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(ReplicationUtils.toStringWordCharsOnly(e.getKey()));
            sb.append('=');
            sb.append(ReplicationUtils.toStringWordCharsOnly(e.getValue()));
            first = false;
        }
        return sb.toString();
    }

    public static String toStringWordCharsOnly(String s) {
        return s == null ? "null" : s.replaceAll("[\\W]", "").toLowerCase();
    }

    Function<String, String> mapBasedFunction(final Map<String, String> m) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String s) {
                if (m == null || !m.containsKey(s)) {
                    return s;
                }
                return (String)m.get(s);
            }
        };
    }

    public static String mapIfMapAvailable(String s, Function<String, String> mapping) {
        try {
            if (mapping != null) {
                return (String)mapping.apply((Object)s);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return s;
    }

    public static String partitionDescriptor(Map<String, String> ptnDesc) {
        StringBuilder sb = new StringBuilder();
        if (ptnDesc != null && !ptnDesc.isEmpty()) {
            boolean first = true;
            sb.append(" PARTITION (");
            for (Map.Entry<String, String> e : ptnDesc.entrySet()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append((Object)e.getKey());
                sb.append('=');
                sb.append('\"');
                sb.append((Object)e.getValue());
                sb.append('\"');
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static String serializeCommand(Command command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(baos);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)command.getClass().getName());
        command.write(dataOutput);
        return Base64.getUrlEncoder().encodeToString(baos.toByteArray());
    }

    public static Command deserializeCommand(String s) throws IOException {
        Command cmd;
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(Base64.getUrlDecoder().decode(s)));
        String clazz = (String)ReaderWriter.readDatum((DataInput)dataInput);
        try {
            cmd = (Command)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new IOExceptionWithCause("Error instantiating class " + clazz, (Throwable)e);
        }
        cmd.readFields(dataInput);
        return cmd;
    }
}

