/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchemaUtils;

public class HCatPartition {
    private String tableName;
    private String dbName;
    private List<String> values;
    private List<HCatFieldSchema> tableCols;
    private int createTime;
    private int lastAccessTime;
    private StorageDescriptor sd;
    private Map<String, String> parameters;

    HCatPartition(Partition partition) throws HCatException {
        this.tableName = partition.getTableName();
        this.dbName = partition.getDbName();
        this.createTime = partition.getCreateTime();
        this.lastAccessTime = partition.getLastAccessTime();
        this.parameters = partition.getParameters();
        this.values = partition.getValues();
        this.sd = partition.getSd();
        this.tableCols = new ArrayList<HCatFieldSchema>();
        for (FieldSchema fs : this.sd.getCols()) {
            this.tableCols.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)fs));
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public List<HCatFieldSchema> getColumns() {
        return this.tableCols;
    }

    public String getInputFormat() {
        return this.sd.getInputFormat();
    }

    public String getOutputFormat() {
        return this.sd.getOutputFormat();
    }

    public String getStorageHandler() {
        return (String)this.sd.getParameters().get("storage_handler");
    }

    public String getLocation() {
        return this.sd.getLocation();
    }

    public String getSerDe() {
        return this.sd.getSerdeInfo().getSerializationLib();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public List<String> getValues() {
        return this.values;
    }

    public List<String> getBucketCols() {
        return this.sd.getBucketCols();
    }

    public int getNumBuckets() {
        return this.sd.getNumBuckets();
    }

    public List<Order> getSortCols() {
        return this.sd.getSortCols();
    }

    public String toString() {
        return "HCatPartition [" + (this.tableName != null ? "tableName=" + this.tableName + ", " : "tableName=null") + (this.dbName != null ? "dbName=" + this.dbName + ", " : "dbName=null") + (this.values != null ? "values=" + this.values + ", " : "values=null") + "createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + ", " + (this.sd != null ? "sd=" + this.sd + ", " : "sd=null") + (this.parameters != null ? "parameters=" + this.parameters : "parameters=null") + "]";
    }
}

