/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging.json;

import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hive.hcatalog.messaging.AlterIndexMessage;
import org.apache.hive.hcatalog.messaging.json.JSONMessageDeserializer;
import org.apache.hive.hcatalog.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONAlterIndexMessage
extends AlterIndexMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String beforeIndexObjJson;
    @JsonProperty
    String afterIndexObjJson;
    @JsonProperty
    Long timestamp;

    public JSONAlterIndexMessage() {
    }

    public JSONAlterIndexMessage(String server, String servicePrincipal, Index before, Index after, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = after.getDbName();
        this.timestamp = timestamp;
        try {
            this.beforeIndexObjJson = JSONMessageFactory.createIndexObjJson(before);
            this.afterIndexObjJson = JSONMessageFactory.createIndexObjJson(after);
        }
        catch (TException ex) {
            throw new IllegalArgumentException("Could not serialize Index object", ex);
        }
        this.checkValid();
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getBeforeIndexObjJson() {
        return this.beforeIndexObjJson;
    }

    public String getAfterIndexObjJson() {
        return this.afterIndexObjJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

