/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;
import org.apache.hive.hcatalog.messaging.CreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.CreateTableMessage;
import org.apache.hive.hcatalog.messaging.DropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;
import org.apache.hive.hcatalog.messaging.DropTableMessage;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.hive.hcatalog.messaging.json.JSONMessageFactory;

public abstract class MessageFactory {
    private static MessageFactory instance = new JSONMessageFactory();
    protected static final HiveConf hiveConf = new HiveConf();
    private static final String CONF_LABEL_HCAT_MESSAGE_FACTORY_IMPL_PREFIX = "hcatalog.message.factory.impl.";
    private static final String CONF_LABEL_HCAT_MESSAGE_FORMAT = "hcatalog.message.format";
    private static final String HCAT_MESSAGE_FORMAT;
    private static final String DEFAULT_MESSAGE_FACTORY_IMPL = "org.apache.hive.hcatalog.messaging.json.JSONMessageFactory";
    private static final String HCAT_MESSAGE_FACTORY_IMPL;
    protected static final String HCAT_SERVER_URL;
    protected static final String HCAT_SERVICE_PRINCIPAL;

    public static MessageFactory getInstance() {
        if (instance == null) {
            instance = MessageFactory.getInstance(HCAT_MESSAGE_FACTORY_IMPL);
        }
        return instance;
    }

    private static MessageFactory getInstance(String className) {
        try {
            return (MessageFactory)ReflectionUtils.newInstance(Class.forName(className), (Configuration)hiveConf);
        }
        catch (ClassNotFoundException classNotFound) {
            throw new IllegalStateException("Could not construct MessageFactory implementation: ", classNotFound);
        }
    }

    public static MessageDeserializer getDeserializer(String format, String version) {
        return MessageFactory.getInstance(hiveConf.get(CONF_LABEL_HCAT_MESSAGE_FACTORY_IMPL_PREFIX + format, DEFAULT_MESSAGE_FACTORY_IMPL)).getDeserializer();
    }

    public abstract MessageDeserializer getDeserializer();

    public abstract String getVersion();

    public abstract String getMessageFormat();

    public abstract CreateDatabaseMessage buildCreateDatabaseMessage(Database var1);

    public abstract DropDatabaseMessage buildDropDatabaseMessage(Database var1);

    public abstract CreateTableMessage buildCreateTableMessage(Table var1);

    public abstract DropTableMessage buildDropTableMessage(Table var1);

    public abstract AddPartitionMessage buildAddPartitionMessage(Table var1, List<Partition> var2);

    public abstract DropPartitionMessage buildDropPartitionMessage(Table var1, Partition var2);

    static {
        hiveConf.addResource("hive-site.xml");
        HCAT_MESSAGE_FORMAT = hiveConf.get(CONF_LABEL_HCAT_MESSAGE_FORMAT, "json");
        HCAT_MESSAGE_FACTORY_IMPL = hiveConf.get(CONF_LABEL_HCAT_MESSAGE_FACTORY_IMPL_PREFIX + HCAT_MESSAGE_FORMAT, DEFAULT_MESSAGE_FACTORY_IMPL);
        HCAT_SERVER_URL = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.name(), "");
        HCAT_SERVICE_PRINCIPAL = hiveConf.get(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.name(), "");
    }
}

