/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import com.google.common.base.Joiner;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={LargeTests.class})
public class TestThriftHttpServer {
    private static final Log LOG = LogFactory.getLog(TestThriftHttpServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Thread httpServerThread;
    private volatile Exception httpServerException;
    private Exception clientSideException;
    private ThriftServer thriftServer;
    private int port;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static volatile boolean tableCreated = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testExceptionThrownWhenMisConfigured() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.thrift.security.qop", "privacy");
        conf.setBoolean("hbase.thrift.ssl.enabled", false);
        ThriftServerRunner runner = null;
        ExpectedException thrown = ExpectedException.none();
        try {
            thrown.expect(IllegalArgumentException.class);
            thrown.expectMessage("Thrift HTTP Server's QoP is privacy, but hbase.thrift.ssl.enabled is false");
            runner = new ThriftServerRunner(conf);
            Assert.fail((String)"Thrift HTTP Server starts up even with wrong security configurations.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull(runner);
    }

    private void startHttpServerThread(final String[] args) {
        LOG.info((Object)("Starting HBase Thrift server with HTTP server: " + Joiner.on((String)" ").join((Object[])args)));
        this.httpServerException = null;
        this.httpServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestThriftHttpServer.this.thriftServer.doMain(args);
                }
                catch (Exception e) {
                    TestThriftHttpServer.this.httpServerException = e;
                }
            }
        });
        this.httpServerThread.setName(ThriftServer.class.getSimpleName() + "-httpServer");
        this.httpServerThread.start();
    }

    @Test(timeout=600000L)
    public void testRunThriftServerWithHeaderBufferLength() throws Exception {
        try {
            this.runThriftServer(64512);
        }
        catch (TTransportException tex) {
            Assert.assertFalse((boolean)tex.getMessage().equals("HTTP Response code: 413"));
        }
        this.exception.expect(TTransportException.class);
        this.exception.expectMessage("HTTP Response code: 413");
        this.runThriftServer(65536);
    }

    @Test(timeout=600000L)
    public void testRunThriftServer() throws Exception {
        this.runThriftServer(0);
    }

    @Test
    public void testThriftServerHttpTraceForbiddenWhenOptionsDisabled() throws Exception {
        this.checkHttpMethods("TRACE", 403);
    }

    @Test
    public void testThriftServerHttpTraceForbiddenWhenOptionsEnabled() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean(ThriftServerRunner.THRIFT_HTTP_ALLOW_OPTIONS_METHOD, true);
        this.checkHttpMethods("TRACE", 403);
    }

    @Test
    public void testThriftServerHttpOptionsForbiddenWhenOptionsDisabled() throws Exception {
        TEST_UTIL.getConfiguration().unset(ThriftServerRunner.THRIFT_HTTP_ALLOW_OPTIONS_METHOD);
        this.checkHttpMethods("OPTIONS", 403);
    }

    @Test
    public void testThriftServerHttpOptionsOkWhenOptionsEnabled() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean(ThriftServerRunner.THRIFT_HTTP_ALLOW_OPTIONS_METHOD, true);
        this.checkHttpMethods("OPTIONS", 200);
    }

    private void waitThriftServerStartup() throws Exception {
        HBaseTestingUtility.waitForHostPort((String)"localhost", (int)this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runThriftServer(int customHeaderSize) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        args.add("start");
        this.thriftServer = new ThriftServer(TEST_UTIL.getConfiguration());
        this.startHttpServerThread(args.toArray(new String[args.size()]));
        this.waitThriftServerStartup();
        try {
            this.talkToThriftServer(customHeaderSize);
        }
        catch (Exception ex) {
            this.clientSideException = ex;
        }
        finally {
            this.stopHttpServerThread();
        }
        if (this.clientSideException != null) {
            LOG.error((Object)("Thrift client threw an exception " + this.clientSideException));
            if (this.clientSideException instanceof TTransportException) {
                throw this.clientSideException;
            }
            throw new Exception(this.clientSideException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void talkToThriftServer(int customHeaderSize) throws Exception {
        THttpClient httpClient = new THttpClient("http://localhost:" + this.port);
        httpClient.open();
        if (customHeaderSize > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < customHeaderSize; ++i) {
                sb.append("a");
            }
            httpClient.setCustomHeader("User-Agent", sb.toString());
        }
        try {
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            httpClient.close();
        }
    }

    private void stopHttpServerThread() throws Exception {
        LOG.debug((Object)"Stopping Thrift HTTP server");
        this.thriftServer.stop();
        this.httpServerThread.join();
        if (this.httpServerException != null) {
            LOG.error((Object)"Command-line invocation of HBase Thrift server threw an exception", (Throwable)this.httpServerException);
            throw new Exception(this.httpServerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHttpMethods(String httpRequestMethod, int httpExpectedResponse) throws Exception {
        this.port = HBaseTestingUtility.randomFreePort();
        this.thriftServer = new ThriftServer(TEST_UTIL.getConfiguration());
        try {
            this.startHttpServerThread(new String[]{"-port", String.valueOf(this.port), "start"});
            this.waitThriftServerStartup();
            URL url = new URL("http://localhost:" + this.port);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestMethod(httpRequestMethod);
            Assert.assertEquals((long)httpExpectedResponse, (long)httpConn.getResponseCode());
        }
        finally {
            this.stopHttpServerThread();
        }
    }
}

