/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.hbase.Version;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)VersionInfo.class.getName());
    private static final int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return Version.version;
    }

    public static String getRevision() {
        return "01ac2f51f3bb4cee623ea7dced75bfccbb6b562e";
    }

    public static String getDate() {
        return "Thu Jul 10 15:51:01 UTC 2025";
    }

    public static String getUser() {
        return "work";
    }

    public static String getUrl() {
        return "git://b62dd40cd0ae/home/work/hbase-rm/output/hbase";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "91a968dbd81d5302ae8e4dfce6a02ae3a1c7f9b169efbe68aa88d55436c44b5912c3de47c4c6fc4710a5d34cf27a2449969a95dabe778f4ee36d390bc32b545d";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info(line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] v1Comps = VersionInfo.getVersionComponents(v1);
        String[] v2Comps = VersionInfo.getVersionComponents(v2);
        int length = Math.max(v1Comps.length, v2Comps.length);
        for (int i = 0; i < length; ++i) {
            Integer vb;
            Integer va = i < v1Comps.length ? Integer.parseInt(v1Comps[i]) : 0;
            int compare = va.compareTo(vb = Integer.valueOf(i < v2Comps.length ? Integer.parseInt(v2Comps[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static String[] getVersionComponents(String version) {
        assert (version != null);
        List<String> list = Splitter.onPattern("[\\.-]").splitToList(version);
        String[] strComps = list.toArray(new String[list.size()]);
        assert (strComps.length > 0);
        String[] comps = new String[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            comps[i] = StringUtils.isNumeric(strComps[i]) ? strComps[i] : (StringUtils.isEmpty(strComps[i]) ? String.valueOf(100000) : ("SNAPSHOT".equals(strComps[i]) ? "-1" : ("beta".equals(strComps[i]) ? "-2" : ("alpha".equals(strComps[i]) ? "-3" : "-4"))));
        }
        return comps;
    }

    public static int getMajorVersion(String version) {
        return Integer.parseInt(Iterables.get(Splitter.on('.').split(version), 0));
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

