/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.WorkerAssigner;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.SplitWALProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALManager {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALManager.class);
    private final MasterServices master;
    private final WorkerAssigner splitWorkerAssigner;
    private final Path rootDir;
    private final FileSystem fs;
    private final Configuration conf;
    private final Path walArchiveDir;

    public SplitWALManager(MasterServices master) throws IOException {
        this.master = master;
        this.conf = master.getConfiguration();
        this.splitWorkerAssigner = new WorkerAssigner(this.master, this.conf.getInt("hbase.regionserver.wal.max.splitters", 2), new ProcedureEvent<String>("split-WAL-worker-assigning"));
        this.rootDir = master.getMasterFileSystem().getWALRootDir();
        this.fs = master.getMasterFileSystem().getWALFileSystem();
        this.walArchiveDir = new Path(this.rootDir, "oldWALs");
    }

    public List<Procedure> splitWALs(ServerName crashedServer, boolean splitMeta) throws IOException {
        try {
            List<FileStatus> splittingFiles = this.getWALsToSplit(crashedServer, splitMeta);
            return this.createSplitWALProcedures(splittingFiles, crashedServer);
        }
        catch (IOException e) {
            LOG.error("Failed to create procedures for splitting WALs of {}", (Object)crashedServer, (Object)e);
            throw e;
        }
    }

    public List<FileStatus> getWALsToSplit(ServerName serverName, boolean splitMeta) throws IOException {
        List<Path> logDirs = this.master.getMasterWalManager().getLogDirs(Collections.singleton(serverName));
        List<FileStatus> fileStatuses = SplitLogManager.getFileList(this.conf, logDirs, splitMeta ? MasterWalManager.META_FILTER : MasterWalManager.NON_META_FILTER);
        LOG.info("{} WAL count={}, meta={}", new Object[]{serverName, fileStatuses.size(), splitMeta});
        return fileStatuses;
    }

    private Path getWALSplitDir(ServerName serverName) {
        Path logDir = new Path(this.rootDir, AbstractFSWALProvider.getWALDirectoryName(serverName.toString()));
        return logDir.suffix("-splitting");
    }

    public void archive(String wal) throws IOException {
        WALSplitUtil.moveWAL(this.fs, new Path(wal), this.walArchiveDir);
    }

    public void deleteWALDir(ServerName serverName) throws IOException {
        Path splitDir = this.getWALSplitDir(serverName);
        try {
            if (!this.fs.delete(splitDir, false)) {
                LOG.warn("Failed delete {}, contains {}", (Object)splitDir, (Object)this.fs.listFiles(splitDir, true));
            }
        }
        catch (PathIsNotEmptyDirectoryException e) {
            FileStatus[] files = CommonFSUtils.listStatus(this.fs, splitDir);
            LOG.warn("PathIsNotEmptyDirectoryException {}", Arrays.stream(files).map(f -> f.getPath()).collect(Collectors.toList()));
            throw e;
        }
    }

    public boolean isSplitWALFinished(String walPath) throws IOException {
        return !this.fs.exists(new Path(this.rootDir, walPath));
    }

    List<Procedure> createSplitWALProcedures(List<FileStatus> splittingWALs, ServerName crashedServer) {
        return splittingWALs.stream().map(wal -> new SplitWALProcedure(wal.getPath().toString(), crashedServer)).collect(Collectors.toList());
    }

    public ServerName acquireSplitWALWorker(Procedure<?> procedure) throws ProcedureSuspendedException {
        Optional<ServerName> worker = this.splitWorkerAssigner.acquire();
        if (worker.isPresent()) {
            LOG.debug("Acquired split WAL worker={}", (Object)worker.get());
            return worker.get();
        }
        this.splitWorkerAssigner.suspend(procedure);
        throw new ProcedureSuspendedException();
    }

    public void releaseSplitWALWorker(ServerName worker, MasterProcedureScheduler scheduler) {
        LOG.debug("Release split WAL worker={}", (Object)worker);
        this.splitWorkerAssigner.release(worker);
        this.splitWorkerAssigner.wake(scheduler);
    }

    public void addUsedSplitWALWorker(ServerName worker) {
        this.splitWorkerAssigner.addUsedWorker(worker);
    }
}

