/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OldWALsDirSizeChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(OldWALsDirSizeChore.class);
    private final MasterServices master;

    public OldWALsDirSizeChore(MasterServices master) {
        super(master.getServerName() + "-OldWALsDirSizeChore", master, master.getConfiguration().getInt("hbase.master.oldwals.dir.updater.period", 300000));
        this.master = master;
    }

    @Override
    protected void chore() {
        try {
            this.master.getMasterWalManager().updateOldWALsDirSize();
        }
        catch (IOException e) {
            LOG.error("Got exception while trying to update the old WALs Directory size counter: " + e.getMessage(), (Throwable)e);
        }
    }
}

