/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FavoredNodesPlan {
    private final Map<String, List<ServerName>> favoredNodesMap = new ConcurrentHashMap<String, List<ServerName>>();

    void updateFavoredNodesMap(FavoredNodesPlan fnp) {
        this.favoredNodesMap.putAll(fnp.favoredNodesMap);
    }

    public void updateFavoredNodesMap(RegionInfo region, List<ServerName> servers) {
        if (region == null || servers == null || servers.isEmpty()) {
            return;
        }
        this.favoredNodesMap.put(region.getRegionNameAsString(), servers);
    }

    List<ServerName> removeFavoredNodes(RegionInfo region) {
        return this.favoredNodesMap.remove(region.getRegionNameAsString());
    }

    public List<ServerName> getFavoredNodes(RegionInfo region) {
        return this.favoredNodesMap.get(region.getRegionNameAsString());
    }

    public static Position getFavoredServerPosition(List<ServerName> favoredNodes, ServerName server) {
        if (favoredNodes == null || server == null || favoredNodes.size() != 3) {
            return null;
        }
        for (Position p : Position.values()) {
            if (!ServerName.isSameAddress(favoredNodes.get(p.ordinal()), server)) continue;
            return p;
        }
        return null;
    }

    public Map<String, List<ServerName>> getAssignmentMap() {
        return this.favoredNodesMap.entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), v -> new ArrayList((Collection)v.getValue())));
    }

    public int size() {
        return this.favoredNodesMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FavoredNodesPlan)) {
            return false;
        }
        Map<String, List<ServerName>> comparedMap = ((FavoredNodesPlan)o).favoredNodesMap;
        if (comparedMap.size() != this.favoredNodesMap.size()) {
            return false;
        }
        for (Map.Entry<String, List<ServerName>> entry : comparedMap.entrySet()) {
            List<ServerName> serverList = this.favoredNodesMap.get(entry.getKey());
            if (serverList == null && entry.getValue() != null) {
                return false;
            }
            if (serverList == null || serverList.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.favoredNodesMap.hashCode();
    }

    public static enum Position {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

