/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseHbck
implements Hbck {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseHbck.class);
    private boolean aborted;
    private final MasterProtos.HbckService.BlockingInterface hbck;
    private RpcControllerFactory rpcControllerFactory;

    HBaseHbck(ClusterConnection connection, MasterProtos.HbckService.BlockingInterface hbck) throws IOException {
        this.hbck = hbck;
        this.rpcControllerFactory = connection.getRpcControllerFactory();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public TableState setTableStateInMeta(TableState state) throws IOException {
        try {
            MasterProtos.GetTableStateResponse response = this.hbck.setTableStateInMeta(this.rpcControllerFactory.newController(), RequestConverter.buildSetTableStateInMetaRequest(state));
            return TableState.convert(state.getTableName(), response.getTableState());
        }
        catch (ServiceException se) {
            LOG.debug("ServiceException while updating table state in meta. table={}, state={}", (Object)state.getTableName(), (Object)state.getState());
            throw new IOException(se);
        }
    }
}

