/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Public
public class HTableDescriptor
implements TableDescriptor,
Comparable<HTableDescriptor> {
    public static final String SPLIT_POLICY = "SPLIT_POLICY";
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    public static final String OWNER = "OWNER";
    public static final Bytes OWNER_KEY = TableDescriptorBuilder.OWNER_KEY;
    public static final String READONLY = "READONLY";
    public static final String COMPACTION_ENABLED = "COMPACTION_ENABLED";
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    public static final String FLUSH_POLICY = "FLUSH_POLICY";
    public static final String IS_ROOT = "IS_ROOT";
    public static final String IS_META = "IS_META";
    public static final String DURABILITY = "DURABILITY";
    public static final String REGION_REPLICATION = "REGION_REPLICATION";
    public static final String REGION_MEMSTORE_REPLICATION = "REGION_MEMSTORE_REPLICATION";
    public static final String NORMALIZATION_ENABLED = "NORMALIZATION_ENABLED";
    public static final String PRIORITY = "PRIORITY";
    public static final boolean DEFAULT_READONLY = false;
    public static final boolean DEFAULT_COMPACTION_ENABLED = true;
    public static final boolean DEFAULT_NORMALIZATION_ENABLED = false;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x8000000L;
    public static final int DEFAULT_REGION_REPLICATION = 1;
    public static final boolean DEFAULT_REGION_MEMSTORE_REPLICATION = true;
    protected final TableDescriptorBuilder.ModifyableTableDescriptor delegatee;
    public static final String NAMESPACE_FAMILY_INFO = "info";
    public static final byte[] NAMESPACE_FAMILY_INFO_BYTES = TableDescriptorBuilder.NAMESPACE_FAMILY_INFO_BYTES;
    public static final byte[] NAMESPACE_COL_DESC_BYTES = TableDescriptorBuilder.NAMESPACE_COL_DESC_BYTES;
    public static final HTableDescriptor NAMESPACE_TABLEDESC = new HTableDescriptor(TableDescriptorBuilder.NAMESPACE_TABLEDESC);

    public HTableDescriptor(TableName name) {
        this(new TableDescriptorBuilder.ModifyableTableDescriptor(name));
    }

    public HTableDescriptor(HTableDescriptor desc) {
        this(desc, true);
    }

    protected HTableDescriptor(HTableDescriptor desc, boolean deepClone) {
        this(deepClone ? new TableDescriptorBuilder.ModifyableTableDescriptor(desc.getTableName(), desc) : desc.delegatee);
    }

    public HTableDescriptor(TableDescriptor desc) {
        this(new TableDescriptorBuilder.ModifyableTableDescriptor(desc.getTableName(), desc));
    }

    public HTableDescriptor(TableName name, HTableDescriptor desc) {
        this(new TableDescriptorBuilder.ModifyableTableDescriptor(name, desc));
    }

    protected HTableDescriptor(TableDescriptorBuilder.ModifyableTableDescriptor delegatee) {
        this.delegatee = delegatee;
    }

    public boolean isRootRegion() {
        return false;
    }

    @Override
    public boolean isMetaRegion() {
        return this.delegatee.isMetaRegion();
    }

    @Override
    public boolean isMetaTable() {
        return this.delegatee.isMetaTable();
    }

    @Override
    public Map<Bytes, Bytes> getValues() {
        return this.delegatee.getValues();
    }

    public HTableDescriptor setValue(byte[] key, byte[] value) {
        this.getDelegateeForModification().setValue(key, value);
        return this;
    }

    public HTableDescriptor setValue(Bytes key, Bytes value) {
        this.getDelegateeForModification().setValue(key, value);
        return this;
    }

    public HTableDescriptor setValue(String key, String value) {
        this.getDelegateeForModification().setValue(Bytes.toBytes(key), Bytes.toBytes(value));
        return this;
    }

    public void remove(String key) {
        this.getDelegateeForModification().removeValue(Bytes.toBytes(key));
    }

    public void remove(Bytes key) {
        this.getDelegateeForModification().removeValue(key);
    }

    public void remove(byte[] key) {
        this.getDelegateeForModification().removeValue(key);
    }

    @Override
    public boolean isReadOnly() {
        return this.delegatee.isReadOnly();
    }

    public HTableDescriptor setReadOnly(boolean readOnly) {
        this.getDelegateeForModification().setReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isCompactionEnabled() {
        return this.delegatee.isCompactionEnabled();
    }

    public HTableDescriptor setCompactionEnabled(boolean isEnable) {
        this.getDelegateeForModification().setCompactionEnabled(isEnable);
        return this;
    }

    @Override
    public boolean isNormalizationEnabled() {
        return this.delegatee.isNormalizationEnabled();
    }

    public HTableDescriptor setNormalizationEnabled(boolean isEnable) {
        this.getDelegateeForModification().setNormalizationEnabled(isEnable);
        return this;
    }

    public HTableDescriptor setDurability(Durability durability) {
        this.getDelegateeForModification().setDurability(durability);
        return this;
    }

    @Override
    public Durability getDurability() {
        return this.delegatee.getDurability();
    }

    @Override
    public TableName getTableName() {
        return this.delegatee.getTableName();
    }

    public String getNameAsString() {
        return this.delegatee.getTableName().getNameAsString();
    }

    public HTableDescriptor setRegionSplitPolicyClassName(String clazz) {
        this.getDelegateeForModification().setRegionSplitPolicyClassName(clazz);
        return this;
    }

    @Override
    public String getRegionSplitPolicyClassName() {
        return this.delegatee.getRegionSplitPolicyClassName();
    }

    @Override
    public long getMaxFileSize() {
        return this.delegatee.getMaxFileSize();
    }

    public HTableDescriptor setMaxFileSize(long maxFileSize) {
        this.getDelegateeForModification().setMaxFileSize(maxFileSize);
        return this;
    }

    @Override
    public long getMemStoreFlushSize() {
        return this.delegatee.getMemStoreFlushSize();
    }

    public HTableDescriptor setMemStoreFlushSize(long memstoreFlushSize) {
        this.getDelegateeForModification().setMemStoreFlushSize(memstoreFlushSize);
        return this;
    }

    public HTableDescriptor setFlushPolicyClassName(String clazz) {
        this.getDelegateeForModification().setFlushPolicyClassName(clazz);
        return this;
    }

    @Override
    public String getFlushPolicyClassName() {
        return this.delegatee.getFlushPolicyClassName();
    }

    public HTableDescriptor addFamily(HColumnDescriptor family) {
        this.getDelegateeForModification().setColumnFamily(family);
        return this;
    }

    public HTableDescriptor modifyFamily(HColumnDescriptor family) {
        this.getDelegateeForModification().modifyColumnFamily(family);
        return this;
    }

    public boolean hasFamily(byte[] familyName) {
        return this.delegatee.hasColumnFamily(familyName);
    }

    public String toString() {
        return this.delegatee.toString();
    }

    public String toStringCustomizedValues() {
        return this.delegatee.toStringCustomizedValues();
    }

    public String toStringTableAttributes() {
        return this.delegatee.toStringTableAttributes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HTableDescriptor) {
            return this.delegatee.equals(((HTableDescriptor)obj).delegatee);
        }
        return false;
    }

    public int hashCode() {
        return this.delegatee.hashCode();
    }

    @Override
    public int compareTo(HTableDescriptor other) {
        return TableDescriptor.COMPARATOR.compare(this, other);
    }

    @Deprecated
    public Collection<HColumnDescriptor> getFamilies() {
        return Stream.of(this.delegatee.getColumnFamilies()).map(this::toHColumnDescriptor).collect(Collectors.toList());
    }

    @Override
    public int getRegionReplication() {
        return this.delegatee.getRegionReplication();
    }

    public HTableDescriptor setRegionReplication(int regionReplication) {
        this.getDelegateeForModification().setRegionReplication(regionReplication);
        return this;
    }

    @Deprecated
    public boolean hasRegionMemstoreReplication() {
        return this.hasRegionMemStoreReplication();
    }

    @Override
    public boolean hasRegionMemStoreReplication() {
        return this.delegatee.hasRegionMemStoreReplication();
    }

    @Deprecated
    public HTableDescriptor setRegionMemstoreReplication(boolean memstoreReplication) {
        return this.setRegionMemStoreReplication(memstoreReplication);
    }

    public HTableDescriptor setRegionMemStoreReplication(boolean memstoreReplication) {
        this.getDelegateeForModification().setRegionMemStoreReplication(memstoreReplication);
        return this;
    }

    public HTableDescriptor setPriority(int priority) {
        this.getDelegateeForModification().setPriority(priority);
        return this;
    }

    @Override
    public int getPriority() {
        return this.delegatee.getPriority();
    }

    @Deprecated
    public Set<byte[]> getFamiliesKeys() {
        return this.delegatee.getColumnFamilyNames();
    }

    @Override
    public int getColumnFamilyCount() {
        return this.delegatee.getColumnFamilyCount();
    }

    @Deprecated
    public HColumnDescriptor[] getColumnFamilies() {
        return (HColumnDescriptor[])Stream.of(this.delegatee.getColumnFamilies()).map(this::toHColumnDescriptor).toArray(HColumnDescriptor[]::new);
    }

    @Deprecated
    public HColumnDescriptor getFamily(byte[] column) {
        return this.toHColumnDescriptor(this.delegatee.getColumnFamily(column));
    }

    public HColumnDescriptor removeFamily(byte[] column) {
        return this.toHColumnDescriptor(this.getDelegateeForModification().removeColumnFamily(column));
    }

    protected HColumnDescriptor toHColumnDescriptor(ColumnFamilyDescriptor desc) {
        if (desc == null) {
            return null;
        }
        if (desc instanceof ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor) {
            return new HColumnDescriptor((ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor)desc);
        }
        if (desc instanceof HColumnDescriptor) {
            return (HColumnDescriptor)desc;
        }
        return new HColumnDescriptor(new ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor(desc));
    }

    public HTableDescriptor addCoprocessor(String className) throws IOException {
        this.getDelegateeForModification().setCoprocessor(className);
        return this;
    }

    public HTableDescriptor addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
        this.getDelegateeForModification().setCoprocessor(CoprocessorDescriptorBuilder.newBuilder(className).setJarPath(jarFilePath == null ? null : jarFilePath.toString()).setPriority(priority).setProperties(kvs == null ? Collections.emptyMap() : kvs).build());
        return this;
    }

    public HTableDescriptor addCoprocessorWithSpec(String specStr) throws IOException {
        this.getDelegateeForModification().setCoprocessorWithSpec(specStr);
        return this;
    }

    @Override
    public boolean hasCoprocessor(String classNameToMatch) {
        return this.delegatee.hasCoprocessor(classNameToMatch);
    }

    @Override
    public Collection<CoprocessorDescriptor> getCoprocessorDescriptors() {
        return this.delegatee.getCoprocessorDescriptors();
    }

    public void removeCoprocessor(String className) {
        this.getDelegateeForModification().removeCoprocessor(className);
    }

    @Deprecated
    public HTableDescriptor setOwner(User owner) {
        this.getDelegateeForModification().setOwner(owner);
        return this;
    }

    @Deprecated
    public HTableDescriptor setOwnerString(String ownerString) {
        this.getDelegateeForModification().setOwnerString(ownerString);
        return this;
    }

    @Override
    @Deprecated
    public String getOwnerString() {
        return this.delegatee.getOwnerString();
    }

    public byte[] toByteArray() {
        return TableDescriptorBuilder.toByteArray(this.delegatee);
    }

    public static HTableDescriptor parseFrom(byte[] bytes) throws DeserializationException, IOException {
        TableDescriptor desc = TableDescriptorBuilder.parseFrom(bytes);
        if (desc instanceof TableDescriptorBuilder.ModifyableTableDescriptor) {
            return new HTableDescriptor((TableDescriptorBuilder.ModifyableTableDescriptor)desc);
        }
        return new HTableDescriptor(desc);
    }

    public String getConfigurationValue(String key) {
        return this.delegatee.getValue(key);
    }

    public Map<String, String> getConfiguration() {
        return this.delegatee.getValues().entrySet().stream().collect(Collectors.toMap(e -> Bytes.toString(((Bytes)e.getKey()).get(), ((Bytes)e.getKey()).getOffset(), ((Bytes)e.getKey()).getLength()), e -> Bytes.toString(((Bytes)e.getValue()).get(), ((Bytes)e.getValue()).getOffset(), ((Bytes)e.getValue()).getLength())));
    }

    public HTableDescriptor setConfiguration(String key, String value) {
        this.getDelegateeForModification().setValue(key, value);
        return this;
    }

    public void removeConfiguration(String key) {
        this.getDelegateeForModification().removeValue(Bytes.toBytes(key));
    }

    @Override
    public Bytes getValue(Bytes key) {
        return this.delegatee.getValue(key);
    }

    @Override
    public String getValue(String key) {
        return this.delegatee.getValue(key);
    }

    @Override
    public byte[] getValue(byte[] key) {
        return this.delegatee.getValue(key);
    }

    @Override
    public Set<byte[]> getColumnFamilyNames() {
        return this.delegatee.getColumnFamilyNames();
    }

    @Override
    public boolean hasColumnFamily(byte[] name) {
        return this.delegatee.hasColumnFamily(name);
    }

    @Override
    public ColumnFamilyDescriptor getColumnFamily(byte[] name) {
        return this.delegatee.getColumnFamily(name);
    }

    protected TableDescriptorBuilder.ModifyableTableDescriptor getDelegateeForModification() {
        return this.delegatee;
    }
}

