/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.waleventtracker;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerTableAccessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class WALEventTrackerTableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(WALEventTrackerTableCreator.class);
    public static final String WAL_EVENT_TRACKER_ENABLED_KEY = "hbase.regionserver.wal.event.tracker.enabled";
    public static final boolean WAL_EVENT_TRACKER_ENABLED_DEFAULT = false;
    private static final String WAL_EVENT_TRACKER_INFO_FAMILY_STR = "info";
    public static final byte[] WAL_EVENT_TRACKER_INFO_FAMILY = Bytes.toBytes((String)"info");
    private static final long TTL = TimeUnit.DAYS.toSeconds(365L);
    private static final TableDescriptorBuilder TABLE_DESCRIPTOR_BUILDER = TableDescriptorBuilder.newBuilder((TableName)WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME).setRegionReplication(1).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])WAL_EVENT_TRACKER_INFO_FAMILY).setScope(0).setBlockCacheEnabled(false).setMaxVersions(1).setTimeToLive((int)TTL).build());

    private WALEventTrackerTableCreator() {
    }

    public static void createIfNeededAndNotExists(Configuration conf, MasterServices masterServices) throws IOException {
        boolean walEventTrackerEnabled = conf.getBoolean(WAL_EVENT_TRACKER_ENABLED_KEY, false);
        if (!walEventTrackerEnabled) {
            LOG.info("wal event tracker requests logging to table REPLICATION.WALEVENTTRACKER is disabled. Quitting.");
            return;
        }
        if (!masterServices.getTableDescriptors().exists(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME)) {
            LOG.info("REPLICATION.WALEVENTTRACKER table not found. Creating.");
            masterServices.createTable(TABLE_DESCRIPTOR_BUILDER.build(), null, 0L, 0L);
        }
    }
}

