/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.WorkerAssigner;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.procedure.CloneSnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.RestoreSnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotVerifyProcedure;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.EnabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerValidationUtils;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclCleaner;
import org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TablePartiallyOpenException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Unstable
public class SnapshotManager
extends MasterProcedureManager
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManager.class);
    private static final int SNAPSHOT_WAKE_MILLIS_DEFAULT = 500;
    public static final String HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS = "hbase.snapshot.sentinels.cleanup.timeoutMillis";
    public static final long SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLS_DEFAULT = 60000L;
    public static final String HBASE_SNAPSHOT_ENABLED = "hbase.snapshot.enabled";
    private static final String SNAPSHOT_WAKE_MILLIS_KEY = "hbase.snapshot.master.wakeMillis";
    public static final String ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION = "online-snapshot";
    public static final String SNAPSHOT_POOL_THREADS_KEY = "hbase.snapshot.master.threads";
    public static final int SNAPSHOT_POOL_THREADS_DEFAULT = 1;
    public static final String SNAPSHOT_MAX_FILE_SIZE_PRESERVE = "hbase.snapshot.max.filesize.preserve";
    public static final String SNAPSHOT_PROCEDURE_ENABLED = "hbase.snapshot.procedure.enabled";
    public static final boolean SNAPSHOT_PROCEDURE_ENABLED_DEFAULT = true;
    private boolean stopped;
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean isSnapshotSupported = false;
    private final Map<TableName, SnapshotSentinel> snapshotHandlers = new ConcurrentHashMap<TableName, SnapshotSentinel>();
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("SnapshotHandlerChoreCleaner").setDaemon(true).build());
    private ScheduledFuture<?> snapshotHandlerChoreCleanerTask;
    private Map<TableName, Long> restoreTableToProcIdMap = new HashMap<TableName, Long>();
    private final ConcurrentHashMap<SnapshotProtos.SnapshotDescription, Long> snapshotToProcIdMap = new ConcurrentHashMap();
    private WorkerAssigner verifyWorkerAssigner;
    private Path rootDir;
    private ExecutorService executorService;
    private ReentrantReadWriteLock takingSnapshotLock = new ReentrantReadWriteLock(true);

    public SnapshotManager() {
    }

    @InterfaceAudience.Private
    SnapshotManager(MasterServices master, ProcedureCoordinator coordinator, ExecutorService pool, int sentinelCleanInterval) throws IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        Configuration conf = master.getConfiguration();
        this.checkSnapshotSupport(conf, master.getMasterFileSystem());
        this.coordinator = coordinator;
        this.executorService = pool;
        this.resetTempDir();
        this.snapshotHandlerChoreCleanerTask = this.scheduleThreadPool.scheduleAtFixedRate(this::cleanupSentinels, sentinelCleanInterval, sentinelCleanInterval, TimeUnit.SECONDS);
    }

    public List<SnapshotProtos.SnapshotDescription> getCompletedSnapshots() throws IOException {
        return this.getCompletedSnapshots(SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnapshotProtos.SnapshotDescription> getCompletedSnapshots(Path snapshotDir, boolean withCpCall) throws IOException {
        ArrayList<SnapshotProtos.SnapshotDescription> snapshotDescs = new ArrayList<SnapshotProtos.SnapshotDescription>();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        if (snapshotDir == null) {
            snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir);
        }
        if (!fs.exists(snapshotDir)) {
            return snapshotDescs;
        }
        FileStatus[] snapshots = fs.listStatus(snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs));
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        withCpCall = withCpCall && cpHost != null;
        for (FileStatus snapshot : snapshots) {
            Path info = new Path(snapshot.getPath(), ".snapshotinfo");
            if (!fs.exists(info)) {
                LOG.error("Snapshot information for " + snapshot.getPath() + " doesn't exist");
                continue;
            }
            try (FSDataInputStream in = null;){
                SnapshotDescription descPOJO;
                in = fs.open(info);
                SnapshotProtos.SnapshotDescription desc = SnapshotProtos.SnapshotDescription.parseFrom((InputStream)in);
                SnapshotDescription snapshotDescription = descPOJO = withCpCall ? ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)desc) : null;
                if (withCpCall) {
                    try {
                        cpHost.preListSnapshot(descPOJO);
                    }
                    catch (AccessDeniedException e) {
                        LOG.warn("Current user does not have access to " + desc.getName() + " snapshot. Either you should be owner of this snapshot or admin user.");
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                }
                snapshotDescs.add(desc);
                if (!withCpCall) continue;
                cpHost.postListSnapshot(descPOJO);
            }
        }
        return snapshotDescs;
    }

    private void resetTempDir() throws IOException {
        Set workingProcedureCoordinatedSnapshotNames = this.snapshotToProcIdMap.keySet().stream().map(s -> s.getName()).collect(Collectors.toSet());
        Path tmpdir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.rootDir, this.master.getConfiguration());
        FileSystem tmpFs = tmpdir.getFileSystem(this.master.getConfiguration());
        FileStatus[] workingSnapshotDirs = CommonFSUtils.listStatus((FileSystem)tmpFs, (Path)tmpdir);
        if (workingSnapshotDirs == null) {
            return;
        }
        for (FileStatus workingSnapshotDir : workingSnapshotDirs) {
            String workingSnapshotName = workingSnapshotDir.getPath().getName();
            if (!workingProcedureCoordinatedSnapshotNames.contains(workingSnapshotName)) {
                try {
                    if (tmpFs.delete(workingSnapshotDir.getPath(), true)) {
                        LOG.info("delete unfinished zk-coordinated snapshot working directory {}", (Object)workingSnapshotDir.getPath());
                        continue;
                    }
                    LOG.warn("Couldn't delete unfinished zk-coordinated snapshot working directory {}", (Object)workingSnapshotDir.getPath());
                }
                catch (IOException e) {
                    LOG.warn("Couldn't delete unfinished zk-coordinated snapshot working directory {}", (Object)workingSnapshotDir.getPath(), (Object)e);
                }
                continue;
            }
            LOG.debug("find working directory of unfinished procedure {}", (Object)workingSnapshotName);
        }
    }

    public void deleteSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        if (!this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotDoesNotExistException(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        String snapshotName = snapshot.getName();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, this.rootDir);
        snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot);
            cpHost.preDeleteSnapshot(snapshotPOJO);
        }
        LOG.debug("Deleting snapshot: " + snapshotName);
        if (!fs.delete(snapshotDir, true)) {
            throw new HBaseSnapshotException("Failed to delete snapshot directory: " + snapshotDir);
        }
        if (cpHost != null) {
            cpHost.postDeleteSnapshot(snapshotPOJO);
        }
    }

    public boolean isSnapshotDone(SnapshotProtos.SnapshotDescription expected) throws IOException {
        if (expected == null) {
            throw new UnknownSnapshotException("No snapshot name passed in request, can't figure out which snapshot you want to check.");
        }
        Long procId = this.snapshotToProcIdMap.get(expected);
        if (procId != null) {
            if (this.master.getMasterProcedureExecutor().isRunning()) {
                return this.master.getMasterProcedureExecutor().isFinished(procId.longValue());
            }
            return false;
        }
        String ssString = ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)expected);
        SnapshotSentinel handler = this.removeSentinelIfFinished(this.snapshotHandlers, expected);
        this.cleanupSentinels();
        if (handler == null) {
            if (!this.isSnapshotCompleted(expected)) {
                throw new UnknownSnapshotException("Snapshot " + ssString + " is not currently running or one of the known completed snapshots.");
            }
            return true;
        }
        try {
            handler.rethrowExceptionIfFailed();
        }
        catch (ForeignException e) {
            Procedure p = this.coordinator.getProcedure(expected.getName());
            String status = p != null ? p.getStatus() : expected.getName() + " not found in proclist " + this.coordinator.getProcedureNames();
            throw new HBaseSnapshotException("Snapshot " + ssString + " had an error.  " + status, (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)expected));
        }
        if (handler.isFinished()) {
            LOG.debug("Snapshot '" + ssString + "' has completed, notifying client.");
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshoting '" + ssString + "' is still in progress!");
        }
        return false;
    }

    synchronized boolean isTakingSnapshot(SnapshotProtos.SnapshotDescription snapshot, boolean checkTable) {
        TableName snapshotTable;
        if (checkTable && this.isTakingSnapshot(snapshotTable = TableName.valueOf((String)snapshot.getTable()))) {
            return true;
        }
        for (Map.Entry<TableName, SnapshotSentinel> entry : this.snapshotHandlers.entrySet()) {
            SnapshotSentinel sentinel = entry.getValue();
            if (!snapshot.getName().equals(sentinel.getSnapshot().getName()) || sentinel.isFinished()) continue;
            return true;
        }
        for (Map.Entry<SnapshotProtos.SnapshotDescription, Long> entry : this.snapshotToProcIdMap.entrySet()) {
            if (!snapshot.getName().equals(entry.getKey().getName()) || this.master.getMasterProcedureExecutor().isFinished(entry.getValue().longValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isTakingSnapshot(TableName tableName) {
        return this.isTakingSnapshot(tableName, false);
    }

    public boolean isTableTakingAnySnapshot(TableName tableName) {
        return this.isTakingSnapshot(tableName, true);
    }

    private synchronized boolean isTakingSnapshot(TableName tableName, boolean checkProcedure) {
        SnapshotSentinel handler = this.snapshotHandlers.get(tableName);
        if (handler != null && !handler.isFinished()) {
            return true;
        }
        if (checkProcedure) {
            for (Map.Entry<SnapshotProtos.SnapshotDescription, Long> entry : this.snapshotToProcIdMap.entrySet()) {
                if (!TableName.valueOf((String)entry.getKey().getTable()).equals((Object)tableName) || this.master.getMasterProcedureExecutor().isFinished(entry.getValue().longValue())) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void prepareWorkingDirectory(SnapshotProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
        try {
            FileSystem workingDirFS = workingDir.getFileSystem(this.master.getConfiguration());
            workingDirFS.delete(workingDir, true);
            if (!workingDirFS.mkdirs(workingDir)) {
                throw new SnapshotCreationException("Couldn't create working directory (" + workingDir + ") for snapshot", ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
            }
            SnapshotManager.updateWorkingDirAclsIfRequired(workingDir, workingDirFS);
        }
        catch (HBaseSnapshotException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Exception while checking to see if snapshot could be started.", (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
    }

    private static void updateWorkingDirAclsIfRequired(Path workingDir, FileSystem workingDirFS) throws IOException {
        AclStatus snapshotWorkingParentDirStatus;
        if (workingDir.getParent() == null || workingDir.getParent().getParent() == null) {
            return;
        }
        try {
            snapshotWorkingParentDirStatus = workingDirFS.getAclStatus(workingDir.getParent().getParent());
        }
        catch (IOException | UnsupportedOperationException e) {
            LOG.warn("Unable to retrieve ACL status for path: {}, current working dir path: {}", new Object[]{workingDir.getParent().getParent(), workingDir, e});
            return;
        }
        List snapshotWorkingParentDirAclStatusEntries = snapshotWorkingParentDirStatus.getEntries();
        if (snapshotWorkingParentDirAclStatusEntries != null && snapshotWorkingParentDirAclStatusEntries.size() > 0) {
            workingDirFS.modifyAclEntries(workingDir, snapshotWorkingParentDirAclStatusEntries);
        }
    }

    private synchronized void snapshotDisabledTable(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareWorkingDirectory(snapshot);
        snapshot = snapshot.toBuilder().setType(SnapshotProtos.SnapshotDescription.Type.DISABLED).build();
        DisabledTableSnapshotHandler handler = new DisabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotEnabledTable(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareWorkingDirectory(snapshot);
        EnabledTableSnapshotHandler handler = new EnabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotTable(SnapshotProtos.SnapshotDescription snapshot, TakeSnapshotHandler handler) throws IOException {
        try {
            handler.prepare();
            this.executorService.submit(handler);
            this.snapshotHandlers.put(TableName.valueOf((String)snapshot.getTable()), handler);
        }
        catch (Exception e) {
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
            FileSystem workingDirFs = workingDir.getFileSystem(this.master.getConfiguration());
            try {
                if (!workingDirFs.delete(workingDir, true)) {
                    LOG.error("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
                }
            }
            catch (IOException e1) {
                LOG.error("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
            }
            throw new SnapshotCreationException("Could not build snapshot handler", (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
    }

    public ReadWriteLock getTakingSnapshotLock() {
        return this.takingSnapshotLock;
    }

    public synchronized boolean isTakingAnySnapshot() {
        return this.takingSnapshotLock.getReadHoldCount() > 0 || this.snapshotHandlers.size() > 0 || this.snapshotToProcIdMap.size() > 0;
    }

    public void takeSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.takingSnapshotLock.readLock().lock();
        try {
            this.takeSnapshotInternal(snapshot);
        }
        finally {
            this.takingSnapshotLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long takeSnapshot(SnapshotProtos.SnapshotDescription snapshot, long nonceGroup, long nonce) throws IOException {
        this.takingSnapshotLock.readLock().lock();
        try {
            long l = this.submitSnapshotProcedure(snapshot, nonceGroup, nonce);
            return l;
        }
        finally {
            this.takingSnapshotLock.readLock().unlock();
        }
    }

    private synchronized long submitSnapshotProcedure(final SnapshotProtos.SnapshotDescription snapshot, long nonceGroup, long nonce) throws IOException {
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this.master, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                TableDescriptor tableDescriptor = SnapshotManager.this.master.getTableDescriptors().get(TableName.valueOf((String)snapshot.getTable()));
                MasterCoprocessorHost cpHost = this.getMaster().getMasterCoprocessorHost();
                User user = RpcServer.getRequestUser().orElse(null);
                SnapshotDescription snapshotDesc = ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot);
                if (cpHost != null) {
                    cpHost.preSnapshot(snapshotDesc, tableDescriptor, user);
                }
                SnapshotManager.this.sanityCheckBeforeSnapshot(snapshot, false);
                long procId = this.submitProcedure((org.apache.hadoop.hbase.procedure2.Procedure<MasterProcedureEnv>)new SnapshotProcedure((MasterProcedureEnv)this.getMaster().getMasterProcedureExecutor().getEnvironment(), snapshot));
                this.getMaster().getSnapshotManager().registerSnapshotProcedure(snapshot, procId);
                if (cpHost != null) {
                    cpHost.postSnapshot(snapshotDesc, tableDescriptor, user);
                }
            }

            @Override
            protected String getDescription() {
                return "SnapshotProcedure";
            }
        });
    }

    private void takeSnapshotInternal(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        TableDescriptor desc = this.sanityCheckBeforeSnapshot(snapshot, true);
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot);
            cpHost.preSnapshot(snapshotPOJO, desc, RpcServer.getRequestUser().orElse(null));
        }
        TableName snapshotTable = TableName.valueOf((String)snapshot.getTable());
        if (this.master.getTableStateManager().isTableState(snapshotTable, TableState.State.ENABLED)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Table enabled, starting distributed snapshots for {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
            }
            this.snapshotEnabledTable(snapshot);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started snapshot: {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
            }
        } else if (this.master.getTableStateManager().isTableState(snapshotTable, TableState.State.DISABLED)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Table is disabled, running snapshot entirely on master for {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
            }
            this.snapshotDisabledTable(snapshot);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started snapshot: {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot));
            }
        } else {
            LOG.error("Can't snapshot table '" + snapshot.getTable() + "', isn't open or closed, we don't know what to do!");
            TablePartiallyOpenException tpoe = new TablePartiallyOpenException(snapshot.getTable() + " isn't fully open.");
            throw new SnapshotCreationException("Table is not entirely open or closed", (Throwable)tpoe, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        if (cpHost != null) {
            cpHost.postSnapshot(snapshotPOJO, desc, RpcServer.getRequestUser().orElse(null));
        }
    }

    private synchronized TableDescriptor sanityCheckBeforeSnapshot(SnapshotProtos.SnapshotDescription snapshot, boolean checkTable) throws IOException {
        if (this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotExistsException("Snapshot '" + snapshot.getName() + "' already stored on the filesystem.", ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        LOG.debug("No existing snapshot, attempting snapshot...");
        this.cleanupSentinels();
        TableName snapshotTable = TableName.valueOf((String)snapshot.getTable());
        if (this.isTakingSnapshot(snapshot, checkTable)) {
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot) + " because we are already running another snapshot on the same table or with the same name");
        }
        if (this.isRestoringTable(snapshotTable)) {
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot) + " because we are already have a restore in progress on the same snapshot.");
        }
        TableDescriptor desc = null;
        try {
            desc = this.master.getTableDescriptors().get(TableName.valueOf((String)snapshot.getTable()));
        }
        catch (FileNotFoundException e) {
            String msg = "Table:" + snapshot.getTable() + " info doesn't exist!";
            LOG.error(msg);
            throw new SnapshotCreationException(msg, (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Error while geting table description for table " + snapshot.getTable(), (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        if (desc == null) {
            throw new SnapshotCreationException("Table '" + snapshot.getTable() + "' doesn't exist, can't take snapshot.", ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot));
        }
        return desc;
    }

    public synchronized void setSnapshotHandlerForTesting(TableName tableName, SnapshotSentinel handler) {
        if (handler != null) {
            this.snapshotHandlers.put(tableName, handler);
        } else {
            this.snapshotHandlers.remove(tableName);
        }
    }

    ProcedureCoordinator getCoordinator() {
        return this.coordinator;
    }

    private boolean isSnapshotCompleted(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
            FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
            return fs.exists(snapshotDir);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownSnapshotException("Unexpected exception thrown", (Exception)iae);
        }
    }

    private long cloneSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, TableName tableName, SnapshotProtos.SnapshotDescription snapshot, TableDescriptor snapshotTableDesc, NonceKey nonceKey, boolean restoreAcl, String customSFT) throws IOException {
        long procId;
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        TableDescriptor htd = TableDescriptorBuilder.copy((TableName)tableName, (TableDescriptor)snapshotTableDesc);
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot);
            cpHost.preCloneSnapshot(snapshotPOJO, htd);
        }
        try {
            procId = this.cloneSnapshot(snapshot, htd, nonceKey, restoreAcl, customSFT);
        }
        catch (IOException e) {
            LOG.error("Exception occurred while cloning the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString(), (Throwable)e);
            throw e;
        }
        LOG.info("Clone snapshot=" + snapshot.getName() + " as table=" + tableName);
        if (cpHost != null) {
            cpHost.postCloneSnapshot(snapshotPOJO, htd);
        }
        return procId;
    }

    synchronized long cloneSnapshot(SnapshotProtos.SnapshotDescription snapshot, TableDescriptor tableDescriptor, NonceKey nonceKey, boolean restoreAcl, String customSFT) throws HBaseSnapshotException {
        TableName tableName = tableDescriptor.getTableName();
        if (this.isTableTakingAnySnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            long procId = this.master.getMasterProcedureExecutor().submitProcedure((org.apache.hadoop.hbase.procedure2.Procedure)new CloneSnapshotProcedure((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), tableDescriptor, snapshot, restoreAcl, customSFT), nonceKey);
            this.restoreTableToProcIdMap.put(tableName, procId);
            return procId;
        }
        catch (Exception e) {
            String msg = "Couldn't clone the snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot) + " on table=" + tableName;
            LOG.error(msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, (Throwable)e);
        }
    }

    public long restoreOrCloneSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, NonceKey nonceKey, boolean restoreAcl, String customSFT) throws IOException {
        Path snapshotDir;
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        if (!fs.exists(snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(reqSnapshot, this.rootDir))) {
            LOG.error("A Snapshot named '" + reqSnapshot.getName() + "' does not exist.");
            throw new SnapshotDoesNotExistException(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)reqSnapshot));
        }
        SnapshotProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.master.getConfiguration(), fs, snapshotDir, snapshot);
        TableDescriptor snapshotTableDesc = manifest.getTableDescriptor();
        TableName tableName = TableName.valueOf((String)reqSnapshot.getTable());
        TableDescriptorChecker.sanityCheck(this.master.getConfiguration(), snapshotTableDesc);
        this.cleanupSentinels();
        SnapshotReferenceUtil.verifySnapshot(this.master.getConfiguration(), fs, manifest);
        long procId = this.master.getTableDescriptors().exists(tableName) ? this.restoreSnapshot(reqSnapshot, tableName, snapshot, snapshotTableDesc, nonceKey, restoreAcl) : this.cloneSnapshot(reqSnapshot, tableName, snapshot, snapshotTableDesc, nonceKey, restoreAcl, customSFT);
        return procId;
    }

    private long restoreSnapshot(SnapshotProtos.SnapshotDescription reqSnapshot, TableName tableName, SnapshotProtos.SnapshotDescription snapshot, TableDescriptor snapshotTableDesc, NonceKey nonceKey, boolean restoreAcl) throws IOException {
        long procId;
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        StoreFileTrackerValidationUtils.validatePreRestoreSnapshot(this.master.getTableDescriptors().get(tableName), snapshotTableDesc, this.master.getConfiguration());
        if (this.master.getTableStateManager().isTableState(TableName.valueOf((String)snapshot.getTable()), TableState.State.ENABLED)) {
            throw new UnsupportedOperationException("Table '" + TableName.valueOf((String)snapshot.getTable()) + "' must be disabled in order to perform a restore operation.");
        }
        SnapshotDescription snapshotPOJO = null;
        if (cpHost != null) {
            snapshotPOJO = ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshot);
            cpHost.preRestoreSnapshot(snapshotPOJO, snapshotTableDesc);
        }
        try {
            procId = this.restoreSnapshot(snapshot, snapshotTableDesc, nonceKey, restoreAcl);
        }
        catch (IOException e) {
            LOG.error("Exception occurred while restoring the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString(), (Throwable)e);
            throw e;
        }
        LOG.info("Restore snapshot=" + snapshot.getName() + " as table=" + tableName);
        if (cpHost != null) {
            cpHost.postRestoreSnapshot(snapshotPOJO, snapshotTableDesc);
        }
        return procId;
    }

    private synchronized long restoreSnapshot(SnapshotProtos.SnapshotDescription snapshot, TableDescriptor tableDescriptor, NonceKey nonceKey, boolean restoreAcl) throws HBaseSnapshotException {
        TableName tableName = tableDescriptor.getTableName();
        if (this.isTableTakingAnySnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            TableDescriptor oldDescriptor = this.master.getTableDescriptors().get(tableName);
            long procId = this.master.getMasterProcedureExecutor().submitProcedure((org.apache.hadoop.hbase.procedure2.Procedure)new RestoreSnapshotProcedure((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), oldDescriptor, tableDescriptor, snapshot, restoreAcl), nonceKey);
            this.restoreTableToProcIdMap.put(tableName, procId);
            return procId;
        }
        catch (Exception e) {
            String msg = "Couldn't restore the snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot) + " on table=" + tableName;
            LOG.error(msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, (Throwable)e);
        }
    }

    private synchronized boolean isRestoringTable(TableName tableName) {
        Long procId = this.restoreTableToProcIdMap.get(tableName);
        if (procId == null) {
            return false;
        }
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        if (procExec.isRunning() && !procExec.isFinished(procId.longValue())) {
            return true;
        }
        this.restoreTableToProcIdMap.remove(tableName);
        return false;
    }

    private synchronized SnapshotSentinel removeSentinelIfFinished(Map<TableName, SnapshotSentinel> sentinels, SnapshotProtos.SnapshotDescription snapshot) {
        if (!snapshot.hasTable()) {
            return null;
        }
        TableName snapshotTable = TableName.valueOf((String)snapshot.getTable());
        SnapshotSentinel h = sentinels.get(snapshotTable);
        if (h == null) {
            return null;
        }
        if (!h.getSnapshot().getName().equals(snapshot.getName())) {
            return null;
        }
        if (h.isFinished()) {
            sentinels.remove(snapshotTable);
        }
        return h;
    }

    private void cleanupSentinels() {
        this.cleanupSentinels(this.snapshotHandlers);
        this.cleanupCompletedRestoreInMap();
        this.cleanupCompletedSnapshotInMap();
    }

    private synchronized void cleanupSentinels(Map<TableName, SnapshotSentinel> sentinels) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        long sentinelsCleanupTimeoutMillis = this.master.getConfiguration().getLong(HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS, 60000L);
        Iterator<Map.Entry<TableName, SnapshotSentinel>> it = sentinels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TableName, SnapshotSentinel> entry = it.next();
            SnapshotSentinel sentinel = entry.getValue();
            if (!sentinel.isFinished() || currentTime - sentinel.getCompletionTimestamp() <= sentinelsCleanupTimeoutMillis) continue;
            it.remove();
        }
    }

    private synchronized void cleanupCompletedRestoreInMap() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        Iterator<Map.Entry<TableName, Long>> it = this.restoreTableToProcIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TableName, Long> entry = it.next();
            Long procId = entry.getValue();
            if (!procExec.isRunning() || !procExec.isFinished(procId.longValue())) continue;
            it.remove();
        }
    }

    private synchronized void cleanupCompletedSnapshotInMap() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
        Iterator<Map.Entry<SnapshotProtos.SnapshotDescription, Long>> it = this.snapshotToProcIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SnapshotProtos.SnapshotDescription, Long> entry = it.next();
            Long procId = entry.getValue();
            if (!procExec.isRunning() || !procExec.isFinished(procId.longValue())) continue;
            it.remove();
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        for (SnapshotSentinel snapshotHandler : this.snapshotHandlers.values()) {
            snapshotHandler.cancel(why);
        }
        if (this.snapshotHandlerChoreCleanerTask != null) {
            this.snapshotHandlerChoreCleanerTask.cancel(true);
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.close();
            }
        }
        catch (IOException e) {
            LOG.error("stop ProcedureCoordinator error", (Throwable)e);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void checkSnapshotSupport() throws UnsupportedOperationException {
        if (!this.isSnapshotSupported) {
            throw new UnsupportedOperationException("To use snapshots, You must add to the hbase-site.xml of the HBase Master: 'hbase.snapshot.enabled' property with value 'true'.");
        }
    }

    private void checkSnapshotSupport(Configuration conf, MasterFileSystem mfs) throws IOException, UnsupportedOperationException {
        String enabled = conf.get(HBASE_SNAPSHOT_ENABLED);
        boolean snapshotEnabled = conf.getBoolean(HBASE_SNAPSHOT_ENABLED, false);
        boolean userDisabled = enabled != null && enabled.trim().length() > 0 && !snapshotEnabled;
        HashSet<String> hfileCleaners = new HashSet<String>();
        String[] cleaners = conf.getStrings("hbase.master.hfilecleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(hfileCleaners, cleaners);
        }
        HashSet logCleaners = new HashSet();
        cleaners = conf.getStrings("hbase.master.logcleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(logCleaners, cleaners);
        }
        Path oldSnapshotDir = new Path(mfs.getRootDir(), ".snapshot");
        FileSystem fs = mfs.getFileSystem();
        List<SnapshotProtos.SnapshotDescription> ss = this.getCompletedSnapshots(new Path(this.rootDir, oldSnapshotDir), false);
        if (ss != null && !ss.isEmpty()) {
            LOG.error("Snapshots from an earlier release were found under: " + oldSnapshotDir);
            LOG.error("Please rename the directory as .hbase-snapshot");
        }
        if (snapshotEnabled) {
            hfileCleaners.add(SnapshotHFileCleaner.class.getName());
            hfileCleaners.add(HFileLinkCleaner.class.getName());
            if (SnapshotScannerHDFSAclHelper.isAclSyncToHdfsEnabled(conf)) {
                hfileCleaners.add(SnapshotScannerHDFSAclCleaner.class.getName());
            }
            conf.setStrings("hbase.master.hfilecleaner.plugins", hfileCleaners.toArray(new String[hfileCleaners.size()]));
            conf.setStrings("hbase.master.logcleaner.plugins", logCleaners.toArray(new String[logCleaners.size()]));
        } else {
            hfileCleaners.add(HFileLinkCleaner.class.getName());
            conf.setStrings("hbase.master.hfilecleaner.plugins", hfileCleaners.toArray(new String[hfileCleaners.size()]));
            snapshotEnabled = hfileCleaners.contains(SnapshotHFileCleaner.class.getName());
            if (snapshotEnabled) {
                LOG.warn("Snapshot log and hfile cleaners are present in the configuration, but the 'hbase.snapshot.enabled' property " + (userDisabled ? "is set to 'false'." : "is not set."));
            }
        }
        boolean bl = this.isSnapshotSupported = snapshotEnabled && !userDisabled;
        if (!snapshotEnabled) {
            FileStatus[] snapshots;
            LOG.info("Snapshot feature is not enabled, missing log and hfile cleaners.");
            Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(mfs.getRootDir());
            if (fs.exists(snapshotDir) && (snapshots = CommonFSUtils.listStatus((FileSystem)fs, (Path)snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) != null) {
                LOG.error("Snapshots are present, but cleaners are not enabled.");
                this.checkSnapshotSupport();
            }
        }
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        this.checkSnapshotSupport(master.getConfiguration(), master.getMasterFileSystem());
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(SNAPSHOT_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = Math.max(conf.getLong("hbase.snapshot.master.timeoutMillis", 300000L), conf.getLong("hbase.snapshot.master.timeout.millis", 300000L));
        int opThreads = conf.getInt(SNAPSHOT_POOL_THREADS_KEY, 1);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, opThreads);
        ZKProcedureCoordinator comms = new ZKProcedureCoordinator(master.getZooKeeper(), ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION, name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
        this.executorService = master.getExecutorService();
        this.verifyWorkerAssigner = new WorkerAssigner(master, conf.getInt("hbase.snapshot.verify.task.max", 3), new ProcedureEvent((Object)"snapshot-verify-worker-assigning"));
        this.restoreUnfinishedSnapshotProcedure();
        this.restoreWorkers();
        this.resetTempDir();
        this.snapshotHandlerChoreCleanerTask = this.scheduleThreadPool.scheduleAtFixedRate(this::cleanupSentinels, 10L, 10L, TimeUnit.SECONDS);
    }

    private void restoreUnfinishedSnapshotProcedure() {
        this.master.getMasterProcedureExecutor().getActiveProceduresNoCopy().stream().filter(p -> p instanceof SnapshotProcedure).filter(p -> !p.isFinished()).map(p -> (SnapshotProcedure)p).forEach(p -> {
            this.registerSnapshotProcedure(p.getSnapshot(), p.getProcId());
            LOG.info("restore unfinished snapshot procedure {}", p);
        });
    }

    @Override
    public String getProcedureSignature() {
        return ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        this.takeSnapshot(this.toSnapshotDescription(desc));
    }

    @Override
    public void checkPermissions(HBaseProtos.ProcedureDescription desc, AccessChecker accessChecker, User user) throws IOException {
    }

    @Override
    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        return this.isSnapshotDone(this.toSnapshotDescription(desc));
    }

    private SnapshotProtos.SnapshotDescription toSnapshotDescription(HBaseProtos.ProcedureDescription desc) throws IOException {
        SnapshotProtos.SnapshotDescription.Builder builder = SnapshotProtos.SnapshotDescription.newBuilder();
        if (!desc.hasInstance()) {
            throw new IOException("Snapshot name is not defined: " + desc.toString());
        }
        String snapshotName = desc.getInstance();
        List props = desc.getConfigurationList();
        String table = null;
        for (HBaseProtos.NameStringPair prop : props) {
            if (!"table".equalsIgnoreCase(prop.getName())) continue;
            table = prop.getValue();
        }
        if (table == null) {
            throw new IOException("Snapshot table is not defined: " + desc.toString());
        }
        TableName tableName = TableName.valueOf(table);
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(SnapshotProtos.SnapshotDescription.Type.FLUSH);
        return builder.build();
    }

    public void registerSnapshotProcedure(SnapshotProtos.SnapshotDescription snapshot, long procId) {
        this.snapshotToProcIdMap.put(snapshot, procId);
        LOG.debug("register snapshot={}, snapshot procedure id = {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot), (Object)procId);
    }

    public void unregisterSnapshotProcedure(SnapshotProtos.SnapshotDescription snapshot, long procId) {
        this.snapshotToProcIdMap.remove(snapshot, procId);
        LOG.debug("unregister snapshot={}, snapshot procedure id = {}", (Object)ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)snapshot), (Object)procId);
    }

    public boolean snapshotProcedureEnabled() {
        return this.master.getConfiguration().getBoolean(SNAPSHOT_PROCEDURE_ENABLED, true);
    }

    public ServerName acquireSnapshotVerifyWorker(SnapshotVerifyProcedure procedure) throws ProcedureSuspendedException {
        Optional<ServerName> worker = this.verifyWorkerAssigner.acquire();
        if (worker.isPresent()) {
            LOG.debug("{} Acquired verify snapshot worker={}", (Object)procedure, (Object)worker.get());
            return worker.get();
        }
        this.verifyWorkerAssigner.suspend(procedure);
        throw new ProcedureSuspendedException();
    }

    public void releaseSnapshotVerifyWorker(SnapshotVerifyProcedure procedure, ServerName worker, MasterProcedureScheduler scheduler) {
        LOG.debug("{} Release verify snapshot worker={}", (Object)procedure, (Object)worker);
        this.verifyWorkerAssigner.release(worker);
        this.verifyWorkerAssigner.wake(scheduler);
    }

    private void restoreWorkers() {
        this.master.getMasterProcedureExecutor().getActiveProceduresNoCopy().stream().filter(p -> p instanceof SnapshotVerifyProcedure).map(p -> (SnapshotVerifyProcedure)p).filter(p -> !p.isFinished()).filter(p -> p.getServerName() != null).forEach(p -> {
            this.verifyWorkerAssigner.addUsedWorker(p.getServerName());
            LOG.debug("{} restores used worker {}", p, (Object)p.getServerName());
        });
    }

    public Integer getAvailableWorker(ServerName serverName) {
        return this.verifyWorkerAssigner.getAvailableWorker(serverName);
    }
}

