/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ClusterMarkingEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.SystemTableWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.HBaseInterClusterReplicationEndpoint;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationThrottler;
import org.apache.hadoop.hbase.replication.regionserver.SerialReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationSource
implements ReplicationSourceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSource.class);
    private Map<String, PriorityBlockingQueue<Path>> queues = new HashMap<String, PriorityBlockingQueue<Path>>();
    protected int queueSizePerGroup;
    protected ReplicationQueueStorage queueStorage;
    protected ReplicationPeer replicationPeer;
    protected Configuration conf;
    protected ReplicationQueueInfo replicationQueueInfo;
    private String peerId;
    protected ReplicationSourceManager manager;
    protected Server server;
    private long sleepForRetries;
    protected FileSystem fs;
    private UUID clusterId;
    private AtomicLong totalReplicatedEdits = new AtomicLong(0L);
    protected String queueId;
    private int maxRetriesMultiplier;
    private volatile boolean sourceRunning = false;
    private MetricsSource metrics;
    private int logQueueWarnThreshold;
    private volatile ReplicationEndpoint replicationEndpoint;
    protected volatile WALEntryFilter walEntryFilter;
    private ReplicationThrottler throttler;
    private long defaultBandwidth;
    private long currentBandwidth;
    private WALFileLengthProvider walFileLengthProvider;
    protected final ConcurrentHashMap<String, ReplicationSourceShipper> workerThreads = new ConcurrentHashMap();
    private AtomicLong totalBufferUsed;
    public static final String WAIT_ON_ENDPOINT_SECONDS = "hbase.replication.wait.on.endpoint.seconds";
    public static final int DEFAULT_WAIT_ON_ENDPOINT_SECONDS = 30;
    private int waitOnEndpointSeconds = -1;
    private Thread initThread;

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueueStorage queueStorage, ReplicationPeer replicationPeer, Server server, String queueId, UUID clusterId, WALFileLengthProvider walFileLengthProvider, MetricsSource metrics) throws IOException {
        this.server = server;
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.waitOnEndpointSeconds = this.conf.getInt(WAIT_ON_ENDPOINT_SECONDS, 30);
        this.decorateConf();
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.queueSizePerGroup = this.conf.getInt("hbase.regionserver.maxlogs", 32);
        this.queueStorage = queueStorage;
        this.replicationPeer = replicationPeer;
        this.manager = manager;
        this.fs = fs;
        this.metrics = metrics;
        this.clusterId = clusterId;
        this.queueId = queueId;
        this.replicationQueueInfo = new ReplicationQueueInfo(queueId);
        this.peerId = this.replicationQueueInfo.getPeerId();
        this.logQueueWarnThreshold = this.conf.getInt("replication.source.log.queue.warn", 2);
        this.defaultBandwidth = this.conf.getLong("replication.source.per.peer.node.bandwidth", 0L);
        this.currentBandwidth = this.getCurrentBandwidth();
        this.throttler = new ReplicationThrottler((double)this.currentBandwidth / 10.0);
        this.totalBufferUsed = manager.getTotalBufferUsed();
        this.walFileLengthProvider = walFileLengthProvider;
        LOG.info("queueId={}, ReplicationSource: {}, currentBandwidth={}", new Object[]{queueId, replicationPeer.getId(), this.currentBandwidth});
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((CharSequence)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    @Override
    public void enqueueLog(Path log) {
        String logPrefix = AbstractFSWALProvider.getWALPrefixFromWALName(log.getName());
        PriorityBlockingQueue<Path> queue = this.queues.get(logPrefix);
        if (queue == null) {
            queue = new PriorityBlockingQueue<Path>(this.queueSizePerGroup, new LogsComparator());
            this.queues.put(logPrefix, queue);
            if (this.isSourceActive() && this.walEntryFilter != null) {
                this.tryStartNewShipper(logPrefix, queue);
            }
        }
        queue.put(log);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} Added log file {} to queue of source {}.", new Object[]{this.logPeerId(), logPrefix, this.replicationQueueInfo.getQueueId()});
        }
        this.metrics.incrSizeOfLogQueue();
        int queueSize = queue.size();
        if (queueSize > this.logQueueWarnThreshold) {
            LOG.warn("{} WAL group {} queue size: {} exceeds value of replication.source.log.queue.warn: {}", new Object[]{this.logPeerId(), logPrefix, queueSize, this.logQueueWarnThreshold});
        }
    }

    @Override
    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws ReplicationException {
        String peerId = this.replicationPeer.getId();
        Set namespaces = this.replicationPeer.getNamespaces();
        Map tableCFMap = this.replicationPeer.getTableCFs();
        if (tableCFMap != null) {
            List tableCfs = (List)tableCFMap.get(tableName);
            if (tableCFMap.containsKey(tableName) && (tableCfs == null || tableCfs.contains(Bytes.toString((byte[])family)))) {
                this.queueStorage.addHFileRefs(peerId, pairs);
                this.metrics.incrSizeOfHFileRefsQueue(pairs.size());
            } else {
                LOG.debug("HFiles will not be replicated belonging to the table {} family {} to peer id {}", new Object[]{tableName, Bytes.toString((byte[])family), peerId});
            }
        } else if (namespaces != null) {
            if (namespaces.contains(tableName.getNamespaceAsString())) {
                this.queueStorage.addHFileRefs(peerId, pairs);
                this.metrics.incrSizeOfHFileRefsQueue(pairs.size());
            } else {
                LOG.debug("HFiles will not be replicated belonging to the table {} family {} to peer id {}", new Object[]{tableName, Bytes.toString((byte[])family), peerId});
            }
        } else {
            this.queueStorage.addHFileRefs(peerId, pairs);
            this.metrics.incrSizeOfHFileRefsQueue(pairs.size());
        }
    }

    private ReplicationEndpoint createReplicationEndpoint() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        ReplicationEndpoint newReplicationEndPoint;
        ReplicationEndpoint replicationEndpoint;
        String replicationEndpointImpl;
        RegionServerCoprocessorHost rsServerHost = null;
        if (this.server instanceof HRegionServer) {
            rsServerHost = ((HRegionServer)this.server).getRegionServerCoprocessorHost();
        }
        if ((replicationEndpointImpl = this.replicationPeer.getPeerConfig().getReplicationEndpointImpl()) == null) {
            replicationEndpoint = new HBaseInterClusterReplicationEndpoint();
        } else {
            try {
                replicationEndpoint = Class.forName(replicationEndpointImpl).asSubclass(ReplicationEndpoint.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (rsServerHost != null && (newReplicationEndPoint = rsServerHost.postCreateReplicationEndPoint(replicationEndpoint)) != null) {
            replicationEndpoint = newReplicationEndPoint;
        }
        return replicationEndpoint;
    }

    private void initAndStartReplicationEndpoint(ReplicationEndpoint replicationEndpoint) throws IOException, TimeoutException {
        TableDescriptors tableDescriptors = null;
        if (this.server instanceof HRegionServer) {
            tableDescriptors = ((HRegionServer)this.server).getTableDescriptors();
        }
        replicationEndpoint.init(new ReplicationEndpoint.Context(this.conf, this.replicationPeer.getConfiguration(), this.fs, this.peerId, this.clusterId, this.replicationPeer, this.metrics, tableDescriptors, this.server));
        replicationEndpoint.start();
        replicationEndpoint.awaitRunning(this.waitOnEndpointSeconds, TimeUnit.SECONDS);
    }

    private void initializeWALEntryFilter(UUID peerClusterId) {
        ArrayList filters = Lists.newArrayList((Object[])new WALEntryFilter[]{new SystemTableWALEntryFilter()});
        WALEntryFilter filterFromEndpoint = this.replicationEndpoint.getWALEntryfilter();
        if (filterFromEndpoint != null) {
            filters.add(filterFromEndpoint);
        }
        filters.add(new ClusterMarkingEntryFilter(this.clusterId, peerClusterId, this.replicationEndpoint));
        this.walEntryFilter = new ChainWALEntryFilter(filters);
    }

    private void tryStartNewShipper(String walGroupId, PriorityBlockingQueue<Path> queue) {
        ReplicationSourceShipper worker = this.createNewShipper(walGroupId, queue);
        ReplicationSourceShipper extant = this.workerThreads.putIfAbsent(walGroupId, worker);
        if (extant != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Someone has beat us to start a worker thread for wal group {}", (Object)this.logPeerId(), (Object)walGroupId);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Starting up worker for wal group {}", (Object)this.logPeerId(), (Object)walGroupId);
            }
            ReplicationSourceWALReader walReader = this.createNewWALReader(walGroupId, queue, worker.getStartPosition());
            Threads.setDaemonThreadRunning((Thread)walReader, (String)(Thread.currentThread().getName() + ".replicationSource.wal-reader." + walGroupId + "," + this.queueId), this::uncaughtException);
            worker.setWALReader(walReader);
            worker.startup(this::uncaughtException);
        }
    }

    @Override
    public Map<String, ReplicationStatus> getWalGroupStatus() {
        TreeMap<String, ReplicationStatus> sourceReplicationStatus = new TreeMap<String, ReplicationStatus>();
        for (Map.Entry<String, ReplicationSourceShipper> walGroupShipper : this.workerThreads.entrySet()) {
            String walGroupId = walGroupShipper.getKey();
            ReplicationSourceShipper shipper = walGroupShipper.getValue();
            long ageOfLastShippedOp = this.metrics.getAgeofLastShippedOp(walGroupId);
            int queueSize = this.queues.get(walGroupId).size();
            long replicationDelay = this.metrics.getReplicationDelay();
            Path currentPath = shipper.getCurrentPath();
            long fileSize = -1L;
            if (currentPath != null) {
                try {
                    fileSize = this.getFileSize(currentPath);
                }
                catch (IOException e) {
                    LOG.warn("Ignore the exception as the file size of HLog only affects the web ui", (Throwable)e);
                }
            } else {
                currentPath = new Path("NO_LOGS_IN_QUEUE");
                LOG.warn("{} No replication ongoing, waiting for new log", (Object)this.logPeerId());
            }
            ReplicationStatus.ReplicationStatusBuilder statusBuilder = ReplicationStatus.newBuilder();
            statusBuilder.withPeerId(this.getPeerId()).withQueueSize(queueSize).withWalGroup(walGroupId).withCurrentPath(currentPath).withCurrentPosition(shipper.getCurrentPosition()).withFileSize(fileSize).withAgeOfLastShippedOp(ageOfLastShippedOp).withReplicationDelay(replicationDelay);
            sourceReplicationStatus.put(this.getPeerId() + "=>" + walGroupId, statusBuilder.build());
        }
        return sourceReplicationStatus;
    }

    private long getFileSize(Path currentPath) throws IOException {
        long fileSize;
        try {
            fileSize = this.fs.getContentSummary(currentPath).getLength();
        }
        catch (FileNotFoundException e) {
            currentPath = AbstractFSWALProvider.getArchivedLogPath(currentPath, this.conf);
            fileSize = this.fs.getContentSummary(currentPath).getLength();
        }
        return fileSize;
    }

    protected ReplicationSourceShipper createNewShipper(String walGroupId, PriorityBlockingQueue<Path> queue) {
        return new ReplicationSourceShipper(this.conf, walGroupId, queue, this);
    }

    private ReplicationSourceWALReader createNewWALReader(String walGroupId, PriorityBlockingQueue<Path> queue, long startPosition) {
        return this.replicationPeer.getPeerConfig().isSerial() ? new SerialReplicationSourceWALReader(this.fs, this.conf, queue, startPosition, this.walEntryFilter, this) : new ReplicationSourceWALReader(this.fs, this.conf, queue, startPosition, this.walEntryFilter, this);
    }

    protected final void uncaughtException(Thread t, Throwable e) {
        RSRpcServices.exitIfOOME(e);
        LOG.error("Unexpected exception in {} currentPath={}", new Object[]{t.getName(), this.getCurrentPath(), e});
        this.server.abort("Unexpected exception in " + t.getName(), e);
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    @Override
    public ReplicationSourceManager getSourceManager() {
        return this.manager;
    }

    @Override
    public void tryThrottle(int batchSize) throws InterruptedException {
        long sleepTicks;
        this.checkBandwidthChangeAndResetThrottler();
        if (this.throttler.isEnabled() && (sleepTicks = this.throttler.getNextSleepInterval(batchSize)) > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} To sleep {}ms for throttling control", (Object)this.logPeerId(), (Object)sleepTicks);
            }
            Thread.sleep(sleepTicks);
            this.throttler.resetStartTick();
        }
    }

    private void checkBandwidthChangeAndResetThrottler() {
        long peerBandwidth = this.getCurrentBandwidth();
        if (peerBandwidth != this.currentBandwidth) {
            this.currentBandwidth = peerBandwidth;
            this.throttler.setBandwidth((double)this.currentBandwidth / 10.0);
            LOG.info("ReplicationSource : " + this.peerId + " bandwidth throttling changed, currentBandWidth=" + this.currentBandwidth);
        }
    }

    private long getCurrentBandwidth() {
        long peerBandwidth = this.replicationPeer.getPeerBandwidth();
        return peerBandwidth != 0L ? peerBandwidth : this.defaultBandwidth;
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} {}, sleeping {} times {}", new Object[]{this.logPeerId(), msg, this.sleepForRetries, sleepMultiplier});
            }
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Interrupted while sleeping between retries", (Object)this.logPeerId());
            }
            Thread.currentThread().interrupt();
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    @Override
    public boolean isPeerEnabled() {
        return this.replicationPeer.isPeerEnabled();
    }

    private void initialize() {
        UUID peerClusterId;
        int sleepMultiplier = 1;
        while (this.isSourceActive()) {
            ReplicationEndpoint replicationEndpoint;
            try {
                replicationEndpoint = this.createReplicationEndpoint();
            }
            catch (Exception e) {
                LOG.warn("{} error creating ReplicationEndpoint, retry", (Object)this.logPeerId(), (Object)e);
                if (!this.sleepForRetries("Error creating ReplicationEndpoint", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            try {
                this.initAndStartReplicationEndpoint(replicationEndpoint);
                this.replicationEndpoint = replicationEndpoint;
                break;
            }
            catch (Exception e) {
                LOG.warn("{} Error starting ReplicationEndpoint, retry", (Object)this.logPeerId(), (Object)e);
                replicationEndpoint.stop();
                if (!this.sleepForRetries("Error starting ReplicationEndpoint", sleepMultiplier)) continue;
                ++sleepMultiplier;
            }
        }
        if (!this.isSourceActive()) {
            return;
        }
        sleepMultiplier = 1;
        while (true) {
            peerClusterId = this.replicationEndpoint.getPeerUUID();
            if (!this.isSourceActive() || peerClusterId != null) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Could not connect to Peer ZK. Sleeping for {} millis", (Object)this.logPeerId(), (Object)(this.sleepForRetries * (long)sleepMultiplier));
            }
            if (!this.sleepForRetries("Cannot contact the peer's zk ensemble", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
        if (!this.isSourceActive()) {
            return;
        }
        if (this.clusterId.equals(peerClusterId) && !this.replicationEndpoint.canReplicateToSameCluster()) {
            this.terminate("ClusterId " + this.clusterId + " is replicating to itself: peerClusterId " + peerClusterId + " which is not allowed by ReplicationEndpoint:" + this.replicationEndpoint.getClass().getName(), null, false);
            this.manager.removeSource(this);
            return;
        }
        LOG.info("{} Source: {}, is now replicating from cluster: {}; to peer cluster: {};", new Object[]{this.logPeerId(), this.replicationQueueInfo.getQueueId(), this.clusterId, peerClusterId});
        this.initializeWALEntryFilter(peerClusterId);
        for (Map.Entry<String, PriorityBlockingQueue<Path>> entry : this.queues.entrySet()) {
            String walGroupId = entry.getKey();
            PriorityBlockingQueue<Path> queue = entry.getValue();
            this.tryStartNewShipper(walGroupId, queue);
        }
    }

    @Override
    public void startup() {
        this.sourceRunning = true;
        this.initThread = new Thread(this::initialize);
        Threads.setDaemonThreadRunning((Thread)this.initThread, (String)(Thread.currentThread().getName() + ".replicationSource," + this.queueId), this::uncaughtException);
    }

    @Override
    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    @Override
    public void terminate(String reason, Exception cause) {
        this.terminate(reason, cause, true);
    }

    @Override
    public void terminate(String reason, Exception cause, boolean clearMetrics) {
        this.terminate(reason, cause, clearMetrics, true);
    }

    public void terminate(String reason, Exception cause, boolean clearMetrics, boolean join) {
        if (cause == null) {
            LOG.info("{} Closing source {} because: {}", new Object[]{this.logPeerId(), this.queueId, reason});
        } else {
            LOG.error("{} Closing source {} because an error occurred: {}", new Object[]{this.logPeerId(), this.queueId, reason, cause});
        }
        this.sourceRunning = false;
        if (this.initThread != null && Thread.currentThread() != this.initThread) {
            this.initThread.interrupt();
            Threads.shutdown((Thread)this.initThread, (long)this.sleepForRetries);
        }
        Collection<ReplicationSourceShipper> workers = this.workerThreads.values();
        for (ReplicationSourceShipper worker : workers) {
            worker.stopWorker();
            if (worker.entryReader == null) continue;
            worker.entryReader.setReaderRunning(false);
        }
        if (this.replicationEndpoint != null) {
            this.replicationEndpoint.stop();
        }
        for (ReplicationSourceShipper worker : workers) {
            if (!worker.isAlive() && !worker.entryReader.isAlive()) continue;
            try {
                Thread.sleep(this.sleepForRetries);
            }
            catch (InterruptedException e) {
                LOG.info("{} Interrupted while waiting {} to stop", (Object)this.logPeerId(), (Object)worker.getName());
                Thread.currentThread().interrupt();
            }
            if (worker.isAlive()) {
                worker.interrupt();
            }
            if (!worker.entryReader.isAlive()) continue;
            worker.entryReader.interrupt();
        }
        if (join) {
            for (ReplicationSourceShipper worker : workers) {
                Threads.shutdown((Thread)worker, (long)this.sleepForRetries);
                LOG.info("{} ReplicationSourceWorker {} terminated", (Object)this.logPeerId(), (Object)worker.getName());
            }
            if (this.replicationEndpoint != null) {
                try {
                    this.replicationEndpoint.awaitTerminated(this.sleepForRetries * (long)this.maxRetriesMultiplier, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    LOG.warn("{} Got exception while waiting for endpoint to shutdown for replication source : {}", new Object[]{this.logPeerId(), this.queueId, te});
                }
            }
        }
        if (clearMetrics) {
            this.metrics.clear();
        }
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    public Path getCurrentPath() {
        for (ReplicationSourceShipper worker : this.workerThreads.values()) {
            if (worker.getCurrentPath() == null) continue;
            return worker.getCurrentPath();
        }
        return null;
    }

    @Override
    public boolean isSourceActive() {
        return !this.server.isStopped() && this.sourceRunning;
    }

    public UUID getPeerClusterUUID() {
        return this.clusterId;
    }

    public ReplicationQueueInfo getReplicationQueueInfo() {
        return this.replicationQueueInfo;
    }

    public boolean isWorkerRunning() {
        for (ReplicationSourceShipper worker : this.workerThreads.values()) {
            if (!worker.isActive()) continue;
            return worker.isActive();
        }
        return false;
    }

    @Override
    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total replicated edits: ").append(this.totalReplicatedEdits).append(", current progress: \n");
        for (Map.Entry<String, ReplicationSourceShipper> entry : this.workerThreads.entrySet()) {
            String walGroupId = entry.getKey();
            ReplicationSourceShipper worker = entry.getValue();
            long position = worker.getCurrentPosition();
            Path currentPath = worker.getCurrentPath();
            sb.append("walGroup [").append(walGroupId).append("]: ");
            if (currentPath != null) {
                sb.append("currently replicating from: ").append(currentPath).append(" at position: ").append(position).append("\n");
                continue;
            }
            sb.append("no replication ongoing, waiting for new log");
        }
        return sb.toString();
    }

    @Override
    public MetricsSource getSourceMetrics() {
        return this.metrics;
    }

    @Override
    public void postShipEdits(List<WAL.Entry> entries, int batchSize) {
        if (this.throttler.isEnabled()) {
            this.throttler.addPushSize(batchSize);
        }
        this.totalReplicatedEdits.addAndGet(entries.size());
        this.totalBufferUsed.addAndGet(-batchSize);
    }

    @Override
    public WALFileLengthProvider getWALFileLengthProvider() {
        return this.walFileLengthProvider;
    }

    @Override
    public ServerName getServerWALsBelongTo() {
        return this.server.getServerName();
    }

    Server getServer() {
        return this.server;
    }

    ReplicationQueueStorage getQueueStorage() {
        return this.queueStorage;
    }

    private String logPeerId() {
        return "[Source for peer " + this.getPeerId() + "]:";
    }

    public static class LogsComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.compare(LogsComparator.getTS(o1), LogsComparator.getTS(o2));
        }

        private static long getTS(Path p) {
            int tsIndex = p.getName().lastIndexOf(46) + 1;
            return Long.parseLong(p.getName().substring(tsIndex));
        }
    }
}

