/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class OfflineMetaRebuildTestCore {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineMetaRebuildTestCore.class);
    protected HBaseTestingUtility TEST_UTIL;
    protected Configuration conf;
    private static final byte[] FAM = Bytes.toBytes((String)"fam");
    protected Table htbl;
    protected static final byte[][] splits = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
    private static final String TABLE_BASE = "tableMetaRebuild";
    private static int tableIdx = 0;
    protected TableName table = TableName.valueOf((String)"tableMetaRebuild");
    protected Connection connection;

    @Before
    public void setUpBefore() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.TEST_UTIL.getConfiguration().setInt("dfs.datanode.max.xceivers", 9192);
        this.TEST_UTIL.startMiniCluster(3);
        this.conf = this.TEST_UTIL.getConfiguration();
        this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
        Assert.assertEquals((long)0L, (long)this.TEST_UTIL.getAdmin().listTables().length);
        this.table = TableName.valueOf((String)("tableMetaRebuild-" + tableIdx));
        ++tableIdx;
        this.htbl = this.setupTable(this.table);
        this.populateTable(this.htbl);
        Assert.assertEquals((long)5L, (long)this.scanMeta());
        LOG.info("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries.");
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
        this.TEST_UTIL.getAdmin().disableTable(this.table);
        Assert.assertEquals((long)1L, (long)this.TEST_UTIL.getAdmin().listTables().length);
    }

    @After
    public void tearDownAfter() throws Exception {
        if (this.htbl != null) {
            this.htbl.close();
            this.htbl = null;
        }
        this.connection.close();
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private Table setupTable(TableName tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        this.TEST_UTIL.getAdmin().createTable((TableDescriptor)desc, splits);
        return this.connection.getTable(tablename);
    }

    private void dumpMeta(HTableDescriptor htd) throws IOException {
        List<byte[]> metaRows = this.TEST_UTIL.getMetaTableRows(htd.getTableName());
        for (byte[] row : metaRows) {
            LOG.info(Bytes.toString((byte[])row));
        }
    }

    private void populateTable(Table tbl) throws IOException {
        byte[] values = new byte[]{65, 66, 67, 68};
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Put put = new Put(new byte[]{values[i], values[j]});
                put.addColumn(Bytes.toBytes((String)"fam"), new byte[0], new byte[]{values[i], values[j]});
                puts.add(put);
            }
        }
        tbl.put(puts);
    }

    protected void deleteRegion(Configuration conf, Table tbl, byte[] startKey, byte[] endKey) throws IOException {
        List regions;
        LOG.info("Before delete:");
        HTableDescriptor htd = tbl.getTableDescriptor();
        this.dumpMeta(htd);
        try (RegionLocator rl = this.connection.getRegionLocator(tbl.getName());){
            regions = rl.getAllRegionLocations();
        }
        for (HRegionLocation e : regions) {
            HRegionInfo hri = e.getRegionInfo();
            ServerName hsa = e.getServerName();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0) {
                LOG.info("RegionName: " + hri.getRegionNameAsString());
                byte[] deleteRow = hri.getRegionName();
                this.TEST_UTIL.getAdmin().unassign(deleteRow, true);
                LOG.info("deleting hdfs data: " + hri.toString() + hsa.toString());
                Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
                FileSystem fs = rootDir.getFileSystem(conf);
                Path p = new Path(CommonFSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), hri.getEncodedName());
                fs.delete(p, true);
                try (Table meta = this.connection.getTable(TableName.META_TABLE_NAME);){
                    Delete delete = new Delete(deleteRow);
                    meta.delete(delete);
                }
            }
            LOG.info(hri.toString() + hsa.toString());
        }
        this.TEST_UTIL.getMetaTableRows(htd.getTableName());
        LOG.info("After delete:");
        this.dumpMeta(htd);
    }

    protected RegionInfo createRegion(Configuration conf, Table htbl, byte[] startKey, byte[] endKey) throws IOException {
        Table meta = this.TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
        HTableDescriptor htd = htbl.getTableDescriptor();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htbl.getName()).setStartKey(startKey).setEndKey(endKey).build();
        LOG.info("manually adding regioninfo and hdfs data: " + hri.toString());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path p = new Path(CommonFSUtils.getTableDir((Path)rootDir, (TableName)htbl.getName()), hri.getEncodedName());
        fs.mkdirs(p);
        Path riPath = new Path(p, ".regioninfo");
        FSDataOutputStream out = fs.create(riPath);
        out.write(RegionInfo.toDelimitedByteArray((RegionInfo)hri));
        out.close();
        MetaTableAccessor.addRegionToMeta((Connection)this.TEST_UTIL.getConnection(), (RegionInfo)hri);
        meta.close();
        return hri;
    }

    protected void wipeOutMeta() throws IOException {
        Admin admin = this.TEST_UTIL.getAdmin();
        Scan s = new Scan();
        Table meta = this.TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
        ResultScanner scanner = meta.getScanner(s);
        ArrayList<Delete> dels = new ArrayList<Delete>();
        for (Result r : scanner) {
            RegionInfo info = MetaTableAccessor.getRegionInfo((Result)r);
            if (info == null || info.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) continue;
            Delete d = new Delete(r.getRow());
            dels.add(d);
            admin.unassign(r.getRow(), true);
        }
        meta.delete(dels);
        scanner.close();
        meta.close();
    }

    protected int tableRowCount(Configuration conf, TableName table) throws IOException {
        Table t = this.TEST_UTIL.getConnection().getTable(table);
        Scan st = new Scan();
        ResultScanner rst = t.getScanner(st);
        int count = 0;
        for (Result rt : rst) {
            ++count;
        }
        t.close();
        return count;
    }

    protected int scanMeta() throws IOException {
        LOG.info("Scanning META");
        MetaTableAccessor.fullScanMetaAndPrint((Connection)this.TEST_UTIL.getConnection());
        return MetaTableAccessor.fullScanRegions((Connection)this.TEST_UTIL.getConnection()).size();
    }

    protected HTableDescriptor[] getTables(Configuration configuration) throws IOException {
        HTableDescriptor[] htbls = null;
        try (Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
             Admin admin = connection.getAdmin();){
            htbls = admin.listTables();
        }
        return htbls;
    }
}

