/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestProcedurePriority {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedurePriority.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String TABLE_NAME_PREFIX = "TestProcedurePriority-";
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static int CORE_POOL_SIZE;
    private static int TABLE_COUNT;
    private static volatile boolean FAIL;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setLong("hbase.procedure.worker.keep.alive.time.msec", 5000L);
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 4);
        UTIL.getConfiguration().set("hbase.coprocessor.region.classes", MyCP.class.getName());
        UTIL.startMiniCluster(3);
        CORE_POOL_SIZE = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getCorePoolSize();
        TABLE_COUNT = 50 * CORE_POOL_SIZE;
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int i = 0; i < TABLE_COUNT; ++i) {
            futures.add(UTIL.getAdmin().createTableAsync(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(TABLE_NAME_PREFIX + i))).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build()));
        }
        for (Future future : futures) {
            future.get(1L, TimeUnit.MINUTES);
        }
        UTIL.getAdmin().balance(true);
        UTIL.waitUntilNoRegionsInTransition();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        JVMClusterUtil.RegionServerThread rsWithMetaThread = UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().filter(t -> !t.getRegionServer().getRegions(TableName.META_TABLE_NAME).isEmpty()).findAny().get();
        HRegionServer rsNoMeta = UTIL.getOtherRegionServer(rsWithMetaThread.getRegionServer());
        UTIL.waitTableAvailable(TableName.NAMESPACE_TABLE_NAME);
        FAIL = true;
        UTIL.getMiniHBaseCluster().killRegionServer(rsNoMeta.getServerName());
        final ProcedureExecutor executor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return executor.getWorkerThreadCount() > CORE_POOL_SIZE;
            }

            public String explainFailure() throws Exception {
                return "Stuck checker does not add new worker thread";
            }
        });
        UTIL.getMiniHBaseCluster().killRegionServer(rsWithMetaThread.getRegionServer().getServerName());
        rsWithMetaThread.join();
        FAIL = false;
        UTIL.waitUntilNoRegionsInTransition(480000L);
        for (int i = 0; i < TABLE_COUNT; ++i) {
            try (Table table = UTIL.getConnection().getTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + i)));){
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
                continue;
            }
        }
        UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return executor.getWorkerThreadCount() == CORE_POOL_SIZE;
            }

            public String explainFailure() throws Exception {
                return "The new workers do not timeout";
            }
        });
    }

    static {
        FAIL = false;
    }

    public static final class MyCP
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            if (FAIL && ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().isMetaRegion()) {
                throw new IOException("Inject error");
            }
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (FAIL && ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().isMetaRegion()) {
                throw new IOException("Inject error");
            }
        }
    }
}

