/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorHost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorHost.class);

    @Test
    public void testDoubleLoadingAndPriorityValue() {
        Configuration conf = HBaseConfiguration.create();
        String key = "KEY";
        String coprocessor = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        CoprocessorHostForTest host = new CoprocessorHostForTest(conf);
        int overridePriority = 0x7FFFFFFE;
        String coprocessor_v3 = SimpleRegionObserverV3.class.getName() + "|" + overridePriority;
        conf.setStrings("KEY", new String[]{"org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", SimpleRegionObserverV2.class.getName(), coprocessor_v3});
        host.loadSystemCoprocessors(conf, "KEY");
        Assert.assertEquals((long)3L, (long)host.coprocEnvironments.size());
        CoprocessorEnvironment simpleEnv = host.findCoprocessorEnvironment(SimpleRegionObserver.class.getName());
        CoprocessorEnvironment simpleEnv_v2 = host.findCoprocessorEnvironment(SimpleRegionObserverV2.class.getName());
        CoprocessorEnvironment simpleEnv_v3 = host.findCoprocessorEnvironment(SimpleRegionObserverV3.class.getName());
        Assert.assertNotNull((Object)simpleEnv);
        Assert.assertNotNull((Object)simpleEnv_v2);
        Assert.assertNotNull((Object)simpleEnv_v3);
        Assert.assertEquals((long)0x1FFFFFFFL, (long)simpleEnv.getPriority());
        Assert.assertEquals((long)0x20000000L, (long)simpleEnv_v2.getPriority());
        Assert.assertEquals((long)overridePriority, (long)simpleEnv_v3.getPriority());
    }

    private static class CoprocessorHostForTest<E extends Coprocessor>
    extends CoprocessorHost<E, CoprocessorEnvironment<E>> {
        final Configuration cpHostConf;

        public CoprocessorHostForTest(Configuration conf) {
            super((Abortable)new TestAbortable());
            this.cpHostConf = conf;
        }

        public E checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
            try {
                return (E)((Coprocessor)implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw (InstantiationException)new InstantiationException().initCause(e);
            }
        }

        public CoprocessorEnvironment<E> createEnvironment(E instance, int priority, int sequence, Configuration conf) {
            return new BaseEnvironment(instance, priority, 0, this.cpHostConf);
        }
    }

    public static class SimpleRegionObserverV3
    extends SimpleRegionObserver {
    }

    public static class SimpleRegionObserverV2
    extends SimpleRegionObserver {
    }

    private static class TestAbortable
    implements Abortable {
        private volatile boolean aborted = false;

        private TestAbortable() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
            Assert.fail();
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

