/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationMetricsforUI
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationMetricsforUI.class);
    private static final byte[] qualName = Bytes.toBytes((String)"q");

    @Test
    public void testReplicationMetrics() throws Exception {
        try (Admin hbaseAdmin = utility1.getConnection().getAdmin();){
            Put p = new Put(Bytes.toBytes((String)"starter"));
            p.addColumn(famName, qualName, Bytes.toBytes((String)"value help to test replication delay"));
            htable1.put(p);
            while (htable2.get(new Get(Bytes.toBytes((String)"starter"))).size() == 0) {
                Thread.sleep(500L);
            }
            Thread.sleep(5000L);
            HRegionServer rs = utility1.getRSForFirstRegionInTable(tableName);
            Map metrics = rs.getWalGroupsReplicationStatus();
            Assert.assertEquals((String)"metric size ", (long)1L, (long)metrics.size());
            long lastPosition = 0L;
            for (Map.Entry metric : metrics.entrySet()) {
                Assert.assertEquals((String)"peerId", (Object)"2", (Object)((ReplicationStatus)metric.getValue()).getPeerId());
                Assert.assertEquals((String)"queue length", (long)1L, (long)((ReplicationStatus)metric.getValue()).getQueueSize());
                Assert.assertEquals((String)"replication delay", (long)0L, (long)((ReplicationStatus)metric.getValue()).getReplicationDelay());
                Assert.assertTrue((String)"current position >= 0", (((ReplicationStatus)metric.getValue()).getCurrentPosition() >= 0L ? 1 : 0) != 0);
                lastPosition = ((ReplicationStatus)metric.getValue()).getCurrentPosition();
            }
            for (int i = 0; i < 100; ++i) {
                p = new Put(Bytes.toBytes((String)("" + Integer.toString(i))));
                p.addColumn(famName, qualName, Bytes.toBytes((String)("value help to test replication delay " + i)));
                htable1.put(p);
            }
            while (htable2.get(new Get(Bytes.toBytes((String)("" + Integer.toString(99))))).size() == 0) {
                Thread.sleep(500L);
            }
            rs = utility1.getRSForFirstRegionInTable(tableName);
            metrics = rs.getWalGroupsReplicationStatus();
            Path lastPath = null;
            for (Map.Entry metric : metrics.entrySet()) {
                lastPath = ((ReplicationStatus)metric.getValue()).getCurrentPath();
                Assert.assertEquals((String)"peerId", (Object)"2", (Object)((ReplicationStatus)metric.getValue()).getPeerId());
                Assert.assertTrue((String)"age of Last Shipped Op should be > 0 ", (((ReplicationStatus)metric.getValue()).getAgeOfLastShippedOp() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"current position should > last position", (((ReplicationStatus)metric.getValue()).getCurrentPosition() - lastPosition > 0L ? 1 : 0) != 0);
                lastPosition = ((ReplicationStatus)metric.getValue()).getCurrentPosition();
            }
            hbaseAdmin.rollWALWriter(rs.getServerName());
            p = new Put(Bytes.toBytes((String)"trigger"));
            p.addColumn(famName, qualName, Bytes.toBytes((String)"value help to test replication delay"));
            htable1.put(p);
            while (htable2.get(new Get(Bytes.toBytes((String)"trigger"))).size() == 0) {
                Thread.sleep(500L);
            }
            Thread.sleep(5000L);
            metrics = rs.getWalGroupsReplicationStatus();
            for (Map.Entry metric : metrics.entrySet()) {
                Assert.assertEquals((String)"replication delay", (long)0L, (long)((ReplicationStatus)metric.getValue()).getReplicationDelay());
                Assert.assertTrue((String)"current position should < last position", (((ReplicationStatus)metric.getValue()).getCurrentPosition() < lastPosition ? 1 : 0) != 0);
                Assert.assertNotEquals((String)"current path", (Object)lastPath, (Object)((ReplicationStatus)metric.getValue()).getCurrentPath());
            }
        }
    }
}

