/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.FailedArchiveException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MockHStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCompactionArchiveIOException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionArchiveIOException.class);
    private static final String ERROR_FILE = "fffffffffffffffffdeadbeef";
    public HBaseTestingUtility testUtil;
    private Path testDir;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.testUtil.startMiniDFSCluster(1);
        this.testDir = this.testUtil.getDataTestDirOnTestFS();
        FSUtils.setRootDir((Configuration)this.testUtil.getConfiguration(), (Path)this.testDir);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.cleanupTestDir();
        this.testUtil.shutdownMiniDFSCluster();
    }

    @Test
    public void testRemoveCompactedFilesWithException() throws Exception {
        byte[] fam = Bytes.toBytes((String)"f");
        byte[] col = Bytes.toBytes((String)"c");
        byte[] val = Bytes.toBytes((String)"val");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])fam)).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        HRegion region = this.initHRegion(htd, info);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        regions.add(region);
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)rss)).getRegions();
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, rss, false);
        int batchSize = 10;
        int fileCount = 10;
        for (int f = 0; f < fileCount; ++f) {
            int start;
            for (int i = start = f * batchSize; i < start + batchSize; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(fam, col, val);
                region.put(p);
            }
            region.flush(true);
        }
        HStore store = region.getStore(fam);
        Assert.assertEquals((long)fileCount, (long)store.getStorefilesCount());
        Collection storefiles = store.getStorefiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        StoreFileManager fileManager = store.getStoreEngine().getStoreFileManager();
        Collection initialCompactedFiles = fileManager.getCompactedfiles();
        Assert.assertTrue((initialCompactedFiles == null || initialCompactedFiles.isEmpty() ? 1 : 0) != 0);
        region.compact(true);
        Collection compactedFilesPreClean = fileManager.getCompactedfiles();
        Assert.assertNotNull((Object)compactedFilesPreClean);
        Assert.assertTrue((compactedFilesPreClean.size() > 0 ? 1 : 0) != 0);
        HRegionFileSystem regionFS = region.getRegionFileSystem();
        Path errFile = regionFS.getStoreFilePath(Bytes.toString((byte[])fam), ERROR_FILE);
        FSDataOutputStream out = regionFS.getFileSystem().create(errFile);
        out.writeInt(1);
        out.close();
        MockHStoreFile errStoreFile = new MockHStoreFile(this.testUtil, errFile, 1L, 0L, false, 1L);
        fileManager.addCompactionResults((Collection)ImmutableList.of((Object)((Object)errStoreFile)), (Collection)ImmutableList.of());
        cleaner.chore();
        Collection compactedFilesPostClean = fileManager.getCompactedfiles();
        Assert.assertEquals((long)1L, (long)compactedFilesPostClean.size());
        for (HStoreFile origFile : compactedFilesPreClean) {
            Assert.assertFalse((boolean)compactedFilesPostClean.contains(origFile));
        }
        try {
            region.close();
        }
        catch (FailedArchiveException e) {
            Assert.assertEquals((long)1L, (long)e.getFailedFiles().size());
            Assert.assertEquals((Object)ERROR_FILE, (Object)((Path)e.getFailedFiles().iterator().next()).getName());
        }
    }

    private HRegion initHRegion(TableDescriptor htd, RegionInfo info) throws IOException {
        Configuration conf = this.testUtil.getConfiguration();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        Path tableDir = FSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName());
        Path regionDir = new Path(tableDir, info.getEncodedName());
        Path storeDir = new Path(regionDir, htd.getColumnFamilies()[0].getNameAsString());
        FileSystem errFS = (FileSystem)Mockito.spy((Object)this.testUtil.getTestFileSystem());
        ((FileSystem)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Error for test")}).when((Object)errFS)).rename((Path)ArgumentMatchers.eq((Object)new Path(storeDir, ERROR_FILE)), (Path)ArgumentMatchers.any());
        HRegionFileSystem fs = new HRegionFileSystem(conf, errFS, tableDir, info);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir((Configuration)walConf, (Path)tableDir);
        WALFactory wals = new WALFactory(walConf, "log_" + info.getEncodedName());
        HRegion region = new HRegion(fs, wals.getWAL(info), conf, htd, null);
        region.initialize();
        return region;
    }
}

