/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifier;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierFactory;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierFactoryImpl;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SnapshotQuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSnapshotQuotaObserverChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotQuotaObserverChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotQuotaObserverChore.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong();
    @Rule
    public TestName testName = new TestName();
    private Connection conn;
    private Admin admin;
    private SpaceQuotaHelperForTests helper;
    private HMaster master;
    private SnapshotQuotaObserverChore testChore;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 15000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.conn = TEST_UTIL.getConnection();
        this.admin = TEST_UTIL.getAdmin();
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.helper.removeAllQuotas(this.conn);
        this.testChore = new SnapshotQuotaObserverChore(TEST_UTIL.getConnection(), TEST_UTIL.getConfiguration(), this.master.getFileSystem(), (Stoppable)this.master, null);
    }

    @Test
    public void testSnapshotsFromTables() throws Exception {
        TableName tn1 = this.helper.createTableWithRegions(1);
        TableName tn2 = this.helper.createTableWithRegions(1);
        TableName tn3 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn2, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.snapshot(new SnapshotDescription(tn1 + "snapshot", tn1, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn2 + "snapshot", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3 + "snapshot", tn3, SnapshotType.SKIPFLUSH));
        Multimap mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)2L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1 + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals((Object)(tn2 + "snapshot"), mapping.get((Object)tn2).iterator().next());
        this.admin.snapshot(new SnapshotDescription(tn2 + "snapshot1", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3 + "snapshot1", tn3, SnapshotType.SKIPFLUSH));
        mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)3L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1 + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)2L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList(tn2 + "snapshot", tn2 + "snapshot1")), (Object)mapping.get((Object)tn2));
    }

    @Test
    public void testSnapshotsFromNamespaces() throws Exception {
        NamespaceDescriptor ns = NamespaceDescriptor.create((String)"snapshots_from_namespaces").build();
        this.admin.createNamespace(ns);
        TableName tn1 = this.helper.createTableWithRegions(ns.getName(), 1);
        TableName tn2 = this.helper.createTableWithRegions(ns.getName(), 1);
        TableName tn3 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)tn3.getNamespaceAsString(), (ThrottleType)ThrottleType.WRITE_NUMBER, (long)100L, (TimeUnit)TimeUnit.SECONDS));
        this.admin.setQuota(QuotaSettingsFactory.throttleUser((String)"user", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)100L, (TimeUnit)TimeUnit.MINUTES));
        this.admin.setQuota(QuotaSettingsFactory.limitNamespaceSpace((String)ns.getName(), (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.snapshot(new SnapshotDescription(tn1.getQualifierAsString() + "snapshot", tn1, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn2.getQualifierAsString() + "snapshot", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3.getQualifierAsString() + "snapshot", tn3, SnapshotType.SKIPFLUSH));
        Multimap mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)2L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1.getQualifierAsString() + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals((Object)(tn2.getQualifierAsString() + "snapshot"), mapping.get((Object)tn2).iterator().next());
        this.admin.snapshot(new SnapshotDescription(tn2.getQualifierAsString() + "snapshot1", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3.getQualifierAsString() + "snapshot2", tn3, SnapshotType.SKIPFLUSH));
        mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)3L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1.getQualifierAsString() + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)2L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList(tn2.getQualifierAsString() + "snapshot", tn2.getQualifierAsString() + "snapshot1")), (Object)mapping.get((Object)tn2));
    }

    @Test
    public void testSnapshotSize() throws Exception {
        final TableName tn1 = this.helper.createTableWithRegions(5);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        this.admin.flush(tn1);
        final long snapshotSize = TEST_UTIL.getMiniHBaseCluster().getRegions(tn1).stream().flatMap(r -> r.getStores().stream()).mapToLong(HStore::getHFilesSize).sum();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == snapshotSize;
            }
        });
        String snapshotName = tn1 + "snapshot";
        this.admin.snapshot(new SnapshotDescription(snapshotName, tn1, SnapshotType.SKIPFLUSH));
        Multimap snapshotsToCompute = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((String)("Expected to see the single snapshot: " + snapshotsToCompute), (long)1L, (long)snapshotsToCompute.size());
        Map namespaceSnapshotSizes = this.testChore.computeSnapshotSizes(snapshotsToCompute);
        Assert.assertEquals((long)1L, (long)namespaceSnapshotSizes.size());
        Long size = (Long)namespaceSnapshotSizes.get(tn1.getNamespaceAsString());
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)0L, (long)size);
        this.helper.writeData(tn1, 262144L);
        this.admin.flush(tn1);
        TEST_UTIL.compact(tn1, true);
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){
            private final long regionSize;
            {
                super(conn, tn);
                this.regionSize = TEST_UTIL.getMiniHBaseCluster().getRegions(tn1).stream().flatMap(r -> r.getStores().stream()).mapToLong(HStore::getHFilesSize).sum();
            }

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                LOG.debug("Current usage=" + snapshot.getUsage() + " snapshotSize=" + snapshotSize);
                return TestSnapshotQuotaObserverChore.this.closeInSize(snapshot.getUsage(), snapshotSize + this.regionSize, 1024L);
            }
        });
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.NoFilesToDischarge(TEST_UTIL.getMiniHBaseCluster(), tn1));
        snapshotsToCompute = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((String)("Expected to see the single snapshot: " + snapshotsToCompute), (long)1L, (long)snapshotsToCompute.size());
        namespaceSnapshotSizes = this.testChore.computeSnapshotSizes(snapshotsToCompute);
        Assert.assertEquals((long)1L, (long)namespaceSnapshotSizes.size());
        size = (Long)namespaceSnapshotSizes.get(tn1.getNamespaceAsString());
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)snapshotSize, (long)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistingSnapshotsForNamespaces() throws Exception {
        final TableName tn1 = TableName.valueOf((String)"ns1:tn1");
        final TableName tn2 = TableName.valueOf((String)"ns1:tn2");
        final TableName tn3 = TableName.valueOf((String)"ns2:tn1");
        final TableName tn4 = TableName.valueOf((String)"ns2:tn2");
        final TableName tn5 = TableName.valueOf((String)"tn1");
        FileArchiverNotifierFactory test = new FileArchiverNotifierFactory(){
            Map<TableName, Long> tableToSize;
            {
                this.tableToSize = ImmutableMap.of((Object)tn1, (Object)1024L, (Object)tn2, (Object)1024L, (Object)tn3, (Object)512L, (Object)tn4, (Object)1024L, (Object)tn5, (Object)3072L);
            }

            public FileArchiverNotifier get(Connection conn, Configuration conf, FileSystem fs, final TableName tn) {
                return new FileArchiverNotifier(){

                    public void addArchivedFiles(Set<Map.Entry<String, Long>> fileSizes) throws IOException {
                    }

                    public long computeAndStoreSnapshotSizes(Collection<String> currentSnapshots) throws IOException {
                        return tableToSize.get(tn);
                    }
                };
            }
        };
        try {
            FileArchiverNotifierFactoryImpl.setInstance((FileArchiverNotifierFactory)test);
            HashMultimap snapshotsToCompute = HashMultimap.create();
            snapshotsToCompute.put((Object)tn1, (Object)"");
            snapshotsToCompute.put((Object)tn2, (Object)"");
            snapshotsToCompute.put((Object)tn3, (Object)"");
            snapshotsToCompute.put((Object)tn4, (Object)"");
            snapshotsToCompute.put((Object)tn5, (Object)"");
            Map nsSizes = this.testChore.computeSnapshotSizes((Multimap)snapshotsToCompute);
            Assert.assertEquals((long)3L, (long)nsSizes.size());
            Assert.assertEquals((long)2048L, (long)((Long)nsSizes.get("ns1")));
            Assert.assertEquals((long)1536L, (long)((Long)nsSizes.get("ns2")));
            Assert.assertEquals((long)3072L, (long)((Long)nsSizes.get(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR)));
        }
        finally {
            FileArchiverNotifierFactoryImpl.reset();
        }
    }

    @Test
    public void testRemovedSnapshots() throws Exception {
        final TableName tn1 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        final AtomicReference lastSeenSize = new AtomicReference();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                lastSeenSize.set(snapshot.getUsage());
                return snapshot.getUsage() > 235520L;
            }
        });
        final String snapshotName1 = tn1 + "snapshot1";
        this.admin.snapshot(new SnapshotDescription(snapshotName1, tn1, SnapshotType.SKIPFLUSH));
        final Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName1);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return QuotaTableUtil.parseSnapshotSize((Cell)c) == 0L;
            }
        });
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == ((Long)lastSeenSize.get()).longValue();
            }
        });
        TEST_UTIL.compact(tn1, true);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName1);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return (Long)lastSeenSize.get() == QuotaTableUtil.parseSnapshotSize((Cell)c);
            }
        });
        final AtomicReference sizeAfterCompaction = new AtomicReference();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                sizeAfterCompaction.set(snapshot.getUsage());
                return snapshot.getUsage() >= 2L * (Long)lastSeenSize.get();
            }
        });
        this.admin.deleteSnapshot(snapshotName1);
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == (Long)sizeAfterCompaction.get() - (Long)lastSeenSize.get();
            }
        });
    }

    @Test
    public void testBucketingFilesToSnapshots() throws Exception {
        final TableName tn1 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        this.admin.flush(tn1);
        final AtomicReference lastSeenSize = new AtomicReference();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                lastSeenSize.set(snapshot.getUsage());
                return snapshot.getUsage() > 235520L;
            }
        });
        final String snapshotName1 = tn1 + "snapshot1";
        this.admin.snapshot(new SnapshotDescription(snapshotName1, tn1, SnapshotType.SKIPFLUSH));
        TEST_UTIL.compact(tn1, true);
        final Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info("Waiting to see quota snapshot1 size");
                TestSnapshotQuotaObserverChore.this.debugFilesForSnapshot(tn1, snapshotName1);
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName1);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return (Long)lastSeenSize.get() == QuotaTableUtil.parseSnapshotSize((Cell)c);
            }
        });
        LOG.info("Snapshotting table again");
        final String snapshotName2 = tn1 + "snapshot2";
        this.admin.snapshot(new SnapshotDescription(snapshotName2, tn1, SnapshotType.SKIPFLUSH));
        LOG.info("Compacting table");
        TEST_UTIL.compact(tn1, true);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info("Waiting to see quota snapshot2 size");
                TestSnapshotQuotaObserverChore.this.debugFilesForSnapshot(tn1, snapshotName2);
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName2);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return TestSnapshotQuotaObserverChore.this.closeInSize((Long)lastSeenSize.get(), QuotaTableUtil.parseSnapshotSize((Cell)c), 1024L);
            }
        });
        Get g = QuotaTableUtil.createGetNamespaceSnapshotSize((String)tn1.getNamespaceAsString());
        Result r = quotaTable.get(g);
        Assert.assertNotNull((Object)r);
        Assert.assertFalse((boolean)r.isEmpty());
        r.advance();
        long size = QuotaTableUtil.parseSnapshotSize((Cell)r.current());
        Assert.assertTrue((boolean)this.closeInSize((Long)lastSeenSize.get() * 2L, size, 1024L));
    }

    void debugFilesForSnapshot(TableName table, final String snapshot) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path snapshotDir = new Path(conf.get("hbase.rootdir"), ".hbase-snapshot");
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)conf, (FileSystem)fs, (Path)new Path(snapshotDir, snapshot), (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(RegionInfo regionInfo, String familyName, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                LOG.info("Snapshot={} references file={}, size={}", new Object[]{snapshot, storeFile.getName(), storeFile.getFileSize()});
            }
        });
    }

    boolean closeInSize(long size1, long size2, long delta) {
        long lower = size1 - delta;
        long upper = size1 + delta;
        return lower <= size2 && size2 <= upper;
    }
}

