/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.quotas.RegionSize;
import org.apache.hadoop.hbase.quotas.RegionSizeStoreImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionSizeStoreImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSizeStoreImpl.class);
    private static final RegionInfo INFOA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"TEST")).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
    private static final RegionInfo INFOB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"TEST")).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"c")).build();

    @Test
    public void testSizeUpdates() {
        RegionSizeStoreImpl store = new RegionSizeStoreImpl();
        Assert.assertTrue((boolean)store.isEmpty());
        Assert.assertEquals((long)0L, (long)store.size());
        store.put(INFOA, 1024L);
        Assert.assertFalse((boolean)store.isEmpty());
        Assert.assertEquals((long)1L, (long)store.size());
        Assert.assertEquals((long)1024L, (long)store.getRegionSize(INFOA).getSize());
        store.put(INFOA, 2048L);
        Assert.assertEquals((long)1L, (long)store.size());
        Assert.assertEquals((long)2048L, (long)store.getRegionSize(INFOA).getSize());
        store.incrementRegionSize(INFOA, 512L);
        Assert.assertEquals((long)1L, (long)store.size());
        Assert.assertEquals((long)2560L, (long)store.getRegionSize(INFOA).getSize());
        store.remove(INFOA);
        Assert.assertTrue((boolean)store.isEmpty());
        Assert.assertEquals((long)0L, (long)store.size());
        store.put(INFOA, 64L);
        store.put(INFOB, 128L);
        Assert.assertEquals((long)2L, (long)store.size());
        HashMap records = new HashMap();
        for (Map.Entry entry : store) {
            records.put(entry.getKey(), entry.getValue());
        }
        Assert.assertEquals((long)64L, (long)((RegionSize)records.remove(INFOA)).getSize());
        Assert.assertEquals((long)128L, (long)((RegionSize)records.remove(INFOB)).getSize());
        Assert.assertTrue((boolean)records.isEmpty());
    }

    @Test
    public void testNegativeDeltaForMissingRegion() {
        RegionSizeStoreImpl store = new RegionSizeStoreImpl();
        Assert.assertNull((Object)store.getRegionSize(INFOA));
        store.incrementRegionSize(INFOA, -5L);
        Assert.assertNotNull((Object)store.getRegionSize(INFOA));
        Assert.assertEquals((long)0L, (long)store.getRegionSize(INFOA).getSize());
    }
}

