/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AssignmentTestingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentTestingUtil.class);

    private AssignmentTestingUtil() {
    }

    public static void waitForRegionToBeInTransition(HBaseTestingUtility util, RegionInfo hri) throws Exception {
        while (!AssignmentTestingUtil.getMaster(util).getAssignmentManager().getRegionStates().isRegionInTransition(hri)) {
            Threads.sleep((long)10L);
        }
    }

    public static void waitForRsToBeDead(final HBaseTestingUtility util, final ServerName serverName) throws Exception {
        util.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() {
                return AssignmentTestingUtil.getMaster(util).getServerManager().isServerDead(serverName);
            }

            public String explainFailure() {
                return "Server " + serverName + " is not dead";
            }
        });
    }

    public static void stopRs(HBaseTestingUtility util, ServerName serverName) throws Exception {
        LOG.info("STOP REGION SERVER " + serverName);
        util.getMiniHBaseCluster().stopRegionServer(serverName);
        AssignmentTestingUtil.waitForRsToBeDead(util, serverName);
    }

    public static void killRs(HBaseTestingUtility util, ServerName serverName) throws Exception {
        LOG.info("KILL REGION SERVER " + serverName);
        util.getMiniHBaseCluster().killRegionServer(serverName);
        AssignmentTestingUtil.waitForRsToBeDead(util, serverName);
    }

    public static void crashRs(HBaseTestingUtility util, ServerName serverName, boolean kill) throws Exception {
        if (kill) {
            AssignmentTestingUtil.killRs(util, serverName);
        } else {
            AssignmentTestingUtil.stopRs(util, serverName);
        }
    }

    public static ServerName crashRsWithRegion(HBaseTestingUtility util, RegionInfo hri, boolean kill) throws Exception {
        ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(util, hri);
        AssignmentTestingUtil.crashRs(util, serverName, kill);
        return serverName;
    }

    public static ServerName getServerHoldingRegion(HBaseTestingUtility util, RegionInfo hri) throws Exception {
        ServerName serverName = util.getMiniHBaseCluster().getServerHoldingRegion(hri.getTable(), hri.getRegionName());
        ServerName amServerName = AssignmentTestingUtil.getMaster(util).getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        Assert.assertEquals((Object)amServerName, (Object)serverName);
        Assert.assertEquals((Object)true, (Object)AssignmentTestingUtil.getMaster(util).getServerManager().isServerOnline(serverName));
        return serverName;
    }

    public static boolean isServerHoldingMeta(HBaseTestingUtility util, ServerName serverName) throws Exception {
        for (RegionInfo hri : AssignmentTestingUtil.getMetaRegions(util)) {
            if (!serverName.equals((Object)AssignmentTestingUtil.getServerHoldingRegion(util, hri))) continue;
            return true;
        }
        return false;
    }

    public static Set<RegionInfo> getMetaRegions(HBaseTestingUtility util) {
        return AssignmentTestingUtil.getMaster(util).getAssignmentManager().getMetaRegionSet();
    }

    private static HMaster getMaster(HBaseTestingUtility util) {
        return util.getMiniHBaseCluster().getMaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForAssignment(AssignmentManager am, RegionInfo regionInfo) throws IOException {
        Waiter.waitFor((Configuration)am.getConfiguration(), (long)10000L, () -> am.getRegionStates().getRegionStateNode(regionInfo) != null);
        RegionStateNode regionNode = am.getRegionStates().getRegionStateNode(regionInfo);
        Waiter.waitFor((Configuration)am.getConfiguration(), (long)30000L, () -> regionNode.isInState(new RegionState.State[]{RegionState.State.OPEN}) || regionNode.isInTransition());
        TransitRegionStateProcedure proc = regionNode.getProcedure();
        regionNode.lock();
        try {
            if (regionNode.isInState(new RegionState.State[]{RegionState.State.OPEN})) {
                boolean bl = true;
                return bl;
            }
            proc = regionNode.getProcedure();
        }
        finally {
            regionNode.unlock();
        }
        Assert.assertNotNull((Object)proc);
        ProcedureSyncWait.waitForProcedureToCompleteIOE((ProcedureExecutor)am.getMaster().getMasterProcedureExecutor(), (Procedure)proc, (long)300000L);
        return true;
    }
}

