/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLoadProcedureError {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadProcedureError.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Load");
    private static volatile CountDownLatch ARRIVE;
    private static volatile boolean FINISH_PROC;
    private static volatile boolean FAIL_LOAD;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void waitNoMaster() {
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getLiveMasterThreads().isEmpty());
    }

    @Test
    public void testLoadError() throws Exception {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        ARRIVE = new CountDownLatch(1);
        long procId = procExec.submitProcedure((Procedure)new TestProcedure());
        ARRIVE.await();
        FAIL_LOAD = true;
        UTIL.getMiniHBaseCluster().getMaster().getWalProcedureStore().stop(true);
        UTIL.getMiniHBaseCluster().getMaster().abort("for testing");
        this.waitNoMaster();
        UTIL.getMiniHBaseCluster().startMaster();
        this.waitNoMaster();
        UTIL.getMiniHBaseCluster().startMaster();
        this.waitNoMaster();
        FAIL_LOAD = false;
        HMaster master = UTIL.getMiniHBaseCluster().startMaster().getMaster();
        UTIL.waitFor(30000L, () -> master.isActiveMaster() && master.isInitialized());
        TestProcedure proc = (TestProcedure)master.getMasterProcedureExecutor().getProcedure(procId);
        Assert.assertFalse((boolean)proc.isFinished());
        FINISH_PROC = true;
        UTIL.waitFor(30000L, () -> proc.isFinished());
    }

    public static final class TestProcedure
    extends ProcedureTestingUtility.NoopProcedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (ARRIVE != null) {
                ARRIVE.countDown();
                ARRIVE = null;
            }
            if (FINISH_PROC) {
                return null;
            }
            this.setTimeout(1000);
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            throw new ProcedureSuspendedException();
        }

        protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
            this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
            env.getProcedureScheduler().addBack((Procedure)this);
            return false;
        }

        protected void afterReplay(MasterProcedureEnv env) {
            if (FAIL_LOAD) {
                throw new RuntimeException("Inject error");
            }
        }

        public TableName getTableName() {
            return NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }
    }
}

