/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.FileMmapEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.TestByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestFileMmapEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileMmapEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileMmapEngine() throws IOException {
        int size = 0x200000;
        String filePath = "testFileMmapEngine";
        try {
            FileMmapEngine fileMmapEngine = new FileMmapEngine(filePath, (long)size);
            for (int i = 0; i < 50; ++i) {
                int len = (int)Math.floor(Math.random() * 100.0);
                long offset = (long)Math.floor(Math.random() * (double)size % (double)(size - len));
                byte[] data1 = new byte[len];
                for (int j = 0; j < data1.length; ++j) {
                    data1[j] = (byte)(Math.random() * 255.0);
                }
                fileMmapEngine.write(ByteBuffer.wrap(data1), offset);
                TestByteBufferIOEngine.BufferGrabbingDeserializer deserializer = new TestByteBufferIOEngine.BufferGrabbingDeserializer();
                fileMmapEngine.read(offset, len, (CacheableDeserializer)deserializer);
                ByteBuff data2 = deserializer.getDeserializedByteBuff();
                for (int j = 0; j < data1.length; ++j) {
                    Assert.assertTrue((data1[j] == data2.get(j) ? 1 : 0) != 0);
                }
            }
        }
        finally {
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

