/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.TestMiniClusterLoadSequential;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={IOTests.class, MediumTests.class})
public class TestLoadAndSwitchEncodeOnDisk
extends TestMiniClusterLoadSequential {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadAndSwitchEncodeOnDisk.class);
    private static final boolean USE_MULTI_PUT = true;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{new Object[0]});
    }

    public TestLoadAndSwitchEncodeOnDisk() {
        super(true, DataBlockEncoding.PREFIX);
        this.conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
    }

    @Override
    protected int numKeys() {
        return 3000;
    }

    @Override
    @Test
    public void loadTest() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        this.compression = Compression.Algorithm.GZ;
        super.loadTest();
        HColumnDescriptor hcd = this.getColumnDesc(admin);
        System.err.println("\nDisabling encode-on-disk. Old column descriptor: " + hcd + "\n");
        Table t = TEST_UTIL.getConnection().getTable(TABLE);
        this.assertAllOnLine(t);
        admin.disableTable(TABLE);
        admin.modifyColumnFamily(TABLE, (ColumnFamilyDescriptor)hcd);
        System.err.println("\nRe-enabling table\n");
        admin.enableTable(TABLE);
        System.err.println("\nNew column descriptor: " + this.getColumnDesc(admin) + "\n");
        this.assertAllOnLine(t);
        System.err.println("\nCompacting the table\n");
        admin.majorCompact(TABLE);
        Threads.sleepWithoutInterrupt((long)5000L);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep((long)50L);
        }
        System.err.println("\nDone with the test, shutting down the cluster\n");
    }

    private void assertAllOnLine(Table t) throws IOException {
        List regions;
        try (RegionLocator rl = TEST_UTIL.getConnection().getRegionLocator(t.getName());){
            regions = rl.getAllRegionLocations();
        }
        for (HRegionLocation e : regions) {
            byte[] startkey = e.getRegionInfo().getStartKey();
            Scan s = new Scan(startkey);
            ResultScanner scanner = t.getScanner(s);
            Result r = scanner.next();
            Assert.assertTrue((r != null && r.size() > 0 ? 1 : 0) != 0);
            scanner.close();
        }
    }
}

